

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canSeeOrManageNameServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +==================================================================================+
--  |Description : Case 1: When @i_forView=1, checks whether user can see the domain or not
--  |			   Case 2: When @i_forView=0, checks whether user can manage the domain
--	|
--  +==================================================================================+
-- O/p values for viewing domain:
-- O/p values for managing domain:
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_canSeeOrManageNameServer')
BEGIN
	print '>>> Drop Stored Procedure: sec_canSeeOrManageNameServer <<<'
	drop procedure sec_canSeeOrManageNameServer
END
IF EXISTS (select * from GxQscripts where name='sec_canSeeOrManageNameServer')
	delete from GxQscripts where name = 'sec_canSeeOrManageNameServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canSeeOrManageNameServer')
	delete from GXDBVersions where aliasname = 'sec_canSeeOrManageNameServer'
GO
print '... Creating Procedure: sec_canSeeOrManageNameServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_canSeeOrManageNameServer
  @i_userId int,
  @i_UMDSProviderId int,
  @i_forView int , 
  @i_isRestrictedViewEnabled int ,
  @i_returnCursor int,
  @o_retCode int OUTPUT
AS
  DECLARE @outputCode int
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode			INT
DECLARE @capabilityMask		BIGINT = 0
DECLARE @retCode			INT
DECLARE @userHasRights INT = 0
-- Security Check for seeing the name server
IF @i_forView = 1
BEGIN
	--User can see domain if he is the creator
	IF EXISTS( SELECT 1 FROM UMDSProviders WHERE [id] = @i_UMDSProviderId  AND [ownerId] = @i_userId )
	BEGIN
SET @retCode = 1
		GOTO ALL_DONE
	END
	-- User can see the domain if he is a member
	IF EXISTS ( SELECT 1 FROM UMUsers WHERE [id] = @i_userId AND [umDSproviderId] = @i_UMDSProviderId
	             UNION SELECT  1 FROM UMUSers U JOIN UMDSPRoviders P ON P.id = U.umdsproviderId and U.id=@i_userId and ownercompany=@i_UMDSProviderId )
	BEGIN
SET @retCode = 1
		GOTO ALL_DONE
	END
	-- Check for explicit rights.
EXEC sec_checkPermissionOnEntity @i_userId, '0', @userHasRights OUTPUT, 61, @i_UMDSProviderId
	IF @userHasRights = 1
	BEGIN
SET @retCode = 1
		GOTO ALL_DONE
	END
	-- This block is same as sec_getNameServersForThisUser.sp.
	-- We need this separate one because the above one gets all name servers. But if caller code is interesred in only one, then above code is costly.
	-- Check whether he has rights on any of this domain's user / group. Then he can see this one.
	DECLARE @entityTYpe INT
	IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_OutputTablee') IS NOT NULL
        DROP TABLE #getNonIdaObjects_OutputTable
    CREATE TABLE #getNonIdaObjects_OutputTable
    (
        entityId INT
    )
    -- Get all users who he has direct rights on, and get their providers
SET @entityType = 13               -- CvEntities::EntityType_USER_ENTITY (13)
    EXEC sec_getNonIdaObjectsForThisUser @userId = @i_userId,
                                        @entityTypeReq = @entityType,
                                        @permissionId = 0,
                                        @tableOutput = '#getNonIdaObjects_OutputTable',         -- We need to pass this table name as parameter to the SP. This is needed as part of removing unnecessary temp table usage in get non ida objects SP.
                                        @honorParentAssociations = 0                    -- We can get only direct associations. If it is coming from parents like nameserver / commcell it is already included in the previous call.
    IF EXISTS (SELECT 1
			   FROM UMUsers U
					INNER JOIN #getNonIdaObjects_OutputTable Sec
						ON U.id = Sec.entityId
				WHERE
					U.umdsProviderId = @i_UMDSProviderID)
	BEGIN
SET @retCode = 1
		GOTO ALL_DONE
	END
    TRUNCATE TABLE #getNonIdaObjects_OutputTable
SET @entityType = 15              -- CvEntities::EntityType_USER_GROUP_ENTITY (15)
    EXEC sec_getNonIdaObjectsForThisUser @userId = @i_userId,
                                        @entityTypeReq = @entityType,
                                        @permissionId = 0,
                                        @tableOutput = '#getNonIdaObjects_OutputTable',
                                        @honorParentAssociations = 0                -- We can get only direct associations. If it is coming from parents like nameserver / commcell it is already included in the previous call.
    IF EXISTS(
				SELECT TOP 1 1
				FROM UMGroups G
					 INNER JOIN #getNonIdaObjects_OutputTable Sec
						ON G.id = Sec.entityId
				WHERE
					G.umdsProviderId = @i_UMDSProviderId
				UNION
				SELECT TOP 1 1                                   -- Local groups contain AD groups. So get providers of those AD groups too.
				FROM UMGroups G
					INNER JOIN UMDSGroupMaps GM
						ON G.id = GM.umdsGroupId
					INNER JOIN #getNonIdaObjects_OutputTable Sec
						ON GM.umgroupId = Sec.entityId
				WHERE
					G.umdsProviderId = @i_UMDSProviderId
				UNION
				SELECT TOP 1 1                             -- Local groups contain AD users. So get providers of those AD users too.
				FROM UMUserGroup UG
					INNER JOIN #getNonIdaObjects_OutputTable Sec
						ON UG.groupId = Sec.entityId
					INNER JOIN UMGroups G				-- This is to avoid AD groups in the JOIN. They already came in above UNION.
						ON UG.groupId = G.id
						AND G.umdsProviderID = 0
					INNER JOIN UMUsers U
						ON U.id = UG.userID
				WHERE
					U.umdsProviderId = @i_UMDSProviderId
			)
	BEGIN
SET @retCode = 1
		GOTO ALL_DONE
	END
SET @retCode = 0
	GOTO ALL_DONE
END
-- Security checks for create/edit/delete or addExternalGroups to name server
EXEC sec_checkPermissionOnEntity @i_userId, '250, 251', @userHasRights OUTPUT, 61, @i_UMDSProviderId
IF @userHasRights = 1
BEGIN
SET @retCode = 1
	GOTO ALL_DONE
END
ELSE
BEGIN
SET @retCode = 2
	GOTO ALL_DONE
END
ALL_DONE:
SET @o_retCode = @retCode
if @i_returnCursor > 0
	SELECT @o_retCode  outputCode
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canSeeOrManageNameServer')
	delete from GxQscripts where name = 'sec_canSeeOrManageNameServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canSeeOrManageNameServer')
	delete from GXDBVersions where aliasname = 'sec_canSeeOrManageNameServer'
GO

insert into GXDBVersions values(2, 'sec_canSeeOrManageNameServer',  '00000000000000000000', 'sec_canSeeOrManageNameServer', '00000000000000000000')
GO

