

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canManageUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_canManageUser <<<'

IF EXISTS (select * from sysobjects where name='sec_canManageUser')
	drop procedure sec_canManageUser
IF EXISTS (select * from GxQscripts where name='sec_canManageUser')
	delete from GxQscripts where name = 'sec_canManageUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canManageUser')
	delete from GXDBVersions where aliasname = 'sec_canManageUser'
GO
print '... Creating Procedure: sec_canManageUser'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_canManageUser
  @i_callerId integer,
  @i_userId integer,
  @i_returnCursor integer,
  @o_canManageRetCode integer OUTPUT
AS
  DECLARE @canManageRetCode integer
SET NOCOUNT ON
 	DECLARE @CanManage integer = 0		-- no error caller can manage user
	DECLARE @NoCap integer = 1			-- caller dont have user management cap at anylevel
	DECLARE @NotInSameGroup integer = 2 -- users are not member of same user group
	SET @o_canManageRetCode = @CanManage
	DECLARE  @canManageAllUsers			integer = 0
	-- IF MANAGE IS TRUE
	IF dbo.IsUserOwnerofLockedClient(@i_userId) = 1
	BEGIN
		-- CANNOT MANGE LOCKED CLIENT
		IF @i_callerId <> @i_userId
		BEGIN
				SET @o_canManageRetCode = 3
				GOTO ALL_DONE;
		END
	END
	DECLARE @userHasRights INT = 0
EXEC sec_checkPermissionOnEntity @i_callerId, '101', @userHasRights OUTPUT, 13, @i_userId
	IF @userHasRights = 1
		SET @o_canManageRetCode = @canManage
	ELSE
		SET @o_canManageRetCode = @NoCap			-- We do not have the concept that user can manage only his peer users anymore in V11.
ALL_DONE:
	IF (@i_returnCursor <> 0)
	BEGIN
		SELECT @o_canManageRetCode canManageRetCode;
	END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canManageUser')
	delete from GxQscripts where name = 'sec_canManageUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canManageUser')
	delete from GXDBVersions where aliasname = 'sec_canManageUser'
GO

insert into GXDBVersions values(2, 'sec_canManageUser',  '00000000000000000000', 'sec_canManageUser', '00000000000000000000')
GO

