

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canManageGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_canManageGroup <<<'

IF EXISTS (select * from sysobjects where name='sec_canManageGroup')
	drop procedure sec_canManageGroup
IF EXISTS (select * from GxQscripts where name='sec_canManageGroup')
	delete from GxQscripts where name = 'sec_canManageGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canManageGroup')
	delete from GXDBVersions where aliasname = 'sec_canManageGroup'
GO
print '... Creating Procedure: sec_canManageGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_canManageGroup
  @i_callerId integer,
  @i_groupId integer,
  @i_returnCursor integer,
  @o_canManageRetCode integer OUTPUT
AS
  DECLARE @canManageRetCode integer
SET NOCOUNT ON
 	DECLARE @CanManage integer = 0		-- no error caller can manage user
	DECLARE @NoCap integer = 1			-- caller dont have user management cap at anylevel
	DECLARE @NotMemberOf integer = 2	-- user not member of user group
	SET @o_canManageRetCode = 0
	DECLARE  @canManageAllUsers			integer = 0
	EXEC sec_canManageAllUsers @i_callerId, @canManageAllUsers OUTPUT
	IF @canManageAllUsers <> 0
	BEGIN
		SET @o_canManageRetCode = @CanManage
		GOTO ALL_DONE;
	END
	DECLARE @userHasUserManagementCap int = 0
DECLARE @ManageUserCapMask bigint = CAST(POWER(2.0, 14 - 1) AS bigint)
	EXEC sec_userHasCapability @i_callerId, @ManageUserCapMask, @userHasUserManagementCap OUTPUT
	IF @userHasUserManagementCap = 0
	BEGIN
		SET @o_canManageRetCode = @NoCap
		GOTO ALL_DONE;
	END
	---while creating new group, id passed as 0, so allow it
	IF @i_groupId = 0
	BEGIN
		SET @o_canManageRetCode = @CanManage
		GOTO ALL_DONE;
	END
	DECLARE  @isMemberOfGroup  	integer = 0
	EXEC sec_isMemberOfGroup @i_callerId, @i_groupId, @isMemberOfGroup OUTPUT
	IF @isMemberOfGroup = 0
		SET @o_canManageRetCode = @NotMemberOf;
	ELSE
IF NOT EXISTS(	SELECT groupId FROM UMGroupCapability WHERE capabilityId = 14 AND groupId = @i_groupId
						UNION
						SELECT id from UMGroups WHERE allCapabilities = 1 AND id = @i_groupId
						)
			SET @o_canManageRetCode = @NoCap;
		ELSE
			SET @o_canManageRetCode = @CanManage
ALL_DONE:
	IF (@i_returnCursor <> 0)
	BEGIN
		SELECT @o_canManageRetCode canManageRetCode;
	END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canManageGroup')
	delete from GxQscripts where name = 'sec_canManageGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canManageGroup')
	delete from GXDBVersions where aliasname = 'sec_canManageGroup'
GO

insert into GXDBVersions values(2, 'sec_canManageGroup',  '00000000000000000000', 'sec_canManageGroup', '00000000000000000000')
GO

