

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canManageDM2EntityType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_canManageDM2EntityType.sp,v $ $Id: sec_canManageDM2EntityType.sp,v 1.7.200.4 2018/10/15 14:14:04 csingh Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_canManageDM2EntityType()
--  |
--  | Description:
--  |
--  |       Input:
--	|
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_canManageDM2EntityType')
BEGIN
	print '>>> Drop Stored Procedure: sec_canManageDM2EntityType <<<'
	drop procedure sec_canManageDM2EntityType
END
IF EXISTS (select * from GxQscripts where name='sec_canManageDM2EntityType')
	delete from GxQscripts where name = 'sec_canManageDM2EntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canManageDM2EntityType')
	delete from GXDBVersions where aliasname = 'sec_canManageDM2EntityType'
GO
print '... Creating Procedure: sec_canManageDM2EntityType'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_canManageDM2EntityType
  @i_commcellId integer,
  @i_userId integer,
  @i_entityType integer,
  @i_entityId integer,
  @o_canManageEntityType integer OUTPUT,
  @i_userGUID VARCHAR(36) = ''
AS
SET NOCOUNT ON
BEGIN
DECLARE @capability INT
SET @o_canManageEntityType = 0 -- initially set it to false
-- Get the user id
IF ( LEN( @i_userGUID ) > 0 )
BEGIN
	SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID )
	IF ( @i_userId = 0 )
		RETURN
END
-- check if user is the admin
DECLARE @isUserAdmin int
EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
IF ( @isUserAdmin = 1 )
BEGIN
	SET @o_canManageEntityType = 1
	RETURN
END
IF ( @i_entityType = 9501 OR @i_entityType = 9502 OR @i_entityType = 9503 )
SET @capability = 25 -- compliance search
ELSE IF ( @i_entityType = 9504 ) -- tags
SET @capability = 27
ELSE IF ( @i_entityType = 9505 ) -- legal hold
SET @capability = 29
IF ( @i_commcellId = 0 OR @i_commcellId IS null )
	SET @i_commcellId = 2
EXECUTE dbo.sec_checkPermissionOnEntity @userId = @i_userId, @permissionIdList = @capability, @isAllowed = @o_canManageEntityType output, @entityType1 = @i_entityType, @entityId1 = @i_entityId
-- special handling for endusers
IF ( @o_canManageEntityType <> 1 AND ( @i_entityType = 9501 OR @i_entityType = 9502 OR @i_entityType = 9503 ) )
BEGIN
	SET @capability = 24 -- end user search
	EXECUTE dbo.sec_checkPermissionOnEntity @userId = @i_userId, @permissionIdList = @capability, @isAllowed = @o_canManageEntityType output, @entityType1 = @i_entityType, @entityId1 = @i_entityId
END
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canManageDM2EntityType')
	delete from GxQscripts where name = 'sec_canManageDM2EntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canManageDM2EntityType')
	delete from GXDBVersions where aliasname = 'sec_canManageDM2EntityType'
GO

insert into GXDBVersions values(2, 'sec_canManageDM2EntityType',  '00010007020000040000', 'sec_canManageDM2EntityType', '00010007020000040000')
GO

