

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canLoginMasterCommcell.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_canLoginMasterCommcell')
BEGIN
	print '>>> Drop Stored Procedure: sec_canLoginMasterCommcell <<<'
	drop procedure sec_canLoginMasterCommcell
END
IF EXISTS (select * from GxQscripts where name='sec_canLoginMasterCommcell')
	delete from GxQscripts where name = 'sec_canLoginMasterCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canLoginMasterCommcell')
	delete from GXDBVersions where aliasname = 'sec_canLoginMasterCommcell'
GO
print '... Creating Procedure: sec_canLoginMasterCommcell'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_canLoginMasterCommcell
  @iUserId INT,
  @canUserLogin INT OUTPUT
AS
BEGIN TRY
  DECLARE @returnVar INT
SET @returnVar = 0
SET @canUserLogin = 0
-- Table variable wont be enough. This may contain more entries. Have a temp table.
IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
    DROP TABLE #getMemberUserGroupsHelperOutputTbl
CREATE TABLE #getMemberUserGroupsHelperOutputTbl
(
    isUser INT,
    userOrgroupId INT,
    UNIQUE CLUSTERED(isUser, userOrGroupId)
)
EXEC sec_getMemberUserGroupsHelper @iUserId
IF EXISTS (SELECT TOP 1 Sec.roleId, Sec.permissionId
           FROM UMSecurityAssociations Sec INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId and entityType1 <> 194)
    OR
    EXISTS (SELECT TOP 1 Sec.entityType
            FROM UMOwners Sec INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
            ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId)
    SET @returnVar = 1
ELSE -- For first time edge drive configuration and share users with no association
BEGIN
    --check if user is associated to edge drive
DECLARE @capUpload  BIGINT= (POWER(2.0, 5 -1));
DECLARE @capBrowse  BIGINT= (POWER(2.0, 13 -1));
    DECLARE @capUploadBrowse bigint=  (@capUpload | @capBrowse );
    IF object_id('tempdb.dbo.#edgeClientsWithCapabilities') IS NOT NULL DROP TABLE #edgeClientsWithCapabilities
    CREATE TABLE #edgeClientsWithCapabilities (clientId INT PRIMARY KEY, clientStatus INT, capabilities BIGINT, userAssociationType INT )
    EXEC AppGetEdgeCapabilties @iUserId, '#edgeClientsWithCapabilities'
    IF EXISTS ( SELECT 1
                FROM    #edgeClientsWithCapabilities EC
                        INNER JOIN App_EdgeDriveAssociation EDA WITH(NOLOCK) ON EDA.clientId = EC.clientId
                        AND EDA.entityType = 3
                        AND EDA.entityId > 1
                WHERE EC.capabilities & @capUploadBrowse  = @capUploadBrowse -- Clients with upload and browse capability
                )
    BEGIN
        SET @returnVar = 1
    END
    ELSE --check if user is part of any share
    BEGIN
        EXEC AppSharingDoesUserHaveSharedFolder @iUserId,@returnVar OUT
    END
    DROP Table #edgeClientsWithCapabilities
END
SET @canUserLogin = @returnVar
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @canUserLogin = @returnVar
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canLoginMasterCommcell')
	delete from GxQscripts where name = 'sec_canLoginMasterCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canLoginMasterCommcell')
	delete from GXDBVersions where aliasname = 'sec_canLoginMasterCommcell'
GO

insert into GXDBVersions values(2, 'sec_canLoginMasterCommcell',  '00000000000000000000', 'sec_canLoginMasterCommcell', '00000000000000000000')
GO

