

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canLogin.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_canLogin"
--	|	This Procedure is used to check if a user can login
--	|	This SP to be called from Evmgrs login and web console login too.
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_canLogin')
BEGIN
	print '>>> Drop Stored Procedure: sec_canLogin <<<'
	drop procedure sec_canLogin
END
IF EXISTS (select * from GxQscripts where name='sec_canLogin')
	delete from GxQscripts where name = 'sec_canLogin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canLogin')
	delete from GXDBVersions where aliasname = 'sec_canLogin'
GO
print '... Creating Procedure: sec_canLogin'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_canLogin
  @userId INT,
  @canUserLogin INT OUTPUT,
  @populateUserCredentials INT = 0,
  @returnCursor INT = 0,
  @isCmdLineLogin INT = 0
AS
  DECLARE @returnVar INT
SET @returnVar = 0
-- Table variable wont be enough. This may contain more entries. Have a temp table.
IF OBJECT_ID('tempdb.dbo.#getMemberUserGroupsHelperOutputTbl') IS NOT NULL
	DROP TABLE #getMemberUserGroupsHelperOutputTbl
CREATE TABLE #getMemberUserGroupsHelperOutputTbl
(
	isUser INT,
	userOrgroupId INT,
	UNIQUE CLUSTERED(isUser, userOrGroupId)
)
EXEC sec_getMemberUserGroupsHelper @userId
IF EXISTS (SELECT TOP 1 Sec.roleId, Sec.permissionId
		   FROM UMSecurityAssociations Sec INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
		   ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId)
	OR
	EXISTS (SELECT TOP 1 Sec.entityType
			FROM UMOwners Sec INNER JOIN #getMemberUserGroupsHelperOutputTbl UG
			ON Sec.isUser = UG.isUser AND Sec.userOrGroupId = UG.userOrGroupId)
	SET @returnVar = 1
ELSE -- For first time edge drive configuration and share users with no association
BEGIN
	--check if user is associated to edge drive
DECLARE @capUpload	BIGINT= (POWER(2.0, 5 -1));
DECLARE @capBrowse  BIGINT= (POWER(2.0, 13 -1));
	DECLARE @capUploadBrowse bigint=  (@capUpload | @capBrowse );
	IF object_id('tempdb.dbo.#edgeClientsWithCapabilities') IS NOT NULL DROP TABLE #edgeClientsWithCapabilities
	CREATE TABLE #edgeClientsWithCapabilities (clientId INT PRIMARY KEY, clientStatus INT, capabilities BIGINT,	userAssociationType INT	)
	EXEC AppGetEdgeCapabilties @userId, '#edgeClientsWithCapabilities'
	IF EXISTS ( SELECT 1
				FROM	#edgeClientsWithCapabilities EC
						INNER JOIN App_EdgeDriveAssociation EDA WITH(NOLOCK) ON EDA.clientId = EC.clientId
						AND EDA.entityType = 3
						AND EDA.entityId > 1
				WHERE EC.capabilities & @capUploadBrowse  = @capUploadBrowse -- Clients with upload and browse capability
				)
	BEGIN
		SET @returnVar = 1
	END
	ELSE --check if user is part of any share
	BEGIN
		EXEC AppSharingDoesUserHaveSharedFolder @userId,@returnVar OUT
	END
	DROP Table #edgeClientsWithCapabilities
END
-- If credentials updated within 60 seconds before, then do not update it again for QSDK logins.
IF (@isCmdLineLogin = 1) AND (@populateUserCredentials = 1)
BEGIN
	DECLARE @updateUserCredsFrequency_QSDK INT = 0
	SELECT @updateUserCredsFrequency_QSDK = ISNULL(CAST(value AS INT), 0) FROM GxGlobalParam (NOLOCK) WHERE	name = 'nUpdateUserCredsFrequency_QSDK'	AND modified = 0
	-- Setting value to 0 (or key not set) will disable this optimized behavior change.
	IF @updateUserCredsFrequency_QSDK > 0
	BEGIN
		BEGIN TRY
			-- Begin a transaction if one is not already done. This is needed so that parallel sessions do not end up calling update user credentials.
			DECLARE @isLocalTran INT = 0
			IF @@TRANCOUNT = 0
				SET @isLocalTran = 1
			IF @isLocalTran = 1
				BEGIN TRAN
			DECLARE @lastQloginCredSetTime INT = 0, @nowTime INT = 0
			-- This is a gate-keeper, if there is another thread that has started the update user credentials for that user, wait until it is done.
			UPDATE UMUsers SET pager = pager WHERE id = @userId
			-- Not using NOLOCK to avoid dirty-reads. Using MAX to avoid duplicates in case there are any.
SELECT @lastQloginCredSetTime = ISNULL(MAX(CAST(attrVal AS INT)), 0) FROM UMUsersProp WHERE componentNameId = @userId AND attrName = N'Last qlogin credentials update time' AND cs_attrName = CHECKSUM(N'Last qlogin credentials update time') AND modified = 0
			-- Set this variable just before checking so that exact current time is known.
			SET @nowTime = dbo.getUnixTime(GETUTCDATE())
			-- print	'sec_canLogin: @lastQloginCredSetTime: [' + cast(@lastQloginCredSetTime as varchar(10)) + '], @updateUserCredsFrequency_QSDK: [' + cast(@updateUserCredsFrequency_QSDK as varchar(10)) + '], @nowTime: [' + cast(@nowTime as varchar(10)) + ']'
			IF @lastQloginCredSetTime + @updateUserCredsFrequency_QSDK > @nowTime		-- Skip update user credentials.
			BEGIN
				-- Set last Cred set time with now time, so that code like get user objects will not end up updating user credentials again.
				UPDATE UMUsers SET credSetTime = @nowTime WHERE id = @userId
			END
			ELSE																		-- Call update user credentials.
			BEGIN
				-- Calling get user objects was just to invoke this SP. Directly call it instead, within this transaction. (This SP too begins tran internally if one is not there. So calling within this existing transaction does no harm).
				EXEC sec_updateUserCredentials @userId
				-- Set last qlogin credential update time property.
				SET @nowTime = dbo.getUnixTime(GETUTCDATE())
UPDATE UMUsersProp SET attrVal = @nowTime WHERE componentNameId = @userId AND attrName = N'Last qlogin credentials update time' AND cs_attrName = CHECKSUM(N'Last qlogin credentials update time') AND modified = 0
				IF @@ROWCOUNT = 0
					INSERT INTO UMUsersProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, N'Last qlogin credentials update time', 7, @nowTime, @nowTime, 0)
			END
			IF @isLocalTran = 1
				COMMIT TRAN
			-- If we reach here, then no need to call get user objects in Line 153.
			SET @populateUserCredentials = 0
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			IF @isLocalTran = 1
				ROLLBACK TRAN
			SET @populateUserCredentials = 1		-- Call get user objects at Line 153 if something went wrong!!!
		END CATCH
	END
END
IF @populateUserCredentials = 1			-- When called from Evmgrs login(existing code), we need to call Get User Objects to populate User Credentials table.
BEGIN									-- When called from web console login, it is not needed. So skipping it for them.
	IF object_id('tempdb.dbo.#getUserCredentialsTmp') is not null DROP TABLE #getUserCredentialsTmp
create table  #getUserCredentialsTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#getUserCredentialsTmp'
	DROP Table #getUserCredentialsTmp
END
DROP TABLE #getMemberUserGroupsHelperOutputTbl
IF(@userId<0) --- special system users
	SET @returnVar =1
IF @returnCursor = 1					-- When called from Evmgrs login (cpp code), it expects output to be "selected" as output.
	SELECT @returnVar
ELSE
	SET @canUserLogin = @returnVar		-- When called from Web console login, it expects output variable to be filled.
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canLogin')
	delete from GxQscripts where name = 'sec_canLogin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canLogin')
	delete from GXDBVersions where aliasname = 'sec_canLogin'
GO

insert into GXDBVersions values(2, 'sec_canLogin',  '00000000000000000000', 'sec_canLogin', '00000000000000000000')
GO

