

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canDeleteDM2EntityType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_canDeleteDM2EntityType.sp,v $ $Id: sec_canDeleteDM2EntityType.sp,v 1.4.276.6 2020/11/03 01:30:43 sgolla Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_canDeleteDM2EntityType()
--  |
--  | Description:
--  |
--  |       Input:
--	|
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_canDeleteDM2EntityType')
BEGIN
	print '>>> Drop Stored Procedure: sec_canDeleteDM2EntityType <<<'
	drop procedure sec_canDeleteDM2EntityType
END
IF EXISTS (select * from GxQscripts where name='sec_canDeleteDM2EntityType')
	delete from GxQscripts where name = 'sec_canDeleteDM2EntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canDeleteDM2EntityType')
	delete from GXDBVersions where aliasname = 'sec_canDeleteDM2EntityType'
GO
print '... Creating Procedure: sec_canDeleteDM2EntityType'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_canDeleteDM2EntityType
  @i_commcellId integer,
  @i_userId integer,
  @i_entityType integer,
  @i_entityId integer,
  @o_canDeleteEntityType integer OUTPUT,
  @i_userGUID VARCHAR(36) = ''
AS
SET NOCOUNT ON
BEGIN
DECLARE @capability int = 35
SET @o_canDeleteEntityType = 0 -- initially set it to false
-- Get the user id
IF ( LEN( @i_userGUID ) > 0 )
BEGIN
	SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @i_userGUID )
	IF ( @i_userId = 0 )
		RETURN
END
-- check if user is the admin
DECLARE @isUserAdmin int
EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
IF ( @isUserAdmin = 1 )
BEGIN
	SET @o_canDeleteEntityType = 1
	RETURN
END
DECLARE @isOwner INT = 0
SELECT @isOwner = dbo.IsUserCreator(@i_userId, @i_entityType, @i_entityId)
IF @i_entityType = 9505
BEGIN
	--syncrhonize logic w.r.t stored proc DM2PerformLegalHoldDelete
	--allow owner to perform Legal Hold delete operation based on gxglobalParam key
	--
	DECLARE @allowOwnerForLHOperation INT = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'AllowOwnerForLHOperation' AND modified =0), 0)
	IF @allowOwnerForLHOperation = 1
	BEGIN
		IF @isOwner = 1
		BEGIN
			SET @o_canDeleteEntityType = 1
			RETURN
		END
	END
END
IF @i_entityType = 9504
BEGIN
	IF @isOwner = 1
	BEGIN
		SET @o_canDeleteEntityType = 1
		RETURN
	END
END
IF ( @i_commcellId = 0 OR @i_commcellId IS null )
	SET @i_commcellId = 2
EXECUTE dbo.sec_checkPermissionOnEntity @userId = @i_userId, @permissionIdList = @capability, @isAllowed = @o_canDeleteEntityType output, @entityType1 = @i_entityType, @entityId1 = @i_entityId
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canDeleteDM2EntityType')
	delete from GxQscripts where name = 'sec_canDeleteDM2EntityType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canDeleteDM2EntityType')
	delete from GXDBVersions where aliasname = 'sec_canDeleteDM2EntityType'
GO

insert into GXDBVersions values(2, 'sec_canDeleteDM2EntityType',  '00010004027600060000', 'sec_canDeleteDM2EntityType', '00010004027600060000')
GO

