

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_canAddClientToClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_canAddClientToClientGroup.sp,v $ $Id: sec_canAddClientToClientGroup.sp,v 1.5.34.6 2018/03/22 01:35:20 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_canAddClientToClientGroup <<<'

IF EXISTS (select * from sysobjects where name='sec_canAddClientToClientGroup')
	drop procedure sec_canAddClientToClientGroup
IF EXISTS (select * from GxQscripts where name='sec_canAddClientToClientGroup')
	delete from GxQscripts where name = 'sec_canAddClientToClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canAddClientToClientGroup')
	delete from GXDBVersions where aliasname = 'sec_canAddClientToClientGroup'
GO
print '... Creating Procedure: sec_canAddClientToClientGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_canAddClientToClientGroup
  @i_userId integer,
  @i_clientGroupId integer, 
  @i_localeId integer,
  @i_PerformClientGroupReqXml varchar(max),
  @returnValue integer =0,
  @o_errorCode integer OUTPUT,
  @o_isSecuritCheckNeeded integer OUTPUT,
  @o_userGroupList nvarchar(max) OUTPUT
AS
  DECLARE @errorCode int 
  DECLARE @isSecurityCheckNeeded int
  DECLARE @errorMessage nvarchar(max)
SET @isSecurityCheckNeeded=0
SET @errorMessage =''
	SET @errorCode  = 0
	SET @errorMessage = 'Success'
	DECLARE @canManageAllUsers int = 0
DECLARE @adminFlags			bigint = (convert(int, 0x0008))
	if(dbo.isNewSecurity()=0)
		EXEC sec_canManageAllUsers @i_userId, @canManageAllUsers OUTPUT
	ELSE
exec sec_checkPermissionOnEntity @i_userId,107,@canManageAllUsers OUTPUT ,1,2
	--User has User Management capability at commcell level.
	IF(@canManageAllUsers<>0)
	BEGIN
		SET @isSecurityCheckNeeded =0
		SET @errorCode=0
		GOTO PROC_EXIT
	END
	DECLARE @userGroupList nvarchar(MAX)
	DECLARE @capStringUserMgmt nvarchar(max)
	SET @capStringUserMgmt =(SELECT (dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 14), 0,2)))
DECLARE @capability bigint=POWER(14,1-1)
	DECLARE @masterGroupId integer = (dbo.GetMasterGroupID())
	DECLARE @viewAllGroupId integer =ISNULL((select id from UMGroups with (nolock) where name ='View All'), 0)
	DECLARE @clientGroupUserGroupAssocTbl table(userGroupId int)
	DECLARE @isSmartClientGroup Integer=0
	DECLARE @iDoc integer
	exec sp_xml_preparedocument @iDoc OUTPUT, @i_PerformClientGroupReqXml
	DECLARE @UserGroupsOperationType INTEGER=0
	DECLARE @viewALLGroupUpgradeRoleId INTEGER = ISNULL(( SELECT  Top 1 CAST(attrVal as INTEGER) FROM UMGroupsProp where componentNameId = @viewAllGroupId AND attrName ='SystemCreatedRole_'),0)
	SET @UserGroupsOperationType =ISNULL((SELECT TOP 1 operationType
										FROM OPENXML(@iDoc,'App_PerformClientGroupReq/clientGroupDetail//associatedUserGroups',0)
										WITH(operationType int '../@associatedUserGroupsOperationType')),0)
	if(dbo.isNewSecurity()=0)
	BEGIN
		IF(@UserGroupsOperationType=1)   --OVER WRITE
		BEGIN
			INSERT INTO @clientGroupUserGroupAssocTbl (userGroupId)
			SELECT userGroupId
			FROM OPENXML(@iDoc,'App_PerformClientGroupReq/clientGroupDetail//associatedUserGroups',0)
			WITH (userGroupId int '@userGroupId',associatedUserGroupsOperationType int '../@associatedUserGroupsOperationType')
			JOIN UMGroups UG with (NOLOCK) on userGroupId =UG.id
			WHERE associatedUserGroupsOperationType in (1,2) and userGroupId not in (@viewAllGroupId,@masterGroupId)
			and allAssociations<>1
		END
		ELSE
		BEGIN
			INSERT INTO @clientGroupUserGroupAssocTbl (userGroupId)
			SELECT Assoc.groupId
			FROM
			(
				SELECT groupId
				FROM UMGroupAssociation
				WHERE type1=2572 and  id1=@i_clientGroupId
				UNION
				SELECT userGroupId FROM OPENXML(@iDoc,'App_PerformClientGroupReq/clientGroupDetail//associatedUserGroups',0)
				WITH (userGroupId int '@userGroupId',associatedUserGroupsOperationType int '../@associatedUserGroupsOperationType')
				WHERE associatedUserGroupsOperationType in (1,2)
				)
			Assoc
			JOIN UMGroups UG with (NOLOCK)
			ON Assoc.groupId=UG.id
			WHERE UG.id not in (@viewAllGroupId,@masterGroupId)AND allAssociations<>1
		END
		--IF @clientGroupUserGroupAssocTbl is empty, no user group is not associated lets return true
		IF NOT EXISTS(select * from @clientGroupUserGroupAssocTbl)
		BEGIN
			SET @isSecurityCheckNeeded =0
			SET @errorCode=0
			goto PROC_EXIT
		END
		SET @isSecurityCheckNeeded =1
	END
	ELSE   --NEW SECURITY
	BEGIN
		DECLARE @newSecurityAssociationsOperationtype INTEGER=0
		SET @newSecurityAssociationsOperationtype =ISNULL((SELECT TOP 1 operationType
										FROM OPENXML(@iDoc,'App_PerformClientGroupReq/clientGroupDetail/securityAssociations',0)
										WITH(operationType int '@associationsOperationType')),0)
		IF(@newSecurityAssociationsOperationtype<>0)
			SET @UserGroupsOperationType=0
		IF(@UserGroupsOperationType=1)
		BEGIN
			IF EXISTS(SELECT userGroupId
					FROM OPENXML(@iDoc,'App_PerformClientGroupReq/clientGroupDetail//associatedUserGroups',0)
					WITH (userGroupId int '@userGroupId',associatedUserGroupsOperationType int '../@associatedUserGroupsOperationType')
					JOIN UMGroups UG with (NOLOCK) on userGroupId =UG.id
					WHERE associatedUserGroupsOperationType in (1,2) and userGroupId not in (@viewAllGroupId,@masterGroupId)
					and allAssociations<>1
				 )
			SET @isSecurityCheckNeeded=1
		END
		IF(@isSecurityCheckNeeded=0  and @newSecurityAssociationsOperationtype=0)
		BEGIN
			-- Any explicit security association.
			-- Except associated to Master user group(any role / permission) OR View all with View role.
			IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
						WHERE
entityType1 = 28
								AND entityId1 = @i_clientGroupId
								AND isCreator = 0
								AND NOT(
											(isUser = 0 AND userOrGroupId = @masterGroupId)
											OR (@viewALLGroupUpgradeRoleId > 0 AND isUser = 0 AND userOrGroupId = @viewAllGroupId AND roleID = @viewALLGroupUpgradeRoleId)
									   )
						)
						SET @isSecurityCheckNeeded=1
		END
		IF (@isSecurityCheckNeeded=0 and @newSecurityAssociationsOperationtype<>0)
		BEGIN
			DECLARE @usergroupTable TABLE (userId integer DEFAULT 0,userGroupId integer DEFAULT 0,externalGroupId integer,roleId integer  DEFAULT 0, permissionId INT DEFAULT 0)
			INSERT INTO @usergroupTable(userId,userGroupId,externalGroupId,roleId, permissionId)
			SELECT  ISNULL(userId,0) ,ISNULL(userGroupId,0),ISNULL(externalGRoupId,0),ISNULL(roleId,0), ISNULL(permissionId, 0)
					FROM OPENXML(@iDoc,'App_PerformClientGroupReq/clientGroupDetail/securityAssociations/associations',0)
					WITH (	userId int 'userOrGroup/@userId',
							userGroupId int 'userOrGroup/@userGroupId',
							externalGroupId int  'userOrGroup/@groupId',
							 roleId int 'properties/role/@roleId',
							 permissionID int 'properties/categoryPermission/categoriesPermissionList/@permissionId')
			DELETE FROM @usergroupTable where userId=0 and userGroupId=0 and externalGroupId=0
			DELETE FROM @usergroupTable
			where userGroupId=@masterGroupId OR (userGroupId=@viewAllGroupId and roleId=@viewALLGroupUpgradeRoleId)
			IF(@newSecurityAssociationsOperationtype=1 OR @newSecurityAssociationsOperationtype =2 ) --OVERwrite
			BEGIN
				IF EXISTS (SELECT 1 FROM @usergroupTable)
					SET @isSecurityCheckNeeded=1
			END
			IF(@isSecurityCheckNeeded =0 AND @newSecurityAssociationsOperationtype =2)			-- Nothing has come from input and opType is ADD. So just check in DB - same case as (@isSecurityCheckNeeded=0  and @newSecurityAssociationsOperationtype=0)
			BEGIN
				IF EXISTS (SELECT TOP 1 1
						FROM UMSecurityAssociations Sec
						WHERE
entityType1 = 28
								AND entityId1 = @i_clientGroupId
								AND isCreator = 0
								AND NOT(
											(isUser = 0 AND userOrGroupId = @masterGroupId)
											OR (@viewALLGroupUpgradeRoleId > 0 AND isUser = 0 AND userOrGroupId = @viewAllGroupId AND roleID = @viewALLGroupUpgradeRoleId)
									   )
						)
					SET @isSecurityCheckNeeded=1
			END
			IF(@isSecurityCheckNeeded=0 and @newSecurityAssociationsOperationtype=3)			-- opType is DELETE. If there exists some association in DB - not in input and not Master user group(with any permission) or View All (with View role) then seucrity check is needed.
			BEGIN
				IF EXISTS (
							SELECT TOP 1 1
							FROM UMSecurityAssociations Sec
								 LEFT OUTER JOIN @userGroupTable UG
									ON Sec.isUser = CASE WHEN UG.userID > 0 THEN 1 ELSE 0 END
									   AND Sec.userOrGroupId = CASE WHEN UG.userID > 0 THEN UG.userId
																	WHEN UG.userGroupID > 0 THEN UG.userGroupId
																	ELSE UG.externalGroupID
																END
									   AND Sec.roleID = UG.roleID
									   AND Sec.permissionId = UG.permissionId
							WHERE
Sec.entityType1 = 28
								AND Sec.entityId1 = @i_clientGroupId
								AND Sec.isCreator = 0
								AND NOT(
										(Sec.isUser = 0 AND Sec.userOrGroupId = @masterGroupId)
										OR (@viewALLGroupUpgradeRoleId > 0 AND Sec.isUser = 0 AND Sec.userOrGroupId = @viewAllGroupId AND Sec.roleID = @viewALLGroupUpgradeRoleId)
									   )
								AND UG.userId IS NULL
						  )
					SELECT @isSecurityCheckNeeded=1
			END
			IF(@newSecurityAssociationsOperationtype=4)
				SET @isSecurityCheckNeeded=0
		END
	END
	PROC_EXIT:
    if(@returnValue<>0)
			SELECT @errorCode,@isSecurityCheckNeeded,@errorMessage
	ELSE
	  BEGIN
		SET  @o_errorCode   = @errorCode
		SET  @o_isSecuritCheckNeeded =@isSecurityCheckNeeded
		SET @o_userGroupList =@userGroupList
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_canAddClientToClientGroup')
	delete from GxQscripts where name = 'sec_canAddClientToClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_canAddClientToClientGroup')
	delete from GXDBVersions where aliasname = 'sec_canAddClientToClientGroup'
GO

insert into GXDBVersions values(2, 'sec_canAddClientToClientGroup',  '00010005003400060000', 'sec_canAddClientToClientGroup', '00010005003400060000')
GO

