

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_associateCompaniesWithEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------------
--      This SP is used to perform explicit security associations for entity with
--		tenant admin group of the specified company.
--      Specify the entity on which the security associations is to be done
--      and the list of <company_id> combinations
--
--		Authors: sghatbale
-- -----------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_associateCompaniesWithEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_associateCompaniesWithEntity <<<'
	drop procedure sec_associateCompaniesWithEntity
END
IF EXISTS (select * from GxQscripts where name='sec_associateCompaniesWithEntity')
	delete from GxQscripts where name = 'sec_associateCompaniesWithEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_associateCompaniesWithEntity')
	delete from GXDBVersions where aliasname = 'sec_associateCompaniesWithEntity'
GO
print '... Creating Procedure: sec_associateCompaniesWithEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_associateCompaniesWithEntity
  @entityType INT,
  @entityId INT,
  @xmlIn XML
AS
--Output variables
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(1024)
	DECLARE @companyTenantAdminGroupTbl TABLE
	(
		id INT,
		tenantAdminGroupId INT
		PRIMARY KEY (id)
	)
	DECLARE @existingNonCompanyAssociationsTbl TABLE
	(
		userOrGroupId INT,
		isUser INT,
		roleId INT,
		permissionId INT
	)
	SET @errorCode = 0
	SET @errorString = 'Successful'
	DECLARE @userID INT = 0
	DECLARE @associationsOperationType INT = 0
	DECLARE @roleId INT = 0
	SET @userID = ISNULL((select ref.value('@userId','INT') FROM @xmlIn.nodes('/Api_AssociateCompaniesWithEntityReq/processinginstructioninfo/user')  R(ref)),0)
	IF @userID <= 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid user id: ' + cast (@userID AS varchar(10) )
		GOTO PROC_EXIT
	END
	SET @associationsOperationType  = ISNULL((select ref.value('@associationsOperationType ','INT') FROM @xmlIn.nodes('/Api_AssociateCompaniesWithEntityReq')  R(ref)),0)
	-- supported entity types for associating company to entity directly : Plan entity
IF @entityType <> 158
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Entity type ' + cast (@entityType AS varchar(10) ) + ' is not supported'
		GOTO PROC_EXIT
	END
SET @roleId = CASE  WHEN @entityType = 158
THEN ISNULL((SELECT id FROM UMRoles WITH (NOLOCK) WHERE name = 'Plan Subscription Role' and flags & 64 <> 0) ,0)
						ELSE 0
						END
	INSERT INTO @companyTenantAdminGroupTbl (id, tenantAdminGroupId)
	SELECT ref.value('@providerId', 'INT'), UG.id
	FROM @xmlIn.nodes('Api_AssociateCompaniesWithEntityReq/companies') R(ref)
		INNER JOIN UMGroups UG WITH (NOLOCK)
		ON UG.umdsProviderId = ref.value('@providerId', 'INT')
WHERE groupFlags &  0x10000 = 0x10000
	IF @associationsOperationType = 1    -- operation type override
	BEGIN
		-- We need to retain all the associations for the given entity which are non company associations
		INSERT INTO @existingNonCompanyAssociationsTbl
		SELECT userOrGroupId, isUser, roleId, permissionId
		FROM UMSecurityAssociations US WITH (NOLOCK)
		LEFT JOIN UMGroups UG WITH (NOLOCK)
			ON US.isUser = 0
				AND UG.id = US.userOrGroupId
AND UG.groupFlags & 0x10000 = 0x10000
				AND US.roleId = @roleId
		WHERE entityType1 = @entityType
			AND entityId1 = @entityId
			AND isCreator = 0
			AND UG.id is NULL
	END
	DECLARE @securityAssociationsXML XML
	SET @securityAssociationsXML =  (
                                        SELECT @associationsOperationType  AS '@associationsOperationType'
										,(SELECT @xmlIn.query('Api_AssociateCompaniesWithEntityReq/processinginstructioninfo') )
										,(
                                            SELECT
                                                (
                                                    SELECT tenantAdminGroupId AS '@userGroupId',
15  AS '@_type_'
                                                    FOR XML PATH('userOrGroup'), TYPE
                                                )
                                                ,(
                                                    SELECT
                                                        (
                                                            SELECT @roleId AS '@roleId'
                                                            FOR XML PATH ('role'), TYPE
                                                        )
                                                    FOR XML PATH ('properties'), TYPE
                                                )
                                            FROM @companyTenantAdminGroupTbl
                                            FOR XML PATH ('associations'), TYPE
                                        )
					,(
                                            SELECT
                                                (
                                                    SELECT userOrGroupId AS '@userGroupId' ,
15 AS '@_type_'
                                                    FOR XML PATH('userOrGroup'), TYPE
                                                )
                                                ,(
                                                    SELECT
                                                        (
                                                            SELECT roleId AS '@roleId'
                                                            FOR XML PATH ('role'), TYPE
                                                        )
							,(
                                                            SELECT permissionId AS '@permissionId'
                                                            FOR XML PATH ('permissions'), TYPE
                                                        )
                                                    FOR XML PATH ('properties'), TYPE
                                                )
                                            FROM @existingNonCompanyAssociationsTbl
					    WHERE isUser = 0
                                            FOR XML PATH ('associations'), TYPE
                                        )
					,(
                                            SELECT
                                                (
                                                    SELECT userOrGroupId AS '@userId',
13 AS '@_type_'
                                                    FOR XML PATH('userOrGroup'), TYPE
                                                )
                                                ,(
                                                    SELECT
                                                        (
                                                            SELECT roleId AS '@roleId'
                                                            FOR XML PATH ('role'), TYPE
                                                        )
							,(
                                                            SELECT permissionId AS '@permissionId'
                                                            FOR XML PATH ('permissions'), TYPE
                                                        )
                                                    FOR XML PATH ('properties'), TYPE
                                                )
                                            FROM @existingNonCompanyAssociationsTbl
					    WHERE isUser = 1
                                            FOR XML PATH ('associations'), TYPE
                                        )
                                        FOR XML PATH('App_SecurityAssociationForEntityList')
                                    )
	DECLARE @errorTable TABLE
    (
        errorCode INT,
        errorString VARCHAR(MAX)
    )
	INSERT INTO @errorTable
        EXEC sec_setSecurityAssociationsFromEntity @securityAssociationsXML, @userID, 0, 0, @entityType, @entityId, 0, 0, 0, 0, 0, 0, 0, 0
    SET @errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
    IF @errorCode <> 0
    BEGIN
        SET @errorString = (SELECT TOP 1 errorString FROM @errorTable)
        GOTO PROC_EXIT
    END
PROC_EXIT:
    SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_associateCompaniesWithEntity')
	delete from GxQscripts where name = 'sec_associateCompaniesWithEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_associateCompaniesWithEntity')
	delete from GXDBVersions where aliasname = 'sec_associateCompaniesWithEntity'
GO

insert into GXDBVersions values(2, 'sec_associateCompaniesWithEntity',  '00000000000000000000', 'sec_associateCompaniesWithEntity', '00000000000000000000')
GO

