

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_addServiceCommcellAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET NOCOUNT ON
-- This Stored Procedure will add newPerm for all entities which have oldPerm
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_addServiceCommcellAssociations')
BEGIN
	print '>>> Drop Stored Procedure: sec_addServiceCommcellAssociations <<<'
	drop procedure sec_addServiceCommcellAssociations
END
IF EXISTS (select * from GxQscripts where name='sec_addServiceCommcellAssociations')
	delete from GxQscripts where name = 'sec_addServiceCommcellAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_addServiceCommcellAssociations')
	delete from GXDBVersions where aliasname = 'sec_addServiceCommcellAssociations'
GO
print '... Creating Procedure: sec_addServiceCommcellAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_addServiceCommcellAssociations
  @requestXML XML,
  @o_responseXML NVARCHAR(MAX) OUTPUT
AS
DECLARE @errorCode INT =0
DECLARE @errorSTring Varchar(2048) =''
BEGIN TRY
DECLARE @csGUID VARCHAR(256)  = ISNULL((SELECT ref.value('@csGUID','VARCHAR(256)') AS role
										FROM @requestXML.nodes('App_UpdateSecurityAssociationRequest/entityAssociated/entity') R (ref)),0)
DECLARE @commcellId INT = ISNULL(( SELECT TOP 1 id from APP_CommCell where csGUID = @csGUID),0)
DECLARE @viewRoleID INT = ISNULL((SELECT TOP 1 id FROM UMRoles (NOLOCK) WHERE (name = 'View') AND (flags & 1 | 2 <> 0)), 0)
IF(@commcellId<>0)
BEGIN
		DECLARE @inputTempTable TABLE
	(
		userORGRoupId INT,
		isUser INT
	)
	INSERT INTO @inputTempTable
			SELECT
CASE  WHEN UG.value('(@_type_)[1]', 'INT') = 15  THEN UG.value('(@userGroupId)[1]', 'INT')
WHEN UG.value('(@_type_)[1]', 'INT') = 13 THEN UG.value('(@userId)[1]', 'INT')
					ELSE 0
			   END,
CASE WHEN UG.value('(@_type_)[1]', 'INT') = 15  THEN 0
WHEN UG.value('(@_type_)[1]', 'INT') = 13 THEN 1
					ELSE 0
			   END
		FROM @requestXML.nodes('App_UpdateSecurityAssociationRequest/securityAssociations/associations/userOrGroup') AS Input(UG)
	INSERT INTO UMSecurityAssociations (entityType1,entityID1,userOrGroupId,isUser,roleId,isCreator,authorId)
SELECT 194,@commcellId,input.userORGRoupId,input.isUser,@ViewRoleId,0,-1
	FROM @inputTempTable input LEFT JOIN UMSecurityAssociations sec
	ON input.userORGRoupId=sec.userOrGroupId and input.isUser=sec.isUser
AND sec.entityType1=194 and entityId1=@commcellId AND sec.entityType2=0
	WHERE sec.userOrGroupId  IS NULL
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode =ERROR_NUMBER()
		SET @errorSTring = 'Can not update associations '+ ERROR_MESSAGE()
END CATCH
  SET @o_responseXML = CAST( ( SELECT @errorCode '@errorCode', @errorString '@errorString'
                        FOR XML PATH('response'), ROOT('App_GenericResponse')) AS NVARCHAR(MAX))
GO

IF EXISTS (select * from GxQscripts where name = 'sec_addServiceCommcellAssociations')
	delete from GxQscripts where name = 'sec_addServiceCommcellAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_addServiceCommcellAssociations')
	delete from GXDBVersions where aliasname = 'sec_addServiceCommcellAssociations'
GO

insert into GXDBVersions values(2, 'sec_addServiceCommcellAssociations',  '00000000000000000000', 'sec_addServiceCommcellAssociations', '00000000000000000000')
GO

