

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_VisibilityNodeAccess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_VisibilityNodeAccess.sp,v $ $Id: sec_VisibilityNodeAccess.sp,v 1.9.48.2 2018/03/20 00:34:49 jiechen Exp $";
--
--  +========================================================================+
--  |      Procedure:  sec_VisibilityNodeAccess()
--  |
--  | Description:  Determines whether a user can see a chosen commcell object.
--  |
--  |       Input:  integer Affiliation: Bit map representation of which
--	|				affiliations are requested
--	|
--	|       Notes:  Objects are "visible" IF:
--	|               1. There is a Group with an Association Directly to them
--	|				2. Inherit Association Hierarchially
--	|				3. Any of their children are directly associated.
--	|				4. User is a member of ANY group with "all Associations" set
--	|
--  |      Output:  Returns list of groups that can see the object
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1        skatz						Initial Edit
--	|	1.2        saggarwal & jswaminathan		Initial Edit
--	|
--  +========================================================================+
--
-- Note that these must be "hard coded" in the SQL code
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_VisibilityNodeAccess <<<'

IF EXISTS (select * from sysobjects where name='sec_VisibilityNodeAccess')
	drop procedure sec_VisibilityNodeAccess
IF EXISTS (select * from GxQscripts where name='sec_VisibilityNodeAccess')
	delete from GxQscripts where name = 'sec_VisibilityNodeAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_VisibilityNodeAccess')
	delete from GXDBVersions where aliasname = 'sec_VisibilityNodeAccess'
GO
print '... Creating Procedure: sec_VisibilityNodeAccess'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_VisibilityNodeAccess
  @uid integer,
  @type1 integer,
  @id1 integer,
  @type2 integer,
  @id2 integer,
  @type3 integer,
  @id3 integer,
  @type4 integer,
  @id4 integer
AS
  DECLARE @canSee integer
  SET nocount ON
  SET @canSee = 0
	IF dbo.isNewSecurity() = 0
	BEGIN
  declare @commcellId		int
  declare @rowsAffected		int
	if object_id('tempdb.dbo.#UMuserGroup') is not Null	DROP TABLE #UMuserGroup
	create table #UMuserGroup (
		userId int not null,
		groupId int not null,
		flag     int not null
	)
	INSERT    INTO #UMuserGroup
		SELECT userID, groupId, flag
		FROM UMUserGroup
		WHERE userid = @uid
	INSERT    INTO #UMuserGroup
		SELECT DISTINCT
			UG.userId,
--			extGroup=UG.groupId,
			groupId=GM.umgroupId,
			GM.flag
		FROM
				UMDSUserGroup AS UG,
				UMDSGroupMaps AS GM
		WHERE
				UG.userID = @uid
				AND  GM.umdsgroupId = UG.groupId
  set @commcellId = 2
-- +------------------------------------------------------------------------+
-- | GET LIST OF GROUPS THE USER IS A MEMBER OF. "MARK" THOSE GROUPS THAT   |
-- | HAVE "ALL ASSOCIATIONS SET FOR RETURN TO CALLING PROGRAM               |
-- +------------------------------------------------------------------------+
  select groupId, canSee = allassociations INTO #TMP_VNA
  FROM #UMUserGroup, UMGroups
  WHERE userId = @uid AND (UMGroups.groupFlags & 1 = 1) AND #UMUserGroup.groupId = UMGroups.id
--   ----------------------------------------------------------------------------
--   Have to handle commcell Association seperately, since it is not a component
--   of the 3-couplet hiererachial definitions
--   ----------------------------------------------------------------------------
      update #TMP_VNA SET CANSEE = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
            AND GA.type1 = 2018 AND GA.id1 = @commcellId
            AND GA.type2 = 0      AND GA.id2 = 0
            AND GA.type3 = 0      AND GA.id3 = 0
            AND GA.type4 = 0      AND GA.id4 = 0
--	----------------------------------------------------
--	--  HERE, if  @type1 == CLIENT_ITEM 2009,       ----
--	--   WE NEED TO CHECK IF WE GET                 ----
--	--   VISIBILITY DUE TO CLIENT GROUP             ----
--	----------------------------------------------------
 IF (@type1 = 2009)
 BEGIN
  update #TMP_VNA SET canSee = 1
  FROM #TMP_VNA, userClientGroupClients as UCGC
  WHERE UCGC.groupId  = #TMP_VNA.groupId
    AND UCGC.userId   = @uid
    AND UCGC.clientId = @id1
 END
--   -------------------------------------------------
--   CHECKS IF THIS SPECIFIC OBJECT HAS AN ASSOCIATION
--   -------------------------------------------------
  update #TMP_VNA SET canSee = 1
  FROM #TMP_VNA, UMGroupAssociation AS GA
  WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
AND GA.type2 = @type2 AND ( GA.id2 = @id2 OR GA.id2 = -10 )
AND GA.type3 = @type3 AND ( GA.id3 = @id3 OR GA.id3 = -10 )
AND GA.type4 = @type4 AND ( GA.id4 = @id4 OR GA.id4 = -10 )
  set @rowsAffected = @@rowcount
  if (@rowsAffected <> 0)
      GOTO RETURN_RESULTS
-- +------------------------------------------------------------------------------------+
-- | LEVEL 4:
-- +------------------------------------------------------------------------------------+
	if (@type4 <> 0)
	BEGIN
--	  --------------------
--	  INHERIT FROM PARENTS:
--	  --------------------
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
AND GA.type2 = @type2 AND ( GA.id2 = @id2 OR GA.id2 = -10 )
AND GA.type3 = @type3 AND ( GA.id3 = @id3 OR GA.id3 = -10 )
			AND GA.type4 = 0	  AND GA.id4 = 0
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
AND GA.type2 = @type2 AND ( GA.id2 = @id2 OR GA.id2 = -10 )
            AND GA.type3 = 0      AND GA.id3 = 0
			AND GA.type4 = 0	  AND GA.id4 = 0
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
            AND GA.type2 = 0      AND GA.id2 = 0
            AND GA.type3 = 0      AND GA.id3 = 0
			AND GA.type4 = 0	  AND GA.id4 = 0
--		---------------------
--		INHERIT FROM CHILDREN
--		---------------------
--		(no children)
	END
-- +------------------------------------------------------------------------------------+
-- | LEVEL 3:
-- +------------------------------------------------------------------------------------+
	if (@type3 <> 0 AND @type4 = 0)
	BEGIN
--	  INHERIT FROM PARENTS:
--	  --------------------
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
AND GA.type2 = @type2 AND ( GA.id2 = @id2 OR GA.id2 = -10 )
            AND GA.type3 = 0      AND GA.id3 = 0
			AND GA.type4 = 0	  AND GA.id4 = 0
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
            AND GA.type2 = 0      AND GA.id2 = 0
            AND GA.type3 = 0      AND GA.id3 = 0
			AND GA.type4 = 0	  AND GA.id4 = 0
--		---------------------
--		INHERIT FROM CHILDREN
--		---------------------
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
            AND GA.type1 = @type1	AND GA.id1 = @id1
            AND GA.type2 = @type2   AND GA.id2 = @id2
            AND GA.type3 = @type3   AND GA.id3 = @id3
			AND GA.id4 <> 0
	END
-- +------------------------------------------------------------------------------------+
-- | LEVEL 2:
-- +------------------------------------------------------------------------------------+
	if (@type2 <> 0 AND @type3 = 0 AND @type4 = 0)
	BEGIN
--	  INHERIT FROM PARENTS:
--	  --------------------
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
AND GA.type1 = @type1 AND ( GA.id1 = @id1 OR GA.id1 = -10 )
            AND GA.type2 = 0      AND GA.id2 = 0
            AND GA.type3 = 0      AND GA.id3 = 0
			AND GA.type4 = 0	  AND GA.id4 = 0
--		---------------------
--		INHERIT FROM CHILDREN
--		---------------------
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
            AND GA.type1 = @type1	AND GA.id1 = @id1
            AND GA.type2 = @type2   AND GA.id2 = @id2
            AND (GA.id3 <> 0 OR GA.id4 <> 0)
	END
-- +------------------------------------------------------------------------------------+
-- | LEVEL 1:
-- +------------------------------------------------------------------------------------+
	if (@type1 <> 0 AND @type2 = 0 AND @type3 = 0 AND @type4 = 0)
	BEGIN
--	  INHERIT FROM PARENTS:
--	  --------------------
--	  (no parents)
--		---------------------
--		INHERIT FROM CHILDREN
--		---------------------
      update #TMP_VNA SET canSee = 1
      FROM #TMP_VNA, UMGroupAssociation AS GA
      WHERE #TMP_VNA.groupId = GA.groupId
            AND GA.type1 = @type1	AND GA.id1 = @id1
            AND (GA.type2 <> 0 OR GA.id3 <> 0 OR GA.id4 <> 0)
	END
  RETURN_RESULTS:
  IF EXISTS( select groupId from #TMP_VNA where canSee <> 0)
	SET @canSee = 1
  drop table #TMP_VNA
  if object_id('tempdb.dbo.#UMuserGroup') is not Null DROP TABLE #UMuserGroup
  END
  ELSE
  BEGIN
		DECLARE @newEntityType1 INT = dbo.sec_ObjectTypeToEntityType(@type1)
		DECLARE @newEntityType2 INT = dbo.sec_ObjectTypeToEntityType(@type2)
		DECLARE @newEntityType3 INT = dbo.sec_ObjectTypeToEntityType(@type3)
		DECLARE @newEntityType4 INT = dbo.sec_ObjectTypeToEntityType(@type4)
		DECLARE @newEntityType5 INT
IF @newEntityType1 = 3
		BEGIN
			DECLARE @clientId INT
			DECLARE @appTypeId INT
			DECLARE @instanceId INT
			DECLARE @backupsetID INT
			DECLARE @subclientId INT
			SELECT @clientId = clientId, @appTypeId = appTypeId, @instanceId = instanceId, @backupsetId = backupsetId,
				   @subclientId = subclientId
			FROM dbo.sec_convert4EntityTypeTo5EntityType(@type1, @type2, @type3, @type4, @id1, @id2, @id3, @id4)
SET @newEntityType2 = CASE WHEN @appTypeId = 0 THEN 0 ELSE 4 END
SET @newEntityType3 = CASE WHEN @instanceId = 0 THEN 0 ELSE 5 END
SET @newEntityType4 = CASE WHEN @backupsetId = 0 THEN 0 ELSE 6 END
SET @newEntityType5 = CASE WHEN @subclientId = 0 THEN 0 ELSE 7 END
			EXEC sec_checkPermissionOnEntity @uid, 0, @canSee OUTPUT,
											 @newEntityType1, @clientId,
											 @newEntityType2, @appTypeId,
											 @newEntityType3, @instanceId,
											 @newEntityType4, @backupsetId,
											 @newEntityType5, @subclientId, 0, 1
		END
		ELSE
			EXEC sec_checkPermissionOnEntity @uid, 0, @canSee OUTPUT, @newEntityType1, @id1
  END
  SELECT @canSee
  set nocount off
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_VisibilityNodeAccess')
	delete from GxQscripts where name = 'sec_VisibilityNodeAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_VisibilityNodeAccess')
	delete from GXDBVersions where aliasname = 'sec_VisibilityNodeAccess'
GO

insert into GXDBVersions values(2, 'sec_VisibilityNodeAccess',  '00010009004800020000', 'sec_VisibilityNodeAccess', '00010009004800020000')
GO

