

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_ValidateUsers.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_ValidateUsers()
--  | Description:  Validate users against UMUsers and if not found using APP_GUID and return UserGUID, loginName, primary SMTP, and display name for users given in input
--  | Input / Output: DM2ContentIndexing.CvEventUsers
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_ValidateUsers.sp,v $ $Id: sec_ValidateUsers.sp,v 1.5.12.3 2018/12/31 17:01:14 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_ValidateUsers')
BEGIN
	print '>>> Drop Stored Procedure: sec_ValidateUsers <<<'
	drop procedure sec_ValidateUsers
END
IF EXISTS (select * from GxQscripts where name='sec_ValidateUsers')
	delete from GxQscripts where name = 'sec_ValidateUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ValidateUsers')
	delete from GXDBVersions where aliasname = 'sec_ValidateUsers'
GO
print '... Creating Procedure: sec_ValidateUsers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_ValidateUsers
  @i_xmlText XML 
AS
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Declarations
DECLARE @csHostName nvarchar(255)
DECLARE @CV_APPGUID_STATUSBIT_PRIMARYSMTP    INT
DECLARE @CV_APPGUID_STATUSBIT_DOMAINALIAS    INT
DECLARE @CV_APPGUID_STATUSBIT_DISPLAYNAME	 INT
DECLARE @CV_APPGUID_STATUSBIT_SECONDARYSMTP  INT
DECLARE @debug BIT = 0
--Intialize
SET @CV_APPGUID_STATUSBIT_PRIMARYSMTP = 0x08
SET @CV_APPGUID_STATUSBIT_DOMAINALIAS = 0x04
SET @CV_APPGUID_STATUSBIT_DISPLAYNAME = 0x01
SET @CV_APPGUID_STATUSBIT_SECONDARYSMTP = 0x02
--Create necessary temporary tables
IF OBJECT_ID('tempdb.dbo.#UsersTemp') is not null
DROP TABLE #UsersTemp
CREATE TABLE #UsersTemp ( inputName nvarchar(255),
loginName nvarchar(255),
UserGUID nvarchar(1024),
SmtpAddress nvarchar(255),
MatchFound BIT not null default 0,
IsMatchFromAppGuid BIT NOT NULL default 0,
displayName nvarchar(1024)
)
-- let us keep the status that we want to consider in a temp table too
CREATE TABLE #MatchStatusFlags (StatusID int)
--
-- we will always match display name or primary smtp
--
INSERT INTO #MatchStatusFlags
SELECT @CV_APPGUID_STATUSBIT_PRIMARYSMTP
UNION
SELECT @CV_APPGUID_STATUSBIT_DISPLAYNAME
--
-- customers who want only primary smtp to be matched, we will not need match secondary smtp status records..
--
IF NOT EXISTS (SELECT * FROM APP_AdvanceSettings WHERE keyName = 'MatchPrimarySmtpForDiscoverySearch' and convert(varchar(20), value) = 'True')
BEGIN
	INSERT INTO #MatchStatusFlags
	SELECT @CV_APPGUID_STATUSBIT_SECONDARYSMTP
END
--
SELECT @csHostName = '@' + NET_HOSTNAME FROM APP_CLIENT
WHERE id = 2
--Populate temporary tables with input values
INSERT INTO #UsersTemp (inputName)
SELECT dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@aliasName', 'nvarchar(1024)'), '')) as inputName
FROM @i_xmlText.nodes('/DM2ContentIndexing_CvEventUsers/users') T(ref)
-- IF no inputs, nothing to find, just exit..
IF NOT EXISTS (SELECT * FROM #UsersTemp WHERE MatchFound = 0)
GOTO exitLine
--Find match from UMUsers and update temporary table
UPDATE T
SET T.UserGUID = U.userGuid,
T.SmtpAddress = (CASE WHEN U.umDSproviderId = 0 AND ISNULL(U.email,'') = '' THEN U.login + @csHostName ELSE U.email END),
T.loginName = U.login,
T.MatchFound = 1,
T.displayName = ( CASE WHEN U.umDSProviderId = 0  THEN '' ELSE U.name END)
FROM #UsersTemp T
JOIN UMUsers U ON ISNULL(U.userGuid, '') <> '' AND (T.inputName = U.name OR (isnull(u.email,'') <> '' and T.inputName = U.email) OR (U.umDSproviderId = 0 and isnull(u.email,'') = '' and T.inputName = U.login + @csHostName))
--Debug
IF @debug = 1
SELECT *, 'UMUserEntry' FromUMUsers FROM #UsersTemp
--Find match using APP_GUID and update user details as per matches found..
UPDATE T
SET T.UserGUID = A.GUID, T.MatchFound = 1, T.IsMatchFromAppGuid = 1
FROM #UsersTemp T
JOIN APP_GUID A ON T.inputName = A.name AND A.status in (SELECT StatusID FROM #MatchStatusFlags)
WHERE T.MatchFound = 0
--Now we have GUID from APP_GUID, so from the vertical table, we have to get and update smtp and login user name..
UPDATE T
SET T.SmtpAddress = A.name
FROM #UsersTemp T JOIN APP_GUID A ON T.UserGUID = A.GUID AND A.status = @CV_APPGUID_STATUSBIT_PRIMARYSMTP
WHERE T.IsMatchFromAppGuid = 1
UPDATE T
SET T.loginName = A.name
FROM #UsersTemp T
JOIN APP_GUID A ON UserGUID = GUID AND status = @CV_APPGUID_STATUSBIT_DOMAINALIAS
WHERE T.IsMatchFromAppGuid = 1
UPDATE T SET
T.displayName = A.name
FROM #UsersTemp T
JOIN APP_GUID A ON UserGUID = GUID AND status = @CV_APPGUID_STATUSBIT_DISPLAYNAME
WHERE T.IsMatchFromAppGuid = 1
--GUID has extra flower braces when result is from APP_GUID, So discard it here..
UPDATE T
SET T.UserGUID = REPLACE(REPLACE(T.UserGUID, '{', ''), '}', '')
FROM #UsersTemp T
WHERE IsMatchFromAppGuid = 1
--Return result from temporary table..
SELECT T.UserGUID AS '@userGuid', T.SmtpAddress AS '@smtpAddress', T.loginName AS '@loginName', T.inputName as '@aliasName', T.displayName as '@displayName'
FROM #UsersTemp T
FOR XML PATH('users'), ROOT('DM2ContentIndexing_CvEventUsers')
exitLine:
if @debug = 1
SELECT *, 'ResultEntry' FinalOutput FROM #UsersTemp
if object_id('tempdb.dbo.#MatchStatusFlags') is not null drop table #MatchStatusFlags
if object_id('tempdb.dbo.#UsersTemp') is not null drop table #UsersTemp
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_ValidateUsers')
	delete from GxQscripts where name = 'sec_ValidateUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ValidateUsers')
	delete from GXDBVersions where aliasname = 'sec_ValidateUsers'
GO

insert into GXDBVersions values(2, 'sec_ValidateUsers',  '00010005001200030000', 'sec_ValidateUsers', '00010005001200030000')
GO

