

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UpgradeUMGroupAssociation.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UpgradeUMGroupAssociation.sp,v $ $Id: sec_UpgradeUMGroupAssociation.sp,v 1.4.42.1 2017/02/10 21:57:48 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UpgradeUMGroupAssociation <<<'

IF EXISTS (select * from sysobjects where name='sec_UpgradeUMGroupAssociation')
	drop procedure sec_UpgradeUMGroupAssociation
IF EXISTS (select * from GxQscripts where name='sec_UpgradeUMGroupAssociation')
	delete from GxQscripts where name = 'sec_UpgradeUMGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpgradeUMGroupAssociation')
	delete from GXDBVersions where aliasname = 'sec_UpgradeUMGroupAssociation'
GO
print '... Creating Procedure: sec_UpgradeUMGroupAssociation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_UpgradeUMGroupAssociation
  @userGroupId integer,
  @userGroupRoleId integer, 
  @errorCode integer OUTPUT,
  @errorString nvarchar(1024) OUTPUT,
  @isReturn integer=0
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorString integer
DECLARE @sqlError integer=0
BEGIN TRY
--Associations  ( by now we have role created for our user Group)
	----------------------------------------------------------------------------------------------------------------------------
	-- Things to take care
	--1. All associations.
	--2. Commcell level associations: to all associations.
	--3. @groupAssociation has only for type 4 column, type 3 can backup set or instance.
	--4. 9615,8107,8180 not done ( dont know the entityType for it)
	--5. DM2 * items should not be in @groupAssociations
	------------------------------------------------------------------------------------------------------------------------------
	IF EXISTS ( SELECT 1 FROM UMGroups WHERE id=@userGroupId and allAssociations=1)
	BEGIN
		IF NOT EXISTS ( SELECT 1 FROM UMSecurityAssociations WHERE isUser=0 and userOrGroupId=@userGroupId and entityType1=1 and entityId1=2 and roleId=@userGroupRoleId and isCreator=0)
			INSERT UMSecurityAssociations( roleId,isUser,userOrGroupId,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1)
			VALUES(@userGroupRoleId,0,@userGroupId,1,1,0,0,0,1,2)
	END
	DECLARE  @groupAssociation TABLE ( type1 integer,id1 integer,type2 integer,id2 integer,type3 integer,id3 integer,type4 integer,id4 integer)
	INSERT INTO @groupAssociation  ( type1 ,id1 ,type2 ,id2 ,type3 ,id3 ,type4 ,id4)
	SELECT type1,id1,type2,id2,type3,id3,type4,id4
	FROM UMGroupAssociation
	WHERE groupId=@userGroupId
	UPDATE @groupAssociation
	set type1=dbo.sec_objectTypetoEntityType(type1),type2=dbo.sec_objectTypetoEntityType(type2),type3=dbo.sec_objectTypetoEntityType(type3),type4=dbo.sec_objectTypetoEntityType(type4)
	--not supported currently in 11.0 ( update list for rest of all)
	IF EXISTS ( SELECT type1 FROM @groupAssociation WHERE type1 =-1 or type2=-1 or type3=-1 or type4=-1)
		print 'Warning message :  object types are not supported yet, they will be lost with upgrade.'
	DELETE @groupAssociation
	WHERE type1 =-1 or type2=-1 or type3=-1 or type4=-1
	--Get all static node and  delete them
IF EXISTS ( SELECT type1 FROM @groupAssociation WHERE id1=-10 and type1 in (4,5,6,7) ) --all  entities  are not supported for ( apptype,instance,backupset,subclient)
	BEGIN
		SET @sqlError =210
		print 'Invalid All entity selection'
		GOTO EXIT_ERROR
	END
	MERGE UMSecurityAssociations AS SA
	USING (SELECT @userGroupRoleId,@userGroupId,type1
			FROM @groupAssociation
			WHERE id1=-10) as GA(roleId,userGroupId,entityType)
			ON (SA.isUser=0 and  SA.userOrGroupId=GA.userGroupId AND SA.entityType1=GA.entityType and SA.includeAll=1)
	WHEN NOT MATCHED THEN
		INSERT ( roleId,isUser,userOrGroupId,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,includeAll)
		VALUES(GA.roleId,0,GA.userGroupId,1,1,0,0,0,Ga.entityType,1);
	DELETE @groupAssociation
	WHERE id1=-10
	--Now just update  object type to entityType.
	MERGE UMSecurityAssociations AS SA
	USING(SELECT  @userGroupRoleId,@userGroupId,type1,id1
			  FROM  @groupAssociation
WHERE type1 not in (4,5,6,7) and  type2=0 and type3=0 and type4=0 ) as GA ( roleId,userGroupId,entityType,entityId)
	ON (SA.isUser=0 and  SA.userOrGroupId=GA.userGroupId AND SA.entityType1=GA.entityType AND SA.entityId1=GA.entityId AND SA.entityType2=0 AND SA.entityType3=0 AND entityType4=0 and entityType5=0 and SA.roleId=GA.roleId)
	WHEN NOT MATCHED THEN
		INSERT ( roleId,isUser,userOrGroupId,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1)
		VALUES(GA.roleId,0,GA.userGroupId,1,1,0,0,0,Ga.entityType,Ga.entityId);
	IF EXISTS ( SELECT type1 FROM @groupAssociation WHERE
(  type1=4 OR
(type1<>3 and (type2<>0 OR type3<>0 OR type4<>0)) OR --only client entity allowed to populate type2,type3,type4
(type1=3 and type2<>0 and type2<>4) OR
(type1=3 and type2<>4 and (type3<>0 OR type4<>0)) ) )            --if type2 is there than it should be appType.
	BEGIN
		SET @sqlError =24
		print 'Invalid @groupAssociation'
		GOTO EXIT_ERROR
	END
	--apptype level, instance level,backupset level ( straight)
	MERGE UMSecurityAssociations SA
	USING (
SELECT DISTINCT @userGroupRoleId,0,@userGroupId,3,id1 as clientId ,4,id2 as appType ,type3,id3,type4,id4,0,0
	FROM @groupAssociation
WHERE  type1=3 and type2=4 and ((type3=0 and type4=0) OR (type3=5 and (type4=0 OR type4=6)))
	UNION
	--apptype,instance,subclient
SELECT DISTINCT @userGroupRoleId,0,@userGroupId, 3,id1 as clientId,4,id2 as appType,5,id3 as instanceId ,6,ISNULL(backupSet,1) as backupSet,7,id4 as subclientId
	FROM @groupAssociation LEFT OUTER JOIN APP_Application ON id4=id
WHERE type1=3 and type2=4 and type3=5 and type4=7
	UNION
	--apptype ,backupset ( set default instance 1)
SELECT DISTINCT @userGroupRoleId,0,@userGroupId,3,id1,4,id2,5,1,6,id3,type4,id4
	FROM @groupAssociation
WHERE  type1=3 and type2=4 and type3=6
	UNION
	--type 1 is set as instance --should not happen
SELECT DISTINCT @userGroupRoleId,0,@userGroupId, 3,clientId,4,appTypeId,5,instance,0,0,0,0
	FROM @groupAssociation
	JOIN APP_Application  on id1=instance
WHERE   type1=5  and id1 <>1  -- there can be default instance /backupSet applicable for multiple client ( not unique ) this should not happened anywhere.
	UNION
	--type1  set backupSet should not happen
SELECT DISTINCT @userGroupRoleId,0,@userGroupId,3,clientId,4,appTypeId,5,instance,6,backupSet,0,0
	FROM @groupAssociation
	JOIN APP_Application  on id1=backupSet
WHERE  type1=6  and id1 <>1  -- there can be default instance /backupSet applicable for multiple client ( not unique ) this should not happened anywhere.
	UNION
	--type1 is set as subclient --ideally should not happen but look like happening for edge drive subclients.
SELECT DISTINCT @userGroupRoleId,0,@userGroupId, 3,clientId,4,appTypeId,5,instance,6,backupSet,7,id
	FROM @groupAssociation
	JOIN APP_Application  on id1=instance
WHERE  type1=7 ) as GA(roleId,isUser,userGroupId,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5)
	ON ( SA.isUser=0 and  SA.userOrGroupId=GA.userGroupId AND SA.entityType1=GA.entityType1 AND SA.entityId1=GA.entityId1
			AND SA.entityType2=GA.entityType2 AND SA.entityId2=GA.entityId2
			AND SA.entityType3=GA.entityType3 AND SA.entityId3=GA.entityId3
			AND SA.entityType4=GA.entityType4 AND SA.entityId4=GA.entityId4
			AND SA.entityType5=GA.entityType5 AND SA.entityId5=GA.entityId5
			and SA.roleId=GA.roleId )
	WHEN NOT MATCHED THEN
		INSERT   ( roleId,isUSer,userOrGroupId,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5)
			VALUES( roleId,isUser,userGroupId,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorcode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE ()
END CATCH
EXIT_ERROR:
IF(@errorCode<>0)
BEGIN
	SET @errorCode=@sqlError
	SET @errorString= 'Invalid UMgroup Association'
END
IF(@isReturn<>0)
	SELECT @errorCode,@errorString

IF EXISTS (select * from GxQscripts where name = 'sec_UpgradeUMGroupAssociation')
	delete from GxQscripts where name = 'sec_UpgradeUMGroupAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpgradeUMGroupAssociation')
	delete from GXDBVersions where aliasname = 'sec_UpgradeUMGroupAssociation'
GO

insert into GXDBVersions values(2, 'sec_UpgradeUMGroupAssociation',  '00010004004200010000', 'sec_UpgradeUMGroupAssociation', '00010004004200010000')
GO

