

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UnlockUserAccounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_UnlockUserAccounts"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UnlockUserAccounts')
BEGIN
	print '>>> Drop Stored Procedure: sec_UnlockUserAccounts <<<'
	drop procedure sec_UnlockUserAccounts
END
IF EXISTS (select * from GxQscripts where name='sec_UnlockUserAccounts')
	delete from GxQscripts where name = 'sec_UnlockUserAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UnlockUserAccounts')
	delete from GXDBVersions where aliasname = 'sec_UnlockUserAccounts'
GO
print '... Creating Procedure: sec_UnlockUserAccounts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UnlockUserAccounts
  @lockedAccounts XML = NULL
AS
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON
  DECLARE @result INT = 0
  DECLARE @maxLockDuration INT = 0
  DECLARE @maxLoginAttempts INT = 0
  DECLARE @eligibleLockedAccounts INT = 0
  DECLARE @handle INT = 0
-- -- SP BODY BEGIN : sec_UnlockUserAccounts.spb -----------------------------------------------------------------------------------------------------------------------------------
BEGIN
	DECLARE @SPBodycurrentTime_48036 INT = dbo.GetUnixTime(GetUTCDate())
	SET @maxLockDuration = ISNULL((select convert(int,value) from GXGlobalParam WITH(nolock) where name = 'AccountLockDuration'), 0)
	SET @maxLoginAttempts = ISNULL((select convert(int,value) from GXGlobalParam WITH(nolock) where name = 'FailedLoginAttemptLimit'), 0)
	DECLARE @maxLoginAttemptsStr VARCHAR(10) = CONVERT(VARCHAR(10), @maxLoginAttempts)
	IF @lockedAccounts is not null
		BEGIN
            SELECT  ref.value('@userId', 'INT') AS userId, ref.value('@userName', 'NVARCHAR(255)')  AS userName
            INTO    #AccountsTobeUpdated
            FROM    @lockedAccounts.nodes ('Api_UnlockAccountsReq/lockedAccounts/user') R(ref)
			UPDATE  UUP
            SET     UUP.attrVal = N'0', UUP.modified = @SPBodycurrentTime_48036
            FROM    UMUsersProp UUP JOIN #AccountsTobeUpdated T ON UUP.componentNameId = T.userId
WHERE   UUP.attrName = 'Failed login attempts'
			SELECT  @result = COUNT(*)
            FROM    UMUSERSPROP UUP WITH(NOLOCK) JOIN #AccountsTobeUpdated T WITH(NOLOCK) ON UUP.componentNameId = T.userId
WHERE       UUP.attrName = 'Failed login attempts'
                    AND ISNUMERIC(UUP.attrVal) = 1
                    AND CONVERT(INT, UUP.attrVal) > 0
			DROP TABLE #AccountsTobeUpdated
            SET @eligibleLockedAccounts = @result
			SET NOCOUNT OFF
		END
	ELSE
		BEGIN
			IF(@maxLoginAttempts > 0)
			BEGIN
				SELECT  @eligibleLockedAccounts = COUNT(*)
                FROM    UMUsersProp WITH(nolock)
WHERE       attrName = 'Failed login attempts'
					    AND attrVal = @maxLoginAttemptsStr					-- If we use the integer variable, SQL query optimizer tries to convert all attrVal to integer and ends up in type conversion error.
																			-- So better compare with string variable, avoiding converting attrVal to other datatype.
					    AND modified + @maxLockDuration <= @SPBodycurrentTime_48036
				UPDATE  UMUsersProp
                SET     attrval = N'0'
WHERE       attrName = 'Failed login attempts'
					    AND attrVal = @maxLoginAttemptsStr
					    AND modified + @maxLockDuration <= @SPBodycurrentTime_48036
				SELECT  @result = COUNT(*)
                FROM    UMUsersProp WITH(nolock)
WHERE       attrName = 'Failed login attempts'
					    AND attrVal = @maxLoginAttemptsStr
					    AND modified + @maxLockDuration <= @SPBodycurrentTime_48036
			END
		END
SET NOCOUNT OFF
END
-- -- SP BODY END : sec_UnlockUserAccounts.spb -------------------------------------------------------------------------------------------------------------------------------------
    SELECT @result, @maxLockDuration, @maxLoginAttempts, @result, @handle
    SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UnlockUserAccounts')
	delete from GxQscripts where name = 'sec_UnlockUserAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UnlockUserAccounts')
	delete from GXDBVersions where aliasname = 'sec_UnlockUserAccounts'
GO

insert into GXDBVersions values(2, 'sec_UnlockUserAccounts',  '00000000000000000000', 'sec_UnlockUserAccounts', '00000000000000000000')
GO

