

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSupdateUserGroupsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSupdateUserGroupsReq.sp,v $ $Id: sec_UMDSupdateUserGroupsReq.sp,v 1.5.304.2 2018/03/26 12:55:44 snandhini Exp $";
--#include <EvappMgr/EvAppUMDS.h>
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--   Rev.    Author      Description
--   ---     ------      ----------------------------------------------------------------
--	 1.9     skatz		 Only Save Ext.  Groups for User if Group --> Group Mapping exists
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSupdateUserGroupsReq.sp,v $ $Id: sec_UMDSupdateUserGroupsReq.sp,v 1.12.58.9 2020/07/26 21:00:29 shebbarshankar Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UMDSupdateUserGroupsReq')
BEGIN
	print '>>> Drop Stored Procedure: sec_UMDSupdateUserGroupsReq <<<'
	drop procedure sec_UMDSupdateUserGroupsReq
END
IF EXISTS (select * from GxQscripts where name='sec_UMDSupdateUserGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSupdateUserGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSupdateUserGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSupdateUserGroupsReq'
GO
print '... Creating Procedure: sec_UMDSupdateUserGroupsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSupdateUserGroupsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
declare @errorCode INT
declare @iDoc           int
declare @xmlReqMsg      nvarchar(256)
declare @xmlReqMsgNode  nvarchar(512)
declare @userId         int
declare @extGroupId     int
declare @localeId		int
declare @providerId		int
declare @nowTime		int			-- Will use for finding groups user is no longer a member of!
declare @extGroupName  nvarchar(1024)
set @errorCode = 0
set @errorString = ''
-------------------------------------
-- FETCH PARAMETERS FROM XML INPUT --
-------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSupdateUserGroupsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
------------------------
-- PROCESS PARAMETERS --
------------------------
BEGIN TRY
	BEGIN TRAN
	set @nowTime = dbo.GetUnixTime(GetUTCDate())
	set @xmlReqMsgNode = @xmlReqMsg +'/header'
	set @userId             = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (userId nvarchar(1024) '@userId'))
	set @localeId           = (select * from OPENXML(@iDoc, 'EVGui_UMDSupdateUserGroupsReq/header', 0) WITH (localeId nvarchar(1024) '@localeId'))
	set @providerId         = (select umDSproviderId from UMUsers where id = @userId) -- select userId=@useriD, providerId = @providerId
	set @xmlReqMsgNode = @xmlReqMsg +'/groupName'
	declare groups_cursor CURSOR FOR
		select val from OPENXML(@iDoc, @xmlReqMsgNode, 0)
		WITH ( val nvarchar(1024))
	OPEN  groups_cursor
	FETCH NEXT FROM groups_cursor
		INTO @extGroupName
	WHILE @@FETCH_STATUS = 0
	BEGIN
	    declare @hostName nvarchar(512)
		declare @groupName nvarchar(512)
		declare @groupProviderId INT = @providerId
		IF(charindex('\',@extGroupName) > 0)
		BEGIN
		 SET @hostName = SUBSTRING(@extGroupName,0,charindex('\',@extGroupName))
		 SET @groupName=SUBSTRING(@extGroupName,charindex('\',@extGroupName)+1,len(@extGroupName)-len(@hostName))
		 SET @groupProviderId=(select top(1) id from UMDSProviders WHERE hostName = @hostName)
		END
		ELSE
		 SET @groupName=@extGroupName
		set @extGroupId = ISNULL((select id from UMDSgroups Where name = @groupName AND umdsProviderId = @groupProviderId), 0)
		if @extGroupId = 0
			GOTO NEXT_EXTERNAL_GROUP
		if not exists  (select 1 from UMDSUserGroup where userId = @userId AND groupId = @extGroupId)
		BEGIN
			INSERT UMDSUserGroup
				 VALUES (@userId, @extGroupId, @nowTime)
		END
		ELSE
		BEGIN
			UPDATE UMDSUserGroup
			  SET flag = @nowTime
				WHERE userId = @userId AND groupId = @extGroupId
		END
		if not exists  (select 1 from UMUserGroup where userId = @userId AND groupId = @extGroupId)
		BEGIN
			INSERT UMUserGroup
				 VALUES (@userId, @extGroupId, @nowTime)
		END
		else
		BEGIN
			UPDATE UMUserGroup
			  SET flag = @nowTime
				WHERE userId = @userId AND groupId = @extGroupId
		END
NEXT_EXTERNAL_GROUP:
		FETCH NEXT FROM groups_cursor
			INTO @extGroupName
	END
	CLOSE groups_cursor
	DEALLOCATE groups_cursor
	IF OBJECT_ID('tempdb.dbo.#umdsProvidersForGivenUser') IS NOT NULL
		DROP TABLE #umdsProvidersForGivenUser
	create table #umdsProvidersForGivenUser
	(
		umdsProviderId int,
		providerServiceType int,
		userGroupId int,
		groupFlags int
	)
	insert into #umdsProvidersForGivenUser(umdsProviderId,providerServiceType,userGroupId,groupFlags)
	select UMDS.id,UMDS.serviceType,Temp.id,Temp.groupFlags from UMDSProviders UMDS
	join
	(select UG.id,UG.umdsProviderId,UG.groupFlags from UMGroups UG
	join UMUserGroup UMUG on UG.id = UMUG.groupId and UMUG.userId = @userId) as Temp
	on Temp.umdsProviderId = UMDS.id
where UMDS.id <> 0 and UMDS.serviceType <> 5
	--DELETE UMDSUserGroup WHERE userId = @userId and flag <> @nowTime
	DELETE UMDS FROM UMDSUserGroup UMDS join #umdsProvidersForGivenUser umdsProviders
	ON umdsProviders.userGroupId = UMDS.groupId and UMDS.flag <> @nowTime
	where UMDS.userId = @userId
	DELETE UG FROM UMUSERGroup UG join #umdsProvidersForGivenUser umdsProviders
	ON umdsProviders.userGroupId = UG.groupId and UG.flag <> @nowTime
	Where UG.userId = @userId
	-- We need to delete only those AD groups to which the AD user does not belong to. The AD user might be part of local / Organization groups that should be retained.
	COMMIT TRAN						-- GOT HERE, THE ENTIRE OPERATION SUCCEEDED!
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorString = ERROR_MESSAGE()
	set @errorCode = 1
	ROLLBACK TRAN
END   CATCH
------------------------------
-- THIS IS THE  RESPONSE  ----
------------------------------
SELECT  1                    as TAG,
        NULL                 as Parent,
SUBSTRING(@xmlReqMsg, 2, LEN(@xmlReqMsg))     as [CVGui_GenericResp!1!msgTag],
0						 as [CVGui_GenericResp!1!msgID],
@errorCode               as [CVGui_GenericResp!1!errorCode],
@errorString             as [CVGui_GenericResp!1!errorMessage],
		NULL				as [hdr!2!time],
		NULL				as [hdr!2!uBrowserID],
		NULL				as [hdr!2!uPipeID],
		NULL				as [hdr!2!uPipeType]
-- Header information
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSupdateUserGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSupdateUserGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSupdateUserGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSupdateUserGroupsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSupdateUserGroupsReq',  '00010005030400020000', 'sec_UMDSupdateUserGroupsReq', '00010005030400020000')
GO

