

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSgetValidProviders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSgetValidProviders.sp,v $ $Id: sec_UMDSgetValidProviders.sp,v 1.6 2015/01/21 08:16:05 mnatarajan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_UMDSgetValidProviders()
--  |
--  | Description:  Fetches a flattened list of valid UMDS Providers
--  |
--  |
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSgetValidProviders <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSgetValidProviders')
	drop procedure sec_UMDSgetValidProviders
IF EXISTS (select * from GxQscripts where name='sec_UMDSgetValidProviders')
	delete from GxQscripts where name = 'sec_UMDSgetValidProviders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSgetValidProviders')
	delete from GXDBVersions where aliasname = 'sec_UMDSgetValidProviders'
GO
print '... Creating Procedure: sec_UMDSgetValidProviders'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_UMDSgetValidProviders
AS
----****** Object:  StoredProcedure [dbo].[sec_getValidUMDSProviders]    Script Date: 02/16/2011 17:17:52 ******/
SET NOCOUNT ON
IF dbo.isNewSecurity() = 0
BEGIN
	-- The below table contains list of valid UMGroups Ids possible.
	-- A valid UMgroup should contain at least 1 association and 1 cAPABILITY.
	DECLARE @ValidGroups table
	(
		GroupId int
	)
	-- Finding groups which have valid association
	Insert into @ValidGroups
	select id
	from UMGroups
	where allAssociations=1
	Union
	select groupId
	from UMGroupAssociation
	-- Now delete those groups which do not have any capabilities.
	delete from @ValidGroups
	where GroupId not in
	(
		select id
		from UMGroups
		where allCapabilities=1
		Union
		select groupId
		from UMGroupCapability
	)
	-- Now delete those groups which are disabled.
	delete @ValidGroups
	FROM  @ValidGroups as VL, UMGroups as GR
	WHERE GR.id = VL.groupId
	AND  (GR.groupFlags = 0 OR GR.groupFlags = 2)
		-- This will be used for checking whether Autologin feature is to be enabled or disabled.
		-- Returns only valid UMDSProviders
			-- Meaning the UMDSProvider should be enabled
			-- Shld contain some UMDSProviderGroup which is enabled
			-- And those UMDSGroups should belong to UMGroups which have some association
			-- and some capability.
	select umdsP.domainName,umdsP.id,umdsP.enabled,umdsP.flags,umdsP.hostName
	from dbo.UMDSProviders umdsP
	inner join dbo.UMDSgroups umdsG on
	umdsP.id = umdsG.umdsProviderId
	inner join dbo.UMDSGroupMaps umdsGM on
	umdsG.id = umdsGM.umDSgroupId
	where umdsP.enabled=1
	and umdsG.enabled = 1
	and umdsGM.umgroupId in
	(
		select VG.GroupId from
		@ValidGroups VG
	)
END
ELSE
BEGIN
	DECLARE @usersList TABLE (userID INT)
	DECLARE @userGroupslist TABLE (userGroupId INT)
	DECLARE @umdsProvidersList TABLE (umdsProviderID INT)
	INSERT INTO @usersList
		SELECT userOrGroupId
		FROM UMSecurityAssociations
		WHERE isUser = 1
		UNION
		SELECT userOrGroupId
		FROM UMOwners
		WHERE isUser = 1
	INSERT INTO @userGroupsList
		SELECT userOrGroupId
		FROM UMSecurityAssociations
		WHERE isUser = 0
		UNION
		SELECT userOrGroupId
		FROM UMOwners
		WHERE isUser = 0
	DELETE Tbl
	FROM @userGroupsList Tbl INNER JOIN UMGroups Groups
	ON Tbl.userGroupId = Groups.id
	WHERE Groups.groupFlags & 1 = 0
	INSERT INTO @umdsProvidersList
		SELECT umdsProviderId
		FROM @usersList Tbl INNER JOIN UMUsers Users
		ON Tbl.userId = Users.id
		WHERE Users.enabled <> 0
	INSERT INTO @umdsProvidersList
		SELECT umdsProviderId
		FROM @userGroupsList Tbl INNER JOIN UMGroups Groups
		ON Tbl.userGroupId = Groups.id
		UNION
		SELECT umdsProviderId
		FROM @userGroupsList Tbl INNER JOIN UMDSGroupMaps GM
		ON Tbl.userGroupId = GM.umGroupId INNER JOIN UMGroups Groups
		ON GM.umdsGroupId = Groups.id
		WHERE Groups.groupFlags & 1 <> 0
	select umdsP.domainName,umdsP.id,umdsP.enabled,umdsP.flags,umdsP.hostName
	from dbo.UMDSProviders umdsP
	where umdsP.enabled=1 and umdsP.id in
	(
		select umdsproviderID from
		@umdsProvidersList
	)
	and umdsP.id>0
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSgetValidProviders')
	delete from GxQscripts where name = 'sec_UMDSgetValidProviders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSgetValidProviders')
	delete from GXDBVersions where aliasname = 'sec_UMDSgetValidProviders'
GO

insert into GXDBVersions values(2, 'sec_UMDSgetValidProviders',  '00010006000000000000', 'sec_UMDSgetValidProviders', '00010006000000000000')
GO

