

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSUpdateSSOCredentialsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSUpdateSSOCredentialsReq.sp,v $ $Id: sec_UMDSUpdateSSOCredentialsReq.sp,v 1.1.304.1 2018/03/15 23:33:51 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSUpdateSSOCredentialsReq.sp,v $ $Id: sec_UMDSUpdateSSOCredentialsReq.sp,v 1.7.58.4 2018/09/05 23:22:22 jswaminathan Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSUpdateSSOCredentialsReq <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSUpdateSSOCredentialsReq')
	drop procedure sec_UMDSUpdateSSOCredentialsReq
IF EXISTS (select * from GxQscripts where name='sec_UMDSUpdateSSOCredentialsReq')
	delete from GxQscripts where name = 'sec_UMDSUpdateSSOCredentialsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSUpdateSSOCredentialsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSUpdateSSOCredentialsReq'
GO
print '... Creating Procedure: sec_UMDSUpdateSSOCredentialsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSUpdateSSOCredentialsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @iDoc                   int
declare @xmlReqMsg       nvarchar(256)
declare @xmlReqMsgNode   nvarchar(512)
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
declare @sqlError				int
declare @topOperation           int
-------------------------------------
declare @providerId				integer
declare @trustedHostUser		nvarchar(256)
declare @trustedHostPassword	nvarchar(256)
declare @trustedHostSite		nvarchar(256)
--------------------------------------------
set @errorCode = 0                                               -- ASSUME WE ARE GOING TO BE SUCCESSFUL!
set @errorString = ''
-------------------------------------
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
	set @xmlReqMsg = '/EVGui_UMDSUpdateSSOCredentialsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
set @xmlReqMsgNode = @xmlReqMsg + '/provider'
set @providerId             = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id       nvarchar(100)   '@id'))
set @xmlReqMsgNode = @xmlReqMsg
set @trustedHostUser        = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (trustedHostUser nvarchar(256)     '@trustedHostUser'))
set @trustedHostPassword    = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (trustedHostPassword nvarchar(256) '@trustedHostPassword'))
set @trustedHostSite        = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (trustedHostSite nvarchar(256)     '@trustedHostSite'))
-------------------------------
if @providerId <= 0
BEGIN
	Set @errorCode = -1
	set @errorString = 'Provider id <= 0 not valid'
	goto RETURN_RESULTS
END
IF(dbo.isNewSecurity() = 1)
BEGIN
	DECLARE @hasRights AS INT
	SET @hasRights = 0
EXEC sec_checkPermissionOnEntity @ownerId, 250, @hasRights OUTPUT, 61, @providerId
	IF @hasRights = 0
	BEGIN
			SET @errorCode = 1111
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2267 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in)
	        SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
SET @errorString = REPLACE(@errorString, '^2%s', dbo.sec_getLocalizedPermission(250, @locale_in))
	        SET @errorString = REPLACE(@errorString, '^3%s', (SELECT domainName FROM UMDSProviders WHERE id = @providerId))
			GOTO RETURN_RESULTS
	END
END
-------------------------------------
-- DO SOMETHING WITH INPUTS        --
-------------------------------------
BEGIN TRY
	Update UMDSproviders
	Set trustedHostUser = @trustedHostUser, trustedHostPW = @trustedHostPassword
	Where id = @providerId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Cannot Add/update for [' +@xmlReqMsg +']: ' +ERROR_MESSAGE()
END CATCH
-------------------------------------
-------------
RETURN_RESULTS:
--------------
SELECT  1                    as TAG,
        NULL                 as Parent,
SUBSTRING(@xmlReqMsg, 2, LEN(@xmlReqMsg))     as [CVGui_GenericResp!1!msgTag],
0						 as [CVGui_GenericResp!1!msgID],
@errorCode               as [CVGui_GenericResp!1!errorCode],
@errorString             as [CVGui_GenericResp!1!errorMessage],
		NULL				as [hdr!2!time],
		NULL				as [hdr!2!uBrowserID],
		NULL				as [hdr!2!uPipeID],
		NULL				as [hdr!2!uPipeType]
-- Header information
FOR XML EXPLICIT
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSUpdateSSOCredentialsReq')
	delete from GxQscripts where name = 'sec_UMDSUpdateSSOCredentialsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSUpdateSSOCredentialsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSUpdateSSOCredentialsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSUpdateSSOCredentialsReq',  '00010001030400010000', 'sec_UMDSUpdateSSOCredentialsReq', '00010001030400010000')
GO

