

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSProviderOpsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSProviderOpsReq.sp,v $ $Id: sec_UMDSProviderOpsReq.sp,v 1.9.42.4 2020/12/03 13:20:07 jswaminathan Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSProviderOpsReq.sp,v $ $Id: sec_UMDSProviderOpsReq.sp,v 1.48.2.59 2020/12/03 13:20:10 jswaminathan Exp $";
-- !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !!
--
--                                        ========================
-- 									!!!!! IMPORTANT QINETIX NOTES   !!!!!!!
--                                        ========================
--
-- WHEN CHECKING IN THIS FILE, BE SURE TO UPDATE THE CURSOR, "SEC_UMDSProviderOpsReq.cur" (same name) TOO!
--
-- THE VARIABLE "@MINVER" IN THE CURSOR !MUST! BE SET TO THE REVISION OF THIS STORED PROCEDURE!  YOU MUST
-- .. TAKE THE VALUE OF THE REVISION !AFTER! THIS FILE IS CHECKED IN
--
-- THIS IS THE ONLY WAY "CV_ExecuteSP" WILL KNOW WHICH IS THE LATEST VERSION OF THE STORED PROCEDURE TO LOAD   -StuK
--
-- !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !! !!
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_UMDSProviderOpsReq')
BEGIN
	print '>>> Drop Stored Procedure: sec_UMDSProviderOpsReq <<<'
	drop procedure sec_UMDSProviderOpsReq
END
IF EXISTS (select * from GxQscripts where name='sec_UMDSProviderOpsReq')
	delete from GxQscripts where name = 'sec_UMDSProviderOpsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSProviderOpsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSProviderOpsReq'
GO
print '... Creating Procedure: sec_UMDSProviderOpsReq'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_UMDSProviderOpsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
set @errorCode = 0
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
declare @iDoc                   int
declare @xmlReqMsg       nvarchar(256)
declare @xmlReqMsgNode   nvarchar(512)
declare @sqlError				int
declare @topOperation           int
declare @login					nvarchar(128)
declare @description			nvarchar(512)
declare @password				nvarchar(512)
declare @connectName			nvarchar(4000)
declare @flags					integer
declare @enabled				integer
declare @serviceType			integer
declare	@adminId				integer
declare @providerId				integer
declare @domainName				nvarchar(512)
declare @templateDomainName		nvarchar(512)
declare @dnsRootStatus			integer
declare @useSecureLdap			integer
declare @port           		integer
declare @resourceId				integer
declare @creatorId				integer = 1
DECLARE @providerIdOfInitiator INT=0
declare @timeout				integer = 60
declare @tries					integer = 3
DECLARE @pswdHistoryCount		int
Declare @emailDomains TABLE (emailDomain nvarchar(512))
declare @exts nvarchar(1024) = ''
declare @xml XML
DECLARE @customProviderTypeId INT =0
DECLARE @ownerCompanyId INT = 0
DECLARE @userGroupFitlter VARCHAR(MAX)
DECLARE @userFilter VARCHAR(MAX)
DECLARE @customProviderPropTbl TABLE( domainTypeId int, baseDN varchar(MAX),userFilter varchar(max),userGroupFilter varchar(MAX))
-------------------------------------
set @errorCode = 0
set @errorString = ''
	set @xmlReqMsg = '/EVGui_UMDSProviderOpsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
-- Read Input
set @xmlReqMsgNode = @xmlReqMsg
set @topOperation			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (operation nvarchar(128) '@operation'))
SET @xml = @xmlString
set @xmlReqMsgNode = @xmlReqMsg +'/provider'
set @login					= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (login nvarchar(128) '@login'))
set @description			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (description nvarchar(512) '@description'))
set @connectName			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (connectName nvarchar(4000) '@connectName'))
set @password				= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (password nvarchar(512) '@password'))
set @flags					= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (flags nvarchar(128) '@flags'))
set @enabled				= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (enabled nvarchar(128) '@enabled'))
set @serviceType			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (serviceType nvarchar(128) '@serviceType'))
set @templateDomainName	= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (templateDomainName nvarchar(512) '@templateDomainName'))
set @dnsRootStatus		= ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (dnsRootStatus nvarchar(128) '@dnsRootStatus')),0)
set @useSecureLdap		=  ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (useSecureLdap nvarchar(128) '@useSecureLdap')),0)
set @port		=  ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (port nvarchar(128) '@port')),0)
set @timeout		=  ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (timeout nvarchar(128) '@timeout')),60)
set @tries		=  ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (tries nvarchar(128) '@tries')),3)
set @pswdHistoryCount   = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (pswdHistoryCount nvarchar(1024) '@pswdHistoryCount'))
set @ownerCompanyId   = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (ownerCompanyId nvarchar(128) '@ownerCompanyId'))
	set @creatorId			= ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (ownerId nvarchar(128) '@ownerId')), 1)
	INSERT INTO @emailDomains select distinct ref.value('@val','nvarchar(255)') from @xml.nodes('/EVGui_UMDSProviderOpsReq/provider/emailDomainNames') R (ref)
	select @exts = ISNULL(@exts + ';', '') + e.emailDomain from @emailDomains e
	IF(len(@exts) > 1)
	BEGIN
		SET @exts = RIGHT(@exts, len(@exts) -1) -- Remove leading semi colon
	END
set @xmlReqMsgNode = @xmlReqMsg +'/provider/shortName'
set @providerId			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(128) '@id'))
set @domainName			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (domainName nvarchar(512) '@domainName'))
SET @xmlReqMsgNode = @xmlReqMsg +'/provider/resourceProvider'
SET @resourceId			= ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(128) '@id')), 0)
if object_id('tempdb.dbo.#attributeList') is not null
	DROP TABLE #attributeList
CREATE TABLE #attributeList
(
			[attrId] INT,
			[customAttribute] varchar(max)
)
INSERT INTO #attributeList(attrId, [customAttribute])
	select distinct ref.value('@attrId','INT'),ref.value('@customAttributeString','VARCHAR(max)')
	 from @xml.nodes('/EVGui_UMDSProviderOpsReq/provider/customProvider/attributes') R (ref)
--select OP=@topOperation, login=@login, description=@description, password=@password, flags=@flags, enabled=@enabled, serviceType=@serviceType,
--						providerId=@providerId, domainName=@domainName
--------------------------------------------------------------
-- NOW DO SOMETHING WITH ALL THE PARAMETERS WE'VE COLLECTED	--
--------------------------------------------------------------
IF @topOperation NOT IN (1, 2, 3)
BEGIN
    set @errorCode = -4
    set @errorString = 'Cannot handle Operation [' +convert (nvarchar(12), @topOperation) + '].'
    goto RETURN_RESULTS
END
--Handle default values
IF @topOperation = 1
BEGIN
	IF @flags IS NULL
		SET @flags = 0
	IF @enabled IS NULL
		SET @enabled = 1
	IF @serviceType IS NULL
		SET @serviceType = 0
	IF @useSecureLdap IS NULL
		SET @useSecureLdap = 0
	IF @dnsRootStatus IS NULL
		SET @dnsRootStatus = 0
	IF @port IS NULL
		SET @port = 0
	IF @resourceId IS NULL
		SET @resourceId = 0
set @providerIdOfInitiator = dbo.AppGetOrganizationForUser(@ownerID)
IF (@providerIdOfInitiator = 0)
BEGIN
	set @providerIdOfInitiator = ISNULL(@ownerCompanyId,0)
END
END
--Similarly we need to handle EDIT case also. If some field is NULL, then we need to pick it up from DB.
ELSE IF @topOperation = 3
BEGIN
	IF @flags IS NULL
	BEGIN
		SET @flags = (SELECT flags FROM UMDSProviders WHERE id = @providerId)
	END
    ELSE
	BEGIN
		-- This case will be useful when Provider is marked for delete from Admin Console but still visible from previously opened Java GUI
		-- In that case, any update option should not loose the set delete flag
		IF @flags = 1
		BEGIN
			SET @flags = (SELECT flags FROM UMDSProviders WHERE id = @providerId) | (1)	-- Set 1st bit (1 << 0)
		END
		ELSE IF @flags = 0
		BEGIN
			SET @flags = (SELECT flags FROM UMDSProviders WHERE id = @providerId) & ~(1)	-- For 0. Reset 1st bit (1 << 0)
		END
	END
	IF @enabled IS NULL
		SET @enabled = (SELECT enabled FROM UMDSproviders WHERE id = @providerId)
	IF @serviceType IS NULL
		SET @serviceType = (SELECT serviceType FROM UMDSProviders WHERE id = @providerId)
	IF @useSecureLdap IS NULL
		SET @useSecureLdap = (SELECT useSecureLdap FROM UMDSProviders WHERE id = @providerId)
	IF @dnsRootStatus IS NULL
		SET @dnsRootStatus = (SELECT dnsRootStatus FROM UMDSProviders WHERE id = @providerId)
	IF @port IS NULL
		SET @port = (SELECT port FROM UMDSproviders WHERE id = @providerId)
	IF @resourceId IS NULL
		SET @resourceId = (SELECT resourceId FROM UMDSProviders WHERE id = @providerId)
END
--Security check
IF (dbo.isNewSecurity() = 1)
BEGIN
	DECLARE @hasRights AS INT
	SET @hasRights = 0
	DECLARE @permissionId INT = CASE @topOperation WHEN 1 THEN
CASE WHEN @serviceType <> 5 THEN 249			-- Add Domain
ELSE 255																-- Check Create Company when creating a new company.
																END
WHEN 2 THEN 251		-- Delete Domain
WHEN 3 THEN 250			-- Edit Domain
								END
	IF @topOperation = 1
		EXEC sec_userHasCapability @ownerId,0,@hasRights OUTPUT,0,0,@permissionId
	ELSE
EXEC sec_checkPermissionOnEntity @ownerId, @permissionId, @hasRights OUTPUT, 61, @providerId
	IF @hasRights = 0
	BEGIN
			IF (@domainName IS NULL) AND (@providerId >= 0)
			BEGIN
				set @domainName	= (SELECT domainName FROM UMDSProviders WHERE id = @providerId)
			END
			IF @topOperation <> 1
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = 0)
				SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
				SET @errorString = REPLACE(@errorString, '^2%s', dbo.sec_getLocalizedPermission(@permissionId, 0))
				SET @errorString = REPLACE(@errorString, '^3%s', @domainname)
SET @errorString = REPLACE(@errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2377 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = 0))
			END
			ELSE
			BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = 0)
				SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
				SET @errorString = REPLACE(@errorString, '^2%s', dbo.sec_getLocalizedPermission(@permissionId, 0))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = 0))
			END
			goto RETURN_RESULTS
	END
END
IF @topOperation = 1
BEGIN
	-- Moved from C++ code.
IF (@serviceType = 5) AND
		EXISTS (SELECT TOP 1 1 FROM UMDSProviders (NOLOCK) WHERE hostName = @connectName AND flags & 0x0002 = 0)
	BEGIN
SET @errorCode = (3443 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3443 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @locale_in)
		GOTO RETURN_RESULTS
	END
	EXEC AppUpdateCompanyDomainOnConflictWithProvider @ownerCompanyId, @domainName, @errorCode OUTPUT, @errorString OUTPUT
	if(@errorCode<> 0)
	BEGIN
		GOTO RETURN_RESULTS
	END
-- No two domain with same domain name , baseDN and filters are not allowed.Cases of duplicate domain Not allowed as follows:
--Case 1:  Input type is not dynamic LDAP.
--			1a. Check if any not dynamic LDAP exists , return error
--			1 b. Check if any dynamic LDAP with default baseDN (baseDN) exists return error
--case 2 : Input type is dynamic LDAP.
--			2a. Check if input dynamic LDAP has default base DN and any existing non dynamic LDAP Exists return error.
--			2b. GEt base DN, user group filter, user filter of existing domain with same name.
--					If there is any domain with same base d and suer\user group filter return error.
--		Below if blocks cover above cases in exact order.
	BEGIN TRY
		DECLARE @C_baseDN VARCHAR(MAX)
		IF EXISTS (SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @domainName)
		BEGIN
IF @serviceType<>14
		   BEGIN
IF EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @domainName and serviceType<>14)
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Domain ' + @domainName + ' already exists'
					GOTO RETURN_RESULTS
				END
IF EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @domainName and serviceType=14)
				BEGIN
SET @C_baseDN='baseDN'
					IF EXISTS (SELECT 1 from UMDSProviders WITH(NOLOCK) JOIN UMDSProviderProp  WITH(NOLOCK) on componentNameId=UMDSProviders.id
and attrName='Dynamic Provider Type'
JOIN UMProviderTypeAttributeMap WITH(NOLOCK) on attrVal=providerTypeId and attributeId=10
								and attributeString=@C_baseDN )
					BEGIN
							SET @errorCode = 1
							SET @errorString = 'Domain ' + @domainName + ' already exists with no specific base DN'
							GOTO RETURN_RESULTS
					END
				END
		   END
		   ELSE
		   BEGIN
SET @C_baseDN=(SELECT customAttribute from #attributeList where attrID=10)
IF(@C_baseDN='baseDN')
				BEGIN
IF EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @domainName and serviceType<>14)
					BEGIN
						SET @errorCode = 1
						SET @errorString = 'Domain ' + @domainName + ' already exists without baseDN'
						GOTO RETURN_RESULTS
					END
				END
SET @userGroupFitlter =(SELECT customAttribute from #attributeList where attrID=6)
SET @userFilter=(SELECT customAttribute from #attributeList where attrID=7)
				INSERT INTO @customProviderPropTbl(domainTypeId,baseDN)
					SELECT CAST(attrVal as INT) ,attributeString
					FROM UMDSProviders WITH(NOLOCK) JOIN UMDSProviderProp  WITH(NOLOCK) on componentNameId=UMDSProviders.id
AND attrName='Dynamic Provider Type'
JOIN UMProviderTypeAttributeMap WITH(NOLOCK) on attrVal=providerTypeId and attributeId=10
						AND domainName = @domainName
				UPDATE tbl
				SET userFilter=ISNULL(attributeString,'')
FROM @customProviderPropTbl tbl JOIN UMProviderTypeAttributeMap ON domainTypeId=providerTypeId and attributeId=7
				UPDATE tbl
				SET userGroupFilter=ISNULL(attributeString,'')
FROM @customProviderPropTbl tbl JOIN UMProviderTypeAttributeMap ON domainTypeId=providerTypeId and attributeId=6
				IF EXISTS (SELECT 1 FROM @customProviderPropTbl where (@C_baseDN=baseDN AND  @userFilter=userFilter) OR (@C_baseDN=baseDN AND  @userGroupFitlter=userGroupFilter))
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Domain ' + @domainName + ' already exists with same baseDN and filters'
					GOTO RETURN_RESULTS
				END
			END
		END
		INSERT UMDSProviders (domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled, serviceType,
								modified, dnsRoot, dnsRootStatus, useSecureLdap, origCCId, GUID, port, resourceId, ownerId , ownerCompany)
			VALUES(@domainName, @connectName, @description, @login, @password, '', '', @flags, @enabled, @serviceType,
								0,@templateDomainName,@dnsRootStatus,@useSecureLdap, default, default, @port, @resourceId, @creatorId, @providerIdOfInitiator)
				SET @providerId = SCOPE_IDENTITY()
		IF(@exts IS NOT NULL AND @exts <> '')
		BEGIN
			INSERT INTO APP_COMPONENTPROP(ComponentType, ComponentId, PropertyTypeId, DataType,longVal, longLongVal, StringVal, created, modified)
select 112, @providerId, 16, 1, 0,0,@exts,dbo.GetUnixTime(GETUTCDATE()),0
		END
IF ( @serviceType=14)
		BEGIN
SET @customProviderTypeId =1+ ISNULL((SELECT MAX(CAST(attrVal AS INT)) from UMDSProviderProp where attrName='Dynamic Provider Type' and modified=0),0)
			INSERT INTO UMDSProviderProp (componentNameId,attrName,attrType,attrVal,created, modified)
VALUES(@providerId,'Dynamic Provider Type',1,@customProviderTypeId,dbo.GetUnixTime(GETUTCDATE()),0)
			INSERT INTO UMProviderTypeAttributeMap
			SELECT @customProviderTypeId,attrID,customAttribute
			FROM #attributeList
		END
IF(@serviceType = 5 AND @pswdHistoryCount IS NOT NULL AND @pswdHistoryCount > 0)
		BEGIN
			INSERT INTO UMDSProviderProp (componentNameId,attrName,attrType,attrVal,created, modified)
VALUES(@providerId,'Password History Count',1,@pswdHistoryCount,dbo.GetUnixTime(GETUTCDATE()),0)
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	   set @errorCode = ERROR_NUMBER()
	   set @errorString = 'Cannot Add UMDS Provider [' +@domainName +']: ' +ERROR_MESSAGE()
	END CATCH
	-- When creating new provider and operation type is also 1 (Create), then we should read provider id calculated above. No need to get provider id again by lookup
	IF @errorCode =  0 AND @providerId<>0
	BEGIN
DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)
DECLARE @userManagementRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (name = 'UserManagement_Owner')), 1)
		--MR : 264483 : Restrict the roles on AD to userManagement owner roles. Tenant admin role has too many permissions which may not even be needed.
IF @serviceType = 5
		BEGIN
EXEC sec_setCreatorForEntity @ownerId, @tenantAdminRoleId, '', @errorCode OUTPUT, @errorString OUTPUT, 61, @providerId
			IF @errorCode <> 0
			BEGIN
				GOTO RETURN_RESULTS
			END
		END
		ELSE
			BEGIN
			DECLARE @ownerCompanyTenantAdminGrpId INT = 0
			IF @ownerCompanyId <> 0 AND @ownerCompanyId <> dbo.AppGetOrganizationForUser(@ownerID)
			BEGIN
SET @ownerCompanyTenantAdminGrpId = ISNULL((SELECT id FROM UMGroups WHERE umdsProviderId = @ownerCompanyId AND groupFlags &  0x10000 = 0x10000), 0)
			END
			-- Creator of a company / domain should get Tenant Admin role on his company. Else he is not able to do any operation on his company.
EXEC sec_setCreatorForEntity @ownerId, @userManagementRoleId, '', @errorCode OUTPUT, @errorString OUTPUT, 61, @providerId, 0, 0, 0, 0, 0, 0, 0, 0, @ownerCompanyTenantAdminGrpId
			IF @errorCode <> 0
			BEGIN
				GOTO RETURN_RESULTS
			END
		END
		IF @errorCode = 0					-- Admin console UI expects empty error message on successfully creating Domain. Any other error message sent, UI treats as failure and does not exit the CreateDomain dialog.
		BEGIN								-- Set Creator Stored Procedure returns error message as Successful. So overriding it with empty error message here.
			SET @errorString = ''
		END
	END
	GOTO RETURN_RESULTS
END
IF @topOperation = 2				-- DELETE PROVIDER
BEGIN
	IF @providerId = 0
	BEGIN
		set @errorCode = -5
		set @errorString = 'Cannot Delete UMDS Provider with id=0'
		goto RETURN_RESULTS
	END
	BEGIN TRY
		BEGIN TRAN
--
--	CLEAN UP UMUserCredentials Table
--
 -- Implementation using a separate table to maintain many-to-one relationship of resources to providers
		DELETE UMUserCredentials								-- USERS FROM THIS PROVIDER IMMEDIATELY HAVE NO RIGHTS!
			FROM UMUserCredentials as UC, UMUSers as U
				WHERE U.umDSProviderID = @providerID
				AND UC.userId = U.id
		DELETE UMUserandGroupEntityAssociation
			FROM UMUserandGroupEntityAssociation as UC, UMUSers as U
				WHERE U.umDSProviderID = @providerID
				AND UC.userId = U.id
		DELETE UMUserandGroupEntityAssociation
			FROM UMUserandGroupEntityAssociation as UC, UMgroups as U
				WHERE U.umDSProviderID = @providerID
				AND UC.groupId = U.id and UC.providerId=U.umdsProviderId
--
--	CLEAN UP UMDSDomainResources Table
--
/*  Implementation using a separate table to maintain many-to-one relationship of resources to providers
		DELETE UMDSDomainResources
		   WHERE UMDSproviderId = @providerId OR resourceId = @providerId
*/
	UPDATE UMDSProviders
		Set ResourceId = 0 Where resourceId = @providerId
--
-- CLEAN UP NTnotificationUsers Table because the entries are just marked as deleted so delete cascade will not help
--
		DELETE NTU
		FROM NTNotificationUsers NTU
		INNER JOIN UMUsers UU WITH(NOLOCK)
		ON UU.id = NTU.userId
		WHERE UU.umDSproviderId = @providerId
--
-- CLEAN UP UMDSUserGroup Table
--
		DELETE UMDSUserGroup
		  FROM UMDSGroups as GR, UMDSUSerGroup AS UG
		  WHERE GR.id = UG.groupId
          AND GR.umDSProviderID = @providerID
		  DELETE UMUserGroup
		  FROM UMGroups as GR, UMUSerGroup AS UG
		  WHERE GR.id = UG.groupId
          AND GR.umDSProviderID = @providerID
		  DELETE UMUserGroup
		  FROM UMUsers as U, UMUSerGroup AS UG
		  WHERE U.id = UG.userId
          AND U.umDSProviderID = @providerID
--
--
--	CLEAN UP UMUsers Table
--
		DECLARE @ownerTransferXML XML = (CAST(@xmlString AS XML)).query('//../provider/transferInfo')
		-- Checked with Nipa, admin console code also hits this common code. So adding the code at this one place is sufficient.
		-- Waiting on GUI changes. Once they are done will make this mandatory.
		/*IF ((@ownerTransferXML.exist('transferInfo/newUser') = 0) AND (@ownerTransferXML.exist('transferInfo/newUserGroup') = 0))
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnableMandatoryTransferOfOwnership' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'false' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
			BEGIN
SET @errorCode = (3496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3496 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = 0)			-- locale_in is not coming correct.But it is not coming correct, need to debug. Will fix on a MR.
				GOTO RETURN_RESULTS
			END
		END*/
		DECLARE @deleteUser INT
		DECLARE usersOfThisProvider CURSOR FOR
			SELECT id FROM UMUsers WHERE umdsProviderId = @providerId
		OPEN usersOfThisProvider
		FETCH NEXT FROM usersOfThisProvider INTO @deleteUser
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- Transfer owner for every user.
			-- Calling it from cursor will slow down performance. But transfer user ownership works on only one user and group. Changing it for multiple users / groups will be more regressive.
			-- And deleting UMDSProvider is not going to be done frequently, so this code is very less hit.
			IF @ownerTransferXML IS NOT NULL AND @ownerTransferXML.exist('*') <> 0
			BEGIN
				EXEC sec_transferUserOwnership @ownerTransferXML,					-- transferXML
											   @ownerID,							-- callerId
											   0,									-- @locale_in should be passed. But it is not coming correct, need to debug. Will fix on a MR.
											   0,									-- doReturn
											   @deleteUser,							-- oldOwnerId (user ID)
											   0,									-- oldOwnerGroupId (user group ID)
											   @errorCode OUTPUT,
											   @errorString OUTPUT
				IF @errorCode <> 0
				BEGIN
					CLOSE usersOfThisProvider
					DEALLOCATE usersOfThisProvider
					GOTO RETURN_RESULTS
				END
			END
EXEC sec_deleteSecurityAssociationsForEntity 13, @deleteUser
			FETCH NEXT FROM usersOfThisProvider INTO @deleteUser
		END
		CLOSE usersOfThisProvider
		DEALLOCATE usersOfThisProvider
		-- We need to delete user associations after ownership transfer is done.
		DELETE FROM UMSecurityAssociations
		WHERE isUser = 1 and userOrGroupId IN (SELECT id FROM UMUsers WHERE umdsProviderId = @providerId)
		DELETE FROM UMOwners
		WHERE isUser = 1 and userOrGroupId IN (SELECT id FROM UMUsers WHERE umdsProviderId = @providerId)
--
--  CLEAN UP UMDSGROUPMaps
--
		DELETE UMDSGroupMaps
			FROM UMDSGroupMaps AS GM, UMDSGroups AS GR
			WHERE GR.id = GM.umdsgroupID
        	AND GR.umdsProviderId = @providerId
--
-- CLEAN UP UMDSGROUPS
--
		DELETE FROM APP_PlanProp
WHERE attrName in ( 'Assigned user group', 'Associated internal user group', 'Assigned user group') AND attrval IN (SELECT id FROM UMGroups WHERE umdsProviderId = @providerId)
		DECLARE @deleteUserGroup INT
		DECLARE userGroupsOfThisProvider CURSOR FOR
			SELECT id FROM UMGroups WHERE umdsProviderId = @providerId
		OPEN userGroupsOfThisProvider
		FETCH NEXT FROM userGroupsOfThisProvider INTO @deleteUserGroup
		WHILE @@FETCH_STATUS = 0
		BEGIN
EXEC sec_deleteSecurityAssociationsForEntity 15, @deleteUserGroup
			-- During company delete from admin console, all entities belonging to company are already removed.
			-- So in that case owner transfer is empty. Do not call SP in that case.
			-- The SP mandatorily requires new owner. That is correct, not needed to change that. (Because it is called from places like user delete, etc. where it is mandatory).
			IF @ownerTransferXML IS NOT NULL AND @ownerTransferXML.exist('*') <> 0
			BEGIN
				-- Transfer owner for every user group.
				EXEC sec_transferUserOwnership @ownerTransferXML,					-- transferXML
											   @ownerID,							-- callerId
											   0,									-- @locale_in should be passed. But it is not coming correct, need to debug. Will fix on a MR.
											   0,									-- doReturn
											   0,									-- oldOwnerId (userId)
											   @deleteUserGroup,
											   @errorCode OUTPUT,
											   @errorString OUTPUT
				IF @errorCode <> 0
				BEGIN
					CLOSE userGroupsOfThisProvider
					DEALLOCATE userGroupsOfThisProvider
					GOTO RETURN_RESULTS
				END
			END
			-- Remove Create As user ID
DECLARE @createAsUserID INT = (SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @deleteUserGroup AND attrName = N'Create As User' AND modified = 0)
			IF @createAsUserID IS NOT NULL AND @createAsUserID <> 0 AND EXISTS (SELECT 1 FROM UMUsers WHERE id = @createAsUserID)		--if accidentally that hidden user is already deleted then no need to call delete user request
			BEGIN
				DECLARE @deleteUserXML XML = (SELECT
												(SELECT @createAsUserId AS '@userId',
13 AS '@_type_'
												 FOR XML PATH ('userEntity'), TYPE)
											 FOR XML PATH ('App_UserInfo'))
EXEC sec_performUserOperation 1, 2, @deleteUserXML output, 2, 0, 0, 0, '', '', 0, 0					--DEFAULT_COMMCELL_ID hardcoded, 2 stands for Common::Operation_Delete
			END
			FETCH NEXT FROM userGroupsOfThisProvider INTO @deleteUserGroup
		END
		CLOSE userGroupsOfThisProvider
		DEALLOCATE userGroupsOfThisProvider
		-- We need to delete user group associations after ownership transfer is done.
		DELETE FROM UMSecurityAssociations
		WHERE isUser = 0 and userOrGroupId IN (SELECT id FROM UMGroups WHERE umdsProviderId = @providerId)
		--Entries are sometimes present in the now obsolete UMGroupAssociation table and hence needs to be cleaned up
		DELETE FROM UMGroupAssociation
		WHERE groupId IN (SELECT id FROM UMGroups WITH(NOLOCK) WHERE umdsProviderId = @providerId)
		--UMGroupAssociation table is closely coupled with UMgroupCapability table. So cleaning that as well
		DELETE FROM UMGroupCapability
		WHERE groupId IN (SELECT id FROM UMGroups WITH(NOLOCK) WHERE umdsProviderId = @providerId)
		DELETE FROM UMOwners
		WHERE isUser = 0 AND userOrGroupId IN (SELECT id FROM UMGroups WHERE umdsProviderId = @providerId)
IF EXISTS(SELECT id from UMDSProviders where id=@providerId and flags & 0x0002 <> 0)--for company and AD(for a company), users should be deleted.
		BEGIN
				EXEC AppPruneDeleteProviderUsers @providerId
DELETE FROM App_CompanyEntities WHERE entityType = 13 AND companyId = @providerId
				DELETE FROM UMUSERS WHERE umdsProviderID = @providerId
		END
		ELSE
		BEGIN
		UPDATE UMUsers											--  THEY ALSO CANNOT LOG IN ANYMORE
		SET enabled = 0,
			login = CASE WHEN(flags <> 0) THEN (login + '(Deleted,' +convert(varchar(8),id) + ')') ELSE login END,
		    flags   = 0,
		    umdsProviderID = -1,
			email='Email disabled'
			WHERE umdsProviderID = @providerId
		END
		DELETE UMDSGroups
			WHERE umdsProviderId = @providerId
		DELETE FROM App_CompanyEntities
WHERE entityType = 15 AND companyId = @providerId
		DELETE UMGroups
			WHERE umdsProviderId = @providerId
--
-- Update the installation company id of company clients (clients which are not getting deleted) to MSP (0)
--
	UPDATE APP_ClientProp
	SET attrVal = '0'
	FROM APP_ClientProp ACP
	INNER JOIN App_CompanyEntities ACE WITH (NOLOCK)
ON ACE.entityType = 3
		AND ACE.entityId = ACP.componentNameId
AND ACE.flags = 0x4
		AND ACE.companyId = @providerId
AND ACP.attrName = 'Installation Company ID'
--
--  CLEAN UP APP_ComponentProps table
--
          DELETE APP_ComponentProp
          WHERE propertyTypeId = 16   -- email extension
          AND componentId = @providerId
--
--  Check if all the entities of company got delete
--
	IF object_id('tempdb.dbo.#nonDeletedEntities') is not null
			DROP TABLE #nonDeletedEntities
	create table #nonDeletedEntities (entityType INT NOT NULL
					  PRIMARY KEY (entityType))
	INSERT INTO #nonDeletedEntities
	SELECT DISTINCT entityType
	FROM App_CompanyEntities WITH(NOLOCK)
	WHERE companyId = @providerId
AND flags & 0x4 = 0
	IF (SELECT count(0)
		FROM #nonDeletedEntities) > 0
	BEGIN
		IF object_id('tempdb.dbo.#nonDeletedValidEntities') is not null
			DROP TABLE #nonDeletedValidEntities
		create table #nonDeletedValidEntities (id INT NOT NULL
					  PRIMARY KEY (id))
		DECLARE @entityType INT = 0
		DECLARE @nonDeletedValidEntities INT = 0
		DECLARE entityTypes CURSOR FOR
		SELECT entityType FROM #nonDeletedEntities
		OPEN entityTypes
		FETCH NEXT FROM entityTypes INTO @entityType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
			DECLARE @idColName VARCHAR(128) = ''
				,@tableName VARCHAR(128) = ''
				,@entityNameColName VARCHAR(128) = ''
				,@whereClause VARCHAR(512) = ''
			SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause,  @entityNameColName = entityNameColName
			FROM APP_Entity WITH(NOLOCK)
			WHERE
				entityType = @entityType
			IF @whereClause = ''
				SET @whereClause = '1=1'
			IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
			BEGIN
				-- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
				SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
			END
			SET @dynamicSQLStr =  'INSERT INTO #nonDeletedValidEntities ' +
										'SELECT ' + @idColName +
										' FROM ' + @tableName + ' WITH(NOLOCK) ' +
										' INNER JOIN App_CompanyEntities App WITH(NOLOCK)
										ON App.entityId = '  + @tableName + '.' + @idColName +
										' AND App.entityType = ' + CAST (@entityType AS VARCHAR(10)) +
										' WHERE App.companyId = ' + CAST (@providerId AS VARCHAR(10))  +
' AND App.flags & ' + CAST ((SELECT CONVERT(INT, 0x4)) AS VARCHAR(16)) + ' = 0 ' +
										' AND ' + @whereClause
			EXEC (@dynamicSQLStr)
			IF (SELECT count(0) FROM #nonDeletedValidEntities) <> 0
			BEGIN
				BREAK
			END
			FETCH NEXT FROM entityTypes INTO @entityType
		END
		CLOSE entityTypes
		DEALLOCATE entityTypes
		IF (SELECT count(0) FROM #nonDeletedValidEntities) <> 0
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Cannot delete UMDSProviders row as there are company entities which are not deleted.'
			COMMIT TRAN
			GOTO RETURN_RESULTS
		END
	END
--
--  CLEAN UP UMDSProviderProp table
--
SET @customProviderTypeId =ISNULL((SELECT MAX(CAST(attrVal AS INT)) from UMDSProviderProp where componentNameId =@providerId and  attrName='Dynamic Provider Type' and modified=0),0)
		IF(@customProviderTypeId<>0)
		BEGIN
				DELETE  UMProviderTypeAttributeMap where providerTypeId=@customProviderTypeId
		END
          DELETE UMDSProviderProp
          WHERE componentNameId = @providerId
--
-- FINALLY, CAN NOW DELETE PROVIDER FROM TABLE
--
EXEC sec_deleteSecurityAssociationsForEntity 61, @providerId
		DELETE UMDSProviders Where id = @providerId
		COMMIT TRAN
		goto RETURN_RESULTS
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	   ROLLBACK TRAN
	   set @errorCode = ERROR_NUMBER()
	   set @errorString = 'Cannot Delete UMDS Provider [' +@domainName +']['+convert(nvarchar(20), @providerId) +']: ' +ERROR_MESSAGE()
	END CATCH
	GOTO RETURN_RESULTS
END
IF @topOperation = 3
BEGIN
	BEGIN TRY
		IF @password IS NULL OR @password = ''
		BEGIN
			set @password = (select password from UMDSProviders WHERE id=@providerId AND domainName=@domainName)
		END
		DECLARE @resourceId2 as int = ISNULL((select resourceId from UMDSProviders where id = @resourceId), 0)
		IF @resourceId2 <> 0 AND @resourceId2 = @providerId
		BEGIN
			SET @errorCode = -6
			SET @errorString = 'Providers cannot use each other as resources (circular dependancy)'
			goto RETURN_RESULTS
		END
		IF @domainName <> (SELECT domainName FROM UMDSProviders WHERE id = @providerId)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Cannot change name of the domain'
			GOTO RETURN_RESULTS
		END
IF @serviceType = 12 and @login is NOT NULL and @connectName is NOT NULL and @password is NOT NULL
		BEGIN
			SET @serviceType = 2
SET @flags = @flags&~(CAST(0x0004 AS int)) -- resetting dummy domain flag
		END
		UPDATE UMDSProviders
		SET description = CASE WHEN (@description IS NOT NULL OR @description<>'') THEN @description ELSE description END,
			login      =@login,
			password   =@password,
			flags      =CASE WHEN (@flags IS NOT NULL OR @flags<>'') THEN @flags ELSE flags END,
			enabled	   =CASE WHEN (@enabled IS NOT NULL OR @enabled<>'') THEN @enabled  ELSE enabled END,
			hostName   = @connectName,
			serviceType=CASE WHEN (@serviceType IS NOT NULL OR @serviceType<>'') THEN @serviceType ELSE serviceType END,
			dnsRoot    =@templateDomainName,
			dnsRootStatus = @dnsRootStatus,
			useSecureLdap = @useSecureLdap,
			port = @port,
			resourceId = @resourceId
		WHERE
			id=@providerId
		-- If component prop already has extension, update to whatever is current ext list
		IF(@exts IS NOT NULL AND @exts <> '')
		BEGIN
IF EXISTS(SELECT 1 FROM APP_COMPONENTPROP WHERE COMPONENTTYPE =112 AND ComponentId = @providerId AND PropertyTypeId = 16 )
			BEGIN
UPDATE APP_COMPONENTPROP SET stringVal = @exts WHERE COMPONENTTYPE =112 AND ComponentId = @providerId AND PropertyTypeId = 16
			END
			ELSE
			BEGIN
				-- else insert a new one.
				INSERT INTO APP_COMPONENTPROP(ComponentType, ComponentId, PropertyTypeId, DataType,longVal, longLongVal, StringVal, created, modified)
select 112, @providerId, 16, 1, 0,0,@exts,dbo.GetUnixTime(GETUTCDATE()),0
			END
		END
IF(@serviceType=14 AND (@xml.exist('/EVGui_UMDSProviderOpsReq/provider/customProvider')=1))
		BEGIN
SET @customProviderTypeId = ISNULL((SELECT (attrVal) from UMDSProviderProp where componentNameId=@providerId and  attrName='Dynamic Provider Type' and modified=0),0)
			IF(@customProviderTypeId=0)
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Invalid providerType'
				goto RETURN_RESULTS
			END
			if EXISTS(SELECT 1 from UMDSProviders where id<>@providerId and domainName<>@domainName)
		BEGIN
SET @C_baseDN=ISNULL((SELECT customAttribute from #attributeList where attrID=10),'baseDN')
		IF(@C_baseDN='baseDN')
				BEGIN
IF EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @domainName and id<> @providerId and serviceType<>14)
					BEGIN
						SET @errorCode = 1
						SET @errorString = 'Domain ' + @domainName + ' already exists without baseDN'
						GOTO RETURN_RESULTS
					END
				END
SET @userGroupFitlter =(SELECT customAttribute from #attributeList where attrID=6)
SET @userFilter =(SELECT customAttribute from #attributeList where attrID=7)
		INSERT INTO @customProviderPropTbl(domainTypeId,baseDN)
					SELECT CAST(attrVal as INT) ,attributeString
					FROM UMDSProviders WITH(NOLOCK) JOIN UMDSProviderProp  WITH(NOLOCK) on componentNameId=UMDSProviders.id
AND attrName='Dynamic Provider Type'
JOIN UMProviderTypeAttributeMap WITH(NOLOCK) on attrVal=providerTypeId and attributeId=10
						AND domainName = @domainName and UMDSProviders.id<>@providerId
				UPDATE tbl
				SET userFilter=ISNULL(attributeString,'')
FROM @customProviderPropTbl tbl JOIN UMProviderTypeAttributeMap ON domainTypeId=providerTypeId and attributeId=7
				UPDATE tbl
				SET userGroupFilter=ISNULL(attributeString,'')
FROM @customProviderPropTbl tbl JOIN UMProviderTypeAttributeMap ON domainTypeId=providerTypeId and attributeId=6
				IF EXISTS (SELECT 1 FROM @customProviderPropTbl where  (@C_baseDN=baseDN AND  @userFilter=userFilter) OR (@C_baseDN=baseDN AND  @userGroupFitlter=userGroupFilter))
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Domain ' + @domainName + ' already exists with same baseDN and filters'
					GOTO RETURN_RESULTS
				END
			END
			DELETE FROM UMProviderTypeAttributeMap where providerTypeId=@customProviderTypeId
			INSERT INTO UMProviderTypeAttributeMap
				SELECT @customProviderTypeId,attrID,customAttribute
				FROM #attributeList
		END
/*  Implementation using a separate table to maintain many-to-one relationship of resources to providers:
		SET @xmlReqMsgNode = @xmlReqMsg +'/provider/resourceProviders'
		DELETE UMDSDomainResources where UMDSProviderId = @providerID
		INSERT INTO  UMDSDomainResources (UMDSproviderId, resourceId)
			SELECT @providerID, id
			FROM OPENXML(@iDoc, @xmlReqMsgNode, 0)
			WITH (id int)
*/
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	   set @errorCode = ERROR_NUMBER()
	   set @errorString = 'Cannot Update UMDS Provider [' +@domainName +']['+convert(nvarchar(20), @providerId) +']: ' +ERROR_MESSAGE()
	END CATCH
	GOTO RETURN_RESULTS
END
--------------
RETURN_RESULTS:
--------------
-- Return the Id, name and GUID also in the same response. (Since CVGui::GenericResp does not have the fields, using App::GenericEntityResponse instead).
-- This avoids one more DB call done from C++ to get the id and GUID of the newly created organization.
DECLARE @guidStr VARCHAR(128) = (SELECT guid FROM UMDSProviders (NOLOCK) WHERE id = @providerId)
DECLARE @responseXML xml
SET @responseXML=(
SELECT @errorCode AS '@errorCode',
	   @errorString AS '@errorString',
	   @providerId AS 'entity/@providerId',
	   @domainName AS 'entity/@providerDomainName',
	   @guidStr AS 'entity/@GUID'
FOR XML PATH ('App_GenericEntityResponse'))
SELECT @responseXML
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSProviderOpsReq')
	delete from GxQscripts where name = 'sec_UMDSProviderOpsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSProviderOpsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSProviderOpsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSProviderOpsReq',  '00010009004200040000', 'sec_UMDSProviderOpsReq', '00010009004200040000')
GO

