

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSProviderListReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSProviderListReq.sp,v $ $Id: sec_UMDSProviderListReq.sp,v 1.5.304.5.20.1 2021/05/11 02:05:43 saggarwal Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSProviderListReq.sp,v $ $Id: sec_UMDSProviderListReq.sp,v 1.28.58.35.14.1 2021/05/11 02:05:41 saggarwal Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_UMDSProviderListReq')
BEGIN
	print '>>> Drop Stored Procedure: sec_UMDSProviderListReq <<<'
	drop procedure sec_UMDSProviderListReq
END
IF EXISTS (select * from GxQscripts where name='sec_UMDSProviderListReq')
	delete from GxQscripts where name = 'sec_UMDSProviderListReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSProviderListReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSProviderListReq'
GO
print '... Creating Procedure: sec_UMDSProviderListReq'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_UMDSProviderListReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--	 ownerId: Logged in User ID calling this stored procedure
--	 locale_in: LocaleId of this session
--	 xmlString: <EVGui_UMDSProviderListReq domainId="0" filterFlags="0" getPassword="0">
--						<header localeId="0" userId="0"/>
--				</EVGui_UMDSProviderListReq>
--				filterFlags = 0 => gets all domains (default)
--				filterFlags = 1 => gets all domains except Organizations
--				filterFlags = 2 => gets all Organizations only.
--				filterFlags = 3 => gets all domains except Open Directories and Organizations.
--	 BrowseIDParam,PipeIDParam,PipeTypeParam not used anymore.
--	 bRestrictedViewEnabled: Set to 1, if CV_Restricted_Group enabled
--   forViewUserOrGroupInAD: When called from places like GetSuggestions API,
--							 we need to load domains only if user has rights on
--							 entire domain. Else should not load it, if user just have rights on
--							 individual the users / groups of that domain.
--							 (Default 0: not to break backward compatibility).
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NVARCHAR(MAX),
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0,
  @bRestrictedViewEnabled int = 0,
  @forViewUserOrGroupInAD int = 0				
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
DECLARE @emailDomainNames Table(providerId int default(-20), emailDomainName nvarchar(256))
set @errorCode = 0
 declare  @Xmlstr	XML
 DECLARE @getPassword int = 0
--Security check for determing whether user can see the domain or not(not done for commnet)
DECLARE @filteredUMDSProviders TABLE ( id	INT	)
DECLARE @filter INT = 0
DECLARE @domainId INT = 0
IF OBJECT_ID('tempdb.dbo.#tempUserTable') IS NOT NULL
		DROP TABLE #tempUserTable
CREATE TABLE #tempUserTable (providerId INT, userID INT, userLogin NVARCHAR(255), userDisplayName NVARCHAR(255))
IF OBJECT_ID('tempdb.dbo.#ttpmADProxyList') IS NOT NULL
		DROP TABLE #ttpmADProxyList
CREATE TABLE #ttpmADProxyList (providerId INT, toEntityId int,  clientName NVARCHAR(255))
IF OBJECT_ID('tempdb.dbo.#ttpmProxyList') IS NOT NULL
		DROP TABLE #ttpmProxyList
CREATE TABLE #ttpmProxyList (providerId INT, id int, fromPortNumber int,  toEntityId int, clientName NVARCHAR(255))
IF OBJECT_ID('tempdb.dbo.#companyProp') IS NOT NULL
		DROP TABLE #companyProp
CREATE TABLE #companyProp (providerId INT primary key, disableLogin int, disableBackup int,  disableRestore int, vOrgGuid NVARCHAR(128))
SET @Xmlstr = CAST(@xmlString AS XML)
SELECT @filter = N.UMDSProvider.value('@filterFlags','varchar(20)'),
 @domainId = ISNULL(N.UMDSProvider.value('@domainId','int'),0), @getPassword=ISNULL(N.UMDSProvider.value('@getPassword','int'),0)
FROM @Xmlstr.nodes('EVGui_UMDSProviderListReq')  AS N(UMDSProvider)
IF (dbo.isNewSecurity() = 0)
BEGIN
--now do filtering based on the capabilities of user
DECLARE @tempProviderId	INT
DECLARE @canSeeProvider	INT
IF(@filter = 0)
BEGIN
	DECLARE providerCursor CURSOR
FOR SELECT [id] FROM UMDSProviders Where serviceType <> 11
END
ELSE
IF(@filter = 1)
BEGIN
	DECLARE providerCursor CURSOR
FOR SELECT [id] FROM UMDSProviders Where serviceType<>5 and serviceType <> 11
END
ELSE IF (@filter = 2)
	BEGIN
		DECLARE providerCursor CURSOR
		FOR SELECT [id]
        FROM   umdsproviders
WHERE  servicetype = 5
	END
OPEN providerCursor
FETCH providerCursor INTO @tempProviderId
WHILE @@FETCH_STATUS = 0
BEGIN
		SET @canSeeProvider = 0
		EXEC sec_canSeeOrManageNameServer  @ownerID, @tempProviderId, 1, @bRestrictedViewEnabled, 0, @canSeeProvider OUTPUT
		IF @canSeeProvider = 1
		BEGIN
			INSERT INTO @filteredUMDSProviders VALUES (@tempProviderId)
		END
	FETCH providerCursor INTO @tempProviderId
END
CLOSE providerCursor
DEALLOCATE providerCursor
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb.dbo.#umdsproviderslist') IS NOT NULL
		DROP TABLE #umdsproviderslist
	CREATE TABLE #umdsproviderslist (nameserversId INT)
	EXEC sec_getNameServersForThisUser '#umdsproviderslist', @ownerID, 0, @forViewUserOrGroupInAD
	INSERT INTO @filteredUMDSProviders
		SELECT DISTINCT nameserversid
		FROM #umdsproviderslist where (@domainId = 0 or (@domainId = nameserversId))
	IF OBJECT_ID('tempdb.dbo.#umdsproviderslist') IS NOT NULL
		DROP TABLE #umdsproviderslist
	IF(@filter = 1)
	BEGIN
		DELETE FU
		FROM @filteredUMDSProviders FU INNER JOIN UMDSProviders U ON U.id = FU.id
		Where U.serviceType = 5
	END
	ELSE IF(@filter = 2)
		BEGIN
			DELETE fu
            FROM   @filteredUMDSProviders FU
            INNER JOIN umdsproviders U ON U.id = fu.id
WHERE  U.servicetype <> 5
		END
	ELSE IF(@filter = 3)
	BEGIN
		DELETE FU
		FROM @filteredUMDSProviders FU INNER JOIN UMDSProviders U ON U.id = FU.id
Where (U.flags&8) = 8 or serviceType = 5
	END
	DELETE FU
		FROM @filteredUMDSProviders FU INNER JOIN UMDSProviders U ON U.id = FU.id
Where U.serviceType = 11
END
DECLARE @umdsProviderCountTable TABLE( umdsproviderId int, userCount int , userGroupCount int)
INSERT INTO @umdsProviderCountTable (umdsproviderId,userCount)
SELECT provider.id,Count(U.id) from UMUSERS U
RIGHT JOIN @filteredUMDSProviders provider on  U.umdsPRoviderId=provider.id AND  (U.flags<>0 AND U.flags&0x004=0)
GROUP BY provider.id
UPDATE TBL
SET userGroupCount=ISNULL(count,0)
FROM @umdsProviderCountTable TBL LEFT JOIN
(SELECT P.id,COUNT(G.id) as count
FROM UMGroups G RIGHT JOIN @filteredUMDSProviders  P ON G.umdsProviderId=P.id
WHERE G.groupFlags&0x0001<>0
GROUP BY P.id) Count
ON TBL.umdsproviderId=Count.id
INSERT INTO #tempUserTable SELECT UMU.umDSproviderId, UMU.id , UMU.login, UMU.name
						FROM UMUsers UMU  with (nolock)
						INNER JOIN UMUsersProp UUP  with (nolock)
							ON UMU.id=UUP.componentNameId
						INNER JOIN UMUserGroup UUG  with (nolock)
							ON UUG.userId=UUP.componentNameId
						INNER JOIN UMGroups UG
							ON UG.id=UUG.groupId
						INNER JOIN UMDSProviders UMP
							ON UMP.id=UMU.umDSproviderId
						where UUP.attrName = 'Primary Contact' and UUP.attrVal=N'1' AND UG.groupFlags&0x10000<>0 and UMP.id IS NOT NULL
insert into @emailDomainNames select F.Id, D.Data
								from
									APP_ComponentProp C JOIN @filteredUMDSProviders F ON C.componentId = F.id
									Cross Apply dbo.Split(C.stringVal, ';') D
WHERE C.componentType = 112 AND C.propertyTypeId =   16
AND D.DATA is not null AND LTRIM(RTRIM(D.Data)) <> ''
INSERT INTO #ttpmADProxyList(providerId ,  toEntityId ,   clientName)
SELECT u.id,toEntityId,c.name --this is populated for adproxyList
FROM @filteredUMDSProviders u
INNER JOIN APP_FirewallTppm T ON U.id = CAST (T.tppmParams AS INT)
INNER JOIN APP_Client C  ON T.toEntityId = C.id
INSERT INTO #ttpmProxyList(providerId , id , fromPortNumber ,  toEntityId ,   clientName)
SELECT u.id, isnull(APP_FirewallTppm.id,0), isnull(fromPortNumber,0), isnull(toEntityId,0),isnull(c.name, '0') --this is populated for proxyEntity
FROM @filteredUMDSProviders u
LEFT JOIN APP_FirewallTppm  ON CAST(tppmParams AS INT) = U.id AND tppmType = 4 AND status = 1
LEFT JOIN APP_Client C  ON toEntityId = C.id
INSERT INTO #companyProp (providerId , disableLogin , disableBackup ,  disableRestore, vOrgGuid )
SELECT A.id, isnull(A.[Disable Login],0) as '@disableLogin',isnull(A.[Disable Backup],0) as '@disableBackup' ,isnull(A.[Disable Restore],0) as '@disableRestore' , A.[vOrg Guid] As '@vOrgGuid' from (
SELECT id,[Disable Login], [Disable Backup], [Disable Restore], [vOrg Guid]
	FROM
		(
			SELECT fc.id as id, c.attrName, c.attrVal AS attrVal
FROM  @filteredUMDSProviders fc left JOIN App_CompanyProp c  ON fc.id = c.componentNameId	AND attrName IN ('Disable Login','Disable Backup', 'Disable Restore', 'vOrg Guid')
		) as T
	PIVOT ( MAX(attrVal) FOR attrName IN ( [Disable Login], [Disable Backup],[Disable Restore], [vOrg Guid]) ) AS P) A
--
--
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SET @Xmlstr =(
SELECT hostName AS '@connectName',UMDS.flags AS '@flags',  UMDS.enabled AS '@enabled', serviceType AS '@serviceType',useSecureLdap AS '@useSecureLdap',UMDS.description AS '@description',port AS '@port', login AS '@login', login AS '@trustedHostUser', CASE WHEN @getPassword=1 THEN password  END as '@password'
,ownerCompany AS '@ownerCompanyId', (SELECT hostName FROM UMDSProviders UM WHERE UM.id=UMDS.ownerCompany) AS '@ownerCompanyName', userCount AS '@userCount', userGroupCount AS '@userGroupCount', ISNULL(comp.attrValInt, 0) as '@canCreateCompanies', cp.vOrgGuid as '@vOrgGuid'
,CASE WHEN serviceType =  9
THEN (select top 1 attrVal FROM UMDSproviderProp with (NOLOCK) where attrname='Base DN' AND componentNameId = UMDS.id AND modified=0 ) ELSE NULL END AS '@baseDN'
, (SELECT emailDomainName  as '@val' FROM  @emailDomainNames e WHERE e.providerId = UMDS.id FOR XML PATH ('emailDomainNames'), TYPE)
,CASE WHEN serviceType =  5  THEN (SELECT cp.disableLogin as '@disableLogin', cp.disableBackup as '@disableBackup', cp.disableRestore as '@disableRestore' for xml path ('deactivateOptions') , type) END
,(SELECT TUT.userDisplayName AS '@fullName' , TUT.userLogin AS 'user/@userName',TUT.userID AS 'user/@userId' from  #tempUserTable TUT where TUT.providerId=UMDS.id FOR XML PATH ('primaryContacts'),TYPE)
,(SELECT  (SELECT top 1 CASE WHEN proxy.id>0  THEN 1 ELSE 0 END FROM #ttpmProxyList proxy where proxy.providerId=UMDS.id )AS '@enable',  4 AS '@tppmType'
 ,(SELECT (SELECT TOP 1  ISNULL(proxy.fromPortNumber,0) FROM #ttpmProxyList proxy WHERE proxy.providerId=UMDS.id) AS '@portNumber'
,(SELECT 3  as '@_type_',(SELECT top 1  ISNULL(proxy.toEntityId,0)  FROM #ttpmProxyList proxy WHERE proxy.providerId=UMDS.id) AS '@clientId'
, (SELECT top 1  ISNULL(proxy.clientName,'0') FROM #ttpmProxyList proxy WHERE proxy.providerId=UMDS.id) AS '@clientName' FOR XML PATH('proxyEntity'), type)
,(SELECT '3' as '@_type_', adproxy.toEntityId AS '@clientId', adproxy.clientName AS '@clientName'
 FROM #ttpmADProxyList adproxy where providerId= UMDS.id FOR XML PATH('adProxyList'), TYPE)
 FOR XML PATH ('proxyInformation'),type)--FROM #ttpmProxyList proxy
 FOR XML PATH ('tppm'), type) ,(SELECT adv.keyName AS '@keyName',adv.type AS '@type',adv.value AS '@value',adv.relativePath AS '@relativepath',adv.enabled AS '@enabled' from APP_AdvanceSettings adv where adv.entityType = 61 AND adv.entityId=UMDS.id for xml path('additionalSettings'),type)
,CASE WHEN UMDS.serviceType= 14 THEN
 (SELECT PROP.attrVal as '@providerTypeId'
 ,(SELECT  STAT.id as '@attrId', STAT.name AS '@attributeName', (SELECT CASE WHEN Map.attributeString IS NULL THEN STAT.flags ELSE STAT.flags|4 END ) AS '@attrTypeFlags',  ISNULL(DEfaultMap.attributeString,STAT.attributeString) AS '@staticAttributeString',
 ISNULL(ISNULL(Map.attributeString,DEfaultMap.attributeString),STAT.attributeString) as  '@customAttributeString'
 FROM UMProviderSTaticAttribute STAT
 LEFT JOIN UMPROviderTypeAttributeMap MAP ON PROP.attrVAl=CAST(providerTypeId AS NVARCHAR)  and MAp.attributeId=STAT.id
 LEFT JOIN UMPROviderTypeAttributeMap DEfaultMap ON DEfaultMap.providerTypeId=-1 and DEfaultMap.attributeId = STAT.id
 WHERE PROP.attrVal IS NOT NULL
 FOR XML PATH ('attributes'),type)
 FROM
 UMDSProviderProp  PROP
WHERE PROP.componentNameId = UMDS.id AND PROP.attrName='Dynamic Provider Type' and PROP.modified=0
 FOR XML PATH ('customProvider'), type)  END
,resourceId AS 'resourceProvider/@id', ISNULL((Select domainName from UMDSproviders resource where resource.id = UMDS.resourceId), 'N/A')  AS 'resourceProvider/@domainName'
, UMDS.id as 'shortName/@id', domainName as 'shortName/@domainName'
	FROM UMDSProviders UMDS
	JOIN @umdsProviderCountTable ON UMDS.id=umdsproviderId
LEFT JOIN #companyProp cp on cp.providerId=UMDS.id
LEFT JOIN App_CompanyProp comp WITH(NOLOCK) on UMDS.id = comp.componentNameId AND comp.attrName = 'Allow to Manage Other Companies' AND comp.modified = 0 AND comp.cs_attrName = checksum(N'Allow to Manage Other Companies')
WHERE UMDS.id > 0 AND UMDS.id IN (SELECT Id FROM @filteredUMDSProviders) AND UMDS.flags & 0x0002 = 0
FOR XML PATH('providers'), ROOT('EVGui_UMDSProviderListResp')
)
IF @xmlStr IS NULL													-- When there is no response we need to populate an empty XML, else caller code throws exception.
	SET @xmlStr = '<EVGui_UMDSProviderListResp/>'
select @Xmlstr
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSProviderListReq')
	delete from GxQscripts where name = 'sec_UMDSProviderListReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSProviderListReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSProviderListReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSProviderListReq',  'v1.5.304.5.20.1', 'sec_UMDSProviderListReq', 'v1.5.304.5.20.1')
GO

