

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSProviderCheckReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSProviderCheckReq.sp,v $ $Id: sec_UMDSProviderCheckReq.sp,v 1.5.304.1 2018/03/15 23:33:02 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSProviderCheckReq.sp,v $ $Id: sec_UMDSProviderCheckReq.sp,v 1.9.58.6 2019/05/10 02:31:08 saggarwal Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UMDSProviderCheckReq')
BEGIN
	print '>>> Drop Stored Procedure: sec_UMDSProviderCheckReq <<<'
	drop procedure sec_UMDSProviderCheckReq
END
IF EXISTS (select * from GxQscripts where name='sec_UMDSProviderCheckReq')
	delete from GxQscripts where name = 'sec_UMDSProviderCheckReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSProviderCheckReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSProviderCheckReq'
GO
print '... Creating Procedure: sec_UMDSProviderCheckReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSProviderCheckReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0,
  @principleName nvarchar(1024) = 'CommNet'
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
declare @errorCode INT
declare @flags          int
declare @hasProvider    int
declare @hasSSOEnabled  int
declare @userName		nvarchar(1024)
declare @domainName		nvarchar(1024)
declare @MyDomainName	nvarchar(1024)
declare @iDoc           int
declare @xmlReqMsg       nvarchar(256)
declare @xmlReqMsgNode   nvarchar (512)
set @errorCode = 0
-------------------------------------
-- FETCH PARAMETERS FROM XML INPUT --
-------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSProviderCheckReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
set @xmlReqMsgNode = @xmlReqMsg + '/provider'
set @domainName            = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (domainName nvarchar(1024) '@domainName'))
DECLARE @providerId AS INT
SET @providerId = ISNULL((select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id int '@id')),0)
IF(@providerId=0)
BEGIN
	SET @providerId = (SELECT TOP 1 id FROM UMDSProviders WITH(NOLOCK) WHERE domainname = @domainName)
END
------------------------------
-- SEE IF THERE IS A MATCH  --
------------------------------
    set @hasSSOEnabled = 0				-- Need to Differentiate between Errors & no match!
    set @hasProvider   = 0
    set @MyDomainName      =''
    set @userName      =''
	IF EXISTS (Select * from UMDSProviders Where domainName = @domainName AND enabled <> 0)
	BEGIN
		BEGIN TRY
			IF (dbo.isNewSecurity() = 1)
			BEGIN
				DECLARE @hasRights AS INT = 0
EXEC sec_checkPermissionOnEntity @ownerId, 0, @hasRights OUTPUT, 61, @providerId
				IF @hasRights = 0
				BEGIN
					SET @errorCode = 1111
					SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
SET @errorString = REPLACE(@errorString, '^2%s', 31)
					SET @errorString = REPLACE(@errorString, '^3%s', @domainName)
				END
			END
			set @hasSSOEnabled = 0
			set @flags       = (Select flags    FROM UMDSProviders Where id = @providerId)
if (@flags & 1) = 1					--'UMDS_PROVIDER_FLAGS_SSO'
				set @hasSSOEnabled = 1
			set @hasProvider  = @providerId
			set @MyDomainName =  @domainName
--			set @userName     = @myDomainName+'\'+(Select login FROM UMDSProviders Where id = @providerId)
			set @userName     = (Select login FROM UMDSProviders Where id = @providerId)
			set @principleName= @userName
		END   TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		   set @errorCode = ERROR_NUMBER()
		   set @errorString = 'Cannot Add Check Provider [' +@domainName +']: ' +ERROR_MESSAGE()
		END   CATCH
	END
--------------------
-- RETURN RESULTS --
--------------------
SELECT  1                    as TAG,
        NULL                 as Parent,
@hasProvider	         as [EVGui_UMDSProviderCheckResp!1!hasProvider],
@hasSSOEnabled           as [EVGui_UMDSProviderCheckResp!1!ssoEnabled],
@MydomainName	         as [EVGui_UMDSProviderCheckResp!1!domainName],
@principleName		     as [EVGui_UMDSProviderCheckResp!1!fullyQualifiedName],
		NULL				as [hdr!6!time],
		NULL				as [hdr!6!uBrowserID],
		NULL				as [hdr!6!uPipeID],
		NULL				as [hdr!6!uPipeType]
-- Header information
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSProviderCheckReq')
	delete from GxQscripts where name = 'sec_UMDSProviderCheckReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSProviderCheckReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSProviderCheckReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSProviderCheckReq',  '00010005030400010000', 'sec_UMDSProviderCheckReq', '00010005030400010000')
GO

