

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSLocalGroupOpsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSLocalGroupOpsReq.sp,v $ $Id: sec_UMDSLocalGroupOpsReq.sp,v 1.5.304.1 2018/03/15 23:34:06 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSLocalGroupOpsReq.sp,v $ $Id: sec_UMDSLocalGroupOpsReq.sp,v 1.12.52.2 2018/03/15 23:34:15 jiechen Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSLocalGroupOpsReq <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSLocalGroupOpsReq')
	drop procedure sec_UMDSLocalGroupOpsReq
IF EXISTS (select * from GxQscripts where name='sec_UMDSLocalGroupOpsReq')
	delete from GxQscripts where name = 'sec_UMDSLocalGroupOpsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSLocalGroupOpsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSLocalGroupOpsReq'
GO
print '... Creating Procedure: sec_UMDSLocalGroupOpsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSLocalGroupOpsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @iDoc            int
declare @xmlReqMsg       nvarchar(256)
declare @xmlReqMsgNode   nvarchar (512)
declare @nowTime         int         -- Will use for finding external groups local Group is no longer a member of (do we need this?)
declare @localGroupName  nvarchar(256)
declare @localGroupId    int
declare @errorString	 nvarchar(1024)
DECLARE @errorCode INT
	set @errorCode = 0
    set @nowTime = dbo.GetUnixTime(GetUTCDate())
-------------------------------------
-- FETCH PARAMETERS FROM XML      ---
-------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSLocalGroupOpsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
	set @xmlReqMsgNode = @xmlReqMsg +'/localGroup'
    set @localGroupId            = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(256) '@id'))
    set @localGroupName          = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (name nvarchar(256) '@name'))
-- DEBUG     select localGroupId = @localGroupId, name = @localGroupName
-- PROCESS ALL THE REQUESTS --
declare @extGroupId             int
declare @extGroupName			nvarchar(1024)
declare @extGroupDescription	nvarchar(1024)
declare @extProviderId			int
declare @exProviderName			nvarchar(1024)
declare @operation				int
declare @tranStarted			int
set     @tranStarted = 0
IF (dbo.isNewSecurity() = 1)
BEGIN
	DECLARE @hasRights AS INT
	SET @hasRights = 0
EXEC sec_checkPermissionOnEntity @ownerId, 102, @hasRights OUTPUT, 15, @localGroupId
	IF @hasRights = 0
	BEGIN
		SET @errorCode = 1111
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2267 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
		SET @errorString = REPLACE(@errorString, '^2%s', 'Edit on user group and edit on external group')
		SET @errorString = REPLACE(@errorString, '^3%s', (SELECT @localGroupName))
		GOTO RETURN_RESULTS
	END
END
--------------------------------------------------------------------------------------
--	SINCE OPERATIONS MAY BE MIXED IN THIS REQUEST, WE WILL NEED TO ITERATE THRU ALL --
--  OF THEM, ONE BY ONE                                                             --
--------------------------------------------------------------------------------------
BEGIN TRY
	set @xmlReqMsgNode = @xmlReqMsg +'/externalGroupOps/externalGroup/shortName'
	declare groups_cursor CURSOR FOR
		select id, domainName, extGroupId, name, description, operation
		FROM OPENXML(@iDoc, @xmlReqMsgNode, 0)
		WITH ( id  int,
               domainName nvarchar(1024),
               extGroupId nvarchar(1024)  '../@id',
               name       nvarchar(1024)  '../@name',
			   description nvarchar(1024) '../@description',
               operation  int             '../../@operation'
             )
	BEGIN TRAN
		SET @tranStarted = 1
		OPEN  groups_cursor
		FETCH NEXT FROM groups_cursor
			INTO @extProviderId, @exProviderName, @extGroupId, @extGroupName,@extGroupDescription, @operation
		WHILE @@FETCH_STATUS = 0
		BEGIN
	--		FOR EACH EXTERNAL GROUP, DO THE WORK HERE !!!
--			select 'debug exProviderName' = @exProviderName, id=@extProviderId, extGroupId=@extGroupId,extGroupName=@extGroupName, descr=@extGroupDescription, op=@operation
			--Security check
			IF (dbo.isNewSecurity() = 1)
			BEGIN
				DECLARE @providerIdForSecurityCheck AS INT = ISNULL((Select id from UMgroups WHERE name = @extGroupName AND umdsProviderId = @extProviderId),0)
				--SecurityCheck - in case if a new user group is getting created then check for edit user groups on provider entity
				IF @providerIdForSecurityCheck = 0
EXEC sec_checkPermissionOnEntity @ownerId, 102, @hasRights OUTPUT, 61, @extProviderId
				ELSE	--else check for edit user group on that user group
EXEC sec_checkPermissionOnEntity @ownerId, 102, @hasRights OUTPUT, 62, @providerIdForSecurityCheck
				IF @hasRights = 0
				BEGIN
					SET @errorCode = 1111
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2267 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in)
					SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
					SET @errorString = REPLACE(@errorString, '^2%s', 'Edit on user group and edit on external group')
					SET @errorString = REPLACE(@errorString, '^3%s', (SELECT @extGroupName))
					CLOSE groups_cursor
					DEALLOCATE groups_cursor
					ROLLBACK TRAN
					GOTO RETURN_RESULTS
				END
			END
			IF @operation = 1
			BEGIN
					--Is my user creating the user group ? should i have some permission for this on commcell ?
					--Or shall we simply disallow this operation ?
					IF NOT EXISTS (SELECT * FROM UMGroups WHERE name = @extGroupName AND umdsProviderId = @extProviderId)
						INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
							VALUES(1, 0, 0, 1, @extGroupName, @extGroupDescription, 2, NEWID(), @extProviderId, '', 0)
					ELSE
						UPDATE UMGroups
						SET groupFlags = (groupFlags | 1 )
						WHERE name = @extGroupName AND umdsProviderId = @extProviderId
					SET @extGroupId = (select id from UMgroups WHERE name = @extGroupName AND umdsProviderId = @extProviderId)
					--Ideally the entry should not be there in both UMGroups and UMDSGroups together
					IF NOT exists (Select * from UMDSgroups WHERE name = @extGroupName AND umdsProviderId = @extProviderId)
						INSERT UMDSGroups(id, umdsProviderId, enabled, name, description, email, oldId)
							Values (@extGroupId, @extProviderId, 1, @extGroupName, @extGroupDescription, '',0)
					ELSE
						UPDATE UMDSGroups
						SET id = @extGroupId, enabled = 1
						WHERE name=@extGroupName AND umdsProviderId = @extProviderId
					IF not exists (Select * from UMDSGroupMaps WHERE umdsgroupId = @extGroupId AND umgroupId = @localGroupId)
						INSERT UMDSGroupMaps VALUES (@extGroupId, @localGroupId, @nowTime)
			END
			ELSE IF @operation = 2
			BEGIN
					iF @extGroupId = 0
						SET @extGroupId = (select id from UMDSgroups WHERE name = @extGroupName AND umdsProviderId = @extProviderId)
--DEBUG					print 'Deleting ExtgroupId '+convert(nvarchar(4), @extGroupId)
					DELETE UMDSGroupMaps
						WHERE umdsgroupId = @extGroupId AND umgroupId = @localGroupId
			END
/*
			ELSE
			  BEGIN
			  END
*/
	--		GET THE NEXT REQUEST
			FETCH NEXT FROM groups_cursor
			INTO @extProviderId, @exProviderName, @extGroupId, @extGroupName,@extGroupDescription, @operation
		END
		CLOSE groups_cursor
		DEALLOCATE groups_cursor
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = -1
	set @errorString = ERROR_MESSAGE()
	if @tranStarted > 0
		ROLLBACK TRAN
END   CATCH
RETURN_RESULTS:
-- OP=2 DELETE, OP=3 UPDATEnn
-----------------------------
-- THIS IS THE RESPONSE  ----
-----------------------------
SELECT  1                    as TAG,
        NULL                 as Parent,
SUBSTRING(@xmlReqMsg, 2, LEN(@xmlReqMsg))     as [CVGui_GenericResp!1!msgTag],
0						 as [CVGui_GenericResp!1!msgID],
@errorCode               as [CVGui_GenericResp!1!errorCode],
@errorString             as [CVGui_GenericResp!1!errorMessage],
		NULL				as [hdr!2!time],
		NULL				as [hdr!2!uBrowserID],
		NULL				as [hdr!2!uPipeID],
		NULL				as [hdr!2!uPipeType]
-- Header information
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSLocalGroupOpsReq')
	delete from GxQscripts where name = 'sec_UMDSLocalGroupOpsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSLocalGroupOpsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSLocalGroupOpsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSLocalGroupOpsReq',  '00010005030400010000', 'sec_UMDSLocalGroupOpsReq', '00010005030400010000')
GO

