

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSGetAllExternalGroupsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSGetAllExternalGroupsReq.sp,v $ $Id: sec_UMDSGetAllExternalGroupsReq.sp,v 1.1.294.1 2018/03/15 23:34:09 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSGetAllExternalGroupsReq.sp,v $ $Id: sec_UMDSGetAllExternalGroupsReq.sp,v 1.6.40.1 2017/02/10 20:53:27 sjohnson Exp $";
-- =============================================
-- Author:		JayaRam
-- Create date: 04/12/2007
-- Description:	Return the list of external groups
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSGetAllExternalGroupsReq <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSGetAllExternalGroupsReq')
	drop procedure sec_UMDSGetAllExternalGroupsReq
IF EXISTS (select * from GxQscripts where name='sec_UMDSGetAllExternalGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSGetAllExternalGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSGetAllExternalGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSGetAllExternalGroupsReq'
GO
print '... Creating Procedure: sec_UMDSGetAllExternalGroupsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSGetAllExternalGroupsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
IF (dbo.isnewSecurity() = 0)
BEGIN
SELECT  1                   as TAG,
        NULL                as Parent,
NULL                as [EVGui_UMDSGetAllExternalGroupsResp!1],
		NULL				as [hdr!4!time],
		NULL				as [hdr!4!uBrowserID],
		NULL				as [hdr!4!uPipeID],
		NULL				as [hdr!4!uPipeType],
        NULL                as [groups!2!id],
        NULL                as [groups!2!name],
        NULL                as [groups!2!description],
        NULL                as [groups!2!enabled],
	NULL                as [shortName!3!id],
	NULL                as [shortName!3!domainName]
UNION ALL
-- Header information
SELECT DISTINCT 2, 1, NULL,
	 NULL, NULL, NULL, NULL,
     G.id, G.name, G.description, G.enabled, NULL, NULL
FROM UMDSGroups AS G,UMDSGroupMaps AS M
WHERE G.id = M.umdsgroupId
UNION ALL
SELECT  DISTINCT 3, 2, NULL,
	NULL, NULL, NULL, NULL,
	G.id, NULL, NULL, NULL, G.umdsProviderId, P.domainName
FROM UMDSGroups AS G,UMDSGroupMaps AS M, UMDSProviders AS P
WHERE G.Id = M.umdsgroupId
AND P.id  = G.umdsProviderId
ORDER BY [groups!2!id], [shortName!3!id]
FOR XML Explicit
END
ELSE
BEGIN
	--Display only the user groups that callerId can see (get AD user groups)
	  IF OBJECT_ID('tempdb.dbo.#sec_UMDSGetAllExternalGroupsReqTbl') IS NOT NULL
	       DROP TABLE #sec_UMDSGetAllExternalGroupsReqTbl
	CREATE TABLE #sec_UMDSGetAllExternalGroupsReqTbl (userGroupId INT)
		EXEC sec_getUserGroupsForThisUser  '#sec_UMDSGetAllExternalGroupsReqTbl' ,@ownerId, 0, 2
	SELECT  1                   as TAG,
			NULL                as Parent,
NULL                as [EVGui_UMDSGetAllExternalGroupsResp!1],
			NULL				as [hdr!4!time],
			NULL				as [hdr!4!uBrowserID],
			NULL				as [hdr!4!uPipeID],
			NULL				as [hdr!4!uPipeType],
			NULL                as [groups!2!id],
			NULL                as [groups!2!name],
			NULL                as [groups!2!description],
			NULL                as [groups!2!enabled],
		NULL                as [shortName!3!id],
		NULL                as [shortName!3!domainName]
	UNION ALL
	SELECT DISTINCT 2, 1, NULL,
		 NULL, NULL, NULL, NULL,
		 G.id, G.name, G.description, G.enabled, NULL, NULL
	FROM UMDSGroups AS G,UMDSGroupMaps AS M
	WHERE G.id = M.umdsgroupId
	AND G.id IN (SELECT userGroupId FROM #sec_UMDSGetAllExternalGroupsReqTbl)
	UNION ALL
	SELECT  DISTINCT 3, 2, NULL,
		NULL, NULL, NULL, NULL,
		G.id, NULL, NULL, NULL, G.umdsProviderId, P.domainName
	FROM UMDSGroups AS G,UMDSGroupMaps AS M, UMDSProviders AS P
	WHERE G.Id = M.umdsgroupId
	AND P.id  = G.umdsProviderId
	AND G.id IN (SELECT userGroupId FROM #sec_UMDSGetAllExternalGroupsReqTbl)
	ORDER BY [groups!2!id], [shortName!3!id]
	FOR XML Explicit
	IF OBJECT_ID('tempdb.dbo.#sec_UMDSGetAllExternalGroupsReqTbl') IS NOT NULL
	       DROP TABLE #sec_UMDSGetAllExternalGroupsReqTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSGetAllExternalGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSGetAllExternalGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSGetAllExternalGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSGetAllExternalGroupsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSGetAllExternalGroupsReq',  '00010001029400010000', 'sec_UMDSGetAllExternalGroupsReq', '00010001029400010000')
GO

