

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSExternalUserLogInHistoryReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSExternalUserLogInHistoryReq.sp,v $ $Id: sec_UMDSExternalUserLogInHistoryReq.sp,v 1.7.304.1 2018/03/15 23:33:39 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSExternalUserLogInHistoryReq.sp,v $ $Id: sec_UMDSExternalUserLogInHistoryReq.sp,v 1.15.2.2 2018/03/15 23:32:53 jiechen Exp $";
-- ============================================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of user for a given AD Provider
-- ============================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSExternalUserLogInHistoryReq <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSExternalUserLogInHistoryReq')
	drop procedure sec_UMDSExternalUserLogInHistoryReq
IF EXISTS (select * from GxQscripts where name='sec_UMDSExternalUserLogInHistoryReq')
	delete from GxQscripts where name = 'sec_UMDSExternalUserLogInHistoryReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSExternalUserLogInHistoryReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSExternalUserLogInHistoryReq'
GO
print '... Creating Procedure: sec_UMDSExternalUserLogInHistoryReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSExternalUserLogInHistoryReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
DECLARE @errorString			nvarchar(1024)
DECLARE @errorCode INT
DECLARE @iDoc           int
DECLARE @xmlReqMsg       nvarchar(256)
DECLARE @xmlReqMsgNode   nvarchar (512)
DECLARE @domainName	nvarchar(1024)
DECLARE @umdsProviderId   integer
DECLARE @providerEnabled integer
DECLARE @now            integer
DECLARE @expireTimeSecs integer
DECLARE @expireDaysName nvarchar(80)
DECLARE @expireDaysVal  nvarchar(80)
SET @expireDaysName	= 'UMDS User Expiration Days'
	SET @expireDaysVal	= Isnull((select value from gxglobalParam where name = @expireDaysName), '60')
SET @expireTimeSecs	= (60*60*24 * @expireDaysVal)
SET @now			=  dbo.GetUnixTime (GetUTCdate())
set @errorCode = 0
-------------------------------------
-- FETCH PARAMETERS FROM XML INPUT --
-------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSExternalUserLogInHistoryReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
SET @xmlReqMsgNode = @xmlReqMsg + '/provider/shortName'
SET @umdsProviderId            = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(256) '@id'))
SET @domainName                = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (domainName nvarchar(1024) '@domainName'))
SET @providerEnabled	       = ISNULL((select enabled from UMDSProviders where id = @umdsProviderId), 0)
IF OBJECT_ID('#UsersSec_getUsersNewTbl')  IS NOT NULL
	DROP TABLE #UsersSec_getUsersNewTbl
CREATE TABLE  #UsersSec_getUsersNewTbl  ( userId int);
EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl' ,@ownerID,0,2,0,0
SELECT	1			         as TAG,
		NULL		         as Parent,
NULL				 as [EVGui_UMDSExternalUserLogInHistoryResp!1],
		NULL				as [hdr!6!time],
		NULL				as [hdr!6!uBrowserID],
		NULL				as [hdr!6!uPipeID],
		NULL				as [hdr!6!uPipeType],
		NULL			as [users!2!id],
		NULL			as [users!2!name],
		NULL			as [users!2!userFullName],
		NULL			as [users!2!email],
		NULL			as [users!2!description],
		NULL			as [users!2!enabled],
		NULL			as [users!2!lastLoggedInTime]
UNION ALL
-- Header information
SELECT 2,1, NULL,
		NULL, NULL, NULL, NULL,
		id, login, name, email, description, enabled, lastLoginTime
		FROM UMUsers JOIN #UsersSec_getUsersNewTbl ON id=userId
		WHERE @umdsProviderId <> 0
		  AND  umDSproviderId = @umdsProviderId
AND (flags & 0x001) <> 0			-- 'USERS_VALID' from EvSecuritConst.h
AND (flags & 0x004) = 0
		  AND (lastLoginTime  + @expireTimeSecs > @now)
UNION ALL
SELECT 2,1, NULL,
		NULL, NULL, NULL, NULL,
		id, login, name, email, description, enabled, lastLoginTime
		FROM UMUsers JOIN #UsersSec_getUsersNewTbl ON id=userId
		WHERE @umdsProviderId = 0
		  AND umDSproviderId <> @umdsProviderId
AND (flags & 0x001) <> 0			-- 'USERS_VALID' from EvSecuritConst.h
AND (flags & 0x004) = 0
		  AND (lastLoginTime  + @expireTimeSecs > @now)
FOR XML EXPLICIT
EXEC sp_xml_removedocument @idoc
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSExternalUserLogInHistoryReq')
	delete from GxQscripts where name = 'sec_UMDSExternalUserLogInHistoryReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSExternalUserLogInHistoryReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSExternalUserLogInHistoryReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSExternalUserLogInHistoryReq',  '00010007030400010000', 'sec_UMDSExternalUserLogInHistoryReq', '00010007030400010000')
GO

