

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSExternalGroupsForLocalGroupReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSExternalGroupsForLocalGroupReq.sp,v $ $Id: sec_UMDSExternalGroupsForLocalGroupReq.sp,v 1.4.304.1 2018/03/15 23:33:29 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSExternalGroupsForLocalGroupReq.sp,v $ $Id: sec_UMDSExternalGroupsForLocalGroupReq.sp,v 1.7.40.1 2017/02/10 20:53:27 sjohnson Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSExternalGroupsForLocalGroupReq <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSExternalGroupsForLocalGroupReq')
	drop procedure sec_UMDSExternalGroupsForLocalGroupReq
IF EXISTS (select * from GxQscripts where name='sec_UMDSExternalGroupsForLocalGroupReq')
	delete from GxQscripts where name = 'sec_UMDSExternalGroupsForLocalGroupReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSExternalGroupsForLocalGroupReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSExternalGroupsForLocalGroupReq'
GO
print '... Creating Procedure: sec_UMDSExternalGroupsForLocalGroupReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSExternalGroupsForLocalGroupReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
set @errorCode = 0
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
declare @iDoc                 int
declare @xmlReqMsg       nvarchar(256)
declare @xmlReqMsgNode   nvarchar (512)
declare @locGroupId           int
declare @locGroupName         nvarchar(2048)
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSExternalGroupsForLocalGroupReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
set @xmlReqMsgNode = @xmlReqMsg + '/localGroup'
set @locGroupId       = (select * from OPENXML(@iDoc,  @xmlReqMsgNode,  0) WITH (id nvarchar(128) '@id'))
set @locGroupName     = (select * from OPENXML(@iDoc,  @xmlReqMsgNode,  0) WITH (name nvarchar(2048) '@name'))
--select @locGroupId, @locGroupName
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
IF (dbo.isNewSecurity() = 0)
BEGIN
SELECT  1                   as TAG,
        NULL                as Parent,
NULL                as [EVGui_UMDSExternalGroupsForLocalGroupResp!1],
		NULL				as [hdr!6!time],
		NULL				as [hdr!6!uBrowserID],
		NULL				as [hdr!6!uPipeID],
		NULL				as [hdr!6!uPipeType],
        NULL                as [externalGroups!2!id],
        NULL                as [externalGroups!2!name],
        NULL                as [externalGroups!2!description],
        NULL                as [externalGroups!2!enabled],
        NULL                as [shortName!3!id],
        NULL                as [shortName!3!domainName]
UNION ALL
-- Header information
SELECT DISTINCT 2, 1, NULL,
	NULL, NULL, NULL, NULL,
    G.Id, G.name, G.description, G.enabled,
     NULL, NULL
FROM UMDSGroups AS G, UMDSGroupMaps AS M
WHERE umGroupId = @locGroupId
  AND G.id = M.umdsgroupId
UNION ALL
SELECT 3, 2, NULL,
	 NULL, NULL, NULL, NULL,
     G.id, NULL, NULL, NULL,
     P.id , domainName
FROM UMDSProviders AS P, UMDSGroups as G, UMDSGroupMaps As M
WHERE P.id = G.umdsProviderId
  AND umGroupId = @locGroupId
  AND G.id = M.umdsgroupId
ORDER BY [externalGroups!2!id]
FOR XML Explicit
END
ELSE
BEGIN
	--Display only the user groups that callerId can see (get both normal and AD user groups, since we are going to send both the information)
	IF OBJECT_ID('tempdb.dbo.#sec_UMDSExternalGroupsForLocalGroupReqTbl') IS NOT NULL
	       DROP TABLE #sec_UMDSExternalGroupsForLocalGroupReqTbl
	CREATE TABLE #sec_UMDSExternalGroupsForLocalGroupReqTbl (userGroupId INT)
	EXEC sec_getUserGroupsForThisUser '#sec_UMDSExternalGroupsForLocalGroupReqTbl', @ownerID, 0, 0
	SELECT  1                   as TAG,
        NULL                as Parent,
NULL                as [EVGui_UMDSExternalGroupsForLocalGroupResp!1],
		NULL				as [hdr!6!time],
		NULL				as [hdr!6!uBrowserID],
		NULL				as [hdr!6!uPipeID],
		NULL				as [hdr!6!uPipeType],
        NULL                as [externalGroups!2!id],
        NULL                as [externalGroups!2!name],
        NULL                as [externalGroups!2!description],
        NULL                as [externalGroups!2!enabled],
        NULL                as [shortName!3!id],
        NULL                as [shortName!3!domainName]
	UNION ALL
	SELECT DISTINCT 2, 1, NULL,
		NULL, NULL, NULL, NULL,
		G.Id, G.name, G.description, G.enabled,
		 NULL, NULL
	FROM UMDSGroups AS G, UMDSGroupMaps AS M, UMGroups AS Gr
	WHERE umGroupId = @locGroupId
	  AND G.id = M.umdsgroupId
	  AND M.umGroupId = Gr.id
	  AND G.id IN (SELECT userGroupId FROM #sec_UMDSExternalGroupsForLocalGroupReqTbl)
	  AND Gr.id IN (SELECT userGroupId FROM #sec_UMDSExternalGroupsForLocalGroupReqTbl)
	UNION ALL
	SELECT 3, 2, NULL,
		 NULL, NULL, NULL, NULL,
		 G.id, NULL, NULL, NULL,
		 P.id , domainName
	FROM UMDSProviders AS P, UMDSGroups as G, UMDSGroupMaps As M, UMGroups AS Gr
	WHERE P.id = G.umdsProviderId
	  AND umGroupId = @locGroupId
	  AND G.id = M.umdsgroupId
	  AND M.umGroupId = Gr.id
	  AND G.id IN (SELECT userGroupId FROM #sec_UMDSExternalGroupsForLocalGroupReqTbl)
	  AND Gr.id IN (SELECT userGroupId FROM #sec_UMDSExternalGroupsForLocalGroupReqTbl)
	ORDER BY [externalGroups!2!id]
	FOR XML Explicit
	IF OBJECT_ID('tempdb.dbo.#sec_UMDSExternalGroupsForLocalGroupReqTbl') IS NOT NULL
	       DROP TABLE #sec_UMDSExternalGroupsForLocalGroupReqTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSExternalGroupsForLocalGroupReq')
	delete from GxQscripts where name = 'sec_UMDSExternalGroupsForLocalGroupReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSExternalGroupsForLocalGroupReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSExternalGroupsForLocalGroupReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSExternalGroupsForLocalGroupReq',  '00010004030400010000', 'sec_UMDSExternalGroupsForLocalGroupReq', '00010004030400010000')
GO

