

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSExternalGroupOpsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSExternalGroupOpsReq.sp,v $ $Id: sec_UMDSExternalGroupOpsReq.sp,v 1.8.304.1 2018/03/15 23:33:32 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSExternalGroupOpsReq.sp,v $ $Id: sec_UMDSExternalGroupOpsReq.sp,v 1.25.14.20 2018/12/21 19:22:52 saggarwal Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UMDSExternalGroupOpsReq')
BEGIN
	print '>>> Drop Stored Procedure: sec_UMDSExternalGroupOpsReq <<<'
	drop procedure sec_UMDSExternalGroupOpsReq
END
IF EXISTS (select * from GxQscripts where name='sec_UMDSExternalGroupOpsReq')
	delete from GxQscripts where name = 'sec_UMDSExternalGroupOpsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSExternalGroupOpsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSExternalGroupOpsReq'
GO
print '... Creating Procedure: sec_UMDSExternalGroupOpsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSExternalGroupOpsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
set @errorCode = 0
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
declare @iDoc                   int
declare @xmlReqMsg              nvarchar(256)
declare @xmlReqMsgNode          nvarchar(512)
declare @sqlError				int
declare @topOperation           int
declare @extGroupId int
declare @extGroupDescription	nvarchar(1024)
declare @extGroupName			nvarchar(1024)
declare @extGroupEnabled		int
declare @extMailId   			nvarchar(255)
declare @ProviderId				int
declare @providerName			nvarchar(1024)
declare @locGroupId				int
declare @locGroupOp				int
declare @locGroupName			nvarchar(1024)
declare @enforcequota			nvarchar(255)
declare @boolenforcequota		int
declare @quotasize				int
DECLARE @enforceEdgeDriveQuotaStr  nvarchar(255)
DECLARE @enforceEdgeDriveQuota	int	= 0
DECLARE @edgeDriveQuotaLimitInGB int
declare @guidStr				nvarchar(255)
DECLARE @preferenceMachineCentricClient INT
DECLARE @enforceQuotaChanged INT = 0
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @recomputeQuota	INT = 0
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSExternalGroupOpsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
DECLARE @xmlNode nvarchar(255)
SET @xmlNode = (SELECT  top 1 localname FROM  OPENXML (@idoc, '/.',1) where id = 0)
IF(@xmlNode='Api_UMDSExternalGroupOpsReq')
	set @xmlReqMsg = '/Api_UMDSExternalGroupOpsReq'
set @xmlReqMsgNode = @xmlReqMsg
set @topOperation			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (operation nvarchar(128) '@operation'))
set @xmlReqMsgNode = @xmlReqMsg + '/externalGroup'
set @extGroupId					= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(128) '@id'))
set @extGroupDescription		= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (description nvarchar(128) '@description'))
set @extGroupName				= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (name nvarchar(128) '@name'))
set @extGroupEnabled			= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (enabled nvarchar(128) '@enabled'))
set @extMailId  				= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (name nvarchar(255) '@email'))
set @enforcequota				= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (enforcequota nvarchar(256) '@enforceFSQuota'))
set @quotasize					= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (quotasize int '@quotaLimitInGB'))
set @enforceEdgeDriveQuotaStr	= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (enforceEdgeDriveQuota nvarchar(256) '@enforceEdgeDriveQuota'))
set @edgeDriveQuotaLimitInGB	= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (edgeDriveQuotaLimitInGB int '@edgeDriveQuotaLimitInGB'))
set @guidStr					= (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (guid nvarchar(255) '@GUID'))
SET @preferenceMachineCentricClient	 = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (preferenceMachineCentricClient INT '@preferenceMachineCentricClient'))
if (@enforcequota = 'true' or @enforcequota = '1')
	set @boolenforcequota = 1
else
	set @boolenforcequota = 0
if (@enforceEdgeDriveQuotaStr = 'true' or @enforceEdgeDriveQuotaStr = '1')
	set @enforceEdgeDriveQuota = 1
    --Get plan details from request
    DECLARE @planId int
    DECLARE @planOpType int
    DECLARE @xmlReqPlanMsgNode          nvarchar(512)
    set @planOpType		        = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (planOperationType nvarchar(128) '@planOperationType'))
    set @xmlReqPlanMsgNode = @xmlReqMsg + '/externalGroup/plan'
    set @planId		        = (select * from OPENXML(@iDoc, @xmlReqPlanMsgNode, 0) WITH (planId nvarchar(128) '@planId'))
set @xmlReqMsgNode = @xmlReqMsg + '/externalGroup/shortName'
set @ProviderId		        = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(128) '@id'))
set @providerName		    = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (domainName nvarchar(256) '@domainName'))
DECLARE @hasRights AS INT
--sanity check
IF NOT EXISTS (SELECT 1 FROM UMDSProviders WHERE id = @ProviderId)
BEGIN
	SET @ProviderId = (SELECT top 1 id FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @providerName)
	IF @ProviderId IS NULL OR @ProviderID = 0
	BEGIN
SET @errorCode = (1779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString =  (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @locale_in)
		SET @errorString = REPLACE(@errorString, '^1%s', @providerName)
		goto RETURN_RESULTS
	END
END
IF @topOperation IN (2, 3)
BEGIN
	IF NOT EXISTS (SELECT 1 FROM UMGroups WHERE id = @extGroupId)
	BEGIN
		SET @extGroupId = (SELECT id FROM UMGroups WHERE name = @extGroupName AND umdsProviderId = @providerID)
		IF @extGroupId IS NULL OR @extGroupId = 0
		BEGIN
SET @errorCode = (2429 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString =  (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @locale_in)
			SET @errorString = REPLACE(@errorString, '^1%s', @extGroupName)
			goto RETURN_RESULTS
		END
	END
END
--do security check.
--For external groups, we cannot associate/disassociate users
--But we can edit the security associations - this will be taken care in the security association entity SP
IF (dbo.isNewSecurity() = 1)
BEGIN
	SET @hasRights = 0
	IF (@topOperation = 1)
	BEGIN
		--Since this is a new AD user group we need add on name server to do it
EXEC sec_checkPermissionOnEntity @ownerId, 102, @hasRights OUTPUT, 61, @providerId
	END
	ELSE IF @topOperation IN (2,3)
	BEGIN
EXEC sec_checkPermissionOnEntity @ownerId, 102, @hasRights OUTPUT, 15, @extGroupId
	END
	IF @hasRights = 0
	BEGIN
			SET @errorCode = 1111
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2267 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in)
	        SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
	        SET @errorString = REPLACE(@errorString, '^2%s', ('add, edit, delete user groups'))
	        SET @errorString = REPLACE(@errorString, '^3%s', (SELECT @extGroupName))
			goto RETURN_RESULTS
	END
END
--select providerId=@ProviderId, providerName=@ProviderName
if (@extGroupId = 0 or @extGroupId is null)
BEGIN
--before inserting check email, if null make it emtpy
	set @extMailId = ISNULL(@extMailId,'')
	IF NOT EXISTS (SELECT * FROM UMGroups WHERE name = @extGroupName AND umdsProviderId = @providerId)
		INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsproviderId, email, lastCredSetTime)
		VALUES (1, 0, 0, 1, @extGroupName, '', 2, CASE WHEN (@guidStr IS NULL OR @guidStr = N'') THEN NEWID() ELSE @guidStr END, @providerId, @extMailId, 0)
	if NOT EXISTS (select * from UMDSGroups Where name = @extGroupName AND umdsProviderId = @providerId)
		insert UMDSGroups (id, umdsProviderId, enabled, name, description, email, oldId)
		SELECT UMGroups.id, @ProviderId, 1, @extGroupName, @extGroupDescription, @extMailId, 0
		FROM UMGroups
		WHERE UMGroups.name = @extGroupName AND UMGroups.umdsProviderId = @ProviderId
	set @extGroupId			= (select id from UMDSGroups Where name = @extGroupName AND umdsProviderId = @providerId)
END
IF @topOperation NOT IN (1, 2, 3)
BEGIN
	set @errorCode = -4
	set @errorString = 'Cannot handle Operation [' +convert (nvarchar(12), @topOperation) + '].'
	goto RETURN_RESULTS
END
--	+---------------------------------------------------------------+
--	| ADD EXTERNAL GROUP REQUEST - THIS CODE IS NECESSARY FOR READD |
--	+---------------------------------------------------------------+
IF @topOperation =1
BEGIN
  BEGIN TRY
	UPDATE UMDSgroups    set enabled = 1 , email=@extMailId , description=@extGroupDescription Where id = @extGroupId
	UPDATE UMgroups      set groupFlags = 1 , email=@extMailId , description=@extGroupDescription Where id = @extGroupId
  END TRY
  BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = ERROR_NUMBER()
	set @errorString = 'Cannot Add External Group[' +@extGroupName +']: ' +ERROR_MESSAGE()
	goto RETURN_RESULTS
  END CATCH
END
--	+-----------------------------------------------------------+
--	| DELETE OR UPDATE EXTERNAL GROUP REQUEST  - SECURITY CHECK |
--	+-----------------------------------------------------------+
IF (dbo.isNewSecurity() = 0) AND (@topOperation = 2 OR @topOperation = 3)
BEGIN
	DECLARE @canManageAllUsers INT = 0
	EXEC sec_canManageAllUsers @ownerID, @canManageAllUsers OUTPUT
	IF @canManageAllUsers = 0
	BEGIN
		-- user is not admin, so it should belong to that group or be owner of the domain ('USER MANAGEMENT' rights checked before calling that SP)
		IF NOT EXISTS ( SELECT * FROM UMDSUserGroup WITH(NOLOCK) WHERE [groupId] = @extGroupId and [userId] = @ownerID)
		AND NOT EXISTS ( SELECT * FROM UMDSProviders WITH(NOLOCK) WHERE [id] = @ProviderId  AND [ownerId] = @ownerID )
		BEGIN
			SET @errorCode = 1111
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2267 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in)
	        SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (979 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in))
	        SET @errorString = REPLACE(@errorString, '^3%s', (SELECT @extGroupName))
			goto RETURN_RESULTS
		END
	END
END
----------------------------------------------------
--	+-------------------------------+
--	| DELETE EXTERNAL GROUP REQUEST |
--	+-------------------------------+
IF @topOperation =2
BEGIN
  BEGIN TRY
	DELETE FROM UMSecurityAssociations
		WHERE isUser=0 and userOrGroupId = @extGroupId
	DELETE FROM UMOwners
		WHERE isUser=0 and userOrGroupId = @extGroupId
EXEC sec_deleteSecurityAssociationsForEntity 15, @extGroupId
	-- Remove Create As user ID
DECLARE @createAsUserID INT = (SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @extGroupId AND attrName = N'Create As User' AND modified = 0)
	IF @createAsUserID IS NOT NULL AND @createAsUserID <> 0 AND EXISTS (SELECT 1 FROM UMUsers WHERE id = @createAsUserID)		--if accidentally that hidden user is already deleted then no need to call delete user request
	BEGIN
		DECLARE @deleteUserXML XML = (SELECT
												(SELECT @createAsUserId AS '@userId',
13 AS '@_type_'
												 FOR XML PATH ('userEntity'), TYPE)
											 FOR XML PATH ('App_UserInfo'))
EXEC sec_performUserOperation 1, 2, @deleteUserXML output, 2, 0, 0, 0, '', '', 0, 0					--DEFAULT_COMMCELL_ID hardcoded, 2 stands for Common::Operation_Delete
	END
	DELETE UMDSGroupMaps WHERE umDSgroupId = @extGroupId
	UPDATE UMDSgroups    set enabled = 0 Where id = @extGroupId
	UPDATE UMgroups      set groupFlags = 0 Where id = @extGroupId
	DELETE UMGroupsProp where componentNameId =@extGroupId
	DELETE UMDSUserGroup WHERE groupId = @extGroupId
	DELETE UMUserGroup WHERE groupId = @extGroupId
	DELETE NtNotificationExternalGroups where externalGroupId = @extGroupId
  END TRY
  BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = ERROR_NUMBER()
	set @errorString = 'Cannot Delete External Group[' +@extGroupName +']: ' +ERROR_MESSAGE()
  END CATCH
  goto RETURN_RESULTS
END
--------------------------------------------------------
-- FOR UPDATE, MAY HAVE SOME "TOP LEVEL" PROP CHANGES --
--------------------------------------------------------
IF @topOperation =3
BEGIN
  BEGIN TRY
	 IF( @extGroupEnabled IS NOT NULL)
	 BEGIN
  		UPDATE UMDSGroups SET enabled = @extGroupEnabled WHERE id = @extGroupId
		IF(@extGroupEnabled =1)--to retain group flags
			UPDATE UMGroups SET groupFlags = groupFlags | @extGroupEnabled WHERE id = @extGroupId
		ELSE
			UPDATE UMGroups SET groupFlags = groupFlags & ~@extGroupEnabled WHERE id = @extGroupId
	 END
	 IF( @extMailId IS NOT NULL)
	BEGIN
  		UPDATE UMDSGroups SET  email=@extMailId WHERE id = @extGroupId
		UPDATE UMGroups SET  email=@extMailId WHERE id = @extGroupId
	  END
		IF( @extGroupDescription IS NOT NULL)
	BEGIN
  		UPDATE UMDSGroups SET  description=@extGroupDescription WHERE id = @extGroupId
		UPDATE UMGroups SET  description=@extGroupDescription WHERE id = @extGroupId
	 END
  END TRY
  BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = ERROR_NUMBER()
	set @errorString = 'Cannot Update External Group[' +@extGroupName +']: ' +ERROR_MESSAGE()
    goto RETURN_RESULTS
  END CATCH
END
--SET QUOTA, USER CENTRIC/MACHINE CENTRIC CLIENT PROPETIES, Plan
IF @topOperation = 3 OR @topOperation = 1
BEGIN
	BEGIN TRY
		--Check if quota needs to be recomputed for the users of the group
		IF ((@topOperation = 1 AND @boolenforcequota = 1) -- check if quota is being applied during ADD operation
			OR
				--Iif already set then check if the size is getting changed in UPDATE operation
(@topOperation = 3 AND ISNULL((SELECT CONVERT(INT,attrVal) FROM UMGroupsProp WITH(NOLOCK) WHERE componentNameId = @extGroupId AND attrName='Quota size'), 0) <> @quotasize
			AND @boolenforcequota = 1)
			OR
			-- IF being set/unset
(@topOperation = 3 AND @enforcequota <> ISNULL((SELECT CONVERT(INT,attrVal) FROM UMGroupsProp WITH(NOLOCK) WHERE componentNameId = @extGroupId AND attrName='Enforce quota'), 0))
			)
			SET @recomputeQuota = 1
		IF (@enforcequota is not null)
		BEGIN
				DELETE FROM UMGroupsProp WHERE componentNameId = @extGroupId AND (attrName LIKE 'Enforce quota' OR attrName LIKE 'Quota size')
INSERT INTO UMGroupsProp VALUES (@extGroupId,'Enforce quota',7,@boolenforcequota,@nowTime,0)
				SET @enforceQuotaChanged = 1
		END
		IF( @quotasize is not null )
		BEGIN
INSERT INTO UMGroupsProp VALUES (@extGroupId,'Quota size',7,@quotasize,@nowTime,0)
		END
		IF (@enforceEdgeDriveQuota is not null)
		BEGIN
DELETE FROM UMGroupsProp WHERE componentNameId = @extGroupId AND (attrName LIKE 'Enforce Edge Drive Quota' OR attrName LIKE 'Edge Drive Quota Size')
INSERT INTO UMGroupsProp VALUES (@extGroupId,'Enforce Edge Drive Quota',7,@enforceEdgeDriveQuota,@nowTime,0)
		END
		IF( @edgeDriveQuotaLimitInGB is not null )
		BEGIN
INSERT INTO UMGroupsProp VALUES (@extGroupId,'Edge Drive Quota Size',7,@edgeDriveQuotaLimitInGB,@nowTime,0)
		END
		MERGE   UMGroupsProp AS TGT
		USING   (VALUES (@extGroupId)) AS SRC (clientId)
ON      TGT.componentNameId = SRC.clientId and TGT.attrName = 'Prefer Machine Centric Client' AND TGT.attrType = 7
		WHEN    MATCHED AND @preferenceMachineCentricClient IS NOT NULL
			THEN UPDATE SET
				TGT.attrVal = @preferenceMachineCentricClient
		WHEN    NOT MATCHED AND @preferenceMachineCentricClient IS NOT NULL
			THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.clientId, 'Prefer Machine Centric Client', 7, @preferenceMachineCentricClient, @nowTime, 0);
        --Plan
		IF((@planId IS NOT NULL AND @planId >0) AND (@planOpType IS not null AND (@planOpType=3 OR  @planOpType=2)))
		BEGIN
		    DECLARE @AssociateGroupToPlan XML = N'<Api_UpdatePlanReq>
                <summary>
                    <plan planId="' + cast (@planId as nvarchar) +'" />
                </summary>
                <laptop>
                     <users userOperationType="' + cast (@planOpType as nvarchar) +'">
                        <users>
                            <externalUserGroup groupId="' + cast (@extGroupId as nvarchar) +'" />
                        </users>
                    </users>
                 </laptop>
            </Api_UpdatePlanReq>'
        EXEC[dbo].[AppPlanUpdateV2] @ownerId, @locale_in, @AssociateGroupToPlan output
        DECLARE @planErrorcode int =  (select @AssociateGroupToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorCode)[1]', 'int'))
        IF(@planErrorcode is not null and @planErrorcode > 0)
        BEGIN
            DECLARE @planErrorMsg nvarchar(max) =  (select @AssociateGroupToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorMessage)[1]', 'nvarchar(max)'))
  	        SET @errorCode = @planErrorcode
            SET @errorString = @planErrorMsg
            GOTO RETURN_RESULTS
        END
    END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @errorCode = ERROR_NUMBER()
		set @errorString = 'Cannot Update Quota Property for External Group[' +@extGroupName +']: ' +ERROR_MESSAGE()
		goto RETURN_RESULTS
	END CATCH
END
------------------------------------------------
-- SECURITY ASSOCIATIONS FOR EXTERNAL GROUPS --
------------------------------------------------
DECLARE @securityAssociationsOpType INT = 0
SET @xmlReqMsgNode = @xmlReqMsg + '/externalGroup/securityAssociations'
SET @securityAssociationsOpType = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (associationsOperationType INT '@associationsOperationType'))
IF(@topOperation=1)
	SET @securityAssociationsOpType=2 --add
IF @securityAssociationsOpType <> 0 AND @securityAssociationsOpType IS NOT NULL
BEGIN
	DECLARE @xmlSecurityAssoc AS XML
	DECLARE @inxml AS XML = CAST (@xmlString AS XML)
	IF(@xmlReqMsg='/EVGui_UMDSExternalGroupOpsReq')
		SET @xmlSecurityAssoc = (SELECT @securityAssociationsOpType AS '@associationsOperationType',
									(SELECT @inxml.query('EVGui_UMDSExternalGroupOpsReq/externalGroup/securityAssociations/associations'))
							 FOR XML PATH ('App_SecurityAssociationForUserOrGroupList'))
	ELSE
		SET @xmlSecurityAssoc = (SELECT @securityAssociationsOpType AS '@associationsOperationType',
									(SELECT @inxml.query('Api_UMDSExternalGroupOpsReq/externalGroup/securityAssociations/associations'))
							 FOR XML PATH ('App_SecurityAssociationForUserOrGroupList'))
	DECLARE @errorTable TABLE (errorCode INT, errorString NVARCHAR(MAX))
    INSERT INTO @errorTable
        EXEC sec_setSecurityAssociationsFromUserOrUserGroup @xmlSecurityAssoc, @ownerID, 0, @extGroupId, 0
    SET @errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
    SET @errorString = (SELECT TOP 1 errorString FROM @errorTable)
    IF @errorCode <> 0
         GOTO RETURN_RESULTS
END
--------------------------------------
-- LOOP FOR ALL THE LOCAL GROUPS    --
-- SAME FOR ADD/UPDATE              --
--------------------------------------
set @xmlReqMsgNode = @xmlReqMsg + '/localGroupOps/localGroup'
DECLARE groupOps_Cursor CURSOR FOR
	SELECT  id, name, operation
			FROM OPENXML(@iDoc, @xmlReqMsgNode, 0)
			  WITH (
				id int,
				name varchar(1024),
				operation int '../@operation'
				)
OPEN groupOps_Cursor
FETCH NEXT FROM groupOps_Cursor
INTO @locGroupId, @locGroupName, @locGroupOp
WHILE @@FETCH_STATUS = 0
BEGIN
--	select  @locGroupId, @locGroupName, @locGroupOp
	--SecurityCheck - should have edit permissions on both user group and external group
	IF (dbo.isNewSecurity() = 1)
	BEGIN
		SET @hasRights = 0
EXEC sec_checkPermissionOnEntity @ownerId, 102, @hasRights OUTPUT, 15, @locGroupId
		IF @hasRights = 0
		BEGIN
			SET @errorCode = 1111
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2267 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @locale_in)
			SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @ownerID),@ownerID))
			SET @errorString = REPLACE(@errorString, '^2%s', 'Edit on user group and edit on external group')
			SET @errorString = REPLACE(@errorString, '^3%s', (SELECT @extGroupName))
			CLOSE groupOps_Cursor
			DEALLOCATE groupOps_Cursor
			GOTO RETURN_RESULTS
		END
	END
	IF @locGroupOp = 1
	BEGIN
		BEGIN TRY
			INSERT UMDSGroupMaps VALUES (@extGroupId, @locGroupId, 0)
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			set @errorCode = ERROR_NUMBER()
			set @errorString = 'Cannot Add Local Group[' +@locGroupName +'] to External Group ['+
					@extGroupName + ']: ' +ERROR_MESSAGE()
		END CATCH
	END
	ELSE IF @locGroupOp = 2
	BEGIN TRY
		DELETE UMDSGroupMaps where umdsgroupId = @extGroupId AND umgroupId =  @locGroupId
		set @sqlError = @@error
		if @sqlError <> 0
			select 'sqlError'=@sqlError
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			set @errorCode = ERROR_NUMBER()
			set @errorString = 'Cannot Delete Local Group[' +@locGroupName +'] to External Group ['+
					@extGroupName + ']: ' +ERROR_MESSAGE()
	END  CATCH
	ELSE
	BEGIN
			set @errorCode = -1
			set @errorString = 'Invalid Group Operation [' + convert(nvarchar(4), @locGroupOp)
								 + '] for External Group [' +@extGroupName + ']'
	END
	FETCH NEXT FROM groupOps_Cursor
	INTO @locGroupId, @locGroupName, @locGroupOp
END
CLOSE groupOps_Cursor
DEALLOCATE groupOps_Cursor
EXEC sp_xml_removedocument @idoc
--select 'topOp'=@topOperation, 'extGroupId'=@extGroupId, 'extGroupName'=@extGroupName, 'extGroupDescription'=@extGroupDescription, 'extGroupEnabled'=@extGroupEnabled
---------------------------------------------------------------
--	PROCESSING OF ASSOCIATED USERS							---
--	THIS NEEDS TO BE DONE ONLY FOR ORGANIZATION USER GROUPS	---
---------------------------------------------------------------
IF (SELECT serviceType FROM UMDSProviders WHERE id = (SELECT umdsProviderID FROM UMGroups WHERE id = @extGroupId)) = 5
BEGIN
	SET @inXML = CAST(@xmlString AS XML)
	DECLARE @associatedUsersOperationType INT
	IF(@xmlReqMsg='/EVGui_UMDSExternalGroupOpsReq')
		SET @associatedUsersOperationType = (SELECT ref.value('@associatedUsersOperationType', 'INT')
												FROM @inXML.nodes ('EVGui_UMDSExternalGroupOpsReq/externalGroup') R (ref))
	ELSE
		SET @associatedUsersOperationType = (SELECT ref.value('@associatedUsersOperationType', 'INT')
												FROM @inXML.nodes ('Api_UMDSExternalGroupOpsReq/externalGroup') R (ref))
	IF @associatedUsersOperationType IS NOT NULL
	BEGIN
		DECLARE @inputUsers TABLE
		(
			userId INT,
			userName NVARCHAR(MAX)
		)
		DECLARE @addedUsers TABLE
		(
			userId INT
		)
		DECLARE @deletedUsers TABLE
		(
			userId INT
		)
		INSERT INTO @inputUsers (userId, userName)
			SELECT T.c.value('(@userId)[1]', 'INT'), T.c.value('(@userName)[1]', 'NVARCHAR(MAX)')
			FROM @inXML.nodes('EVGui_UMDSExternalGroupOpsReq/externalGroup/associatedUsers') T(c)
		INSERT INTO @inputUsers (userId, userName)
			SELECT T.c.value('(@userId)[1]', 'INT'), T.c.value('(@userName)[1]', 'NVARCHAR(MAX)')
			FROM @inXML.nodes('Api_UMDSExternalGroupOpsReq/externalGroup/associatedUsers') T(c)
		--Sanity check
		IF EXISTS (SELECT 1 FROM @inputUsers WHERE userId <= 0 OR userId IS NULL)
		BEGIN
SET @errorCode = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @locale_in)
			SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT TOP 1 userName FROM @inputUsers WHERE userId <= 0 OR userId IS NULL), ''))
			GOTO RETURN_RESULTS
		END
		DECLARE @providerTable table (id int)
		IF(@providerId <> 0)
		BEGIN
			-- build the CTE
			;WITH tblChild AS
			(
				SELECT id
					FROM UMDSProviders WHERE ownerCompany = @providerId
				UNION ALL
				SELECT UMDSProviders.id FROM UMDSProviders  JOIN tblChild  ON UMDSProviders.ownerCompany = tblChild.Id
			)
			INSERT INTO @providerTable SELECT id FROM tblChild union select @providerId
			OPTION(MAXRECURSION 32767)
			END
		--Allow only users belonging to this organization to be associated to this user group
		IF EXISTS (SELECT 1 FROM UMUsers WHERE umdsproviderId not in(select id from @providerTable)  AND id IN (SELECT userId FROM @inputUsers))
		BEGIN
SET @errorCode = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @errorCode AND localeId = @locale_in)
			SET @errorString = REPLACE(@errorString, '^1%s', (SELECT TOP 1 login FROM UMUsers WHERE umdsproviderId <> @providerId AND id IN (SELECT userId FROM @inputUsers)))
			GOTO RETURN_RESULTS
		END
		IF OBJECT_ID('tempdb.dbo.#usersVisible') IS NOT NULL
			DROP TABLE #usersVisible
		CREATE TABLE #usersVisible
		(
			userId INT
		)
		EXEC sec_getUsersForThisUser '#usersVisible', @ownerID, 1
		IF @topOperation = 1			--when we are creating new user group, let us assume that the associated users operation type as ADD
			SET @associatedUsersOperationType = 2
		IF ((@associatedUsersOperationType = 2) OR (@associatedUsersOperationType = 1))		--ADD in App::ListOperationType; OVERWRITE in App::ListOperationType
		BEGIN
			INSERT INTO @addedUsers (userID)
				SELECT userId
				FROM @inputUsers
				EXCEPT
				SELECT userID
				FROM UMUserGroup
				WHERE groupId = @extGroupid
		END
		IF @associatedUsersOperationType = 3			--DELETE in App::ListOperationType
		BEGIN
			INSERT INTO @deletedUsers (userId)
					SELECT userId
					FROM @inputUsers
		END
		IF @associatedUsersOperationType = 1			--OVERWRITE in App::ListOperationType
		BEGIN
			INSERT INTO @deletedUsers (userId)
					SELECT userID
					FROM UMUserGroup
					WHERE groupid = @extGroupId
					EXCEPT
					SELECT userId
					FROM @inputUsers
		END
		IF EXISTS (SELECT userId FROM @addedUsers WHERE userId NOT IN (SELECT userID FROM #usersVisible))
		BEGIN
SET @errorCode = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @locale_in)
			SET @errorString = REPLACE(@errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @addedUsers WHERE userId NOT IN (SELECT userId FROM #usersVisible)) ))
			GOTO RETURN_RESULTS
		END
		IF EXISTS (SELECT userId FROM @deletedUsers WHERE userId NOT IN (SELECT userID FROM #usersVisible))
		BEGIN
SET @errorCode = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @locale_in)
			SET @errorString = REPLACE(@errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @deletedUsers WHERE userId NOT IN (SELECT userId FROM #usersVisible)) ))
			GOTO RETURN_RESULTS
		END
		INSERT INTO UMUserGroup (userId, groupId, flag)
			SELECT userId, @extGroupId, 0
			FROM @addedUsers
		--Let us not insert into UMDSUserGroup for organization users. Let this table be filled only with AD information.
		--This way it is easy to handle in stored procedures. That no one should manually alter UMDSUserGroup.
		--Else we need to change everywhere wherever UMDSUserGroup manual alteration is prohibited to exclude organization members.
		DELETE Tbl
		FROM UMUserGroup Tbl INNER JOIN @deletedUsers DeleteTbl
		ON Tbl.userId = DeleteTbl.userId
		WHERE Tbl.groupId = @extGroupId
	END
END
-------------------------------------------------------------
-- DONE ALL THE WORK (OR NOT) RETURN RESPONSE TO CALLER  ----
-------------------------------------------------------------
RETURN_RESULTS:
-- Compute global quota flag before returning
IF @enforceQuotaChanged = 1 OR @topOperation = 2 -- Common.x OperationType_DELETE
BEGIN
	-- Update global quota check flag
	-- Based on this JM and other subsystems decide whether or not to do a quota check.
	DECLARE @newDoQuotaCheck INT = CASE WHEN @boolenforcequota > 0 THEN 1
									ELSE ISNULL((
												SELECT TOP 1 1
												FROM UMUsersProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'
												UNION
												SELECT TOP 1 1
												FROM UMGroupsProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'), 0)
									END
	DECLARE @oldDoQuotaCheck INT = (SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'DoFSQuotaCheck')
	-- Insert only if it gets enabled
	IF @oldDoQuotaCheck IS NULL AND @newDoQuotaCheck = 1
	BEGIN
		INSERT INTO GXGlobalParam(name, value, created, modified)
		VALUES('DoFSQuotaCheck', @newDoQuotaCheck, @nowTime, 0)
	END
	ELSE IF @oldDoQuotaCheck <> @newDoQuotaCheck
	BEGIN
		UPDATE GXGlobalParam
		SET value = @newDoQuotaCheck
		WHERE name = 'DoFSQuotaCheck'
		AND modified = 0
	END
END
--Need to recompute the quota information for the groups whose 'quota size' property is getting updated. Insert 'ReComputeQuota' property in UmUsersProp table for the modified users.
IF @recomputeQuota = 1
BEGIN
	DECLARE @inpXml XML
	SET @inpXml = (SELECT DISTINCT userId as '@id' FROM UMUserGroup WITH(NOLOCK)
					WHERE groupId = @extGroupId
					FOR XML PATH ('userID'), ROOT('UserList')
					)
	exec UpdateUserPropForQuota @inpXml
END
	SELECT @errorCode AS '@errorCode',
		   @errorString AS '@errorString',
		   (SELECT @extGroupId AS '@groupId',
				   name AS '@externalGroupName'
		   FROM UMGroups WHERE id = @extGroupId
		   FOR XML PATH('entity'), TYPE)
	FOR XML PATH ('App_GenericEntityResponse')
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSExternalGroupOpsReq')
	delete from GxQscripts where name = 'sec_UMDSExternalGroupOpsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSExternalGroupOpsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSExternalGroupOpsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSExternalGroupOpsReq',  '00010008030400010000', 'sec_UMDSExternalGroupOpsReq', '00010008030400010000')
GO

