

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSAssociatedExternalGroupsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSAssociatedExternalGroupsReq.sp,v $ $Id: sec_UMDSAssociatedExternalGroupsReq.sp,v 1.6.304.2 2018/03/15 23:33:55 jiechen Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSAssociatedExternalGroupsReq.sp,v $ $Id: sec_UMDSAssociatedExternalGroupsReq.sp,v 1.22.2.9 2018/12/21 19:23:02 saggarwal Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UMDSAssociatedExternalGroupsReq')
BEGIN
	print '>>> Drop Stored Procedure: sec_UMDSAssociatedExternalGroupsReq <<<'
	drop procedure sec_UMDSAssociatedExternalGroupsReq
END
IF EXISTS (select * from GxQscripts where name='sec_UMDSAssociatedExternalGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSAssociatedExternalGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSAssociatedExternalGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSAssociatedExternalGroupsReq'
GO
print '... Creating Procedure: sec_UMDSAssociatedExternalGroupsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSAssociatedExternalGroupsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
set @errorCode = 0
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
declare @iDoc                   int
declare @xmlReqMsg              nvarchar(256)
declare @xmlReqMsgNode          nvarchar (512)
declare @providerId             int
declare @providerName			nvarchar(2048)
declare @externalGroupId		int = 0
declare @externalGroupName		nvarchar(max)
DECLARE @propertyLevel			INT
declare @xmlstring1 xml
set @xmlstring1 = cast(@xmlstring as xml)
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSAssociatedExternalGroupsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
set @xmlReqMsgNode = @xmlReqMsg + '/provider/shortName'
set @providerId   = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(128) '@id'))
set @providerName = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (domainName nvarchar(2048) '@domainName'))
SET @propertyLevel = ISNULL((SELECT @xmlstring1.value('./EVGui_UMDSAssociatedExternalGroupsReq[1]/@propertyLevel', 'INT')), 30)
--we get either userGroupEntity or externalGroupEntity in the input request
IF (@xmlString1.exist ('EVGui_UMDSAssociatedExternalGroupsReq/externalUserGroup/@userGroupId') <> 0)
		OR (@xmlString1.exist ('EVGui_UMDSAssociatedExternalGroupsReq/externalUserGroup/@userGroupName') <> 0)
BEGIN
	SET @externalGroupId = ISNULL((SELECT @xmlstring1.value('(EVGui_UMDSAssociatedExternalGroupsReq/externalUserGroup/@userGroupId)[1]', 'INT')), 0)
	SET @externalGroupName = ISNULL((SELECT @xmlstring1.value('(EVGui_UMDSAssociatedExternalGroupsReq/externalUserGroup/@userGroupName)[1]', 'NVARCHAR(MAX)')), '')
	IF @externalGroupName <> N''
	BEGIN
		SET @externalGroupName = SUBSTRING(@externalGroupName, CHARINDEX('\', @externalGroupName, 1)+1, LEN(@externalGroupName))
	END
	IF (@externalGroupId = 0 OR @externalGroupId IS NULL)
	BEGIN
		SET @externalGroupId = ISNULL((SELECT TOP 1 id FROM UMGroups
					WHERE name = @externalGroupName AND umdsProviderId in (SELECT id
																			FROM UMDSProviders WITH(NOLOCK)
								  WHERE domainName = SUBSTRING(@externalGroupName, 1, CHARINDEX('\', @externalGroupName, 1)-1))
		), 0)
	END
	ELSE
	BEGIN
		SET @externalGroupName = ISNULL((SELECT TOP 1 name FROM UMGroups WHERE id = @externalGroupId), '')
	END
	SET @providerId = ISNULL((SELECT TOP 1 umdsProviderId FROM UMGroups WITH(NOLOCK)  WHERE id = @externalGroupId), 0)
	SET @providerName = ISNULL((SELECT domainName FROM UMDSProviders WITH(NOLOCK)  WHERE id = @providerId), '')
END
ELSE IF (@xmlString1.exist ('EVGui_UMDSAssociatedExternalGroupsReq/group/@groupId') <> 0)
OR (@xmlString1.exist ('EVGui_UMDSAssociatedExternalGroupsReq/group/@externalGroupName') <> 0)
BEGIN
	SET @externalGroupId = ISNULL((SELECT @xmlstring1.value('(EVGui_UMDSAssociatedExternalGroupsReq/group/@groupId)[1]', 'INT')), 0)
	SET @externalGroupName = ISNULL((SELECT @xmlstring1.value('(EVGui_UMDSAssociatedExternalGroupsReq/group/@externalGroupName)[1]', 'NVARCHAR(MAX)')), '')
	SET @providerId = ISNULL((SELECT @xmlstring1.value('(EVGui_UMDSAssociatedExternalGroupsReq/group/@providerId)[1]', 'INT')), 0)
	IF (@externalGroupId = 0 OR @externalGroupId IS NULL)
	BEGIN
		SET @externalGroupId = ISNULL((SELECT TOP 1 id FROM UMGroups WHERE name = @externalGroupName AND umdsProviderId = @providerId), 0)
	END
	ELSE
	BEGIN
		SET @externalGroupName = ISNULL((SELECT TOP 1 name FROM UMGroups WHERE id = @externalGroupId), '')
		SET @providerId = ISNULL((SELECT TOP 1 umdsProviderId FROM UMGroups WHERE id = @externalGroupId), 0)
	END
	SET @providerName = ISNULL((SELECT domainName FROM UMDSProviders WHERE id = @providerId), '')
END
DECLARE @canViewAll int = 0
EXEC sec_canManageAllUsers @ownerID, @canViewAll OUTPUT
IF @canViewAll = 0
BEGIN
	SET @canViewAll = ISNULL( (SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE [id] = @providerId  AND [ownerId] = @ownerID ), 0)
END
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
IF (dbo.isNewSecurity() = 0)
BEGIN
SELECT	1					as TAG,
		NULL				as Parent,
NULL				as [EVGui_UMDSAssociatedExternalGroupsResp!1],
		NULL				as [hdr!6!time],
		NULL				as [hdr!6!uBrowserID],
		NULL				as [hdr!6!uPipeID],
		NULL				as [hdr!6!uPipeType],
		NULL				as [groups!2!id!hide],
		NULL				as [externalGroup!3!id],
		NULL				as [externalGroup!3!name],
		NULL				as [externalGroup!3!description],
		NULL				as [externalGroup!3!enabled],
		NULL				as [externalGroup!3!email],
		NULL				as [externalGroup!3!enforceFSQuota],
		NULL				as [externalGroup!3!quotaLimitinGB],
		NULL				as [shortName!4!id],
		NULL				as [shortName!4!domainName],
		NULL				as [localGroups!5!id],
		NULL				as [localGroups!5!name]
UNION ALL
-- Header information
SELECT DISTINCT 2, 1, NULL,
	NULL, NULL, NULL, NULL,
	G.Id,
	NULL, NULL, NULL, NULL, NULL,NULL, NULL,
	 NULL, NULL,
	 NULL, NULL
FROM UMDSGroups AS G WITH (NOLOCK), UMDSGroupMaps AS M WITH (NOLOCK)
WHERE umdsProviderId = @providerId
  AND G.id = M.umdsgroupId
  AND (@canViewAll <> 0 OR
	   EXISTS (	SELECT	*
				FROM	UMDSUserGroup UG WITH (NOLOCK)
				WHERE	UG.UserID = @ownerID
				AND UG.groupId = M.umdsgroupId) OR
	   EXISTS ( SELECT	*
				FROM	UMUserGroup UG WITH (NOLOCK)
				WHERE	UG.UserID = @ownerID
						AND UG.groupId = M.umgroupId))
UNION ALL
SELECT DISTINCT 3, 2, NULL,
	NULL, NULL, NULL, NULL,
	G.Id,
	G.id, G.name, G.description, G.enabled, G.email,(select attrVal from UMGroupsProp  with (nolock)  where componentNameId = G.id and attrName like 'Enforce quota' and modified = 0)
	,(select attrVal from UMGroupsProp  with (nolock) where componentNameId = G.id and attrName like 'Quota size' and modified = 0),
	 NULL, NULL,
	 NULL, NULL
FROM UMDSGroups AS G WITH (NOLOCK), UMDSGroupMaps AS M WITH (NOLOCK)
WHERE umdsProviderId = @providerId
  AND G.id = M.umdsgroupId
  AND (@canViewAll <> 0 OR
	   EXISTS (	SELECT	*
				FROM	UMDSUserGroup UG WITH (NOLOCK)
				WHERE	UG.UserID = @ownerID
						AND UG.groupId = M.umdsgroupId) OR
	   EXISTS ( SELECT	*
				FROM	UMUserGroup UG WITH (NOLOCK)
				WHERE	UG.UserID = @ownerID
						AND UG.groupId = M.umgroupId))
UNION ALL
SELECT 4, 3, NULL,
	 NULL, NULL, NULL, NULL,
	 GID, GID, NULL, NULL, NULL, NULL,NULL, NULL,
	 PID , domainName,
	 NULL, NULL
FROM	(SELECT	DISTINCT G.id AS 'GID', P.id AS 'PID', domainName
		FROM UMDSProviders AS P WITH (NOLOCK), UMDSGroups as G WITH (NOLOCK), UMDSGroupMaps As M WITH (NOLOCK)
		WHERE P.id = @providerId
		  AND G.UMDSProviderId = P.id
		  AND G.id = M.UMDSgroupId
		  AND (@canViewAll <> 0 OR
		  EXISTS (	SELECT	*
					FROM	UMDSUserGroup UG WITH (NOLOCK)
					WHERE	UG.UserID = @ownerID
					AND UG.groupId = M.umdsgroupId) OR
		  EXISTS ( SELECT	*
					FROM	UMUserGroup UG WITH (NOLOCK)
					WHERE	UG.UserID = @ownerID
					AND UG.groupId = M.umgroupId))) AS T
UNION ALL
SELECT 5, 2, NULL,
     NULL, NULL, NULL, NULL,
	 G.id,
     NULL, NULL, NULL, NULL, NULL,NULL, NULL,
	 NULL, NULL,
	M.umGroupId, lg.name
FROM UMDSProviders AS P WITH (NOLOCK), UMDSGroups as G WITH (NOLOCK), UMDSGroupMaps As M WITH (NOLOCK), UMGroups as lg WITH (NOLOCK)
WHERE P.id = @providerId
  AND G.umdsProviderId = P.id
  AND G.id = M.umdsgroupId
  AND lg.id = M.umgroupId
  AND (@canViewAll <> 0 OR
	   EXISTS (	SELECT	*
				FROM	UMDSUserGroup UG WITH (NOLOCK)
				WHERE	UG.UserID = @ownerID
						AND UG.groupId = M.umdsgroupId) OR
	   EXISTS ( SELECT	*
				FROM	UMUserGroup UG WITH (NOLOCK)
				WHERE	UG.UserID = @ownerID
						AND UG.groupId = M.umgroupId))
ORDER BY [groups!2!id!hide], [externalGroup!3!id], [shortName!4!id], [localGroups!5!id]
FOR XML Explicit
END
ELSE
BEGIN
	DECLARE @outputXML XML
	CREATE TABLE #userGroupIdTbl (userGroupId INT)
	EXEC sec_getUserGroupsForThisUser '#userGroupIdTbl', @ownerId, 0, 0
	IF @propertyLevel = 1
	BEGIN
		SET @outputXML = (SELECT
							(SELECT
									(SELECT UMG.id AS '@id',
											UMG.name AS '@name',
											(SELECT P.id AS '@id',
													P.domainName AS '@domainName'
											FOR XML PATH ('shortName'), TYPE)
									FOR XML PATH ('externalGroup'), TYPE)
								FOR XML PATH ('groups'),TYPE) FROM UMGroups UMG INNER JOIN UMDSProviders P (NOLOCK) ON UMG.umdsProviderId = P.id
										WHERE umdsProviderId = @providerId AND groupFlags<>0 AND UMG.id IN (SELECT userGroupId FROM #userGroupIdTbl ) AND
										(UMG.id = @externalGroupId OR @externalGroupId = 0 OR @externalGroupId IS NULL)
							FOR XML PATH(''), ROOT ('EVGui_UMDSAssociatedExternalGroupsResp'))
	END
	ELSE IF @propertyLevel = 10
	BEGIN
		SET @outputXML = (SELECT
							(SELECT
									(SELECT UMG.id AS '@id',
											UMG.name AS '@name',
											(UMG.groupFlags & 1 ) AS '@enabled',
											UMG.description AS '@description',
											UMG.email AS '@email',
										(SELECT P.id AS '@id',
												P.domainName AS '@domainName'
										FOR XML PATH ('shortName'), TYPE)
									FOR XML PATH ('externalGroup'), TYPE)
								FOR XML PATH ('groups'),TYPE) FROM UMGroups UMG INNER JOIN UMDSProviders P (NOLOCK) ON UMG.umdsProviderId = P.id
										WHERE umdsProviderId = @providerId AND groupFlags<>0 AND UMG.id IN (SELECT userGroupId FROM #userGroupIdTbl ) AND
										(UMG.id = @externalGroupId OR @externalGroupId = 0 OR @externalGroupId IS NULL)
							FOR XML PATH(''), ROOT ('EVGui_UMDSAssociatedExternalGroupsResp'))
	END
	ELSE
	BEGIN
		DECLARE @outputTable TABLE (groups XML)
		DECLARE @localGroupsAssociated TABLE (externalGroupId INT, localGroupId INT)
		INSERT INTO @localGroupsAssociated
			SELECT umdsGroupId, umGroupID
			FROM UMDSGroupMaps (NOLOCK) INNER JOIN UMGroups (NOLOCK)
			ON UMGroups.id = UMDSGroupMaps.umdsgroupId
			WHERE umdsGroupID IN (SELECT * FROM #userGroupIdTbl ) AND
				  umgroupId IN (SELECT * FROM #userGroupIdTbl) AND
			  	umdsProviderID = @providerId AND
			  	(UMGroups.id = @externalGroupId OR @externalGroupId = 0 OR @externalGroupId IS NULL)
		DECLARE @enforeceFSQuota varchar(256)
		DECLARE @quotaLimitInGB INT
		DECLARE @enforceEdgeDriveQuota int
		DECLARE @edgeDriveQuotaLimitInGB int
		DECLARE @tempUMDSGroupId INT
		DECLARE UMDSAssociatedExternalGroupsReqCur CURSOR STATIC FOR
		SELECT DISTINCT id FROM UMGroups (NOLOCK) WHERE umdsProviderId = @providerId AND id IN (SELECT * FROM #userGroupIdTbl ) and groupFlags<>0
														AND (UMGroups.id = @externalGroupId OR @externalGroupId = 0 OR @externalGroupId IS NULL)
		OPEN UMDSAssociatedExternalGroupsReqCur
		FETCH NEXT FROM UMDSAssociatedExternalGroupsReqCur INTO @tempUMDSGroupId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @groupsXML XML
			DECLARE @securityAssociations XML
			DECLARE @securityOnGroup XML
			EXEC sec_getSecurityForUserAndUserGroup 0, @tempUMDSGroupId, @ownerID, @securityAssociations OUTPUT
EXEC sec_getsecurityforentity @ownerID, @securityOnGroup OUTPUT, 15, @tempUMDSGroupId				--on user group
SET @enforeceFSQuota = (select attrVal from UMGroupsProp  with (nolock)  where componentNameId = @tempUMDSGroupId and attrName like 'Enforce quota' and modified = 0)
SET @quotaLimitInGB  =(select attrVal from UMGroupsProp  with (nolock) where componentNameId = @tempUMDSGroupId and attrName like 'Quota size' and modified = 0)
SET @enforceEdgeDriveQuota = (select attrVal from UMGroupsProp  with (nolock)  where componentNameId = @tempUMDSGroupId and attrName like 'Enforce Edge Drive Quota' and modified = 0)
SET @edgeDriveQuotaLimitInGB  =(select attrVal from UMGroupsProp  with (nolock) where componentNameId = @tempUMDSGroupId and attrName like 'Edge Drive Quota Size' and modified = 0)
		SET @groupsXML = (SELECT
								(SELECT GM.localGroupId AS '@id',
										G.name AS '@name'
								FROM @localGroupsAssociated GM INNER JOIN UMGroups G (NOLOCK)
								ON GM.localGroupId = G.id
								WHERE GM.externalGroupId = @tempUMDSGroupId
								FOR XML PATH ('localGroups'),TYPE),
								(SELECT G.id AS '@id',
										G.name AS '@name',
										(G.groupFlags & 1 ) AS '@enabled',
										G.description AS '@description',
										G.email AS '@email',
										@enforeceFSQuota as '@enforceFSQuota',
										@quotaLimitInGB as '@quotaLimitInGB',
										@enforceEdgeDriveQuota as '@enforceEdgeDriveQuota',
										@edgeDriveQuotaLimitInGB as '@edgeDriveQuotaLimitInGB',
										(SELECT P.id AS '@id',
												P.domainName AS '@domainName'
										FOR XML PATH ('shortName'), TYPE),
										(SELECT (SELECT @securityAssociations.query('App_SecurityAssociationForUserOrGroupList/associations') FOR XML PATH(''),TYPE),
											(SELECT @securityAssociations.query('App_SecurityAssociationForUserOrGroupList/inheritedAssociations') FOR XML PATH(''),TYPE)
										FOR XML PATH ('securityAssociations'), TYPE),
										(SELECT @securityOnGroup
										FOR XML PATH ('groupSecurity'), TYPE),
										(SELECT U.id AS '@userId',
												U.login AS '@userName',
13 AS '@_type_'
										FROM UMUserGroup UG (NOLOCK) INNER JOIN UMUsers U (NOLOCK)
										ON UG.userID = U.ID
WHERE UG.groupId = G.id AND P.serviceType = 5
										FOR XML PATH ('associatedUsers'), TYPE),
										(SELECT
                                         CR.keyName as '@keyName',
                                         CR.type as '@type',
                                         (CASE CR.type WHEN 'ENCRYPTED' THEN '********' ELSE CR.value END) as '@value',
                                         CR.relativepath as '@relativepath',
                                         --CR.deleted as '@deleted',
                                         CR.enabled as '@enabled',
                                         ISNULL(AdvEx.details.value('(/App_AdvanceSettingProps/@comment)[1]','NVARCHAR(MAX)'),N'') as '@comment',
                                         NULL as '@isInheritedFromClientGroup',
                                         (SELECT
                                            CASE CR.sourceEntityType WHEN 0 THEN NULL ELSE CR.sourceEntityType END AS '@_type_',
                                            CASE CR.sourceEntityType WHEN 15 THEN CR.sourceId ELSE NULL END AS '@userGroupId',
                                            CASE CR.sourceEntityType WHEN 13 THEN  CR.sourceId ELSE NULL END AS '@userId'
                                         FOR XML PATH('sourceEntity'),TYPE)
                                         FROM APP_AdvanceSettings as CR WITH(NOLOCK)
                                         LEFT OUTER JOIN APP_AdvanceSettingsEx AdvEx WITH(NOLOCK)
                                         ON CR.id = AdvEx.keyId
                                         WHERE CR.entityId =  G.id AND CR.entityType = 15 --USER_ENTITY
                                         and CR.deleted = 0
                                         FOR XML PATH('additionalSettings'),TYPE)
								FROM UMGroups G (NOLOCK) INNER JOIN UMDSProviders P (NOLOCK)
								ON G.umdsProviderId = P.id
								WHERE G.id = @tempUMDSGroupId and G.groupFlags<>0
								FOR XML PATH ('externalGroup'), TYPE)
							FOR XML PATH ('groups'))
		INSERT INTO @outputTable
			VALUES (@groupsXML)
		FETCH NEXT FROM UMDSAssociatedExternalGroupsReqCur INTO @tempUMDSGroupId
		END
		CLOSE UMDSAssociatedExternalGroupsReqCur
		DEALLOCATE UMDSAssociatedExternalGroupsReqCur
		IF EXISTS (SELECT * FROM @outputTable )
			SET @outputXML = (SELECT groups.query('.')
							FROM @outputTable
							FOR XML PATH(''), ROOT ('EVGui_UMDSAssociatedExternalGroupsResp'))
		ELSE
		BEGIN
			SET @outputXML = '<EVGui_UMDSAssociatedExternalGroupsResp/>'
		END
	END
	IF(@outputXML is NULL)
		SET @outputXML = '<EVGui_UMDSAssociatedExternalGroupsResp/>'
	SELECT @outputXML
END
EXEC sp_xml_removedocument @idoc
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSAssociatedExternalGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSAssociatedExternalGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSAssociatedExternalGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSAssociatedExternalGroupsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSAssociatedExternalGroupsReq',  '00010006030400020000', 'sec_UMDSAssociatedExternalGroupsReq', '00010006030400020000')
GO

