

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_UMDSAllExternalGroupsReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_UMDSAllExternalGroupsReq.sp,v $ $Id: sec_UMDSAllExternalGroupsReq.sp,v 1.5.304.1 2018/03/15 23:33:36 jiechen Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/CTE/Modules/Source/DbLib/sp/sec_UMDSAllExternalGroupsReq.sp,v $ $Id: sec_UMDSAllExternalGroupsReq.sp,v 1.5.58.1 2017/02/10 20:53:27 sjohnson Exp $";
-- =============================================
-- Author:		Stuart Katz
-- Create date: 09/15/2006
-- Description:	Return the list of AD Providers
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_UMDSAllExternalGroupsReq <<<'

IF EXISTS (select * from sysobjects where name='sec_UMDSAllExternalGroupsReq')
	drop procedure sec_UMDSAllExternalGroupsReq
IF EXISTS (select * from GxQscripts where name='sec_UMDSAllExternalGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSAllExternalGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSAllExternalGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSAllExternalGroupsReq'
GO
print '... Creating Procedure: sec_UMDSAllExternalGroupsReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UMDSAllExternalGroupsReq
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ownerID integer,
  @locale_in integer,
  @xmlString NTEXT,
  @BrowserIDParam int = 0,
  @PipeIDParam int = 0,
  @PipeTypeParam int = 0
AS
SET NOCOUNT ON
declare @errorString			nvarchar(1024)
DECLARE @errorCode INT
set @errorCode = 0
-------------------------------------
-- Fetch Input Parameters from XML --
-------------------------------------
declare @iDoc                   int
declare @xmlReqMsg              nvarchar(256)
declare @xmlReqMsgNode          nvarchar (512)
declare @providerId             int
declare @providerName           nvarchar(2048)
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @xmlReqMsg = '/EVGui_UMDSAllExternalGroupsReq'							-- THIS TO BE IFDEF'ed FOR QINETIX/QNET
set @xmlReqMsgNode = @xmlReqMsg + '/provider/shortName'
set @providerId   = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (id nvarchar(128) '@id'))
set @providerName = (select * from OPENXML(@iDoc, @xmlReqMsgNode, 0) WITH (domainName nvarchar(2048) '@domainName'))
--------------------------
-- HERE IS THE RESPONSE --
--------------------------
IF (dbo.isNewSecurity() = 0)			--Do we need to do security checks on this ?
BEGIN
SELECT  1                   as TAG,
        NULL                as Parent,
NULL                as [EVGui_UMDSAllExternalGroupsResp!1],
		NULL				as [hdr!4!time],
		NULL				as [hdr!4!uBrowserID],
		NULL				as [hdr!4!uPipeID],
		NULL				as [hdr!4!uPipeType],
        NULL                as [groups!2!id],
        NULL                as [groups!2!name],
        NULL                as [groups!2!description],
        NULL                as [groups!2!enabled],
        NULL                as [shortName!3!id],
        NULL                as [shortName!3!domainName]
UNION ALL
-- Header information
SELECT DISTINCT 2, 1, NULL,
	 NULL, NULL, NULL, NULL,
     G.id, G.name, G.description, G.enabled,
     NULL, NULL
FROM UMDSGroups AS G
WHERE umdsProviderId = @providerId
UNION ALL
SELECT 3, 2, NULL,
	 NULL, NULL, NULL, NULL,
     G.id, NULL, NULL, NULL,
     P.id , domainName
FROM UMDSProviders AS P, UMDSGroups as G
WHERE P.id = @providerId
  AND G.umdsProviderId = P.id
ORDER BY [groups!2!id]
FOR XML Explicit
END
ELSE
BEGIN
	IF OBJECT_ID ('tempdb.dbo.#externalUserGroupIdTbl') IS NOT NULL
		DROP TABLE #externalUserGroupIdTbl
	CREATE TABLE #externalUserGroupIdTbl (userGroupId INT)
	EXEC sec_getUserGroupsForThisUser '#externalUserGroupIdTbl', @ownerId, 0, 2
	SELECT  1                   as TAG,
        NULL                as Parent,
NULL                as [EVGui_UMDSAllExternalGroupsResp!1],
		NULL				as [hdr!4!time],
		NULL				as [hdr!4!uBrowserID],
		NULL				as [hdr!4!uPipeID],
		NULL				as [hdr!4!uPipeType],
        NULL                as [groups!2!id],
        NULL                as [groups!2!name],
        NULL                as [groups!2!description],
        NULL                as [groups!2!enabled],
        NULL                as [shortName!3!id],
        NULL                as [shortName!3!domainName]
	UNION ALL
	SELECT DISTINCT 2, 1, NULL,
			NULL, NULL, NULL, NULL,
			G.id, G.name, G.description, G.enabled,
			NULL, NULL
	FROM UMDSGroups AS G
	WHERE umdsProviderId = @providerId
		  AND G.id IN (SELECT * FROM #externalUserGroupIdTbl)
	UNION ALL
	SELECT 3, 2, NULL,
		 NULL, NULL, NULL, NULL,
		 G.id, NULL, NULL, NULL,
		 P.id , domainName
	FROM UMDSProviders AS P, UMDSGroups as G
	WHERE P.id = @providerId
	  AND G.umdsProviderId = P.id
	  AND G.id IN (SELECT * FROM #externalUserGroupIdTbl)
	ORDER BY [groups!2!id]
	FOR XML Explicit
	IF OBJECT_ID ('tempdb.dbo.#externalUserGroupIdTbl') IS NOT NULL
		DROP TABLE #externalUserGroupIdTbl
END
EXEC sp_xml_removedocument @idoc
GO

IF EXISTS (select * from GxQscripts where name = 'sec_UMDSAllExternalGroupsReq')
	delete from GxQscripts where name = 'sec_UMDSAllExternalGroupsReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UMDSAllExternalGroupsReq')
	delete from GXDBVersions where aliasname = 'sec_UMDSAllExternalGroupsReq'
GO

insert into GXDBVersions values(2, 'sec_UMDSAllExternalGroupsReq',  '00010005030400010000', 'sec_UMDSAllExternalGroupsReq', '00010005030400010000')
GO

