

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_SyncUsersFromRemoteCommcell.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_SyncUsersFromRemoteCommcell')
BEGIN
	print '>>> Drop Stored Procedure: sec_SyncUsersFromRemoteCommcell <<<'
	drop procedure sec_SyncUsersFromRemoteCommcell
END
IF EXISTS (select * from GxQscripts where name='sec_SyncUsersFromRemoteCommcell')
	delete from GxQscripts where name = 'sec_SyncUsersFromRemoteCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_SyncUsersFromRemoteCommcell')
	delete from GXDBVersions where aliasname = 'sec_SyncUsersFromRemoteCommcell'
GO
print '... Creating Procedure: sec_SyncUsersFromRemoteCommcell'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_SyncUsersFromRemoteCommcell
  @i_usersXml XML,
  @commcellGUID nvarchar(255),
  @operationType INT = 2,
  @requestType INT = 0,
  @errorMessage nvarchar(max) = ''
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
if exists (select 1 from INFORMATION_SCHEMA.Tables where table_name='#temp_UmUsers')
    DROP Table #temp_UMUsers
Create Table #temp_UMUSERS
(
id int IDENTITY(1,1) PRIMARY KEY,
name nvarchar(255),
description ntext,
login nvarchar(255),
password nvarchar(400),
email nvarchar(255),
datePasswordSet int,
dateExpires int,
policy int,
enabled int,
flags int,
modified int,
pVer int,
Pager varchar(255),
lastLogInTime int,
credSetTime int,
umDSproviderId int,
userGuid nvarchar(256),
origUserGuid nvarchar(256),
origCCId int,
salt nvarchar(400)
)
DECLARE @userDetails Xml
DECLARE @temp_Password nvarchar(400)
DECLARE @temp_desc varchar(40)
DECLARE @remoteCommcellId int = 0
DECLARE @remoteCommcellName nvarchar(MAX)=''
DECLARE @errorStr nvarchar(max)=''
DECLARE @statusCode INT = 0
DECLARE @xmlStatusCode INT =1
DECLARE @localeId INT =0
DECLARE @errorEntityTypeName nvarchar(MAX) = (SELECT entityTypeNAme from App_entity where entityType=1)
BEGIN TRY
SELECT distinct @remoteCommcellId = id,@remoteCommcellName=aliasName from App_commcell where csGUID = @commcellGUID
IF(LEN(@errorMessage) > 0)
BEGIN
     SET @xmlStatusCode=-1
	 SET @errorStr = @errorMessage
	GOTO PROC_EXIT
END
DECLARE @rulesTbl table(redirectRule nvarchar(255),ruleType int)
DECLARE @nowTime            INT
DECLARE @MergeSameGroupName INT = ISNULL((select value from GXGlobalParam where name='bMergeGroupMultiCommcell' and modified=0 ),1)
DECLARE @newlyCreatedCompanies table(companyName nvarchar(255))
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
SET @temp_Password = newId()
SET @userDetails =@i_usersXml
SET @temp_desc = ''
SET @userDetails = (SELECT REPLACE(CAST(@userDetails as nvarchar(max)),'App_GetUserSpaceforRouterCSResp','Api_GetUserSpaceforRouterCSResp'))
IF(@userDetails.exist('Api_GetUserSpaceforRouterCSResp/*') = 0)
BEGIN
     SET @xmlStatusCode=-1
	 SET @errorStr = 'No entities present to sync.'
	GOTO PROC_EXIT
END
CREATE INDEX temp_UMUsers_index
ON #temp_UMUsers (login,origCCId)
DELETE FROM APP_componentPRop where componentId=@remotecommcellId and componentType=1051
INSERT INTO #temp_UMUsers(name,description,login,email,password, userGuid,origCCId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt)
       SELECT U.value('@fullName[1]','nvarchar(255)') AS name,
              @temp_desc As description,
				U.value('(userEntity/@userName)[1]','nvarchar(255)') As login,
				U.value('@email[1]','nvarchar(255)') As email,
				@temp_Password as password,
				U.value('(userEntity/@userGUID)[1]','nvarchar(256)') As userGuid,
				@remoteCommcellId As origCCId
				,0 AS datePasswordSet
                  ,0 AS dateExpires
                  ,0 AS policy
                  ,ISNULL(U.value('@enableUser[1]','nvarchar(255)'),0) AS enabled
                  ,1 AS flags
                  ,0 AS modified
                  ,0 AS pVer
                  ,0 AS Pager
                  ,0 AS lastLogInTime
                  ,0 AS credSetTime
                  ,0 AS umDSproviderId
                  ,0 AS origUserGuid
                  ,0 AS salt
from @userDetails.nodes('//Api_GetUserSpaceforRouterCSResp/users') users (U) where U.value('(userEntity/@userName)[1]','nvarchar(255)') <> ('_+_MulticommcellPublicUser_')
INSERT INTO @newlyCreatedCompanies Select c.value('@val','nvarchar(255)') from @userDetails.nodes('//Api_GetUserSpaceforRouterCSResp/newCompanies') companies (c)
DECLARE @isIDPServiceCommcell INT = 0
IF EXISTS (SELECT 1 from APP_ComponentProp where  componentType=1048 and componentId = @remoteCommcellId and propertyTypeId = 2 and  longVal=1 and longlongVal=1)
   SET @isIDPServiceCommcell = 1
IF (@operationType = 1) --Overwrite / Merge query
BEGIN
MERGE UMUsersServiceCommcell AS TARGET
            USING #temp_UMUSERS AS SOURCE
            ON (TARGET.login = SOURCE.login AND TARGET.origCCId=@remoteCommcellId AND SOURCE.login is not null and source.login <> '' and target.login is not null and target.login <> '')
            WHEN MATCHED
            THEN
            UPDATE SET TARGET.login = SOURCE.login,
            TARGET.email = SOURCE.email,
            TARGET.name = SOURCE.name
            WHEN NOT MATCHED BY TARGET THEN
            INSERT (name,description,login,email,password, userGuid,origCCId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt)
            VALUES (SOURCE.name,SOURCE.description,SOURCE.login,SOURCE.email,SOURCE.password,SOURCE.userGuid,@remoteCommcellId,SOURCE.datePasswordSet,SOURCE.dateExpires,SOURCE.policy,SOURCE.enabled,SOURCE.flags,SOURCE.modified,SOURCE.pVer,SOURCE.Pager,SOURCE.lastLogInTime,SOURCE.credSetTime,SOURCE.umDSproviderId,SOURCE.origUserGuid,SOURCE.salt)
            WHEN NOT MATCHED BY SOURCE AND TARGET.origCCId=@remoteCommcellId THEN
            DELETE;
	INSERT into @rulesTbl
SELECT R.ref.query('.').value('(/rules/@val)[1]','nvarchar(255)'),1 from @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/redirectRules/rules') R(ref)
	UNION
SELECT R.ref.query('.').value('(/domains/@val)[1]','nvarchar(255)'),2 from @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/redirectRules/domains') R(ref)
DELETE from APP_ComponentProp where componentType in  (1047) and componentId = @remoteCommcellId and propertyTypeId in (1,2)
	INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longval,longlongVal,stringVal,created,modified)
(SELECT  1047,@remoteCommcellId,ruleType,0,0,0,redirectRule, @nowTime, 0 from @rulesTbl)
END
ELSE IF (@operationType = 2)
BEGIN
DELETE tempTbl from #temp_UMUSERS tempTbl INNER JOIN UMUsersServiceCommcell USC ON tempTbl.login = USC.login AND tempTbl.origCCId = USC.origCCId WHERE USC.origCCId = @remoteCommcellId
INSERT INTO UMUsersServiceCommcell (name,description,login,email,password, userGuid,origCCId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt)
SELECT name,description,login,email,password,userGuid,@remoteCommcellId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt from #temp_UMUSERS
END
IF(@isIDPServiceCommcell=1)
BEGIN
SET @errorEntityTypeName = (SELECT CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END
    FROM APP_Entity (NOLOCK)
WHERE entityType = 120)
----------------------------Roles Sync Begin---------------------
  DECLARE @RoleTBl TABLE (remoteCSRoleId int,localRoleId INT,roleNAme nvarchar(MAX),alreadyExists INT DEFAULT 0)
    INSERT INTO @RoleTbl(remoteCSRoleId,roleNAme)
    SELECT ref.value('@roleId','INT'),
            ref.value('@roleName','NVARCHAR(MAX)')
    FROM @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/roles/role')R (ref)
	IF EXISTS (SELECT 1 from @RoleTBL)
	BEGIN
	 if object_id('tempdb.dbo.#categoryPermissionAssociationFromRemoteCS') is not null
        DROP TABLE #categoryPermissionAssociationFromRemoteCS
       CREATE TABLE #categoryPermissionAssociationFromRemoteCS
    (
        roleId INT,
        [categoryId] INT,
        [permissionId] INT
    )
        INSERT INTO #categoryPermissionAssociationFromRemoteCS (roleId,categoryId,permissionId)
        SELECT ISNULL(UG.value('(role/@roleId)[1]', 'INT'), 0),
        ISNULL(R.value('(@categoryId)[1]', 'INT'), 0)   ,
            ISNULL(R.value('(@permissionId)[1]', 'INT'), 0)
        FROM @userDetails .nodes('Api_GetUserSpaceforRouterCSResp/roles') AS Input(UG)
        CROSS APPLY
        Input.UG.nodes('categoryPermission/categoriesPermissionList') AS Role(R)
		JOIN @RoleTBl on remoteCSRoleId=ISNULL(UG.value('(role/@roleId)[1]', 'INT'), 0)
UPDATE roleTbl
SET roleTbl.roleName=@remoteCommcellName+'_'+roleTbl.roleName
FROM
(SELECT DISTINCT roleName
FROM
((SELECT DISTINCT TBL.roleName as roleName ,perm.permissionId
FROM @RoleTBl TBL
JOIN UMRoles R ON TBL.roleNAme=R.name
JOIN #categoryPermissionAssociationFromRemoteCS perm on TBL.remoteCSRoleId =Perm.roleId
EXCEPT
SELECT name,permissionId
FROM UMRoles  JOIN UMRolesWithPermissionsExpanded ON id=roleId)
UNION
(SELECT name as roleName,permissionId
FROM UMRoles  JOIN UMRolesWithPermissionsExpanded ON id=roleId JOIN @RoleTBl TBL ON TBL.roleNAme=name
EXCEPT
SELECT DISTINCT TBL.roleName ,perm.permissionId
FROM @RoleTBl TBL JOIN #categoryPermissionAssociationFromRemoteCS perm on TBL.remoteCSRoleId =Perm.roleId)) as TBL) TBL1 JOIN @RoleTBl roleTbl on  roleTbl.roleNAme= TBL1.roleNAme
UPDATE TBL
set alreadyExists=1,localRoleId=id
FROM @RoleTBl TBL JOIN UMRoles on name=roleName
INSERT INTO UMRoles (commcellId,name,description,disabled,isPrivate,flags,ownerId,created,modified,GUID,xmlProperties,capabilitiesBitMask,permissionsString)
 SELECT DISTINCT @remoteCommcellId,roleName,'Sync from remote CS',0,1,1,-1,1437163696,0,NEWID(),'',0,''
FROM @RoleTbl LEFT JOIN UMRoles ON name=roleName
 WHERE name is NULL
 UPDATE TBL
set localRoleId=id
FROM @RoleTBl TBL JOIN UMRoles ON
       name=roleName
  DELETE TBL
  FROM #categoryPermissionAssociationFromRemoteCS TBL JOIN @RoleTBl role ON   TBL.roleId=Role.remoteCSRoleId and alreadyExists=1
        UPDATE TBL
        set TBL.roleId=localRoleId
        FROM #categoryPermissionAssociationFromRemoteCS TBL JOIN @RoleTBl ON remoteCSRoleId=TBL.roleId
	    DELETE FROM UMRolesPermissions where roleID in (SELECT roleId from #categoryPermissionAssociationFromRemoteCS)
        DELETE FROM UMRolesWithPermissionsExpanded where roleId in (SELECT roleId from #categoryPermissionAssociationFromRemoteCS)
	    INSERT INTO UMRolesPermissions( roleId,hierarchyLevel,categoryId,permissionId,excludeCategory,excludePermission)
        SELECT roleId, 122,categoryId, permissionId,0,0 FROM #categoryPermissionAssociationFromRemoteCS
		INSERT INTO UMRolesWithPermissionsExpanded( roleId,categoryId,permissionId)
        SELECT roleId,categoryId, permissionId FROM #categoryPermissionAssociationFromRemoteCS
	END
----------------------------Roles Sync END ---------------------
------------------UMDSproviders Sync BEGIN ------------------------------------
SET @errorEntityTypeName = (SELECT CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END
    FROM APP_Entity (NOLOCK)
WHERE entityType = 61)
DECLARE @providerTbl TABLE (
		alreadyExists int DEFAULT 0,
		remoteCSPRoviderId int, localproviderId int,
		domainName nvarchar(510),
		hostName nvarchar(MAX),
		description     nvarchar(MAX) DEFAULT '',
    login           nvarchar(510),
    password        nvarchar(800),
    trustedHostUser nvarchar(10),
    trustedHostPW   nvarchar(10),
    flags           integer,
    enabled         integer,
    serviceType     integer,
    modified        int,
    dnsRoot         nvarchar(510),
    dnsRootStatus   integer,
    useSecureLdap   integer,
    origCCId        integer     DEFAULT     2,
    GUID            uniqueidentifier ROWGUIDCOL,
    port            integer         DEFAULT         0,
    resourceId      integer         DEFAULT         0   ,
    checkTime       int          DEFAULT      0,
    ownerId         integer         DEFAULT         1,
    ownerCompany    integer         DEFAULT         0
)
INSERT INTO @providerTBL(remoteCSPRoviderId,domainName,hostName,login,password,trustedHostUser,trustedHostPW,flags,enabled,serviceType,modified,dnsRoot,dnsRootStatus,useSecureLdap,origCCId,GUID,port,resourceId,checkTime,ownerId,ownerCompany)
SELECT P.value('(shortName/@id)[1]','int'),P.value('(shortName/@domainName)[1]','nvarchar(MAX)'),
	ISNULL(P.value('(@connectName)[1]','nvarchar(MAX)'),''),ISNULL(P.value('(@login)[1]','nvarchar(MAX)'),''),
	ISNULL(P.value('(@password)[1]','nvarchar(MAX)'),''),
	'','',
	ISNULL(P.value('(@flags)[1]','int'),0),
	ISNULL(P.value('(@enabled)[1]','int'),0),
	ISNULL(P.value('(@serviceType)[1]','int'),0),
	0,'','',
	ISNULL(P.value('(@useSecureLdap)[1]','int'),0),@remoteCommcellId,NEWID(),ISNULL(P.value('(@port)[1]','int'),0),0,86400,0
	,ISNULL(P.value('(@ownerCompanyId)[1]','int'),0)
FROM @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/providers') prov(P)
DECLARE @userCredsXML XML = (SELECT T2.Loc.value('(@userCreds)[1]','nvarchar(MAX)')
						FROM   @userDetails.nodes('/Api_GetUserSpaceforRouterCSResp') as T2(Loc) )
DECLARE @userCredsTable TABLE (remoteCSuserId int,localUSerId int,password Nvarchar(MAX),salt Nvarchar(MAX))
INSERT INTO @userCredsTable (remoteCSuserId,password,salt)
SELECT U.cred.value('(@userId)[1]','int'),U.cred.value('(@password)[1]','nvarchar(max)'),U.cred.value('(@salt)[1]','nvarchar(max)')
FROM @userCredsXML.nodes('/App_UserCred') as U(cred)
IF OBJECT_ID('tempdb.dbo.#temp_UMUSERSCreds') IS NOT NULL
    DROP TABLE #temp_UMUSERSCreds
 Create Table #temp_UMUSERSCreds
(
remoteCSUserId int,
localCsId int,
name nvarchar(255),
description ntext,
login nvarchar(255),
password nvarchar(400),
email nvarchar(255),
datePasswordSet int,
dateExpires int,
policy int,
enabled int,
flags int,
modified int,
pVer int,
Pager varchar(255),
lastLogInTime int,
credSetTime int,
umDSproviderId int,
userGuid nvarchar(256),
origUserGuid nvarchar(256),
origCCId int,
salt nvarchar(400),
alreadyExists int DEFAULT 0
)
IF EXISTS (SELECT 1 from @userCredsTable)
BEGIN
INSERT INTO #temp_UMUSERSCreds(remoteCSUserId, name,description,login,email,password, userGuid,origCCId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt)
  SELECT      U.value('(userEntity/@userId)[1]','int') as id,
	    U.value('@fullName[1]','nvarchar(255)') AS name,
              '' As description,
				U.value('(userEntity/@userName)[1]','nvarchar(255)') As login,
				U.value('@email[1]','nvarchar(255)') As email,
				'',
				U.value('(userEntity/@userGUID)[1]','nvarchar(256)') As userGuid,
				@remoteCommcellId As origCCId
				,0 AS datePasswordSet
                  ,0 AS dateExpires
                  ,0 AS policy
                  ,ISNULL(U.value('@enableUser[1]','nvarchar(255)'),0) AS enabled
                  ,1 AS flags
                  ,0 AS modified
                  ,0 AS pVer
                  ,0 AS Pager
                  ,0 AS lastLogInTime
                  ,0 AS credSetTime
                  ,0 AS umDSproviderId
                  ,0 AS origUserGuid
                  ,0 AS salt
			from @userDetails.nodes('//Api_GetUserSpaceforRouterCSResp/users') users (U) where U.value('(userEntity/@userId)[1]','int')>1
END
DECLARE @tempThirdPartyTable TABLE
(
appKey          nvarchar(MAX),
appType         integer,
appName         NVARCHAR(MAX),
appToken        NVARCHAR(MAX),
appSecret       NVARCHAR(MAX),
appDescription  NVARCHAR(MAX),
ownerId         integer,
isEnabled       integer,
appDisplayName NVARCHAR(MAX),
isCloud        integer,
flags           integer,
companyId       integer,
redirectRulesPresent integer,
attributeMappingPresent integer,
umdsproviderIdWrapper integer,
props xml,
sameSmtpPresent  INT DEFAULT 0,
existingAppName NVARCHAR(MAX) ,
localCSAppId    INT DEFAULT 0,
sameCompany     INT DEFAULT 0,
localCSAppName   nvarchar(MAX)
)
IF @userDetails.exist('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps/@appName') =1
BEGIN
 DECLARE @propXMLValueTable TABLE(appName nvarchar(MAX),nameValue nvarchar(MAX),keyvalue nvarchar(MAX))
INSERT INTO @propXMLValueTable
SELECT
ref.value('@appName' , 'nvarchar(255)'),
r.value('(@name)' ,'nvarchar(max)'),r.value('(@value)' ,'nvarchar(max)')
FROM    @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps') R ( ref )
		JOIN @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps/props/nameValues') a (r)
		ON ref.value('@appName','nvarchar(255)')=r.value('../../@appName','nvarchar(255)')
INSERT INTO @tempThirdPartyTable(ownerId,appType , appKey , appName , appToken , appSecret, appDescription , isEnabled ,appDisplayName,isCloud,flags,companyId,umdsproviderIdWrapper, redirectRulesPresent,attributeMappingPresent)
SELECT  ISNULL(ref.value('@ownerId', 'INT'),0)                                      					AS agent1,
2                                  						AS agent2,
        ISNULL(ref.value('@appKey', 'nvarchar(256)'),'')                            					AS agent3,
        ISNULL(ref.value('@appName', 'nvarchar(255)'),'')                           					AS agent4,
        ISNULL(ref.value('@appToken', 'nvarchar(255)'),'')                          					AS agent5,
        ISNULL(ref.value('@appSecret', 'nvarchar(255)'),'')                         					AS agent6,
        ISNULL(ref.value('@appDescription', 'nvarchar(255)'),'')                    					AS agent7,
	    ISNULL(ref.value('@isEnabled', 'int'), 0)  														AS agent8,
        ISNULL(ref.value('@appDisplayName', 'nvarchar(255)'), '')                   					AS agent9,
        ISNULL(CASE ref.value('@isCloudApp', 'int') WHEN '1' THEN 1 ELSE 0 END , 0) 					AS agent10,
ISNULL(ref.value('@flags', 'INT') | 4,0)		AS agent11,
        ISNULL(ref.value('@createAsCompanyId', 'INT'),0)                            					AS agent12,
		ISNULL(ref.value('@umdsWrapperId', 'INT'),0)   													AS agent13,
		ISNULL(ref.exist('associations'),0)                                         					AS agent15,
        ISNULL(ref.exist('attributeMappings'),0)                                    					AS agent16
FROM    @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps') R ( ref )
--Insert associations
DECLARE @autoRedirectionEntities TABLE (appKey nvarchar(255),appName nvarchar(255),domainId int,domainName nvarchar(255),emailDomains nvarchar(255))
INSERT into @autoRedirectionEntities(appKey,appName,domainId,domainName,emailDomains)
SELECT ref.value('../../@appKey' , 'nvarchar(255)'),
ref.value('../../@appName' , 'nvarchar(255)'),
        ISNULL(ref.value('../domain[1]/@id','int'),-1) ,
        ref.value('../domain[1]/@domainName','nvarchar(255)') ,
        ref.value('@val','nvarchar(255)')
        FROM    @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps/associations/emailDomains') R ( ref )
 DELETE TBL
 FROM @tempThirdPartyTable TBL JOIN App_ThirdPartyApp ON TBL.appName=APP_thirdPArtyApp.appName
  DELETE TBL
 FROM @autoRedirectionEntities TBL JOIN App_ThirdPartyApp ON TBL.appName=APP_thirdPArtyApp.appName
 --Check if same smptp already exists with different app name or redirect rule
 UPDATE TBL
 set sameSmtpPresent =1,localCSAppId=CSApp.id,localCSAppName =CSApp.appName
 FROM @tempThirdPartyTable TBL JOIN @autoRedirectionEntities redirect ON TBL.appName=redirect.appName
 JOIN APP_ComponentProp ON componentType=112 and stringVal=emailDomains
 JOIN App_ThirdPartyApp CSApp ON CSApp.id= longVal
--now we need to check is this SAML APP in service CS and remote CS belongs to same company or no compa
UPDATE app
set sameCompany=1
FROM @providerTbl appProv JOIN @tempThirdPartyTable app ON app.appName=appProv.domainName
JOIN @providerTbl company ON company.remoteCSPRoviderId=appProv.ownerCompany
JOIN App_ThirdPartyApp CSapp ON CSapp.id= localCSAppId
JOIN UMDSProviders CSDomain ON CSDomain.domainName=CSapp.appName
JOIN UMDSProviders CSCompany ON CSCompany.id=CSDomain.ownerCompany AND CSCompany.domainName=company.domainName
 WHERE appProv.ownerCompany<>0
 UPDATE app
set sameCompany=1
FROM @providerTbl appProv JOIN @tempThirdPartyTable app ON app.appName=appProv.domainName  and appProv.ownerCompany=0
JOIN App_ThirdPartyApp CSapp ON CSapp.id= localCSAppId
JOIN UMDSProviders CSDomain ON CSDomain.domainName=CSapp.appName and CSDomain.ownerCompany=0
IF EXISTS(SELECT 1 from @tempThirdPartyTable WHERE sameSmtpPresent=1 and sameCompany<>1)
BEGIN
--same smptp is present, but for different companies. Hence we can't merge and sync. HENCE failing sync.
		DECLARE @samlAppList NVARCHAR(MAX)
		SELECT  @samlAppList = COALESCE(@samlAppList +',','') + appname
		FROM @tempThirdPartyTable WHERE sameSmtpPresent=1 and sameCompany<>1
	    SET @errorStr = 'Rule already configured by another SAML App. Conflicted SAMLs are '+ @samlAppList
		SET @errorEntityTypeName  ='SAML App'
		 SET @xmlStatusCode=-1
		GOTO  PROC_EXIT
END
 --If we are here and some app has same smtp , we should merge it into one.
 IF EXISTS(SELECT 1 from @tempThirdPartyTable where sameSmtpPresent=1)
 BEGIN
		--we need to update appName in APP_thirdPArtyapp, update in UMDSPRoviders and in UMUSErs.
	UPDATE TBL
		set login= localCSAppName +'\'+ SUBSTRING(TBL.login,(CHARINDEX('\',TBL.login)+1),LEN(login))
		FROM #temp_UMUSERSCreds TBL JOIN
		@tempThirdPartyTable ON  CHARINDEX('\',TBL.login)<>0 AND SUBSTRING(TBL.login,1,(CHARINDEX('\',TBL.login)-1))=appName
	    	where sameSmtpPresent=1
		UPDATE TBL
		set domainNAme =localCSAppName
		FROM @providerTbl TBL JOIN @tempThirdPartyTable ON TBL.domainName=appName
			where sameSmtpPresent=1
UPDATE TBL
SET TBL.domainName=CSDomain.domainName
		FROM   UMDSProviderProp  JOIN App_ThirdPartyApp CSApp ON  attrNAme ='SAML IDP' and attrVal=CSApp.id
		JOIN UMDSProviders CSDomain ON componentNameId= CSDomain.id
		JOIN @tempThirdPartyTable remoteApp ON remoteApp.localCSappName=CSapp.appname
JOIN @providerTbl TBL ON   TBL.domainName  like remoteApp.appName+'_%' and TBL.serviceType =11
	where sameSmtpPresent=1
UPDATE TBL
SET TBL.appNAme=localCSAppName
FROM @propXMLValueTable  TBL JOIN @tempThirdPartyTable app ON TBL.appName=app.appName and sameSmtpPresent=1
 UPDATE TBL
 set appNAMe=localCSAppName
 FROM @tempThirdPartyTable  TBL where sameSmtpPresent=1
 END
END
------------------UMDSproviders Sync BEGIN ------------------------------------
 SET @errorEntityTypeName = (SELECT CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END
    FROM APP_Entity (NOLOCK)
WHERE entityType = 61)
IF EXISTS(SELECT 1 from @providerTBL)
BEGIN
  UPDATE TBL
  set alreadyExists=1
  FROM @providerTBL TBL JOIN UMDSPRoviders P ON  P.domainName=TBL.domainName and P.serviceType=TBL.serviceType
	INSERT INTO UMDSProviders (domainName,hostName,description,login,password,trustedHostUser,trustedHostPW,flags,enabled,serviceType,modified,dnsRoot,dnsRootStatus,useSecureLdap,origCCId,GUID,port,resourceId,checkTime,ownerId,ownerCompany)
	SELECT TBL.domainName,TBL.hostName,'Synced from Remote CS',TBL.login,TBL.password,TBL.trustedHostUser,TBL.trustedHostPW,TBL.flags,TBL.enabled,TBL.serviceType,TBL.modified,TBL.dnsRoot,TBL.dnsRootStatus,TBL.useSecureLdap,TBL.origCCId,TBL.GUID,TBL.port,TBL.resourceId,TBL.checkTime,TBL.ownerId,TBL.ownerCompany
FROM @providerTBL TBL LEFT JOIN UMDSProviders P  ON  P.domainName=TBL.domainName and ( P.serviceType=TBL.serviceType   or TBL.serviceType= 12)
	WHERE P.domainNAme IS NULL
	UPDATE TBL
	set localproviderId=UMDSProviders.id
FROM @providerTbl TBL JOIN UMDSProviders ON TBL.domainName=UMDSProviders.domainName and ( TBL.serviceType=UMDSProviders.serviceType OR (TBL.serviceType =  12 ))
	UPDATE TBL
	set TBL.ownercompany= input.localproviderId
	FROM @providerTBL  TBL JOIN @providerTBL input on TBL.ownercompany=input.remoteCSProviderId and TBL.ownerCompany<>0
	UPDATE TBL
	set TBL.ownerCompany=input.ownerCompany
	FROM UMDSPRoviders TBL JOIN @providerTBL input ON input.localProviderId=TBL.id and alreadyExists=0
END
--------------------------UMDSPRovider Sync END --------------------------------------------------
----------------------------UMgroups Sync------------------------------------------------------
 SET @errorEntityTypeName = (SELECT CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END
    FROM APP_Entity (NOLOCK)
WHERE entityType = 15)
IF OBJECT_ID('tempdb.dbo.#UserGroupList') IS NOT NULL
    DROP TABLE #UserGroupList
CREATE TABLE #UserGroupList
(
    remoteCSGroupId INT,
    localgroupId INT DEFAULT 0,
    domainId INT,
    name VARCHAR(MAX),
	email Nvarchar(MAX),
	alreadyExists INT DEFAULT 0,
guid varchar(MAX)
)
INSERT INTO #UserGroupList (remoteCSGroupId,name,domainId,email,guid)
 SELECT  T.c.value('(userGroupEntity/@userGroupId)[1]','int'),
         T.c.value('(userGroupEntity/@userGroupName)[1]','VARCHAR(2048)'),
         ISNULL(T.c.value('(provider/@providerId)[1]','int'),0),
		 T.c.value('(@email)[1]','NVARCHAR(MAX)'),
		 T.c.value('(@GUID)[1]','NVARCHAR(MAX)')
 FROM @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/userGroups') T(c)
IF( @MergeSameGroupName=1)
BEGIN
	UPDATE TBL
	SET TBl.alreadyExists=1,localgroupId=G.id
	FROM #UserGroupList TBL JOIN UMGroups G ON g.name =TBL.name and TBL.domainId=0 and alreadyExists=0
END
--update local common group name
UPDATE TBL
SET TBl.alreadyExists=1,localgroupId=G.id
FROM #UserGroupList TBL JOIN UMGroups G ON G.guid=TBL.guid and alreadyExists=0
UPDATE TBL
set TBL.name =@remoteCommcellName+'_'+TBL.name
FROM #UserGroupList TBL WHERE alreadyExists=0 and @MergeSameGroupName=0 and TBL.domainId=0
--Update umds providerID----
Update G
set G.domainId =localproviderId
FROM #UserGroupList G JOIN @providerTbl On G.domainId=remoteCSPRoviderId
 INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, email, GUID, umdsProviderId, origCCId)
 SELECT 1 , 0, 0, 1,member.name, 'Auto-Created group for Multicommcell',member.email, member.guid, domainId, @remoteCommcellId
 FROM #UserGroupList member LEFT JOIN UMGroups UG  on member.name=UG.name and UG.umdsproviderId=member.domainId
 WHERE UG.id is NULL and alreadyExists=0
   Update TBL
 set localgroupId=id
 FROM #UserGroupList TBL JOIN UMGroups UG   ON UG.name=TBL.name and UG.umdsproviderId=TBL.domainId
  Update TBL
 set localgroupId=id
 FROM #UserGroupList TBL JOIN UMGroups UG  on UG.guid=TBL.guid and UG.umdsproviderId=TBL.domainId
------------------------------------------UMUsers sync begin------------------------------------
 SET @errorEntityTypeName = (SELECT CASE WHEN entityTypeNameMessageID <> 0 AND entityTypeNameMessageId IS NOT NULL THEN dbo.fn_EvFormatEventMsgText(0, @localeId, entityTypeNameMessageId, 0, 2) ELSE entityTypeName END
    FROM APP_Entity (NOLOCK)
WHERE entityType = 13)
IF EXISTS (SELECT 1 from @userCredsTable)
BEGIN
UPDATE TBL
set umdsproviderId =Prov.id
FROM #temp_UMUSERSCreds TBL JOIN UMDSProviders PRov ON CHARINDEX('\',TBL.login)<>0 AND SUBSTRING(TBL.login,1,(CHARINDEX('\',TBL.login)-1))=domainName
UPDATE TBL
set alreadyExists=1,localCsId=id
FROM #temp_UMUSERSCreds TBL JOIN UMUsers U  ON TBL.login=U.login and (TBL.email=U.email   OR U.origCCId=@remoteCommcellId)
UPDATE TBL
set alreadyExists=1,localCsId=id
FROM #temp_UMUSERSCreds TBL JOIN UMUsers U  ON TBL.login=U.login and (TBL.umDSproviderId=U.umDSproviderId  OR U.origCCId=@remoteCommcellId)
UPDATE TBL
set TBL.password = creds.password ,TBL.salt=creds.salt
FROM #temp_UMUSERSCreds TBL JOIN @userCredsTable creds on creds.remoteCSuserId=TBL.remoteCSUserId
INSERT INTO UMUSErs(name,description,login,email,password, userGuid,origCCId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt)
SELECT name,description,login,email,password, userGuid,origCCId,datePasswordSet,dateExpires,policy,enabled,flags,modified,pVer,Pager,lastLogInTime,credSetTime,umDSproviderId,origUserGuid,salt
 FROM #temp_UMUSERSCreds where alreadyExists=0
	UPDATE TBL
set localCsId=id
FROM #temp_UMUSERSCreds TBL JOIN UMUsers U  ON TBL.login=U.login and TBL.email=U.email
END
	UPDATE UMUSERS SET password = TBL.password,salt=tbl.salt
		FROM #temp_UMUSERSCreds TBL
		INNER JOIN UMUsers U on U.login = tbl.login and tbl.email = u.email
		INNER JOIN UMDSProviders UMDS on UMDS.id = U.umDSproviderId
		INNER JOIN @newlyCreatedCompanies NC on NC.companyName = UMDS.domainName
WHERE umds.serviceType = 5
	 UPDATE UMUsersProp SET attrVal = 0
		FROM UMUsersProp UP
		INNER JOIN UMUsers U on U.id=UP.componentnameid
		INNER JOIN UMDSProviders UMDS on UMDS.id = U.umDSproviderId
		INNER JOIN @newlyCreatedCompanies NC on NC.companyName = UMDS.domainName
WHERE umds.serviceType = 5 and  attrName = 'Enforce Password Change'
-------------------------------------USer sync end-------------------------------------------------------------------------------------------DECLARE
----------------------------------------------------------USer group memberShip Sync---------------------------------------------------------
DECLARE @UMUserGroupTable TABLE( groupId int, userId int)
INSERT INTO @UMUserGroupTable
SELECT T.col.value('(../userGroupEntity/@userGroupId)[1]','int'),
T.col.value('(@userId)[1]','int')
FROM  @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/userGroups/users') T(col)
JOIN #temp_UMUSERSCreds on T.col.value('(@userId)[1]','int')=remoteCSUserId
UPDATE TBL
SET groupId=localgroupId
FROM @UMUserGroupTable TBL JOIN #UserGroupList on TBL.groupId=remoteCSGroupId
UPDATE TBL
SET userId=localCsId
FROM @UMUserGroupTable TBL JOIN #temp_UMUSERSCreds on TBL.userId=remoteCSUserId
DELETE TBL
FROM @UMUserGroupTable TBL JOIN UMUserGroup UG ON  TBL.userId=UG.userId and TBL.groupId=UG.groupId
INSERT INTO UMUserGroup ( userId,groupId,flag)
SELECT userId,groupId,8
FROM @UMUserGroupTable
----------------------------------------------------------USer group memberShip Sync---------------------------------------------------------
----------------------------AD Group ---Commvault Group Maping-----------------
DECLARE @UMDSUSERGroupMAP TABLE(ADGRoupID int, userGRoupId int)
INSERT INTO @UMDSUSERGroupMAP
SELECT ADGroup.localgroupId,localGroup.localgroupId
FROM  @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/userGroups/externalUserGroups') T(col)
JOIN  #UserGroupList localGroup on T.col.value('(../userGroupEntity/@userGroupId)[1]','int')=localGroup.remoteCSGroupId
JOIN #UserGroupList ADGroup on T.col.value('(@groupId)[1]','int')=ADGroup.remoteCSGroupId
INSERT INTO UMDSGroupMaps (umDSgroupId,umgroupId,flag)
SELECT ADGRoupID,userGRoupId,0
FROM @UMDSUSERGroupMAP
LEFT JOIN UMDSGroupMaps Map ON MAP.umDSgroupId=ADGRoupID AND MAP.umgroupId=userGRoupId
WHERE MAp.umgroupId IS NULL
-----------------------AD Group Maping end----------------------------------------
------------------------------------------USer\Group\Company Association with commcell begins--------------------------------------------------------------
 SET @errorEntityTypeName = 'Security Associations'
DECLARE @userRoleAssoc TABLE(isUSer int,userORGroupId int,roleId int)
DECLARE @viewRoleId INT = (SELECT id from UMroles where name like 'View')
		INSERT INTO @userRoleAssoc(roleId,userORGroupId,isUSer)
		SELECT @viewRoleId,localCSId,1
		FROM #temp_UMUSERSCreds
		UNION
		SELECT @viewRoleId,localgroupId,0
		FROM #UserGroupList
		UNION
		SELECT @viewRoleId ,localproviderId,2
		FROM  @providerTBL
JOIN UMDSProviders P ON localProviderId = P.id and P.serviceType<>11
	 INSERT INTO UMSecurityAssociations(roleId,userOrGroupId,isUSer,entityType1,entityId1,isCreator,authorId)
SELECT Assoc.roleId,Assoc.userORGroupId,Assoc.isUSer,194,@remoteCommcellId,0,-@remoteCommcellId
	 FROM @userRoleAssoc Assoc
LEFT JOIN UMSecurityAssociations DB ON DB.isUser=Assoc.isUSer and DB.userOrGroupId=Assoc.userORGroupId and DB.entityType1=194 and DB.entityId1=@remoteCommcellId and DB.roleId=Assoc.roleId
	  WHERE DB.isUSer is NULL
-------------------------SAML APP SYNC----------------------
 SET @errorEntityTypeName = 'SAML App'
IF @userDetails.exist('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps/@appName') =1
BEGIN
 UPDATE TBL
set keyvalue=CAST(localgroupId as nvarchar(MAX))
FROM @propXMLValueTable  TBL JOIN #userGroupList ON   nameValue='userGroupId' and keyValue=CAST(remoteCSGroupId as nvarchar(MAX))
 DELETE TBL
 FROM @tempThirdPartyTable TBL JOIN App_ThirdPartyApp ON TBL.appName=APP_thirdPArtyApp.appName
  DELETE TBL
 FROM @autoRedirectionEntities TBL JOIN App_ThirdPartyApp ON TBL.appName=APP_thirdPArtyApp.appName
 UPDATE TBL
 SET TBL.domainId=localproviderId
 FROM @autoRedirectionEntities TBL JOIN @providerTbl ON domainId=remoteCSPRoviderId
 UPDATE TBL
 SET TBL.umdsproviderIdWrapper=localproviderId
 FROM @tempThirdPartyTable TBL JOIN @providerTbl ON umdsproviderIdWrapper=remoteCSPRoviderId
  UPDATE TBL
 set  TBL.ownerId=localCsId
 FROM @tempThirdPartyTable TBL JOIN #temp_UMUSERSCreds on TBL.ownerId=remoteCSUserId
  UPDATE TBL
 SET TBL.companyId=localproviderId
 FROM @tempThirdPartyTable TBL JOIN @providerTbl ON companyId=remoteCSPRoviderId
 UPDATE TBL
set keyvalue=CAST(localgroupId as nvarchar(MAX))
FROM @propXMLValueTable  TBL JOIN #userGroupList ON   nameValue='userGroupId' and keyValue=CAST(remoteCSGroupId as nvarchar(MAX))
DECLARE @propXmlTable TABLE (appname nvarchar(MAX),props XML)
INSERT INTO @propXMLTable
SELECT DISTINCT appName,
(SELECT nameValue as '@name',keyvalue as '@value'
FROM @propXMLValueTable inside where inside.appName=out.appName
FOR XML PATH('nameValues'),Root('props')) as propXML
FROM @propXMLValueTable out
UPDATE TBL
set  TBL.props= propsTbl.props
FROM @tempThirdPartyTable TBL JOIN @propXMLTable propsTbl ON propsTBL.appNAme=TBL.appName
   INSERT INTO App_ThirdPartyApp
                        (
                        appType,
                        appKey,
                        appName,
                        appToken,
                        appSecret,
                        appDescription,
                        ownerId,
                        created,
                        modified,
                        isEnabled,
                        props,
                        flags
                        )
						SELECT appType,appKey,appName,appToken,appSecret,appDescription,ownerId,dbo.GetUnixTime(GETUTCDATE()),0
						,isEnabled,props,flags
						FROM @tempThirdPartyTable
		INSERT INTO App_ThirdPartyAppProp
SELECT ATPA.id,'Synced From Service Commcell',1,@remoteCommcellId,@nowTime,0 from app_thirdpartyapp ATPA inner join @tempThirdPartyTable TATPA on ATPA.appKey = TATPA.appKey
		INSERT INTO UMDSProviderProp(componentNameId,attrName,attrType,attrVal,created,modified)
		SELECT umdsproviderIdWrapper,'SAML IDP',10, DB.id ,dbo.GetUnixTime(GETUTCDATE()),0
		FROM App_ThirdPartyApp  DB JOIN @tempThirdPartyTable input on DB.appName=input.appName
		LEFT JOIN UMDSProviderProp ON input.umdsproviderIdWrapper=componentNameId and attrName='SAML IDP'
		WHERE UMDSProviderProp.id is NULL
		INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,stringVal,created,modified)
		SELECT 112,domainId,16,10,DB.id,0,emailDomains,dbo.GetUnixTime(GETUTCDATE()),0
		FROM @autoRedirectionEntities input JOIN App_ThirdPartyApp DB ON input.appName=DB.appName
		LEFT JOIN APP_ComponentProp CP ON CP.componentType=112 and CP.componentType=domainId and CP.longVal=DB.id
		WHERE CP.id is NULL
	DECLARE @attributeMap TABLE ( appName nvarchar(max)  ,attrNAme nvarchar(2048) ,attrType int,attrVal nvarchar(2048),appId int)
	INSERT INTO @attributeMap (appName,attrName,attrType,attrVal)
	SELECT
	ref.value('@appName','nvarchar(255)'),'Attribute Mapping',1,
	CAST(ref.query('attributeMappings') as nvarchar(MAX))
    FROM    @userDetails.nodes('Api_GetUserSpaceforRouterCSResp/clientThirdPartyApps/clientThirdPartyApps') R ( ref )
INSERT INTO App_ThirdPartyAppProp(componentNameId,attrName,attrType,attrVal,created,modified)
SELECT APP.id,sync.attrName,sync.attrType,sync.attrVal,1,0
FROM @attributeMap sync JOIN App_ThirdPartyApp App ON sync.appName=App.appName
LEFT JOIN App_ThirdPartyAppProp DB ON DB.componentNAmeID=App.id and DB.attrName=sync.attrName and DB.attrVal=sync.attrVAl
WHERE DB.componentNameID IS NULL
END
	 END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @xmlStatusCode = -1
END CATCH
PROC_EXIT:
DECLARE @errorXML NVARCHAR(MAX) = (  SELECT @xmlStatusCode as '@status',
							 (SELECT @errorEntityTypeName as 'entity/@entityTypeName' , @errorStr as 'entityErrorMessage'
							 FOR XML PATH('entityErrorResponses'),TYPE)
							FOR XML PATH ('EVGui_CN2CellRegSyncStatus'))
if(@xmlStatusCode=-1) --Failures
BEGIN
	SET @statusCode=1
	SET @errorXML = (  SELECT @xmlStatusCode as '@status',
							 (SELECT @errorEntityTypeName as 'entity/@entityTypeName' , @errorStr as 'entityErrorMessage'
							 FOR XML PATH('entityErrorResponses'),TYPE)
							FOR XML PATH ('EVGui_CN2CellRegSyncStatus'))
END
ELSE IF(@xmlStatuscode=1)   --Success
BEGIN
	SET @statusCode =0
		SET @errorXML= (  SELECT @xmlStatusCode as '@status'
							FOR XML PATH ('EVGui_CN2CellRegSyncStatus'))
END
IF EXISTS (SELECT 1 FROM APP_ComponentProp where componentType = 1051 AND componentId = @remotecommcellId )
BEGIN
			UPDATE App_ComponentPRop
			SET stringVal = @errorXML
WHERE componentType = 1051 AND componentId = @remotecommcellId
END
ELSE
BEGIN
	INSERT INTO APP_ComponentProp(componentType,componentId,propertyTypeId,datatype,longVal,longlongVal,stringVal,created,modified)
SELECT 1051,@remotecommcellId,1,0,0,@statusCode,@errorXML,dbo.GetUnixTime(GETUTCDATE()),0
END
IF @statusCode=0
BEGIN
	IF((@isIDPServiceCommcell = 1 and @requestType = 1) OR (@isIDPServiceCommcell = 0))
	BEGIN
DELETE from APP_ComponentProp where componentType = 1049 and componentId = @remoteCommcellId and propertyTypeId = 1
		INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longval,longlongVal,stringVal,created,modified)
(SELECT  1049,@remoteCommcellId,1,0,0,0,'', @nowTime,0)
	END
END
Select @statusCode as '@errorCode',@errorStr as '@errorMessage' for xml path('App_GenericResp')
GO

IF EXISTS (select * from GxQscripts where name = 'sec_SyncUsersFromRemoteCommcell')
	delete from GxQscripts where name = 'sec_SyncUsersFromRemoteCommcell'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_SyncUsersFromRemoteCommcell')
	delete from GXDBVersions where aliasname = 'sec_SyncUsersFromRemoteCommcell'
GO

insert into GXDBVersions values(2, 'sec_SyncUsersFromRemoteCommcell',  '00000000000000000000', 'sec_SyncUsersFromRemoteCommcell', '00000000000000000000')
GO

