

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_RenewUserSession.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_RenewUserSession.sp,v $ $Id: sec_RenewUserSession.sp,v 1.1.2.8 2020/11/24 12:57:06 manosivams Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_RenewUserSession')
BEGIN
	print '>>> Drop Stored Procedure: sec_RenewUserSession <<<'
	drop procedure sec_RenewUserSession
END
IF EXISTS (select * from GxQscripts where name='sec_RenewUserSession')
	delete from GxQscripts where name = 'sec_RenewUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_RenewUserSession')
	delete from GXDBVersions where aliasname = 'sec_RenewUserSession'
GO
print '... Creating Procedure: sec_RenewUserSession'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_RenewUserSession
  @i_CurSessionId varchar(36),
  @i_DeviceId nvarchar(max),
  @o_NewSessionId varchar(36) OUTPUT,
  @o_errorCode integer output,
  @o_Username nvarchar(510) OUTPUT,
  @o_errorString nvarchar(1024) OUTPUT,
  @o_userId int OUTPUT,
  @o_timeout int OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @deviceId nvarchar(max)
	DECLARE @ExSessionId nvarchar(36)
	SET @o_errorCode= 0
	declare @currentTime int = dbo.GetUnixTime(GETUTCDATE())
	declare @consoleType int = 0
	declare @timeout int = 0
	declare @maxTimeout int = 35791394 -- int.max / 60 approximately 68 years
	--SET @o_errorCode= 0
	-- Check if the session is still alive
	IF EXISTS(select top 1 GUID from UMQSDKSessions where GUID = @i_CurSessionId)
	BEGIN
		SET @o_errorCode= 1139 -- Token not expired.
		SET @o_errorString = 'Token has not expired'
	END
	ELSE
	BEGIN
		--Update logout time of any stale entries in UMSessionAudit which have no corresponding entries in UMQSDKSessions
		update UMSessionAudit set logoutTime = @currentTime
		where sessionId = @i_CurSessionId and logoutTime = 0
		and NOT EXISTS (select 1 from UMQSDKSessions USQ where USQ.GUID =  @i_CurSessionId)
		SELECT @ExSessionId = U.SessionID, @deviceId = DeviceID, @consoleType = ISNULL(U.ConsoleType, 0) FROM UMSessionAudit U with (nolock)
WHERE U.SessionID = @i_CurSessionId and U.logoutTime > 0 and U.flag <> 2 -- not killed, killed sessions should not be renewed.
		--If the session is still preset in UMSessionAudit, perform renew operation thinking in mind that we should reduce the number of relogins for apps like edge monitor. so, removed renewCutoffTime check  {U.logoutTime + (@renewCutoffTime * 60) >= @currentTime}.
		IF ISNULL(@ExSessionId, '') = ''
		BEGIN
			 SET @o_errorCode= 1143 -- SESSION_NOT_FOUND_FOR_SESSION_RENEWAL
			 SET @o_errorString = 'Session is not eligible for renewal'
		END
		ELSE IF ISNULL(@deviceId, '') = '' OR @deviceId <> @i_DeviceId
		BEGIN
			SET @o_errorCode=  1138 -- DEVICE_ID_MISMATCH_FOR_SESSION_RENEWAL
			SET @o_errorString = 'Device ID mismatch'
		END
		SET @maxTimeout = ISNULL((SELECT convert(int, value) from GxGlobalParam with (nolock) where name = 'QSDKPersistSessionTimeOut' and ISNUMERIC(value) = 1), 35791394)
		SET @timeout = ISNULL((SELECT convert(int, value) from GxGlobalParam with (nolock) where name = 'QSDKTimeout' + convert(nvarchar(2), @consoleType) and ISNUMERIC(value) = 1), @maxTimeout)
		IF @o_errorCode= 0
		BEGIN
			BEGIN TRAN
			IF ISNULL(@o_NewSessionId, '') = ''
			BEGIN
				SET @o_NewSessionId = LOWER(NEWID())
			END
			insert into UMQSDKSessions(
										userId,
										GUID,
										evmgrsSessionId,
										userName,
										password,
										created,
										lastAccessedTime,
										referenceCount,
										encryptedToken,
										sessionFileLocation,
										hostName,
										consoleType,
										timeout,
										imp_userId,
										tokenExpires)
									select userId, @o_NewSessionId, 0, u.login, password, @currentTime, @currentTime, 1, '', '', host, @consoleType,
									case when timeout is not null and timeout > 0 then timeout
									else @timeout
									end,
									0, 0
									from UMSessionAudit s join UMUSERS u on s.userId = u.id where s.sessionId = @i_CurSessionId
			SELECT @o_errorCode= @@Error
			IF @o_errorCode= 0
			BEGIN
				-- Successfully added to UMQSDKSessions table
				-- Now add to UMSessionAudit
				INSERT INTO UMSessionAudit(userId, sessionId, createdTime, logoutTime, consoleType, host, remark, browserSessionId, location, deviceId, LinkSessionId, flag, timeout)
				select userId, @o_NewSessionId, @currentTime, 0, consoleType, hostname, '', 0, '', @i_deviceId, @i_CurSessionId, 0, timeout from UMQSDKSessions with (nolock) where guid = @o_NewSessionId
				SELECT @o_errorCode= @@Error
			END
			IF @o_errorCode= 0
			BEGIN
				COMMIT TRAN
				select @o_Username = username, @o_userId = userId, @o_timeout = timeout from UMQSDKSESSIONS where GUID = @o_NewSessionId
			END
			ELSE
				ROLLBACK TRAN
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_RenewUserSession')
	delete from GxQscripts where name = 'sec_RenewUserSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_RenewUserSession')
	delete from GXDBVersions where aliasname = 'sec_RenewUserSession'
GO

insert into GXDBVersions values(2, 'sec_RenewUserSession',  '00010001000200080000', 'sec_RenewUserSession', '00010001000200080000')
GO

