

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_PruneAuditSessions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_PruneAuditSessions.sp,v $ $Id: sec_PruneAuditSessions.sp,v 1.1.2.3 2020/03/19 09:45:40 manojg Exp $";
-- This stored proc will prune stale sessions from UMSessionAudit table. Stale sessions are sessions that are past their logout time for a given threshold time.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_PruneAuditSessions')
BEGIN
	print '>>> Drop Stored Procedure: sec_PruneAuditSessions <<<'
	drop procedure sec_PruneAuditSessions
END
IF EXISTS (select * from GxQscripts where name='sec_PruneAuditSessions')
	delete from GxQscripts where name = 'sec_PruneAuditSessions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_PruneAuditSessions')
	delete from GXDBVersions where aliasname = 'sec_PruneAuditSessions'
GO
print '... Creating Procedure: sec_PruneAuditSessions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_PruneAuditSessions
AS
  DECLARE @errorNum int = 0
  DECLARE @errorMsg nvarchar(1024) = ''
DECLARE @maxSessionCount int = 3
declare @cutoffTime int = 43200
BEGIN TRY
	declare @bulkCount int = 500
	declare @totalRecs int = 0
	declare @now int = dbo.GetUnixTime(GetUTCDate())
	create table #tbl (id int identity (1,1) PRIMARY KEY, userId int, deviceId nvarchar(256), c int, UMSessionId int)
		SELECT @cutoffTime = convert(int,value) from GXGlobalParam where name = 'RenewTimeout' and ISNUMERIC(value) = 1 and modified = 0
		SELECT @maxSessionCount = convert(int,value) from GXGlobalParam where name = 'AuditSessionCountPerDevicePerUser' and ISNUMERIC(value) = 1 and modified = 0
	insert into #tbl(userId, deviceId, c, UMSessionId) select userId, deviceId, COUNT(*) CN, MAX(id) from UMSEssionAudit with (nolock) where logoutTime > 0 and logouttime + @cutoffTime * 60 < @now group by userId, DeviceId
	having COUNT(*) > @bulkCount order by CN desc
	SELECT @totalRecs = max(id) from #tbl
	--1. Delete inidividual user sessions on a per user per device order. This should remove all sessions which are way past their expriy time
	DECLARE @I INT
	PRINT 'deleting user sessions on an individual basis'
	WHILE (@I <= @totalRecs)
	BEGIN
		DELETE A from UMSessionAudit A join #tbl B on A.userId = B.userId AND A.DeviceId = B.DeviceId where A.id <= B.UMSessionId and B.id = @I
		SELECT @I = @I + 1
	END
	PRINT 'deleting bulk user sessions'
	delete  a from
	(
		select *, ROW_NUMBER() OVER (PARTITION BY UserId, deviceId ORDER BY logoutTime desc , USERID, deviceId) AS sn from UMSessionAudit where logoutTime > 0 and logouttime + @cutoffTime * 60 < @now
	) a
	where a.SN > @maxSessionCount
	drop table #tbl
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @errorNum      = ERROR_NUMBER()
    SET @errorMsg  = ERROR_MESSAGE()
END   CATCH
select @errorNum, @errorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'sec_PruneAuditSessions')
	delete from GxQscripts where name = 'sec_PruneAuditSessions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_PruneAuditSessions')
	delete from GXDBVersions where aliasname = 'sec_PruneAuditSessions'
GO

insert into GXDBVersions values(2, 'sec_PruneAuditSessions',  '00010001000200030000', 'sec_PruneAuditSessions', '00010001000200030000')
GO

