

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_NonIDaNodeAccess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_NonIDaNodeAccess.sp,v $ $Id: sec_NonIDaNodeAccess.sp,v 1.34.40.5 2020/11/19 09:43:22 jswaminathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_NoNiDaNodeAccess()
--  |
--  | Description:  Determines whether a user is associated with a group
--	|				that can see a chosen iDa object.
--  |
--  |       Input:  integer Affiliation: Bit map representation of which
--	|				affiliations are requested
--	|
--  |      Output:  Returns list of groups that can see the object
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1        skatz	Created from getSecurityNodeAccess.cur revision 1.8
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_NoNiDaNodeAccess')
BEGIN
	print '>>> Drop Stored Procedure: sec_NoNiDaNodeAccess <<<'
	drop procedure sec_NoNiDaNodeAccess
END
IF EXISTS (select * from GxQscripts where name='sec_NoNiDaNodeAccess')
	delete from GxQscripts where name = 'sec_NoNiDaNodeAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_NoNiDaNodeAccess')
	delete from GXDBVersions where aliasname = 'sec_NoNiDaNodeAccess'
GO
print '... Creating Procedure: sec_NoNiDaNodeAccess'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_NoNiDaNodeAccess
  @uid integer,
  @commcellParam integer,
  @ItemTypeParam integer,
  @ItemIdParam integer
AS
  DECLARE @userId integer
  DECLARE @nodeCapabilites bigint
  DECLARE @childCapabilites bigint
  SET NOCOUNT ON
  declare @returnVal			integer
  declare @nodeCapabilities		bigint
  declare @childCapabilities	bigint
  declare @flag					integer
  SET @returnVal			= 0													-- Assume no Access
  SET @nodeCapabilities		= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
  SET @childCapabilities	= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
  declare @clientGroupId	integer
  declare @arrayId			integer = 0
  declare @mediaAgentId		integer
  declare @libraryId		integer
  declare @archiveGroupId	integer
  declare @vtContainerId	integer
  declare @vtLocationId		integer
  declare @vtShelfId		integer
  declare @vtPolicyId		integer
  declare @reviewSetId		integer = 0
  declare @downloadSetId	integer = 0
  declare @querySetId		integer = 0
  declare @legalHoldId		integer = 0
  declare @ermId			integer = 0
  declare @cdPolicyId		integer = 0
  declare @complianceReportId	integer = 0
  declare @tagId			integer = 0
  declare @taskId			integer = 0
  declare @workflowId		integer = 0
  declare @logMonitoringPolicyId integer=0
  set @clientGroupId	= 0
  set @mediaAgentId		= 0
  set @libraryId		= 0
  set @archiveGroupId	= 0
  set @vtContainerId    = 0
  set @vtLocationId		= 0
  set @vtShelfId		= 0
  set @vtpolicyId       = 0
--  ---------------------------------------------------
--	-- Fetch "Scoped" List of Objects for this user --
--  ---------------------------------------------------
IF object_id('tempdb.dbo.#userObjects') is not null
	DROP TABLE #userObjects
IF @itemTypeParam = 2018
BEGIN
	set @itemTypeParam = 0							-- Need to do this to get COMMCELL LEVEL out of sec_getUserObjects!
	set @itemIdParam = 0
END
create table  #userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--	EXEC sec_getUserObjects @uid, @itemTypeParam, @itemIdParam, '#userObjects'
EXEC sec_updateUserCredentials @uid
EXEC sec_getUserObjects @uid, @itemTypeParam, 0, '#userObjects'
	IF (@ItemTypeParam = 9615)     -- ARRAY_ITEM
		set @arrayId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 2572)     -- SERVER_GROUP_ITEM
		set @clientGroupId	= @ItemIdParam
    ELSE IF (@ItemTypeParam = 2048)     -- MEDIA_AGENT_ITEM
		set @mediaAgentId		= @ItemIdParam
    ELSE IF (@ItemTypeParam = 2049)     -- LIBRARY_ITEM
		set @libraryId		= @ItemIdParam
	ELSE IF (@ItemTypeParam = 2231)     -- ARCHIVE_GROUP_ITEM
		set @archiveGroupId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 8180)     -- SHELF_LIBRARY_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @vtShelfId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 8107)     -- CONTAINER_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @vtContainerId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 8464)     -- TM_DESTINATION_ITEM (Shared/Cvlib/EvsvrStatic.h) -- entityId1
		set @vtLocationId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 8462)     -- TM_POLICY_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @vtPolicyId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 9501)     -- DM2_REVIEW_SET_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @reviewSetId = @ItemIdParam
	ELSE IF (@ItemTypeParam = 9502)     -- DM2_QUERY_SET_ITEM  (Shared/Cvlib/EvsvrStatic.h)
		set @querySetId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 9503)     -- DM2_DOWNLOAD_SET_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @downloadSetId = @ItemIdParam
	ELSE IF (@ItemTypeParam = 9504)     -- DM2_TAG_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @tagId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 9505)     -- DM2_LEGAL_HOLD_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @legalHoldId = @ItemIdParam
	ELSE IF (@ItemTypeParam = 9506)     -- DM2_ERM_CONNECTOR_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @ermId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 9507)     -- DM2_CD_POLICY_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @cdPolicyId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 9508)     -- DM2_COMPLIANCE_REPORT_ITEM (Shared/Cvlib/EvsvrStatic.h)
		set @complianceReportId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 4300)     -- SCHEDULE_ITEM 4300 (Shared/Cvlib/EvsvrStatic.h)
		set @taskId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 14033)     -- WORKFLOW_ITEM 14033 (Shared/Cvlib/EvsvrStatic.h)
		set @workflowId	= @ItemIdParam
	ELSE IF (@ItemTypeParam = 9646)     -- LOG_MONITORING_POLICY_ITEM 9641(Shared/Cvlib/EvsvrStatic.h)
		set @logMonitoringPolicyId	= @ItemIdParam
	ELSE if (@ItemTypeParam <> 0)
		delete #userObjects
    UPDATE #userObjects
        SET FLAG = 1
        WHERE commCellId		= @commcellParam
            AND clientGroupId	= @clientGroupId
            AND mediaAgentId	= @mediaAgentId
            AND libraryId		= @libraryId
            AND archGroupId	= @archiveGroupId
            AND vtContainerId	= @vtContainerId
            AND vtPolicyId	    = @vtPolicyId
            AND vtshelfId 		= @vtShelfId
			AND reviewSetId    = @reviewSetId
            AND querySetId     = @querySetId
            AND downloadSetId  = @downloadSetId
			AND tagId          = @tagId
			AND legalHoldId    = @legalHoldId
			AND ermId          = @ermId
			AND cdPolicyId     = @cdPolicyId
			AND arrayId		= @arrayId
			AND complianceReportId = @complianceReportId
			AND taskId = @taskId
			AND workflowId = @workflowId
			AND logMonitoringPolicyId=@logMonitoringPolicyId
			and cloudId=0
			and userGroupId=0
			and providerId=0
            AND clientId=0
			AND appTypeId=0
			AND instanceId=0
			AND backupsetId=0
			AND subClientId=0
			AND entityId1 = @vtLocationId
			AND entityId2=0
			AND entityId3=0
			AND entityId4=0
			AND entityId5=0
			AND entityId6=0
			AND entityId7=0
			AND entityId8=0
			AND entityId9=0
    UPDATE #userObjects
        SET FLAG = 1
        WHERE commCellId  = @commcellParam
            AND clientGroupId=0 AND clientId=0    AND appTypeId=0
            AND instanceId=0    AND backupsetId=0 AND subClientId=0
            AND mediaAgentId=0  AND libraryId=0   AND archGroupId=0
			AND vtPolicyId=0    AND vtcontainerId=0 AND vtShelfId = 0
			AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
			AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
			AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
			AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
			AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
			AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
			AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			AND arrayId=0
			and cloudId=0
			and userGroupId=0
			and providerId=0
	delete #userObjects where flag = 0									-- No Child visibility inheritance for any of these objects
					AND @ItemTypeParam <> 0								-- (Except CommCell!)
	SELECT
		@childCapabilities = @childCapabilities | capabilities
	FROM #userObjects
	WHERE  capabilities <> 0
	SELECT
		@nodeCapabilities = @nodeCapabilities | capabilities
	FROM #userObjects
	WHERE  capabilities <> 0 and flag <> 0
	IF EXISTS (Select * from #userObjects)
	   SET @returnVal = @uid
	 SELECT @returnVal, @nodeCapabilities, @childCapabilities
  SET @nodeCapabilities		= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
  SET @childCapabilities	= 0													-- THIS WILL BE WHERE Capability Bits ARE "OR-ED"
-- CLEAN UP!
	DROP TABLE #userObjects
	set nocount off
-- Tell the AWK processor that there are no more input lines to scan
GO


IF EXISTS (select * from GxQscripts where name = 'sec_NonIDaNodeAccess')
	delete from GxQscripts where name = 'sec_NonIDaNodeAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_NonIDaNodeAccess')
	delete from GXDBVersions where aliasname = 'sec_NonIDaNodeAccess'
GO

insert into GXDBVersions values(2, 'sec_NonIDaNodeAccess',  '00010034004000050000', 'sec_NonIDaNodeAccess', '00010034004000050000')
GO

