

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_LockClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Ravneet Arora
--	Date:   1/18/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_LockClient.sp,v $ $Id: sec_LockClient.sp,v 1.6.42.14 2020/09/24 14:14:48 rengu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_LockClient')
BEGIN
	print '>>> Drop Stored Procedure: sec_LockClient <<<'
	drop procedure sec_LockClient
END
IF EXISTS (select * from GxQscripts where name='sec_LockClient')
	delete from GxQscripts where name = 'sec_LockClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_LockClient')
	delete from GXDBVersions where aliasname = 'sec_LockClient'
GO
print '... Creating Procedure: sec_LockClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_LockClient
  @i_userId INT,
  @i_entityId INT,
  @i_value INT,
  @i_type INT,
  @i_localeId INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorString nvarchar(max)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errorCode = 0
	-- Applicable only for clients and not company
IF @i_type = 3
	BEGIN
		IF @i_entityId = 0
		BEGIN
SET @o_errorCode = (2290 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ENDSP
		END
		IF @i_entityId > 0
		BEGIN
			-- Do not allow for edge drive clients.
IF EXISTS(SELECT id from App_client WITH (NOLOCK) where status & 0x10000000  = 0x10000000 AND id = @i_entityId)
			BEGIN
SET @o_errorCode = (2855 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
			IF @i_entityId = 2
			BEGIN
SET @o_errorCode = (3658 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
			IF @i_value = 1
			BEGIN
				-- If the client belongs to a company, verify if the privacy option is enabled at the company level
				DECLARE @clientcompanyId INTEGER = ISNULL((SELECT CONVERT(INTEGER,attrval)  FROM APP_ClientProp WHERE
attrname='Installation Company ID' AND componentNameId=@i_entityId AND modified=0) , -1)
				IF @clientcompanyId = -1
				BEGIN
						SET	@clientcompanyId = ISNULL((select componentNameId from App_CompanyProp ACP
INNER JOIN APP_ClientGroupAssoc ACGA on ACP.attrValInt=ACGA.clientGroupId AND  ACP.attrName='Associated Smart Client Group' AND ACP.cs_attrName = checksum('Associated Smart Client Group')
																			INNER JOIN APP_Client AC on AC.id = ACGA.clientId
																			WHERE AC.id = @i_entityId AND ACP.modified = 0),0)
				END
				-- First get the Company Id for the provided client, check if privacy is enabled for the company.
				-- If commcell is the company it will be 0
				IF (@clientcompanyId > 0)
				BEGIN
					-- We should not check if company is locked, as company might not want Privacy enabled at company level and allow its users to change their client privacy.
					-- If client belongs to company and Tenant Admin has not enabled the feature at company level error out
IF EXISTS (SELECT 1 FROM App_CompanyProp ACP WHERE ACP.attrVal = N'1' AND ACP.attrName = 'Allow Users To Enable Privacy' AND ACP.componentNameId = @clientcompanyId AND ACP.modified = 0)
					BEGIN
						SET @o_errorCode = 0
					END
					ELSE
					BEGIN
SET @o_errorCode = (3656 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						GOTO ENDSP
					END
				END
				ELSE --if the client belongs to COMMCELL
				BEGIN
IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = '3c8d1ac5575382ed39b961906a331a2ac82766fdcfa15580a' and value = '1' and modified =0)
					BEGIN
IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = (SELECT csGUID FROM App_Commcell where id = 2) and value = '3b43937232ab5b572bf6bb373d33ca779a47427f93c82b196b881417e07eca1db3601baf45fe32f14'
									and modified =0)
						BEGIN
							SET @o_errorCode = 0
						END
						ELSE
						BEGIN
SET @o_errorCode = (2290 | (CAST(POWER(2, 24) AS BIGINT) * 35))
							GOTO ENDSP
						END
					END
					ELSE
					BEGIN
SET @o_errorCode = (2290 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						GOTO ENDSP
					END
				END
			END
		END
	END
	DECLARE @value nvarchar(100)
	IF @i_value = 1
SET @value = 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'
	ELSE
SET @value = 'd54e22dfae22260e76a0fa543b5d321facbd5489ac662ac4396c52b14e7c4511da3476935e6b832f'
IF @i_type = 3 AND @i_entityId <> 2
	BEGIN
		-- If user is not client owner, error and go to end, else continue
		IF dbo.IsClientOwner(@i_entityId,@i_userId) = 0
		BEGIN
SET @o_errorCode = (2264 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			GOTO ENDSP
		END
		IF @i_value = 1
		BEGIN
			--Check if the client has any user group as clientowners
			-- IS USER GROUP ASSOCIATED WITH THE CLIENT
			IF EXISTS( SELECT Owners.clientID
			FROM sec_getCLientOwners(0) owners
					WHERE clientId = @i_entityId AND (userGroupId <> 0 OR externalGroupId <> 0))
			BEGIN
SET @o_errorCode = (2300 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
			--Check if the client has any owners without email id set
			DECLARE @tmpUser table (id int,email nvarchar(255),enabled int)
			INSERT INTO @tmpUser
			SELECT id, ISNULL(email,''),enabled from UMUsers where id IN
			(SELECT DISTINCT userId FROM sec_getCLientOwners (0)
				 WHERE clientId = @i_entityId)
			IF EXISTS ( SELECT id FROM @tmpUser WHERE email = '' or email = 'Email Disabled' or email='No Email' or enabled=0)
			BEGIN
SET @o_errorCode = (2299 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
		END
		--Get the latest property
		-- Reading from the encrypted attribute name "CV_PROP_ENABLE_DATA_SECURITY" and checking if it's already present or not
IF EXISTS(SELECT 1 FROM APP_ClientProp WHERE componentNameId=@i_entityId AND attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and modified = 0)
		BEGIN
UPDATE APP_ClientProp SET attrVal=@value WHERE componentNameId=@i_entityId AND attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and modified = 0 and attrVal<>@value
    	END
    	ELSE
    	BEGIN
INSERT INTO APP_ClientProp VALUES(@i_entityId , '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807', 2, @value, dbo.GetUnixTime(GETDATE()), 0, 0)
    	END
	END
	ELSE
	BEGIN
IF @i_type = 61 and (@i_entityId > 0)
		BEGIN
			/*
				Security Checks before we do any further operations
				A provider can be locked by MSPAdmin\TenantAdmin\Reseller
				Unlocked by only Tenant admin.
			*/
			DECLARE @IsMSPAdminOrReseller int = 0
			DECLARE @canManageProvider INT = 0
			DECLARE @isTenantAdmin INT = 0
			DECLARE @tenantAdminGroupId INT = 0
SET @tenantAdminGroupId = (SELECT UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@i_entityId)
			IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
				DROP TABLE #userGroupId
			CREATE TABLE #userGroupId
			(
				userGroupId INT
			)
			EXEC sec_getMemberUserGroups @i_userId
			IF EXISTS(
				SELECT 1 FROM #userGroupId WHERE userGroupId = @tenantAdminGroupId
			)
			BEGIN
				SET @isTenantAdmin = 1
			END
			IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
				DROP TABLE #userGroupId
			IF @isTenantAdmin = 0 AND @i_value = 1
			BEGIN
				--MSP/Reseller admin checks
EXEC sec_checkPermissionOnEntity @i_userId, 1, @IsMSPAdminOrReseller OUT,1,2
			END
			-- For enable MSP admin/Reseller/Tenant Admin all can perform the operation
			IF @i_value = 1 AND (@IsMSPAdminOrReseller = 0 AND @isTenantAdmin = 0)
			BEGIN
SET @o_errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
			-- For disable only Tenant Admin can perform the operation
			IF @i_value = 0 AND @isTenantAdmin = 0
			BEGIN
SET @o_errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
			--Only to lock,Check if feature is enabled at the Commcell level
IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = '3c8d1ac5575382ed39b961906a331a2ac82766fdcfa15580a' and value = '1' and modified =0)
			BEGIN
IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = (SELECT csGUID FROM App_Commcell where id = 2) and value = '3b43937232ab5b572bf6bb373d33ca779a47427f93c82b196b881417e07eca1db3601baf45fe32f14'
							and modified =0)
				BEGIN
					--Fix Checksum type, Use checksum for faster access
IF EXISTS(SELECT componentNameId FROM APP_CompanyProp WHERE componentNameId=@i_entityId AND attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'
and modified = 0 and cs_attrName = CHECKSUM('7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807'))
					BEGIN
UPDATE APP_CompanyProp SET attrVal=@value WHERE componentNameId=@i_entityId AND attrName='7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' and modified = 0
					END
					ELSE
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_entityId,'7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807', 2, @value, dbo.GetUnixTime(GETDATE()), 0)
					END
					SET @o_errorCode = 0
				END
				ELSE
				BEGIN
SET @o_errorCode = (3657 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					GOTO ENDSP
				END
			END
			ELSE
			BEGIN
SET @o_errorCode = (3657 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				GOTO ENDSP
			END
		END
	END
	ENDSP:
	SET @o_errorString =(SELECT Message
    from EvLocaleMsgs
    where EvLocaleMsgs.MessageId = @o_errorCode
    AND [localeId] = @i_localeId)
	SELECT @o_errorCode as o_errorCode,@o_errorString as o_errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_LockClient')
	delete from GxQscripts where name = 'sec_LockClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_LockClient')
	delete from GXDBVersions where aliasname = 'sec_LockClient'
GO

insert into GXDBVersions values(2, 'sec_LockClient',  '00010006004200140000', 'sec_LockClient', '00010006004200140000')
GO

