

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_IncrementFailedLoginCountXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_incrementFailedLoginCountXML"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_incrementFailedLoginCountXML')
BEGIN
	print '>>> Drop Stored Procedure: sec_incrementFailedLoginCountXML <<<'
	drop procedure sec_incrementFailedLoginCountXML
END
IF EXISTS (select * from GxQscripts where name='sec_incrementFailedLoginCountXML')
	delete from GxQscripts where name = 'sec_incrementFailedLoginCountXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_incrementFailedLoginCountXML')
	delete from GXDBVersions where aliasname = 'sec_incrementFailedLoginCountXML'
GO
print '... Creating Procedure: sec_incrementFailedLoginCountXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_incrementFailedLoginCountXML
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @failedLoginCount INT
DECLARE @userId INT = ISNULL((SELECT ref.value('@userId', 'INT') FROM @i_xml.nodes ('App_IncrementUserFailedLoginAttemptsReq') R(ref)),
                      ISNULL((SELECT id FROM UMUsers WHERE userGuid = (SELECT ref.value('@userGUID', 'VARCHAR(64)')  FROM @i_xml.nodes ('App_IncrementUserFailedLoginAttemptsReq') R(ref))),
                             (SELECT id FROM UMUsers WHERE [login]  = (SELECT ref.value('@userName', 'VARCHAR(510)') FROM @i_xml.nodes ('App_IncrementUserFailedLoginAttemptsReq') R(ref)))))
-- -- SP BODY BEGIN : sec_incrementFailedLoginCount.spb ----------------------------------------------------------------------------------------------------------------------------
IF @userId IS NOT NULL AND @userId > 0
BEGIN
    DECLARE @SPBodyCurTime_48036 INT = dbo.GetUnixTime(getUtcDate())
	BEGIN TRY
	MERGE UMUSERSPROP as target
USING (SELECT @userID ,'Failed login attempts') as source(UID, ATTRNAME)
	ON (target.componentNameId = source.UID and target.attrName = source.ATTRNAME)
	WHEN MATCHED THEN
		UPDATE SET modified = @SPBodyCurTime_48036, attrVal =
		CASE
			WHEN ISNUMERIC(attrVal) = 1 THEN convert(nvarchar(16), convert(int, attrVal) + 1)
			ELSE N'1'
		END
	WHEN NOT MATCHED THEN
INSERT(componentNameId, attrName, attrVal, attrType, created, modified ) VALUES(@userId, 'Failed login attempts', N'1', 1, @SPBodyCurTime_48036, @SPBodyCurTime_48036);
	OUTPUT:
		SET @failedLoginCount = ISNULL((SELECT CAST(attrval as int) from UMUSERSPROP where componentNameId = @userId and attrName = 'Failed login attempts' and ISNUMERIC(attrVal) = 1), 0)
	END TRY
	BEGIN CATCH
        SET @userId = -1
        SET @failedLoginCount = -1
	END CATCH
END
-- -- SP BODY END : sec_incrementFailedLoginCount.spb ------------------------------------------------------------------------------------------------------------------------------
SET @o_xml =
(
	SELECT
			@failedLoginCount AS '@loginAttempts',
			(
				SELECT U.id         AS '@userId',
                       U.userGuid   AS '@userGUID',
                       U.[login]    AS '@userName'
				FROM  UMUsers U
				WHERE U.id = @userId
				FOR XML PATH('user'), TYPE
			)
	FOR XML PATH('App_IncrementUserFailedLoginAttemptsResp'), TYPE
)
SELECT @o_xml AS [o_xml]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_IncrementFailedLoginCountXML')
	delete from GxQscripts where name = 'sec_IncrementFailedLoginCountXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_IncrementFailedLoginCountXML')
	delete from GXDBVersions where aliasname = 'sec_IncrementFailedLoginCountXML'
GO

insert into GXDBVersions values(2, 'sec_IncrementFailedLoginCountXML',  '00000000000000000000', 'sec_IncrementFailedLoginCountXML', '00000000000000000000')
GO

