

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_IncrementFailedLoginCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_incrementFailedLoginCount"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_incrementFailedLoginCount')
BEGIN
	print '>>> Drop Stored Procedure: sec_incrementFailedLoginCount <<<'
	drop procedure sec_incrementFailedLoginCount
END
IF EXISTS (select * from GxQscripts where name='sec_incrementFailedLoginCount')
	delete from GxQscripts where name = 'sec_incrementFailedLoginCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_incrementFailedLoginCount')
	delete from GXDBVersions where aliasname = 'sec_incrementFailedLoginCount'
GO
print '... Creating Procedure: sec_incrementFailedLoginCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_incrementFailedLoginCount
  @username nvarchar(255)
AS
  DECLARE @userId int
  DECLARE @failedLoginCount int
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SELECT @userId = id FROM UMUSERS WITH(NOLOCK) WHERE [login] = @username
-- -- SP BODY BEGIN : sec_incrementFailedLoginCount.spb ----------------------------------------------------------------------------------------------------------------------------
IF @userId IS NOT NULL AND @userId > 0
BEGIN
    DECLARE @SPBodyCurTime_48036 INT = dbo.GetUnixTime(getUtcDate())
	BEGIN TRY
	MERGE UMUSERSPROP as target
USING (SELECT @userID ,'Failed login attempts') as source(UID, ATTRNAME)
	ON (target.componentNameId = source.UID and target.attrName = source.ATTRNAME)
	WHEN MATCHED THEN
		UPDATE SET modified = @SPBodyCurTime_48036, attrVal =
		CASE
			WHEN ISNUMERIC(attrVal) = 1 THEN convert(nvarchar(16), convert(int, attrVal) + 1)
			ELSE N'1'
		END
	WHEN NOT MATCHED THEN
INSERT(componentNameId, attrName, attrVal, attrType, created, modified ) VALUES(@userId, 'Failed login attempts', N'1', 1, @SPBodyCurTime_48036, @SPBodyCurTime_48036);
	OUTPUT:
		SET @failedLoginCount = ISNULL((SELECT CAST(attrval as int) from UMUSERSPROP where componentNameId = @userId and attrName = 'Failed login attempts' and ISNUMERIC(attrVal) = 1), 0)
	END TRY
	BEGIN CATCH
        SET @userId = -1
        SET @failedLoginCount = -1
	END CATCH
END
-- -- SP BODY END : sec_incrementFailedLoginCount.spb ------------------------------------------------------------------------------------------------------------------------------
SELECT @userId AS userId,  @failedLoginCount AS failedLoginCount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_IncrementFailedLoginCount')
	delete from GxQscripts where name = 'sec_IncrementFailedLoginCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_IncrementFailedLoginCount')
	delete from GXDBVersions where aliasname = 'sec_IncrementFailedLoginCount'
GO

insert into GXDBVersions values(2, 'sec_IncrementFailedLoginCount',  '00000000000000000000', 'sec_IncrementFailedLoginCount', '00000000000000000000')
GO

