

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetValidUserNSubclientsCombo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetValidUserNSubclientsCombo.sp,v $ $Id: sec_GetValidUserNSubclientsCombo.sp,v 1.1.2.3 2019/03/28 16:40:33 riyer Exp $";
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
--	| 			Procedure : "sec_GetValidUserNSubclientsCombo"
--	|	This procedure takes a list of user & subclient Ids and return the list of combiation based on subclients the user can view
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_GetValidUserNSubclientsCombo')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetValidUserNSubclientsCombo <<<'
	drop procedure sec_GetValidUserNSubclientsCombo
END
IF EXISTS (select * from GxQscripts where name='sec_GetValidUserNSubclientsCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNSubclientsCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNSubclientsCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNSubclientsCombo'
GO
print '... Creating Procedure: sec_GetValidUserNSubclientsCombo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetValidUserNSubclientsCombo
-- Input arguments
  @i_getAll INT,
  @i_appType INT = 0,
  @io_xml XML		OUTPUT
AS
BEGIN TRY
SET NOCOUNT ON
declare @userIter				int
declare @userCnt				int
DECLARE @xmlText        		XML
DECLARE @errorCode      		INT
DECLARE @errorMessage   		VARCHAR(MAX)
declare @i_userId				int
DECLARE @r_errors 				XML
DECLARE @r_validUserNSubclientsList 	XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
SET @xmlText = @io_xml
IF OBJECT_ID('tempdb.dbo.#tempSubclientList') IS NOT NULL
    DROP TABLE #tempSubclientList
CREATE TABLE #tempSubclientList
(
	subclientId 		int PRIMARY KEY
)
IF OBJECT_ID('tempdb.dbo.#tempUserList') IS NOT NULL
    DROP TABLE #tempUserList
CREATE TABLE #tempUserList
(
	ID		int identity,
	userId 	int
)
IF OBJECT_ID('tempdb.dbo.#tempSubclientUserVisibility') IS NOT NULL
    DROP TABLE #tempSubclientUserVisibility
CREATE TABLE #tempSubclientUserVisibility
(
	subclientId INT,
	appTypeId	INT,
	userId		INT
)
CREATE CLUSTERED INDEX ix_tempSubclientUserVisibility ON #tempSubclientUserVisibility (userId);
INSERT INTO #tempSubclientList(subclientId)
SELECT  ISNULL(ref.value('@subclientId', 'int'),0) AS scId
		FROM    @xmlText.nodes('App_UserEntityVisibilityReq/subclients') R ( ref )
INSERT INTO #tempUserList
SELECT  ISNULL(ref.value('@userId', 'int'),0) AS userId
		FROM    @xmlText.nodes('App_UserEntityVisibilityReq/users') R ( ref )
ORDER BY ref.value('@userId', 'int') ASC
set @userCnt = @@ROWCOUNT
IF OBJECT_ID('tempdb.dbo.#tempVisibleSubclientOutputTbl') IS NOT NULL
    DROP TABLE #tempVisibleSubclientOutputTbl
CREATE TABLE #tempVisibleSubclientOutputTbl
(
	clientId			int,
	instanceId			int,
	appTypeId			int,
	backupsetId			int,
	subclientId 		int
)
set @userIter = 1
while @userIter <= @userCnt
BEGIN
    select @i_userId = userId
	from #tempUserList
	where ID = @userIter
	TRUNCATE TABLE #tempVisibleSubclientOutputTbl
	exec dbo.sec_getIdaObjectsForUser @i_userId, 7, 0 /*View*/, 0, '#tempVisibleSubclientOutputTbl'
	if @i_getAll = 1	--Case 1: Get All Subclients
	begin
		if @i_appType <> 0	--case 1.1 AppType provided
		begin
			insert into #tempSubclientUserVisibility(subclientId, appTypeId, userId)
			select subclientId, appTypeId, @i_userId
			from  #tempVisibleSubclientOutputTbl
			where appTypeId = @i_appType
		end
		else				--case 1.2 AppType NOT provided
		begin
			insert into #tempSubclientUserVisibility(subclientId, appTypeId, userId)
			select subclientId, appTypeId, @i_userId
			from  #tempVisibleSubclientOutputTbl
		end
	end
	else		--Case 2: Get select subclients
	begin
		if @i_appType <> 0	--case 2.1 AppType provided
		begin
			insert into #tempSubclientUserVisibility(subclientId, appTypeId, userId)
			select A.subclientId, B.appTypeId, @i_userId
			from #tempSubclientList A inner join #tempVisibleSubclientOutputTbl B on A.subclientId = B.subclientId
			where B.appTypeId = @i_appType
		end
		else				--case 2.2 AppType NOT provided
		begin
			insert into #tempSubclientUserVisibility(subclientId, appTypeId, userId)
			select A.subclientId, B.appTypeId, @i_userId
			from #tempSubclientList A inner join #tempVisibleSubclientOutputTbl B on A.subclientId = B.subclientId
		end
	end
    SET @userIter = @userIter + 1
END
SET @r_validUserNSubclientsList =(SELECT
								(SELECT tbl.UserId AS '@userId'
								 for xml path('user'),type),
								 ( SELECT  subclientId AS '@subclientId',
										   appTypeId AS '@applicationId'
									FROM #tempSubclientUserVisibility
									WHERE UserId = tbl.userId
									FOR XML PATH('subclients'), TYPE)
							FROM #tempUserList tbl
							FOR XML PATH('userVisibleEntities'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorString'
                    FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@r_validUserNSubclientsList ,'')
                 FOR xml path(''),ROOT('App_UserEntityVisibilityResp')
               )
SET NOCOUNT OFF
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetValidUserNSubclientsCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNSubclientsCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNSubclientsCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNSubclientsCombo'
GO

insert into GXDBVersions values(2, 'sec_GetValidUserNSubclientsCombo',  '00010001000200030000', 'sec_GetValidUserNSubclientsCombo', '00010001000200030000')
GO

