

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetValidUserNServersCombo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetValidUserNServersCombo.sp,v $ $Id: sec_GetValidUserNServersCombo.sp,v 1.1.2.3 2019/03/28 16:40:43 riyer Exp $";
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
--	| 			Procedure : "sec_GetValidUserNServersCombo"
--	|	This procedure takes a list of user & server Ids and return the list of combiation based on servers the user can view
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_GetValidUserNServersCombo')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetValidUserNServersCombo <<<'
	drop procedure sec_GetValidUserNServersCombo
END
IF EXISTS (select * from GxQscripts where name='sec_GetValidUserNServersCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNServersCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNServersCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNServersCombo'
GO
print '... Creating Procedure: sec_GetValidUserNServersCombo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetValidUserNServersCombo
-- Input arguments
  @i_getAll INT,
  @i_clientGroupId INT,
  @io_xml XML		OUTPUT
AS
BEGIN TRY
SET NOCOUNT ON
declare @userIter					int
declare @userCnt					int
DECLARE @xmlText        			XML
DECLARE @errorCode      			INT
DECLARE @errorMessage   			VARCHAR(MAX)
declare @i_userId					int
declare @canView					int
DECLARE @r_errors 					XML
DECLARE @r_validUserNServersList 	XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
SET @xmlText = @io_xml
IF OBJECT_ID('tempdb.dbo.#tempUserList') IS NOT NULL
    DROP TABLE #tempUserList
CREATE TABLE #tempUserList
(
	ID		int identity,
	userId 	int
)
IF OBJECT_ID('tempdb.dbo.#tempClientList') IS NOT NULL
    DROP TABLE #tempClientList
CREATE TABLE #tempClientList
(
	clientId 	int PRIMARY KEY
)
IF OBJECT_ID('tempdb.dbo.#tempClientUserVisibility') IS NOT NULL
    DROP TABLE #tempClientUserVisibility
CREATE TABLE #tempClientUserVisibility
(
	userId		INT,
	clientId	 INT
)
CREATE CLUSTERED INDEX ix_tempClientUserVisibility ON #tempClientUserVisibility (userId);
IF OBJECT_ID('tempdb.dbo.#tempVisibleClientOutputTbl') IS NOT NULL
    DROP TABLE #tempVisibleClientOutputTbl
CREATE TABLE #tempVisibleClientOutputTbl(
	clientId INT PRIMARY KEY,
	t_appTypeId INT,
	t_instanceId INT,
	t_backupsetId INT,
	t_subclientId INT
)
INSERT INTO #tempUserList
SELECT  ISNULL(ref.value('@userId', 'int'),0) AS userId
		FROM    @xmlText.nodes('App_UserEntityVisibilityReq/users') R ( ref )
ORDER BY ref.value('@userId', 'int') ASC
set @userCnt = @@ROWCOUNT
set @userIter = 1
if @i_getAll = 1 -- Get only visibilities from certain [user/client] combinations
BEGIN
	--For each user, get the list of all visible devices
	while @userIter <= @userCnt
	BEGIN
		select @i_userId = userId
		from #tempUserList
		where ID = @userIter
		TRUNCATE TABLE #tempVisibleClientOutputTbl
exec dbo.sec_getIdaObjectsForUser @i_userId, 3, 0 /*View*/, 0, '#tempVisibleClientOutputTbl'
		--If clientGroupId is provided, remove all clients not part of provided client Id
		IF @i_clientGroupId > 0
		BEGIN
			delete A
			from  #tempVisibleClientOutputTbl A left outer join APP_ClientGroupAssoc B on A.clientId = B.clientId
			and B.ClientGroupId = @i_clientGroupId
			where b.clientGroupId IS NULL
		END
		insert into #tempClientUserVisibility(clientId, userId)
		select A.clientId, @i_userId
		from #tempVisibleClientOutputTbl A inner join App_Client C on A.clientId = C.id
		LEFT OUTER JOIN simOperatingSystem SIM ON c.simOperatingSystemId = sim.id
		where
			((c.STATUS & 0x1000 = 0) and (c.specialClientFlags = 0))
			OR (c.specialClientFlags & 0x20 = 0x20)
			OR (SIM.SubType= 'NAS' )
			OR (SIM.id in (49,118))
		SET @userIter = @userIter + 1
	END
END
ELSE
BEGIN
	INSERT INTO #tempClientList(clientId)
	SELECT  ISNULL(ref.value('@clientId', 'int'),0) AS scId
			FROM    @xmlText.nodes('App_UserEntityVisibilityReq/clients') R ( ref )
	--If clientGroupId is provided, remove all clients not part of provided client Id
	IF @i_clientGroupId > 0
	BEGIN
		delete A
		from  #tempClientList A left outer join APP_ClientGroupAssoc B on A.clientId = B.clientId
		and B.ClientGroupId = @i_clientGroupId
		where b.clientGroupId IS NULL
	END
	while @userIter <= @userCnt
	BEGIN
		select @i_userId = userId
		from #tempUserList
		where ID = @userIter
		TRUNCATE TABLE #tempVisibleClientOutputTbl
exec dbo.sec_getIdaObjectsForUser @i_userId, 3, 0 /*View*/, 0, '#tempVisibleClientOutputTbl'
		insert into #tempClientUserVisibility(clientId, userId)
		select A.clientId, @i_userId
		from #tempClientList A inner join #tempVisibleClientOutputTbl B on A.clientId = B.clientId
		inner join App_Client C on A.clientId = C.id
		LEFT OUTER JOIN simOperatingSystem SIM ON c.simOperatingSystemId = sim.id
		where
			((c.STATUS & 0x1000 = 0) and (c.specialClientFlags = 0))
			OR (c.specialClientFlags & 0x20 = 0x20)
			OR (SIM.SubType= 'NAS' )
			OR (SIM.id in (49,118))
		SET @userIter = @userIter + 1
	END
END
SET @r_validUserNServersList =(SELECT
								(SELECT tbl.UserId AS '@userId'
								 for xml path('user'),type),
								 ( SELECT  clientId AS '@clientId'
									FROM #tempClientUserVisibility WHERE UserId = tbl.userId
									FOR XML PATH('clients'), TYPE)
							FROM #tempUserList tbl
							FOR XML PATH('userVisibleEntities'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorMessage'
                    FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@r_validUserNServersList ,'')
                 FOR xml path(''),ROOT('App_UserEntityVisibilityResp')
               )
SET NOCOUNT OFF
set @io_xml = @xmlText
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetValidUserNServersCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNServersCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNServersCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNServersCombo'
GO

insert into GXDBVersions values(2, 'sec_GetValidUserNServersCombo',  '00010001000200030000', 'sec_GetValidUserNServersCombo', '00010001000200030000')
GO

