

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetValidUserNJobsCombo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetValidUserNJobsCombo.sp,v $ $Id: sec_GetValidUserNJobsCombo.sp,v 1.1.2.1 2018/12/19 23:55:01 riyer Exp $";
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
--	| 			Procedure : "sec_GetValidUserNJobsCombo"
--	|	This procedure takes a list of user & job Ids and return the list of combiation based on jobs the user can view
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_GetValidUserNJobsCombo')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetValidUserNJobsCombo <<<'
	drop procedure sec_GetValidUserNJobsCombo
END
IF EXISTS (select * from GxQscripts where name='sec_GetValidUserNJobsCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNJobsCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNJobsCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNJobsCombo'
GO
print '... Creating Procedure: sec_GetValidUserNJobsCombo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetValidUserNJobsCombo
-- Input arguments
  @i_commcellId INT,
  @io_xml XML     OUTPUT
AS
BEGIN TRY
SET NOCOUNT ON
DECLARE @xmlText                XML
DECLARE @errorCode              INT
DECLARE @errorMessage           VARCHAR(MAX)
declare @i_jobId                int
declare @i_jobRunning           int
declare @i_jobsCategory         int
DECLARE @srcClientid            INT
DECLARE @destClientid           INT
DECLARE @apptypeid              INT
DECLARE @instanceid             INT
DECLARE @backupsetid            INT
DECLARE @subclientid            INT
DECLARE @archGroupid            INT
DECLARE @opType                 INT
DECLARE @r_errors               XML
DECLARE @r_valieUserNJobsList   XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
SET @xmlText = @io_xml
IF OBJECT_ID('tempdb.dbo.#tempJobListVisibility') IS NOT NULL
    DROP TABLE #tempJobListVisibility
CREATE TABLE #tempJobListVisibility
(
    jobId       int PRIMARY KEY,
    jobCategory int,
    jobRunning  int
)
IF OBJECT_ID('tempdb.dbo.#tempUserListTbl') IS NOT NULL
    DROP TABLE #tempUserListTbl
CREATE TABLE #tempUserListTbl
(
    userId  int PRIMARY KEY
)
IF OBJECT_ID('tempdb.dbo.#tempJobUserListVisibility') IS NOT NULL
    DROP TABLE #tempJobUserListVisibility
CREATE TABLE #tempJobUserListVisibility
(
    JobId INT,
    UserId INT
)
--select @xmlText
INSERT INTO #tempJobListVisibility
SELECT  ISNULL(ref.value('@val', 'int'),0) AS jobId,
                0,
                0
        FROM    @xmlText.nodes('App_UsersJobsVisibilityReq/jobIds') R ( ref )
INSERT INTO #tempUserListTbl
SELECT  ISNULL(ref.value('@val', 'int'),0) AS userId
        FROM    @xmlText.nodes('App_UsersJobsVisibilityReq/userIds') R ( ref )
--select * from #tempJobListVisibility
--select * from #tempUserListTbl
update A
set A.jobCategory = B.jobCategory, A.jobRunning = CASE B.status WHEN 1 THEN 1 ELSE 0 END
FROM JMJobStats B inner join #tempJobListVisibility A on B.jobId = A.JobId
where commcellid = @i_commcellId
delete from #tempJobListVisibility where jobRunning = 1
DECLARE @t TABLE (userId INT, isVisible INT)
DECLARE cur CURSOR LOCAL FOR
    SELECT jobId, jobCategory FROM #tempJobListVisibility
OPEN cur
FETCH NEXT FROM cur INTO @i_jobId, @i_jobsCategory
WHILE @@FETCH_STATUS = 0 BEGIN
    -- this is a completed job.
    IF @i_jobsCategory = 1 -- this is a completed backup job
    BEGIN
        SELECT @srcClientid = App_Application.clientid, @apptypeid = App_Application.apptypeid, @instanceid = App_Application.instance, @backupsetid = App_Application.backupset, @subclientid = appId
        FROM JMBkpStats, App_Application
        WHERE jobid = @i_jobId AND commcellId = @i_commcellId AND JMBkpStats.appId = App_Application.id
        IF @@ROWCOUNT = 0
        BEGIN
            -- if the row cannot be found then return error. However if the user id matches then return true for that user
            insert into @t(userId, isVisible)
            SELECT userId, 0 AS isVisible FROM #tempUserListTbl
        END
        ELSE
        BEGIN
            -- at least one of the capabilities are needed to see a backup job
            insert into @t(userId, isVisible)
            SELECT userId, dbo.isBkpJobVisible(userId,@i_commcellId,@srcClientid,@apptypeid,@instanceid,@backupsetid,@subclientid) AS isVisible
            FROM #tempUserListTbl
        END
    END
    ELSE IF @i_jobsCategory = 2 -- this is a completed restore job
    BEGIN
        SELECT @srcClientid = srcClientid, @destClientid = destClientid, @apptypeid = apptype, @instanceid = instanceid, @backupsetid = bkpSetID FROM JMRestoreStats WHERE jobid = @i_jobId AND commcellId = @i_commcellId
        IF @@ROWCOUNT = 0
        BEGIN
            -- if the row cannot be found then return error. However if the user id matches then return true for that user
            insert into @t(userId, isVisible)
            SELECT userId, 0 AS isVisible FROM #tempUserListTbl
        END
        ELSE
        BEGIN
            -- at least one of the capabilities are needed to see a restore job
            -- the user can have rights on either the source or the destination client id
            insert into @t(userId, isVisible)
            SELECT userId, dbo.isRstJobVisible(userId,@i_commcellId,@srcClientid,@destClientId,@apptypeid,@instanceid,@backupsetid) AS isVisible
            FROM #tempUserListTbl
        END
    END
    ELSE -- this is a completed admin job
    BEGIN
        SELECT @archGroupid = archGrpId, @opType = opType, @srcClientid = ISNULL(Q.clientId, 0)
        FROM JMAdminJobStatsTable JA
        LEFT OUTER JOIN JMQinetixUpdateStatus Q ON Q.jobId = JA.jobId
        WHERE JA.jobid = @i_jobId AND JA.commcellId = @i_commcellId
        IF @@ROWCOUNT = 0
        BEGIN
            SET @archGroupid = 0
        END
        insert into @t(userId, isVisible)
        SELECT userId, dbo.isAdminJobVisible(userId,@i_commcellId,@archGroupid,@i_jobId,@opType,@srcClientid) AS isVisible
        FROM #tempUserListTbl
    END
    INSERT #tempJobUserListVisibility SELECT @i_jobId, userId FROM @t WHERE isVisible = 1
    DELETE FROM @t
    FETCH NEXT FROM cur INTO  @i_jobId, @i_jobsCategory
END
SET @r_valieUserNJobsList =(SELECT
                                (SELECT tbl.UserId AS '@userId'
                                 for xml path('user'),type),
                                 ( SELECT  JobId AS '@val'
                                    FROM #tempJobUserListVisibility WHERE UserId = tbl.UserId
                                    FOR XML PATH('jobIds'), TYPE)
                            FROM #tempUserListTbl tbl
                            FOR XML PATH('userVisbileJobs'), TYPE)
CLOSE cur
DEALLOCATE cur
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorMessage'
                    FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@r_valieUserNJobsList ,'')
                 FOR xml path(''),ROOT('App_UsersJobsVisibilityResp')
               )
SET NOCOUNT OFF
set @io_xml = @xmlText
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetValidUserNJobsCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNJobsCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNJobsCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNJobsCombo'
GO

insert into GXDBVersions values(2, 'sec_GetValidUserNJobsCombo',  '00010001000200010000', 'sec_GetValidUserNJobsCombo', '00010001000200010000')
GO

