

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetValidUserNDevicesCombo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetValidUserNDevicesCombo.sp,v $ $Id: sec_GetValidUserNDevicesCombo.sp,v 1.1.2.2 2019/01/03 11:30:34 riyer Exp $";
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
--	| 			Procedure : "sec_GetValidUserNDevicesCombo"
--	|	This procedure takes a list of user & Device Ids and return the list of combiation based on devices the user can view
-- 	+-----------------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_GetValidUserNDevicesCombo')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetValidUserNDevicesCombo <<<'
	drop procedure sec_GetValidUserNDevicesCombo
END
IF EXISTS (select * from GxQscripts where name='sec_GetValidUserNDevicesCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNDevicesCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNDevicesCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNDevicesCombo'
GO
print '... Creating Procedure: sec_GetValidUserNDevicesCombo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetValidUserNDevicesCombo
-- Input arguments
  @i_getAll INT,
  @io_xml XML		OUTPUT
AS
BEGIN TRY
SET NOCOUNT ON
declare @userIter					int
declare @userCnt					int
DECLARE @xmlText        			XML
DECLARE @errorCode      			INT
DECLARE @errorMessage   			VARCHAR(MAX)
declare @i_userId					int
declare @canView					int
DECLARE @r_errors 					XML
DECLARE @r_validUserNDevicesList 	XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
set @errorCode = 0
set @errorMessage = ''
SET @xmlText = @io_xml
IF OBJECT_ID('tempdb.dbo.#tempUserList') IS NOT NULL
    DROP TABLE #tempUserList
CREATE TABLE #tempUserList
(
	ID		int identity,
	userId 	int
)
IF OBJECT_ID('tempdb.dbo.#tempClientList') IS NOT NULL
    DROP TABLE #tempClientList
CREATE TABLE #tempClientList
(
	clientId 	int PRIMARY KEY
)
IF OBJECT_ID('tempdb.dbo.#tempClientUserVisibility') IS NOT NULL
    DROP TABLE #tempClientUserVisibility
CREATE TABLE #tempClientUserVisibility
(
	userId		INT,
	clientId	 INT
)
IF OBJECT_ID('tempdb.dbo.#tempVisibleClientOutputTbl') IS NOT NULL
    DROP TABLE #tempVisibleClientOutputTbl
CREATE TABLE #tempVisibleClientOutputTbl(
	clientId INT PRIMARY KEY,
	t_appTypeId INT,
	t_instanceId INT,
	t_backupsetId INT,
	t_subclientId INT
)
INSERT INTO #tempUserList
SELECT  ISNULL(ref.value('@userId', 'int'),0) AS userId
		FROM    @xmlText.nodes('App_UserEntityVisibilityReq/users') R ( ref )
set @userIter = 1
set @userCnt = @@IDENTITY
if @i_getAll = 1 -- Get only visibilities from certain [user/client] combinations
BEGIN
	--For each user, get the list of all visible devices
	while @userIter <= @userCnt
	BEGIN
		select @i_userId = userId
		from #tempUserList
		where ID = @userIter
		delete from #tempVisibleClientOutputTbl
exec dbo.sec_getIdaObjectsForUser @i_userId, 3, 0 /*View*/, 0, '#tempVisibleClientOutputTbl'
		insert into #tempClientUserVisibility(clientId, userId)
		select A.clientId, @i_userId
		from #tempVisibleClientOutputTbl A inner join App_Client C on A.clientId = C.id
		where c.STATUS & 0x1000 = 0x1000
		order by clientId
		SET @userIter = @userIter + 1
	END
END
ELSE
BEGIN
	INSERT INTO #tempClientList(clientId)
	SELECT  ISNULL(ref.value('@clientId', 'int'),0) AS scId
			FROM    @xmlText.nodes('App_UserEntityVisibilityReq/clients') R ( ref )
	--Retain only laptop clients
	delete A
	from #tempClientList A inner join App_Client C on A.clientId = C.id
	where c.STATUS & 0x1000 = 0
	while @userIter <= @userCnt
	BEGIN
		select @i_userId = userId
		from #tempUserList
		where ID = @userIter
		delete from #tempVisibleClientOutputTbl
exec dbo.sec_getIdaObjectsForUser @i_userId, 3, 0 /*View*/, 0, '#tempVisibleClientOutputTbl'
		insert into #tempClientUserVisibility(clientId, userId)
		select A.clientId, @i_userId
		from #tempClientList A inner join #tempVisibleClientOutputTbl B on A.clientId = B.clientId
		SET @userIter = @userIter + 1
	END
END
SET @r_validUserNDevicesList =(SELECT
								(SELECT tbl.UserId AS '@userId'
								 for xml path('user'),type),
								 ( SELECT  clientId AS '@clientId'
									FROM #tempClientUserVisibility WHERE UserId = tbl.userId
									FOR XML PATH('clients'), TYPE)
							FROM #tempUserList tbl
							FOR XML PATH('userVisibleEntities'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode     = ERROR_NUMBER()
    SET @errorMessage  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SEND_RESPONSE:
SET @r_errors = (SELECT @errorCode   AS '@errorCode',
                        @errorMessage AS '@errorMessage'
                    FOR xml PATH('error'))
SET @xmlText = ( SELECT  ISNULL(@r_errors,'') , ISNULL(@r_validUserNDevicesList ,'')
                 FOR xml path(''),ROOT('App_UserEntityVisibilityResp')
               )
SET NOCOUNT OFF
set @io_xml = @xmlText
SELECT @xmlText as out_xml
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetValidUserNDevicesCombo')
	delete from GxQscripts where name = 'sec_GetValidUserNDevicesCombo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetValidUserNDevicesCombo')
	delete from GXDBVersions where aliasname = 'sec_GetValidUserNDevicesCombo'
GO

insert into GXDBVersions values(2, 'sec_GetValidUserNDevicesCombo',  '00010001000200020000', 'sec_GetValidUserNDevicesCombo', '00010001000200020000')
GO

