

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetUserOrGroupNames.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetUserOrGroupNames.sp,v $ $Id: sec_GetUserOrGroupNames.sp,v 1.1.2.4 2018/03/20 00:04:29 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_GetUserOrGroupNames"				|
--	|									|
-- 	+-----------------------------------------------------------------------+
DECLARE @typeId as int = ISNULL((select TYPE_Id('dbo.IdNameList')), 0)
SELECT typeId=@typeId
IF @typeId = 0
CREATE TYPE dbo.IdNameList AS TABLE
(
    id      integer,
    name    varchar(1024)
)
GO
-- Following Line Indicates new Class.  It should be identical to filename!
-- table has 2 columns col1: type ( commcell user/group/ ad user/group ) col2: guid
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_GetUserOrGroupNames <<<'

IF EXISTS (select * from sysobjects where name='sec_GetUserOrGroupNames')
	drop procedure sec_GetUserOrGroupNames
IF EXISTS (select * from GxQscripts where name='sec_GetUserOrGroupNames')
	delete from GxQscripts where name = 'sec_GetUserOrGroupNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetUserOrGroupNames')
	delete from GXDBVersions where aliasname = 'sec_GetUserOrGroupNames'
GO
print '... Creating Procedure: sec_GetUserOrGroupNames'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_GetUserOrGroupNames
  @tblguids dbo.IdNameList READONLY,
  @fillEmptyUserNameAsGuid INT = 1
AS
SET NOCOUNT ON
	CREATE TABLE #tmpTable ( guid varchar(max), name varchar(max), type INT)
	INSERT INTO #tmpTable select  name , '', ISNULL(Id,0) from @tblguids
	-- fill commcell/External user name from UMUsers table.
	--type = 3 commcell user 4 = external user
	UPDATE #tmpTable  SET name = U.login, type= CASE u.umDSProviderId WHEN 0 THEN 3 ELSE 4 END
	FROM #tmpTable T
	INNER JOIN UMUsers U WITH (NOLOCK) ON U.userGuid = T.guid AND u.enabled = 1
	where  T.name='' AND T.type in ( 3,4,0)
	-- fill commcell/External group name from UMGroups table.
	--type = 1 commcell group 2 = external user
	UPDATE #tmpTable  SET name = U.name, type= CASE u.umDSProviderId WHEN 0 THEN 1 ELSE 2 END
	FROM #tmpTable T
	INNER JOIN UMGroups U WITH (NOLOCK)  ON U.GUID = T.guid
	where  T.name='' AND  T.type in ( 1,2,0)
	-- this will fill users/groups which are not in UM*** table
	--fill external user/group from APP_GUID table
	--since we dont know the type here ( user or group) , we dont fill type
	UPDATE #tmpTable  SET name = U.name
	FROM #tmpTable T
	INNER JOIN APP_GUID U WITH (NOLOCK)  ON U.GUID = '{'+T.guid+'}' AND U.status=4
	where T.name=''  AND  T.type in ( 2,4,0)
	--update name with guid if we cannot find the info from DB and if caller asks so
	IF @fillEmptyUserNameAsGuid = 1
	BEGIN
	Update #tmpTable SET name = guid where name=''
	END
	select guid, name, type from #tmpTable
	IF object_id('tempdb.dbo.#tmpTable') is not null
		DROP table #tmpTable
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetUserOrGroupNames')
	delete from GxQscripts where name = 'sec_GetUserOrGroupNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetUserOrGroupNames')
	delete from GXDBVersions where aliasname = 'sec_GetUserOrGroupNames'
GO

insert into GXDBVersions values(2, 'sec_GetUserOrGroupNames',  '00010001000200040000', 'sec_GetUserOrGroupNames', '00010001000200040000')
GO

