

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetUserAndGroupSuggestions.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_GetUserAndGroupSuggestions()
--  | Description:
--  | Output: DM2ContentIndexing.CvEventUsers
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetUserAndGroupSuggestions.sp,v $ $Id: sec_GetUserAndGroupSuggestions.sp,v 1.4.52.27 2020/12/24 10:57:37 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_GetUserAndGroupSuggestions')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetUserAndGroupSuggestions <<<'
	drop procedure sec_GetUserAndGroupSuggestions
END
IF EXISTS (select * from GxQscripts where name='sec_GetUserAndGroupSuggestions')
	delete from GxQscripts where name = 'sec_GetUserAndGroupSuggestions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetUserAndGroupSuggestions')
	delete from GXDBVersions where aliasname = 'sec_GetUserAndGroupSuggestions'
GO
print '... Creating Procedure: sec_GetUserAndGroupSuggestions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_GetUserAndGroupSuggestions
  @i_NamePattern nvarchar(100),
  @i_GetUsersFlag int = 1,
  @i_GetGroupsFlag int = 1,
  @i_PageSize int = 5,
  @i_SearchOnAlias int = 0,
  @i_SearchOnDisplayName int = 1,
  @i_SearchOnSmtp int = 1,
  @i_IgnoreSmtpRule int = 0,
  @i_ExactMatch int = 0,
  @i_GetOrganizationUsers int = 0,
  @i_loggedInUser int = 1,
  @i_BlackListedDomains nvarchar(max) = '',
  @i_reqserviceCommcell int =0,
  @i_serviceCommcellName nvarchar(512)='',
  @i_returnDomain int =0,
  @i_domainName nvarchar(512) = '',
  @i_requestedProviderType int = -1,
  @i_getAllTenantGroups int = 0
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @CCGroupEntityType INT
	DECLARE @CCUserEntityType INT
	DECLARE @csHostName NVARCHAR(255)
    --
	SELECT @CCGroupEntityType = EntryValue FROM DCReference WITH(NOLOCK)
	WHERE TypeName = 'SecuredEntity' AND EntryName = 'CommCellGroup'
    --
	SELECT @CCUserEntityType = EntryValue FROM DCReference WITH(NOLOCK)
	WHERE TypeName = 'SecuredEntity' AND EntryName = 'CommCellUser'
    --
	SELECT @csHostName = net_hostname FROM APP_CLIENT WITH(NOLOCK) WHERE id = 2
    --
	DECLARE @DynamicWhereConditions NVARCHAR(MAX) = ''
	DECLARE @FinalSQL NVARCHAR(MAX) = ''
	DECLARE @ArgDef NVARCHAR(MAX) = '@i_NamePattern nvarchar(100), @CCUserEntityType int, @CCGroupEntityType int, @i_PageSize int, @i_GetGroupsFlag int, @i_GetUsersFlag int, @csHostName NVARCHAR(255),@i_GetOrganizationUsers int'
	IF @i_ExactMatch = 0
		SET @i_NamePattern = @i_NamePattern + '%'
	if @i_SearchOnDisplayName = 1
	BEGIN
		SET @DynamicWhereConditions = 'U.name LIKE @i_NamePattern'
	END
	if @i_SearchOnSmtp = 1
	BEGIN
		IF @DynamicWhereConditions <> ''
			SET @DynamicWhereConditions += ' OR '
		SET @DynamicWhereConditions += 'U.email like @i_NamePattern'
	END
	if @i_SearchOnAlias = 1
	BEGIN
		IF @DynamicWhereConditions <> ''
			SET @DynamicWhereConditions += ' OR '
		SET @DynamicWhereConditions += 'U.login like @i_NamePattern'
	END
	IF @DynamicWhereConditions = ''
	BEGIN
		--if caller not supplied what to search on, then we won't return any data.
		SET @DynamicWhereConditions = '(1 = 2)'
	END
	ELSE
	BEGIN
		SET @DynamicWhereConditions = '(' + @DynamicWhereConditions + ')' + CASE WHEN @i_IgnoreSmtpRule = 0 THEN ' AND ISNULL(U.email,'''') <> '''' ' ELSE '' END
	END
    IF OBJECT_ID('tempdb.dbo.#sec_getVisibileUsersForThisUsers') IS NOT NULL
	    DROP TABLE #sec_getVisibileUsersForThisUsers
    CREATE TABLE #sec_getVisibileUsersForThisUsers
    (
        userId int primary key
    )
		IF OBJECT_ID('tempdb.dbo.#RoleForThisUsers') IS NOT NULL
	    DROP TABLE #RoleForThisUsers
    CREATE TABLE #RoleForThisUsers
    (
        userOrGroupId int ,
		isUSer int,
		roleId int,
		roleName nvarchar(510)
    )
    --change the localOrExternalUser input of below call once org + non domain commcell users support is added into sec_getUsersForThisUser sp.
    EXEC sec_getUsersForThisUser #sec_getVisibileUsersForThisUsers, @i_loggedInUser , 0 , 0
	IF OBJECT_ID('tempdb.dbo.#sec_getVisibleUserGroupsForThisUser') IS NOT NULL
		DROP TABLE #sec_getVisibleUserGroupsForThisUser
	CREATE TABLE #sec_getVisibleUserGroupsForThisUser
	(
		groupId INT primary key
	)
	--
	IF OBJECT_ID('tempdb.dbo.#BlackListedDomains') IS NOT NULL
	BEGIN
		DROP TABLE #BlackListedDomains
	END
	--
	CREATE TABLE #BlackListedDomains(DomainName nvarchar(512))
	--
	insert into #BlackListedDomains (DomainName)
	SELECT Data FROM dbo.SplitString(@i_BlackListedDomains, ',')
	EXEC sec_getUserGroupsForThisUser #sec_getVisibleUserGroupsForThisUser,@i_loggedInUser, 0, 0, @includeAllTenantGroups = @i_getAllTenantGroups
	-- filter by providerId
	IF @i_domainName <> ''
	BEGIN
		DECLARE @providerId INT = (SELECT id FROM UMDSProviders WHERE domainName = @i_domainName)
		IF @providerId IS NOT NULL
		BEGIN
			DELETE #sec_getVisibileUsersForThisUsers
			FROM #sec_getVisibileUsersForThisUsers vu INNER JOIN UMUsers u on vu.userId = u.id
			INNER JOIN UMDSProviders umdsp ON u.umDSproviderId = umdsp.id
WHERE umdsp.id <> @providerId AND (umdsp.ownerCompany <> @providerId OR umdsp.serviceType = 5)
			DELETE #sec_getVisibleUserGroupsForThisUser
			FROM #sec_getVisibleUserGroupsForThisUser vug INNER JOIN UMGroups umg ON vug.groupId = umg.id
			INNER JOIN UMDSProviders umdsp ON umg.umdsProviderId = umdsp.id
WHERE umdsp.id <> @providerId AND (umdsp.ownerCompany <> @providerId OR umdsp.serviceType = 5)
		END
		ELSE
		BEGIN -- no matching domain is found, return nothing
			DELETE FROM #sec_getVisibileUsersForThisUsers
			DELETE FROM #sec_getVisibleUserGroupsForThisUser
		END
	END
	IF @i_requestedProviderType <> -1
	BEGIN
		DECLARE @providerTypeTable TABLE (type INT)
IF (@i_requestedProviderType & 0x1) > 0
		BEGIN
INSERT INTO @providerTypeTable VALUES (1)
		END
IF (@i_requestedProviderType & 0x2) > 0
		BEGIN
	IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
		DROP TABLE #TFASupportedADServiceTypesTempTable
	CREATE TABLE #TFASupportedADServiceTypesTempTable (serviceType INT)
	-- TFA support: AD, openldap, oracle ldap, apple ldap, jump cloud and Generic LDAP
	INSERT INTO #TFASupportedADServiceTypesTempTable
VALUES (2), (6), (8),
(9), (10), (14)
			INSERT INTO @providerTypeTable
			SELECT serviceType FROM #TFASupportedADServiceTypesTempTable
		END
IF (@i_requestedProviderType & 0x4) > 0
		BEGIN
INSERT INTO @providerTypeTable VALUES (5)
		END
		DELETE #sec_getVisibileUsersForThisUsers
		FROM #sec_getVisibileUsersForThisUsers vu INNER JOIN UMUsers u on vu.userId = u.id
		INNER JOIN UMDSProviders umdsp ON u.umDSproviderId = umdsp.id
		WHERE umdsp.serviceType NOT IN (SELECT type FROM @providerTypeTable)
		DELETE #sec_getVisibleUserGroupsForThisUser
		FROM #sec_getVisibleUserGroupsForThisUser vug INNER JOIN UMGroups umg ON vug.groupId = umg.id
		INNER JOIN UMDSProviders umdsp ON umg.umdsProviderId = umdsp.id
		WHERE umdsp.serviceType NOT IN (SELECT type FROM @providerTypeTable)
	END
	IF(@i_reqserviceCommcell =1)
	BEGIN
	--security will be implied only for company users and group.
	--so first lets get company AD and company providerid
DECLARE @viewRoleID INT = ISNULL((SELECT TOP 1 id FROM UMRoles (NOLOCK) WHERE (name = 'View') AND (flags & 1 | 2 <> 0)), 0)
DECLARE @roleName NVARCHAR(510) = 'View'
	DECLARE @commcellId INT = ISNULL((select id from  APP_Commcell where aliasName=@i_serviceCommcellName),0)
	DECLARE @companyProviderTable TABLE ( providerId  INT,ownerCompany Int  , hasRights INT DEFAULT 0 )
	INSERT INTO @companyProviderTable
	SELECT  id,ownercompany , CASE WHEN UMSecurityAssociations.userORGroupID IS NULL THEN 0 ELSE 1 END
	FROM UMDSPROVIDERS LEFT JOIN UMSecurityAssociations
ON (entityType1=194 AND entityId1=@commcellId and id=userORGroupId and isUSer=2)
	WHERE serviceType=5 OR OwnerCompany<>0
	UPDATE TBL
	SET TBL.hasRights =1
	FROM @companyProviderTable  TBL JOIN  @companyProviderTable Ownercompany  ON TBL.ownerCompany = Ownercompany.providerid and Ownercompany.hasRights=1
	INSERT INTO #RoleForThisUsers
	SELECT DISTINCT groupId,0,@viewRoleID,@roleName
	FROM #sec_getVisibleUserGroupsForThisUser  JOIN UMGRoups G  ON groupID=G.id
	LEFT JOIN @companyProviderTable ON umdsproviderid =providerID
	WHERE providerId is null OR hasRights=1
	INSERT INTO #RoleForThisUsers
	SELECT DISTINCT userId,1,@viewRoleID,@roleName
	 FROM #sec_getVisibileUsersForThisUsers  JOIN UMUsers U ON userID=U.id
	 LEFT JOIN   @companyProviderTable ON umdsproviderid =providerID
	WHERE providerId is null OR hasRights=1
	TRUNCATE TABLE #sec_getVisibleUserGroupsForThisUser
	TRUNCATE TABLE #sec_getVisibileUsersForThisUsers
	INSERT INTO #sec_getVisibileUsersForThisUsers
	SELECT DISTINCT userORGroupId FROM #RoleForThisUsers where isUSer=1
	INSERT INTO #sec_getVisibleUserGroupsForThisUser
	SELECT DISTINCT userORGroupId FROM #RoleForThisUsers where isUSer=0
	END
	IF OBJECT_ID('tempdb.dbo.#Sec_getProvidersNewTbl')  IS NOT NULL
                 DROP TABLE #Sec_getProvidersNewTbl
             CREATE TABLE  #Sec_getProvidersNewTbl  (
                 providerId  INT PRIMARY KEY
             )
	IF(@i_returnDomain=1)
	BEGIN
		EXEC sec_getNameServersForThisUser '#Sec_getProvidersNewTbl', @i_loggedInUser, 0
	END
	--Get user groups and user of service type 0(local), 2(AD) and 5(organization)
	SET @FinalSQL = '
		SELECT
		(
			SELECT userGuid ''@userGuid'', aliasName ''@aliasName'', loginName ''@loginName'', displayName ''@displayName'', smtpAddress ''@smtpAddress'',
			entityType ''@entityType'', userId ''@userId'', id ''@groupId'', objectGuid ''@groupGuid'',
			providerId ''@umEntityId'',providerGUID ''@umGuid'', umEntity ''@umEntityType'', serviceType ''@providerType'',
				(SELECT roleId as ''@val'' from #RoleForThisUsers WHERE (userOrGroupId=userId and isUSer=1 ) OR (userOrGroupId=id and  isUSer=0) FOR XML PATH(''role''),TYPE),
			(SELECT roleId as ''@roleId'' , roleName as ''@roleName'' from #RoleForThisUsers WHERE (userOrGroupId=userId and isUSer=1 ) OR (userOrGroupId=id and  isUSer=0) FOR XML PATH(''roleEntity''),TYPE)
			FROM
			(
				SELECT TOP (@i_PageSize) '''' userGuid, G.name aliasName, case when UP.id>0 then UP.domainname+''\''+G.name else G.name end loginName, G.name displayName, '''' smtpAddress,
				@CCGroupEntityType entityType, 0 userId, G.id id, CONVERT(NVARCHAR(256), G.GUID) objectGuid,0 providerId,'''' providerGUID,13 as umEntity, UP.serviceType
				FROM UMGroups G WITH(NOLOCK)
				JOIN #sec_getVisibleUserGroupsForThisUser VisibleUserGroupsForThisUser on G.id = VisibleUserGroupsForThisUser.groupId
				JOIN UMDSProviders UP WITH(NOLOCK) ON G.umDSproviderId = UP.id AND UP.Enabled = 1
				LEFT JOIN #BlackListedDomains BL ON UP.DomainName = BL.DomainName
WHERE BL.DomainName IS NULL AND @i_GetGroupsFlag = 1 AND (G.umDSproviderId = 0 OR UP.serviceType = 5  OR (UP.serviceType = 2 OR UP.serviceType = 14 OR UP.serviceType = 10 OR UP.serviceType = 9 OR UP.serviceType = 8 OR UP.serviceType = 6 OR UP.serviceType = 7 OR UP.serviceType = 12))
				AND (UP.domainName like @i_NamePattern OR UP.domainName+''\''+G.name like @i_NamePattern
				OR G.name like @i_NamePattern)
			UNION
				SELECT TOP (@i_PageSize) U.userGuid userGuid, U.login aliasName, U.login loginName, U.name displayName,
				(CASE WHEN ISNULL(U.email,'''') = '''' THEN U.login + ''@'' + @csHostName ELSE U.email END) smtpAddress,
				@CCUserEntityType as entityType, U.id userId, 0 id, U.userGuid objectGuid ,0 providerId ,'''' providerGUID,15 as umEntity, UP.serviceType
				FROM UMUsers U WITH(NOLOCK)
				JOIN #sec_getVisibileUsersForThisUsers VisibleUsersForThisUsers ON U.id = VisibleUsersForThisUsers.userId
				JOIN UMDSProviders UP WITH(NOLOCK) ON U.umDSproviderId = UP.id AND UP.Enabled = 1
				LEFT JOIN #BlackListedDomains BL ON UP.DomainName = BL.DomainName
				WHERE BL.DomainName IS NULL AND @i_GetUsersFlag = 1
AND ((@i_GetOrganizationUsers = 1 AND UP.serviceType = 5) OR U.umDSproviderId = 0  OR (UP.serviceType = 2 OR UP.serviceType = 14 OR UP.serviceType = 10 OR UP.serviceType = 9 OR UP.serviceType = 8 OR UP.serviceType = 6 OR UP.serviceType = 7 OR UP.serviceType = 12 ))
					AND U.enabled = 1
					AND ' + @DynamicWhereConditions  + '
			UNION
				SELECT TOP (@i_PageSize) '''' userGuid, P.domainName aliasName, P.domainName loginName, P.domainName  displayName, '''' smtpAddress,
61 entityType, 0 userId, 0 id, '''' objectGuid ,     P.id providerId,  CONVERT(NVARCHAR(256), P.GUID)  providerGUID,61 as umEntity, P.serviceType
			FROM UMDSProviders P JOIN #Sec_getProvidersNewTbl ON id=providerId
WHERE P.domainName like @i_NamePattern and serviceType <> 11 AND ownerCompany=0
			) UT
			FOR XML PATH(''users''), TYPE, ROOT(''DM2ContentIndexing_CvEventUsers'')
		) AS OutputXML
	'
	-- PRINT (@FinalSQL)
	exec sp_executesql @FinalSQL, @ArgDef,
	@i_NamePattern = @i_NamePattern,
	@CCUserEntityType = @CCUserEntityType,
	@CCGroupEntityType = @CCGroupEntityType,
	@i_PageSize = @i_PageSize,
	@i_GetGroupsFlag = @i_GetGroupsFlag,
	@i_GetUsersFlag = @i_GetUsersFlag,
	@csHostName = @csHostName,
	@i_GetOrganizationUsers = @i_GetOrganizationUsers
	--
	IF OBJECT_ID('tempdb.dbo.#sec_getVisibileUsersForThisUsers') IS NOT NULL
	BEGIN
	    DROP TABLE #sec_getVisibileUsersForThisUsers
	END
	IF OBJECT_ID('tempdb.dbo.#sec_getVisibleUserGroupsForThisUser') IS NOT NULL
	BEGIN
		DROP TABLE #sec_getVisibleUserGroupsForThisUser
	END
	IF OBJECT_ID('tempdb.dbo.#BlackListedDomains') IS NOT NULL
	BEGIN
		DROP TABLE #BlackListedDomains
	END
	IF OBJECT_ID('tempdb.dbo.#TFASupportedADServiceTypesTempTable') IS NOT NULL
	BEGIN
		DROP TABLE #TFASupportedADServiceTypesTempTable
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetUserAndGroupSuggestions')
	delete from GxQscripts where name = 'sec_GetUserAndGroupSuggestions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetUserAndGroupSuggestions')
	delete from GXDBVersions where aliasname = 'sec_GetUserAndGroupSuggestions'
GO

insert into GXDBVersions values(2, 'sec_GetUserAndGroupSuggestions',  '00010004005200270000', 'sec_GetUserAndGroupSuggestions', '00010004005200270000')
GO

