

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetLockedAccounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "sec_UnlockUserAccount"
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_GetLockedAccounts')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetLockedAccounts <<<'
	drop procedure sec_GetLockedAccounts
END
IF EXISTS (select * from GxQscripts where name='sec_GetLockedAccounts')
	delete from GxQscripts where name = 'sec_GetLockedAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetLockedAccounts')
	delete from GXDBVersions where aliasname = 'sec_GetLockedAccounts'
GO
print '... Creating Procedure: sec_GetLockedAccounts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetLockedAccounts
AS
DECLARE @accountLockedDuration int
DECLARE @failedLoginAttemptLimit int
DECLARE @currentTimeUnix int
SET @accountLockedDuration = ISNULL((SELECT CAST(VALUE as int) from GXGlobalParam where name = 'AccountLockDuration' and ISNUMERIC(value) = 1), 0)
SET @failedLoginAttemptLimit = ISNULL((SELECT CAST(VALUE as int) from GXGlobalParam where name = 'FailedLoginAttemptLimit' and ISNUMERIC(value) = 1),0)
SET @currentTimeUnix = ISNULL(DATEDIFF(second,'01/01/1970', GETUTCDATE()), 0)
SET NOCOUNT ON
SELECT U.id as USERID, P.modified as LOCKTIME, login as LOGIN from UMUsers U with(nolock) join UMUsersProp P with(nolock)
ON U.id = P.componentNameId
WHERE attrName = 'Failed login attempts' and attrVal > 0 and attrVal >= @failedLoginAttemptLimit and @currentTimeUnix - P.modified < @accountLockedDuration
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetLockedAccounts')
	delete from GxQscripts where name = 'sec_GetLockedAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetLockedAccounts')
	delete from GXDBVersions where aliasname = 'sec_GetLockedAccounts'
GO

insert into GXDBVersions values(2, 'sec_GetLockedAccounts',  '00000000000000000000', 'sec_GetLockedAccounts', '00000000000000000000')
GO

