

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetClientSuggestions.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_GetClientSuggestions()
--  | Description:  	Get clients on which specified user has requested capability and matching (starting with given) name(s).
--  | Output: 		Return client name and Id
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetClientSuggestions.sp,v $ $Id: sec_GetClientSuggestions.sp,v 1.1.2.5 2018/10/22 19:47:00 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_GetClientSuggestions')
BEGIN
	print '>>> Drop Stored Procedure: sec_GetClientSuggestions <<<'
	drop procedure sec_GetClientSuggestions
END
IF EXISTS (select * from GxQscripts where name='sec_GetClientSuggestions')
	delete from GxQscripts where name = 'sec_GetClientSuggestions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetClientSuggestions')
	delete from GXDBVersions where aliasname = 'sec_GetClientSuggestions'
GO
print '... Creating Procedure: sec_GetClientSuggestions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetClientSuggestions
  @i_UserId int,
  @i_Capability int = 31, /* Default to view (EV_VISIBILITY = 31) permission */
  @i_MatchString nvarchar(max) = '',
  @i_startIndex int = 1,
  @i_pageSize int = 10,
  @i_ExactMatch int = 0
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @endIndex int
	--
	IF @i_pageSize IS NULL SET @i_pageSize = 10
	IF @i_startIndex IS NULL SET @i_startIndex = 1
	--
	IF @i_Capability IS NULL OR NOT EXISTS (SELECT 1 FROM UMCapability WHERE id = @i_Capability)
	BEGIN
SET @i_Capability = 31 -- default to View (31) if value not given or does not match a valid one in DB.
	END
	--
	SELECT @i_pageSize = CASE WHEN (@i_pageSize <= 0) THEN 10
							ELSE @i_pageSize
							END,
			@i_startIndex = CASE WHEN (@i_startIndex % 10 = 0) THEN @i_startIndex + 1
							ELSE @i_startIndex
							END;
	--
	SELECT @endIndex = @i_startIndex + @i_pageSize
	--
	IF @i_ExactMatch = 0
	BEGIN
		if @i_MatchString is null
			set @i_MatchString = '%'
		else
		begin
			set @i_MatchString = REPLACE(@i_MatchString, '%', '[%]') + '%'
		end
	END
	--
	IF OBJECT_ID('tempdb.dbo.#PermittedClientList') IS NOT NULL
	BEGIN
		DROP TABLE #PermittedClientList
	END
	--
	CREATE TABLE #PermittedClientList  (
		ClientId INT PRIMARY KEY
	);
	--
	-- Table to be used by SP sec_getIdaObjectsForUser
	--
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
	--
	CREATE TABLE #ClientsOutputTable
	(
	clientID INT,
	appTypeId INT,
	instanceId INT,
	backupsetID INT,
	subclientId INT
	)
	--
	-- Fetch any clients even if any sub client is allowed under that client for the logged-in user
	-- This behavior of inheriting permission from child also can be changed as per input in future if needed
	--
EXEC sec_getIdaObjectsForUser @i_UserId, 3, @i_Capability, 1, '#ClientsOutputTable'
	--
	-- Capture distinct allowed clients list
	--
	INSERT INTO #PermittedClientList
    SELECT DISTINCT ClientId FROM #ClientsOutputTable
	--
	-- delete rows of pseudo clients which we do not need
	--
	DELETE A
      FROM #PermittedClientList A
                  INNER JOIN
            APP_ClientProp AS CP ON A.ClientId = CP.componentNameId
WHERE attrName = 'Index Server Type' AND modified = 0 AND attrVal IN (15,8)
	--
	IF @i_ExactMatch = 1
	BEGIN
		SELECT A.name, A.id FROM APP_Client A
		JOIN dbo.split(@i_MatchString, ',') T ON A.name = T.Data
		JOIN #PermittedClientList P ON P.ClientId = A.id
	END
	ELSE
	BEGIN
		SELECT  TOP (@i_pageSize) A.name, A.id
		FROM APP_Client A
			JOIN #PermittedClientList T ON A.id = T.ClientId
			WHERE A.name like @i_MatchString
			order by a.name
	END
	--
	-- cleanup temp tables
	--
	IF OBJECT_ID('tempdb.dbo.#PermittedClientList') IS NOT NULL
	BEGIN
		DROP TABLE #PermittedClientList
	END
	IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
	BEGIN
		DROP TABLE #ClientsOutputTable
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetClientSuggestions')
	delete from GxQscripts where name = 'sec_GetClientSuggestions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetClientSuggestions')
	delete from GXDBVersions where aliasname = 'sec_GetClientSuggestions'
GO

insert into GXDBVersions values(2, 'sec_GetClientSuggestions',  '00010001000200050000', 'sec_GetClientSuggestions', '00010001000200050000')
GO

