

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_GetClientGroupsForUser.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_GetClientGroupsForUser()
--  | Description:  Fetch list of client groups that given user has view permissoins.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_GetClientGroupsForUser.sp,v $ $Id: sec_GetClientGroupsForUser.sp,v 1.1.2.4 2018/03/27 08:56:03 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_GetClientGroupsForUser <<<'

IF EXISTS (select * from sysobjects where name='sec_GetClientGroupsForUser')
	drop procedure sec_GetClientGroupsForUser
IF EXISTS (select * from GxQscripts where name='sec_GetClientGroupsForUser')
	delete from GxQscripts where name = 'sec_GetClientGroupsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetClientGroupsForUser')
	delete from GXDBVersions where aliasname = 'sec_GetClientGroupsForUser'
GO
print '... Creating Procedure: sec_GetClientGroupsForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_GetClientGroupsForUser
  @i_CaseManagerId int,
  @i_sortOrder VARCHAR(10) = 'asc',
  @i_offset int = 0,
  @i_PageSize int = -1,
  @i_searchText nvarchar(255) = '',
  @i_HonorSortingAndPaging int = 1,
  @o_TotalCount int = 0 OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--
	-- create temp table to hold all allowed client groups if it is not already created by caller
	--
	DECLARE @GroupTblLocal int = 0
	SET @i_SearchText = @i_SearchText + '%'
	IF OBJECT_ID('tempdb.dbo.#sec_CMClientGroups') IS NULL
	BEGIN
		SET @GroupTblLocal = 1
		CREATE TABLE #sec_CMClientGroups ( entityId INT)
	END
	ELSE
	BEGIN
		--if already created, start with clean table
		DELETE FROM #sec_CMClientGroups
	END
EXEC sec_getNonIdaObjectsForThisUser @i_CaseManagerId, 28 /*CLIENT_GROUP_ENTITY (28) */ , 31 /* 31 (31) */ ,'#sec_CMClientGroups'
	--When call is nested via stored procedures, caller is just interested to collect groups into temp table
	--so no need to return another data table by sorting and paging in that case.
	if @i_HonorSortingAndPaging = 1
	BEGIN
		;WITH CTE
		AS
		(
		SELECT A.ID, A.name, ROW_NUMBER() OVER (ORDER BY
		CASE WHEN @i_SortOrder = 'ASC' THEN A.NAME END ASC,
		CASE WHEN @i_SortOrder = 'DESC' THEN A.NAME END DESC
		) RowNum
		FROM APP_ClientGroup A, #sec_CMClientGroups B
		WHERE A.id = B.entityId AND A.name like @i_SearchText
		GROUP BY A.ID, A.name
		)
		SELECT * FROM CTE WHERE @i_PageSize <= 0 OR (@i_PageSize > 0 AND RowNum > @i_Offset and RowNum <= @i_Offset + @i_PageSize)
		SELECT @o_TotalCount = @@ROWCOUNT
		-- if valid page size was given, we have to return total number of records so that UI can do paging based on that value
		--
		IF @i_PageSize > 0
		BEGIN
			SELECT @o_TotalCount = COUNT(DISTINCT a.id) FROM APP_ClientGroup A, #sec_CMClientGroups B WHERE A.id = B.entityId AND A.name like @i_SearchText
		END
	END
	IF @GroupTblLocal = 1
	BEGIN
		DROP TABLE #sec_CMClientGroups
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_GetClientGroupsForUser')
	delete from GxQscripts where name = 'sec_GetClientGroupsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_GetClientGroupsForUser')
	delete from GXDBVersions where aliasname = 'sec_GetClientGroupsForUser'
GO

insert into GXDBVersions values(2, 'sec_GetClientGroupsForUser',  '00010001000200040000', 'sec_GetClientGroupsForUser', '00010001000200040000')
GO

