

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_FetchUserSessionDetails.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_FetchUserSessionDetails()
--  | Description:
--  | Output: User session details such as sessionid, username, userguid, hostname etc.
--  +========================================================================+
-- dataServer_h_rcsid[]=":PARAM(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_FetchUserSessionDetails.sp,v $ $Id: sec_FetchUserSessionDetails.sp,v 1.1.4.2 2018/05/03 14:53:09 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_FetchUserSessionDetails <<<'

IF EXISTS (select * from sysobjects where name='sec_FetchUserSessionDetails')
	drop procedure sec_FetchUserSessionDetails
IF EXISTS (select * from GxQscripts where name='sec_FetchUserSessionDetails')
	delete from GxQscripts where name = 'sec_FetchUserSessionDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_FetchUserSessionDetails')
	delete from GXDBVersions where aliasname = 'sec_FetchUserSessionDetails'
GO
print '... Creating Procedure: sec_FetchUserSessionDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_FetchUserSessionDetails
  @SessionID varchar(36),
  @WebConsoleClientType int = 19,
  @WebConsoleSiteMode int = 4,
  @OutlookAddinClientType int = 15,
  @EndUserClientType int = 25,
  @EndUserSiteMode int = 1,
  @ComplianceSearchClientType int = 26,
  @ComplianceSiteMode int = 2,
  @SearchAdminClientType int = 27,
  @SearchAdminSiteMode int = 3
AS
BEGIN
SELECT B.userGuid, B.login AS UserName, timeout AS TimeOutInMin, CONVERT(VARCHAR(36), GUID) AS SessionID, hostName AS IP, dbo.GetDateTime(created) CreateTime, dbo.GetDateTime(lastAccessedTime) LastAccessTime,
CASE WHEN consoleType = @WebConsoleClientType THEN @WebConsoleSiteMode
WHEN consoleType IN (@OutlookAddinClientType, @EndUserClientType) THEN @EndUserSiteMode
WHEN consoleType = @ComplianceSearchClientType THEN @ComplianceSiteMode
WHEN consoleType = @SearchAdminClientType THEN @SearchAdminSiteMode
ELSE 0 END as SiteMode
FROM UMQSDKSessions A WITH(NOLOCK)
JOIN UMUsers B WITH(NOLOCK) ON A.userId = B.id
WHERE A.GUID = @SessionID AND B.enabled = 1
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_FetchUserSessionDetails')
	delete from GxQscripts where name = 'sec_FetchUserSessionDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_FetchUserSessionDetails')
	delete from GXDBVersions where aliasname = 'sec_FetchUserSessionDetails'
GO

insert into GXDBVersions values(2, 'sec_FetchUserSessionDetails',  '00010001000400020000', 'sec_FetchUserSessionDetails', '00010001000400020000')
GO

