

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_FetchGuidsBySmtp.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_FetchGuidsBySmtp()
--  | Description:  Get user-smtp to userGUIDs association for list of users
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_FetchGuidsBySmtp.sp,v $ $Id: sec_FetchGuidsBySmtp.sp,v 1.4.12.2 2018/04/30 18:33:11 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_FetchGuidsBySmtp <<<'

IF EXISTS (select * from sysobjects where name='sec_FetchGuidsBySmtp')
	drop procedure sec_FetchGuidsBySmtp
IF EXISTS (select * from GxQscripts where name='sec_FetchGuidsBySmtp')
	delete from GxQscripts where name = 'sec_FetchGuidsBySmtp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_FetchGuidsBySmtp')
	delete from GXDBVersions where aliasname = 'sec_FetchGuidsBySmtp'
GO
print '... Creating Procedure: sec_FetchGuidsBySmtp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_FetchGuidsBySmtp
  @i_xmlText XML 
AS
BEGIN
	SET QUOTED_IDENTIFIER ON
	SET NOCOUNT ON
	--Declarations
	DECLARE @CV_APPGUID_STATUSBIT_PRIMARYSMTP    INT = 0x08
	DECLARE @CV_APPGUID_STATUSBIT_ALTERNATESMTP	 INT = 0x02
	DECLARE @CV_APPGUID_STATUSBIT_DISPLAYNAME	 INT = 0x01
	DECLARE @CV_APPGUID_STATUSBIT_ALTERNATESMTP2	 INT = 0x100
	DECLARE @debug BIT = 0
	--Create necessary temporary tables
	IF OBJECT_ID('tempdb.dbo.#UsersTemp') is not null
		DROP TABLE #UsersTemp
	CREATE TABLE #UsersTemp
	(
		SmtpAddress nvarchar(255) not null
	)
	CREATE TABLE #UserMatches (
		UserGUID nvarchar(1024) not null,
		SmtpAddress nvarchar(255) not null,
		DisplayName nvarchar(1024) null,
		RawGUID nvarchar(1024) not null
	)
	--Populate temporary tables with input values
	;WITH InputCTE
	AS
	(
	SELECT dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@smtpAddress', 'nvarchar(255)'), '')) smtpAddress
	FROM @i_xmlText.nodes('/DM2ContentIndexing_CvEventUsers/users') T(ref)
	)
	INSERT INTO #UsersTemp (SmtpAddress)
	SELECT smtpAddress FROM InputCte
	WHERE smtpAddress IS NOT NULL
	-- IF no inputs, nothing to find, just exit..
	IF @@ROWCOUNT = 0
		GOTO exitLine
	--Find matching SMTP in UMUsers table and insert matches in temp table
	INSERT INTO #UserMatches (UserGUID, SmtpAddress, DisplayName, RawGUID)
	SELECT U.userGuid, T.SmtpAddress, U.name, '{' + u.userGuid + '}'
	FROM #UsersTemp T
	JOIN UMUsers U WITH(NOLOCK) ON T.SmtpAddress = U.email
	WHERE ISNULL(U.userGuid,'') <> '' AND enabled = 1 AND U.umDSproviderId > 0
	--Find match using APP_GUID and insert matches in temp table
	INSERT INTO #UserMatches (UserGUID, SmtpAddress, RawGUID)
	SELECT REPLACE(REPLACE(A.GUID, '{', ''), '}', ''), T.SmtpAddress, A.GUID
	FROM #UsersTemp T
	JOIN APP_GUID A WITH(NOLOCK) ON T.SmtpAddress = A.name
	AND (A.status = @CV_APPGUID_STATUSBIT_PRIMARYSMTP OR A.status = @CV_APPGUID_STATUSBIT_ALTERNATESMTP OR A.status = @CV_APPGUID_STATUSBIT_ALTERNATESMTP2)
	--
	UPDATE T
	SET T.DisplayName = NAME
	FROM #UserMatches T
	JOIN APP_GUID A WITH(NOLOCK) ON T.RawGUID = A.GUID AND A.status = @CV_APPGUID_STATUSBIT_DISPLAYNAME
	WHERE T.DisplayName IS NULL
	--
	--Return result from temporary table..
	SELECT DISTINCT T.UserGUID AS '@userGuid', T.SmtpAddress AS '@smtpAddress', T.DisplayName '@displayName' FROM #UserMatches T
	FOR XML PATH('users'), ROOT('DM2ContentIndexing_CvEventUsers')
	exitLine:
	if @debug = 1
	SELECT *, 'ResultEntry' FinalOutput FROM #UsersTemp
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_FetchGuidsBySmtp')
	delete from GxQscripts where name = 'sec_FetchGuidsBySmtp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_FetchGuidsBySmtp')
	delete from GXDBVersions where aliasname = 'sec_FetchGuidsBySmtp'
GO

insert into GXDBVersions values(2, 'sec_FetchGuidsBySmtp',  '00010004001200020000', 'sec_FetchGuidsBySmtp', '00010004001200020000')
GO

