

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_EditRole.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Procedure: sec_EditRole
--  |
--  | Description:
--  |  Called for editing one role - generates a Generic Entity Response
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jagadeesh & Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_EditRole')
BEGIN
	print '>>> Drop Stored Procedure: sec_EditRole <<<'
	drop procedure sec_EditRole
END
IF EXISTS (select * from GxQscripts where name='sec_EditRole')
	delete from GxQscripts where name = 'sec_EditRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_EditRole')
	delete from GXDBVersions where aliasname = 'sec_EditRole'
GO
print '... Creating Procedure: sec_EditRole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_EditRole
  @xmlIn XML,
  @userId INT,
  @isCmdLine INT,
  @o_xml XML OUTPUT,
  @isReturn INT = 0,
  @skipFlagCheck INT = 0
AS
  DECLARE @xmlOut XML
--Sample inputs
/*SET @xmlIn = '<Security_Role status="0" visibility="0" description="Changing description">
	<role roleId="8" roleName="test"/>
	<categoryPermission categoriesPermissionOperationType="2">
		<categoriesPermissionList _type_="CV_CATEGORY_TYPE" categoryId="1"/>
		<categoriesPermissionList _type_="CV_PERMISSION_TYPE" permissionId="2" categoryId="1">
			<flags exclude="1"/>
		</categoriesPermissionList>
	</categoryPermission>
</Security_Role>'
SET @userId = 1
SET @isCmdLine = 1
SET @optype = 3 */
DECLARE @errorCode AS BIGINT
DECLARE @errorString AS NVARCHAR(1000)
SET @errorCode = 0
SET @errorString = 'Successful'
--Local variables
DECLARE @description AS NVARCHAR(1024)
DECLARE @visibility AS INT
DECLARE @roleName AS NVARCHAR(1024)
DECLARE @disabled AS INT
DECLARE @nowTime AS INT
DECLARE @roleId AS INT
DECLARE @localeId AS INT
DECLARE @hasPermission INT =0
DECLARE @isPrivate INT =0
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
SET @roleId = ISNULL((SELECT ref.value('@roleId', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role/role') R (ref)),'')
SET @roleName = ISNULL((SELECT ref.value('@roleName', 'NVARCHAR(MAX)') AS role
						FROM @xmlIn.nodes('Security_Role/role') R (ref)),'')
SET @localeId = ISNULL((SELECT ref.value('@localeId', 'INT') AS role
					  FROM @xmlIn.nodes('Security_Role/processinginstructioninfo/locale') R (ref)), 0)
IF @roleId = 0
BEGIN
SET @errorCode = (2421 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2421 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', @roleName)
	GOTO END_PROCESSING
END
--First check if any role property has been changed, then do security checks. If not changed return, user could have only set security associations for role for which security check will be done in cpp layer.
--Get old Role properties from DB
DECLARE @oldDescription AS NVARCHAR(1024)
DECLARE @oldRoleName AS NVARCHAR(1024)
DECLARE @oldDisabled AS INT
DECLARE @oldIsPrivate AS INT
SELECT @oldDescription=description,@oldRoleName=name,@oldDisabled=disabled,@oldIsPrivate=isPrivate FROM UMRoles WHERE id = @roleId
--1. UMRoles properties
--If some field is not set, let us not unset it from DB, may be the user dont want to modify it
SET @description = ISNULL((SELECT ref.value('@description', 'NVARCHAR(MAX)') AS role
						FROM @xmlIn.nodes('Security_Role')R (ref)),(SELECT description FROM UMRoles WHERE id = @roleId))
SET @visibility = ISNULL((SELECT ref.value('@visibility', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role')R (ref)),(SELECT isPrivate^1 FROM UMRoles WHERE id = @roleId))
SET @roleName = ISNULL((SELECT ref.value('@roleName', 'NVARCHAR(MAX)') AS role
					FROM @xmlIn.nodes('Security_Role/role') R (ref)),(SELECT name FROM UMRoles WHERE id = @roleid))
SET @disabled = ISNULL((SELECT ref.value('@disabled', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role/role/flags') R (ref)), (SELECT disabled FROM UMRoles WHERE id = @roleId))
IF @roleName = '' OR @roleName IS NULL
BEGIN
SET @errorCode = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO END_PROCESSING
END
IF @visibility=1
	SET @isPrivate=0
ELSE
	SET @isPrivate=1
DECLARE @categoryPermissionExists AS INT = 0
DECLARE @categoryPermissionInputXML AS XML
DECLARE @categoriesPermissionOperationType AS INT = 0
IF (@xmlIn.exist('Security_Role/categoryPermission') <> 0)
BEGIN
	SET @categoryPermissionExists = 1
	SET @categoryPermissionInputXML = (SELECT @xmlIn.query('Security_Role/categoryPermission'))
	SET @categoriesPermissionOperationType = ISNULL((SELECT ref.value('@categoriesPermissionOperationType','INT') AS role
							FROM @categorypermissioninputxml.nodes('categoryPermission') R (ref)), 1)
END
IF ((@oldDescription = @description) AND (@roleName = @oldRoleName) AND (@disabled = @oldDisabled) AND (@categoriesPermissionOperationType NOT IN (1, 2, 3))
AND (@oldIsPrivate=@isPrivate))
BEGIN
	GOTO END_PROCESSING
END
IF @skipFlagCheck = 0					--System created non-editable roles like client owner roles can be edited from the code base but not from GUI
BEGIN									--so when they are coming from code base they will come with the skipFlagCheck set to "true"
IF @roleId IN (SELECT DISTINCT ID FROM UMRoles WHERE flags & 1 <> 0)
	BEGIN
SET @errorCode = (2422 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2422 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @roleName)
		GOTO END_PROCESSING
	END
END
--security check to edit roles.
IF NOT EXISTS(SELECT 1 FROM UMRoles WHERE flags & 32 <>0 and id=@roleId)
DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @userId, 242, @userHasRight OUTPUT, 120, @roleId
IF @userHasRight = 0
BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@userId))
SET @errorString = REPLACE(@errorString, '^2%s', dbo.sec_getLocalizedPermission(242, @localeId))
	SET @errorString = REPLACE(@errorString, '^3%s', (SELECT name FROM UMRoles WHERE id = @roleId))
SET @errorString = REPLACE(@errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (3044 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
	GOTO END_PROCESSING
END
IF(@oldIsPrivate<>@isPrivate)
BEGIN
--privacy level is changed.
EXEC sec_checkPermissionOnEntity @userId, 107, @userHasRight OUTPUT, 1, 2
IF @userHasRight = 0
BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
    SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
    GOTO END_PROCESSING
END
END
--1. UMRoles properties
--If some field is not set, let us not unset it from DB, may be the user dont want to modify it
SET @description = ISNULL((SELECT ref.value('@description', 'NVARCHAR(MAX)') AS role
						FROM @xmlIn.nodes('Security_Role')R (ref)),(SELECT description FROM UMRoles WHERE id = @roleId))
SET @visibility = ISNULL((SELECT ref.value('@visibility', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role')R (ref)),(SELECT isPrivate FROM UMRoles WHERE id = @roleId))
SET @roleName = ISNULL((SELECT ref.value('@roleName', 'NVARCHAR(MAX)') AS role
					FROM @xmlIn.nodes('Security_Role/role') R (ref)),(SELECT name FROM UMRoles WHERE id = @roleid))
SET @disabled = ISNULL((SELECT ref.value('@disabled', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role/role/flags') R (ref)), (SELECT disabled FROM UMRoles WHERE id = @roleId))
BEGIN TRY
--2. UMRolesPermissions list
IF (@categoryPermissionExists <> 0)
BEGIN
	if object_id('tempdb.dbo.#categoryPermissionAssociationFromInput') is not null
		DROP TABLE #categoryPermissionAssociationFromInput
	if object_id('tempdb.dbo.#categoryPermissionAssociationConsolidated') is not null
		DROP TABLE #categoryPermissionAssociationConsolidated
	--From input
	CREATE TABLE #categoryPermissionAssociationFromInput
	(
		[hierarchyLevel] INT,
		[categoryId] INT,
		[categoryName] nvarchar(1024),
		[permissionId] INT,
		[permissionName] nvarchar(1024),
		[excludeCategory] INT,
		[excludePermission] INT
	)
	--After consolidating along with existing UMRolesPermissions
	CREATE TABLE #categoryPermissionAssociationConsolidated
	(
		[hierarchyLevel] INT,
		[categoryId] INT,
		[categoryName] nvarchar(1024),
		[permissionId] INT,
		[permissionName] nvarchar(1024),
		[excludeCategory] INT,
		[excludePermission] INT,
		[shouldInsert] INT
	)
IF OBJECT_ID ('tempdb.dbo.#UMRolesPermissionExpandedTempTable') IS  NULL
CREATE TABLE #UMRolesPermissionExpandedTempTable
    (
        roleId integer,
        categoryId integer,
        permissionId integer
    )
	DECLARE @idoc AS INT
	EXEC sp_xml_preparedocument @idoc OUTPUT, @categoryPermissionInputXML
	IF (@xmlIn.exist('Security_Role/categoryPermission/categoriesPermissionList') <> 0)
		INSERT INTO #categoryPermissionAssociationFromInput (hierarchyLevel, categoryId, categoryName, permissionId, permissionName, excludeCategory, excludePermission)
		SELECT hierarchyLevel,
				ISNULL(categoryid,0),
				ISNULL(categoryName,''),
				ISNULL(permissionid,0),
				ISNULL(permissionName,''),
				CASE
WHEN hierarchyLevel = 121 THEN ISNULL(exclude,0)
					ELSE 0
				END,
				CASE
WHEN hierarchyLevel = 122 THEN ISNULL(exclude,0)
					ELSE 0
				END
		FROM OPENXML(@idoc, '/categoryPermission/categoriesPermissionList',0)
		WITH (hierarchyLevel int '@_type_',
				categoryid int '@categoryId',
				permissionid int '@permissionId',
				exclude int 'flags/@exclude',
				permissionName nvarchar(1024) '@permissionName',
				categoryName nvarchar(1024) '@categoryName')
	EXEC  sp_xml_removedocument @idoc
	--In some cases (like when creating owner roles for VM clients) only permissionId is filled in input xml
	--We need to fill category id before inserting in UMRolesPermissions table, so manually filling them here
	--Check if role is associated to any entity
	DECLARE @isRoleAssociated INT =0
	DECLARE @oldPermissions TABLE (permissionId INT)
	IF EXISTS(SELECT 1 FROM UMSEcurityAssociations where roleId=@roleId)
	BEGIN
		--there is some entities and user/userGroup has this role association, so now we need to check if user has all the permissions on the associated entities.
		--lets get list of permission changed
		--Lets get old permissionId list from UMRolesPermissionsExpanded.
		SET @isRoleAssociated =1
		INSERT INTO @oldPErmissions
		SELECT permissionId
		from UMRolesWithPermissionsExpanded where roleId=@roleId
	END
	UPDATE Tbl
	SET Tbl.categoryId = Perm.categoryId
	FROM #categoryPermissionAssociationFromInput Tbl INNER JOIN UMPermissions Perm
	ON Tbl.permissionId = Perm.id
	WHERE Tbl.permissionId <> 0
	IF @categoriesPermissionOperationType = 1			--overwrite
	BEGIN
		INSERT INTO #categoryPermissionAssociationConsolidated
			SELECT hierarchyLevel, categoryId, categoryName,permissionId, permissionName,excludeCategory, excludePermission, 0
			FROM #categoryPermissionAssociationFromInput
	END
	IF @categoriesPermissionOperationType = 2			--add
	BEGIN
		INSERT INTO #categoryPermissionAssociationConsolidated
			SELECT hierarchyLevel, categoryId, '',permissionId, '',excludeCategory, excludePermission, 0
			FROM #categoryPermissionAssociationFromInput
			UNION
			SELECT hierarchyLevel, categoryId, '',permissionId, '',excludeCategory, excludePermission, 0
			FROM UMRolesPermissions
			WHERE roleId = @roleId
	END
	IF @categoriesPermissionOperationType = 3			--delete
	BEGIN
		INSERT INTO #categoryPermissionAssociationConsolidated
			SELECT hierarchyLevel, categoryId, '',permissionId, '',excludeCategory, excludePermission, 0
			FROM UMRolesPermissions
			WHERE roleId = @roleId
			EXCEPT
			SELECT hierarchyLevel, categoryId, '',permissionId, '',excludeCategory, excludePermission, 0
			FROM #categoryPermissionAssociationFromInput
	END
	DELETE FROM #categoryPermissionAssociationConsolidated
WHERE	((hierarchyLevel = 121 AND categoryId = 0 AND categoryName = '' AND permissionId = 0 AND permissionName = '') OR
(hierarchyLevel = 122 AND categoryId = 0 AND categoryName = '' AND permissionId = 0 AND permissionName = ''))
	--if the request is from cmdline, we need to do some validation
	IF @isCmdLine = 1
	BEGIN
		EXEC sec_validatePermissionList  @localeId, @errorCode OUTPUT, @errorString OUTPUT
		IF @errorCode <> 0
				GOTO END_PROCESSING
	END
	ELSE
	BEGIN
		UPDATE #categoryPermissionAssociationConsolidated
		SET shouldInsert = 1
	END
	IF @categoriesPermissionOperationType IN (1, 2, 3)			--alter the tables only if a valid operation type is passed
	BEGIN														--else dont touch them
		--Whatever is in consolidated table, insert into UMRolesPermissions irrespective of categoriesPermissionOperationType
		DELETE FROM UMRolesPermissions
		WHERE roleId = @roleId
		INSERT INTO UMRolesPermissions
			SELECT @roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission
			FROM #categoryPermissionAssociationConsolidated
			WHERE shouldInsert = 1
		EXEC sec_expandRoleWithPermissions @roleId, @errorCode OUTPUT, @errorString OUTPUT,1
	END
	--lets get old disabled value and new one.
	--its needed only for non custom roles..
IF NOT EXISTS(SELECT 1 FROM UMRoles WHERE flags & 32 <>0 and id=@roleId)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
			  DROP TABLE #permissionIdTable
		CREATE TABLE #permissionIdTable (permissionId INT)
		IF(@isRoleAssociated=1)
		BEGIN
				IF(@oldDisabled<> @disabled)
				BEGIN
					--role state is changed, so lets put every permission
					INSERT INTO #permissionIdTable
					SELECT  permissionId from @oldPermissions
				END
				ELSE
				BEGIN
					INSERT INTO #permissionIdTable
					SELECT permissionId FROM @oldPErmissions
					EXCEPT
SELECT permissionId FROM #UMRolesPermissionExpandedTempTable
					INSERT INTO #permissionIdTable
SELECT permissionId FROM #UMRolesPermissionExpandedTempTable
					EXCEPT
					SELECT permissionId FROM @oldPErmissions
				END
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF EXISTS(SELECT 1 from #permissionIdTable)
BEGIN
IF NOT EXISTS(SELECT 1 FROM #permissionIdTable where permissionId=107)
	BEGIN
		INSERT INTO #permissionIdTable
VALUES(107)
	END
	 DECLARE @entityType1 INT,@entityId1 INT,
			@entityType2 INT,@entityId2 INT,
			@entityType3 INT,@entityId3 INT,
			@entityType4 INT,@entityId4 INT,
			@entityType5 INT,@entityId5 INT
	DECLARE @errorPerimssionString VARCHAR(MAX)
	  IF OBJECT_ID('tempdb.dbo.#sec_checkPermissionList') IS NOT NULL
                DROP TABLE #sec_checkPermissionList
    CREATE TABLE #sec_checkPermissionList (permissionId INT)
	  DECLARE AssociatedEntitiesWithRoleCursor CURSOR STATIC FOR
      SELECT DISTINCT Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5
      FROM UMSecurityAssociations Sec WITH(NOLOCK)   where roleId=@roleId
	  OPEN AssociatedEntitiesWithRoleCursor
      FETCH NEXT FROM AssociatedEntitiesWithRoleCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
	   WHILE @@FETCH_STATUS = 0
       BEGIN
                DELETE FROM #sec_checkPermissionList
                EXEC sec_getPermissionsOnEntity '#sec_checkPermissionList', @userId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5,0,1
IF NOT EXISTS (SELECT * FROM #sec_checkPermissionList WHERE permissionId = 107)
				 BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
						EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @errorPerimssionString OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
						SET @errorString = REPLACE(@errorString, '^2%s', @errorPerimssionString)
						CLOSE AssociatedEntitiesWithRoleCursor
					    DEALLOCATE AssociatedEntitiesWithRoleCursor
						GOTO END_PROCESSING
				END
				IF EXISTS(SELECT 1 FROM #permissionIdTable Input where Input.permissionId not in (SELECT sec.permissionId from #sec_checkPermissionList sec))
				BEGIN
SET @errorCode = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
                    SET @errorPerimssionString = (SELECT ISNULL(SUBSTRING((SELECT ',' +  dbo.sec_getLocalizedPermission(Input.permissionId, @localeId)
                                                                 FROM #permissionIdTable Input where Input.permissionId not in (SELECT sec.permissionId from #sec_checkPermissionList sec)
                                                                FOR XML PATH('')), 2, 2147483647), ''))
                    SET @errorString = REPLACE(@errorString, '^1%s', @errorPerimssionString)
                    EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @errorPerimssionString OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
                    SET @errorString = REPLACE(@errorString, '^2%s', @errorPerimssionString)
					CLOSE AssociatedEntitiesWithRoleCursor
					DEALLOCATE AssociatedEntitiesWithRoleCursor
                    GOTO END_PROCESSING
				END
                FETCH NEXT FROM AssociatedEntitiesWithRoleCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
            END
            CLOSE AssociatedEntitiesWithRoleCursor
            DEALLOCATE AssociatedEntitiesWithRoleCursor
   END
			END
		END
		IF @categoriesPermissionOperationType IN (1, 2, 3)
		BEGIN
IF NOT EXISTS(SELECT 1 FROM UMRoles WHERE flags & 32 <>0 and id=@roleId)
			BEGIN
				DELETE UMRolesWithPermissionsExpanded
				WHERE roleId = @roleId
			   INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)
			   SELECT @roleId , categoryId,permissionId
FROM #UMRolesPermissionExpandedTempTable
			END
		 END
	END
		UPDATE UMRoles
		SET disabled = @disabled, description = @description, isPrivate = @isPrivate, name = @roleName, modified = @nowTime
		WHERE id = @roleId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode = ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
END CATCH
END_PROCESSING:
SET @xmlout = (SELECT @errorCode AS '@errorCode',
					  @errorString AS '@errorString',
					  (SELECT @roleId AS '@roleId',
							  @roleName AS '@roleName'
					   FOR XML PATH('entity'),TYPE)
FOR XML PATH('App_GenericEntityResponse'))
SET @o_xml =@xmlOut
IF(@isReturn<>0)
	SELECT @xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'sec_EditRole')
	delete from GxQscripts where name = 'sec_EditRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_EditRole')
	delete from GXDBVersions where aliasname = 'sec_EditRole'
GO

insert into GXDBVersions values(2, 'sec_EditRole',  '00000000000000000000', 'sec_EditRole', '00000000000000000000')
GO

