

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_DoesUserHaveRightsOnEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_DoesUserHaveRightsOnEntity.sp,v $ $Id: sec_DoesUserHaveRightsOnEntity.sp,v 1.14.42.4 2020/10/04 00:51:02 abilbrey Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_DoesUserHaveRightsOnEntity()
--  |
--  | Description:  SP version for validating whether an user has permissions on an entity.
--	|				Intended to be called by SPs for retrieving properties for new Xml framework
--  |
--  |       Input:  Entity string , Userid, Locale , capability
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_DoesUserHaveRightsOnEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_DoesUserHaveRightsOnEntity <<<'
	drop procedure sec_DoesUserHaveRightsOnEntity
END
IF EXISTS (select * from GxQscripts where name='sec_DoesUserHaveRightsOnEntity')
	delete from GxQscripts where name = 'sec_DoesUserHaveRightsOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_DoesUserHaveRightsOnEntity')
	delete from GXDBVersions where aliasname = 'sec_DoesUserHaveRightsOnEntity'
GO
print '... Creating Procedure: sec_DoesUserHaveRightsOnEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_DoesUserHaveRightsOnEntity
  @i_xml XML,
  @userId integer, 
  @capability integer,
  @inheritFromChildren integer,
  @i_localeId integer,
  @errorString NVARCHAR(1024) OUTPUT
AS
	SET QUOTED_IDENTIFIER ON
	set @errorString = ''
	declare @xmlModifiedString nvarchar(max)
	declare @xml xml
	set @xmlModifiedString = Convert(nvarchar(max),@i_xml)
	set @xmlModifiedString = '<Root>'+@xmlModifiedString+'</Root>'
	set @xml = @xmlModifiedString
	declare @commcellId integer
	declare @clientId integer
	declare	@appTypeId integer
	declare @instanceId integer
	declare @backupSetId integer
	declare @subclientId integer
	declare @treeType integer
	declare @nodeCapabilities bigint
	declare @childCapabilities bigint
	declare @errorCode int
	DECLARE @cursorFlag 	INTEGER
	declare @clientGroupId	integer
	declare @type1 integer
	declare @type2 int
	declare @type3 int
	declare @type4 int
	declare @id1 int
	declare @id2 int
	declare @id3 int
	declare @id4 int
	set @nodeCapabilities = 0
	set @childCapabilities = 0
	set @cursorFlag = 0
	DECLARE @iDoc				integer
	exec sp_xml_preparedocument @iDoc OUTPUT, @xml
	--set transaction isolation level read uncommitted
	declare @sec_NodeIdaAccessOutput table
	(
		UserIDVal int,
		nodeCapabilities bigint,
		childCapabilities bigint
	)
	set @commcellId = IsNull((select * from OPENXML(@iDoc, 'Root/entity', 2)
							WITH (commCellId int '@commCellId')),2)
	set @clientId = IsNull((select * from OPENXML(@iDoc, '/Root/entity', 0)
							WITH (clientId int '@clientId')),0)
	set @appTypeId = IsNull((select * from OPENXML(@iDoc, 'Root/entity', 0)
							WITH (applicationId int '@applicationId')),0)
	set @instanceId = IsNull((select * from OPENXML(@iDoc, 'Root/entity', 0)
							WITH (instanceId int '@instanceId')),0)
	set @backupSetId = IsNull((select * from OPENXML(@iDoc, 'Root/entity', 0)
							WITH (backupsetId int '@backupsetId')),0)
	set @subclientId = IsNull((select * from OPENXML(@iDoc, 'Root/entity', 0)
							WITH (subclientId int '@subclientId')),0)
	set @clientGroupId = IsNull((select * from OPENXML(@iDoc, 'Root/entity', 0)
							WITH (clientGroupId int '@clientGroupId')),0)
	--select @clientId,@appTypeId,@instanceId,@backupSetId,@subclientId
	-- First force the credentials to be updated
	-- Do we need this?
	--exec [dbo].[sec_updateUserCredentials]
	--	@userId , 1
	if @clientId>0
	begin
		Insert into @sec_NodeIdaAccessOutput
		exec dbo.sec_iDaNodeAccess @userId,
			@commcellId,
			@clientId,
			@appTypeId,
			@instanceId,
			@backupSetId,
			@subclientId
		set @treeType = Isnull(( select treeType from APP_iDAType
			where type = @appTypeId),1)
set @type1 = 2009
set @type2 = 2230
set @type3 = 2012
set @type4 = 2013
		set @id1 = @clientId
		set @id2 = @appTypeId
		set @id3 = @backupSetId
		set @id4 = @subclientId
if @treeType=2
		begin
set @type3 = 2011
			set @id3 = @instanceId
set @type4 = 2012
			set @id4 = @backupSetId
		end
else if @treeType=3
		begin
set @type3 = 2011
			set @id3 = @instanceId
set @type4 = 2013
			set @id4 = @subclientId
		end
	end
	else
	begin
		-- Call to check permissions for non - ida node access
		declare @val integer
		if (@clientGroupId>0)
		begin
set @type1 =  2572 --_SERVER_GROUP_NAME_ITEM
			set @val = @clientGroupId
		end
		else
		begin
set @type1 =  2018 --_COMM_CELL_ITEM
			set @val = @commcellId
		end
		Insert into @sec_NodeIdaAccessOutput
		exec dbo.sec_NoNiDaNodeAccess @userId,@commcellId,@type1,@val
	end
	declare @hasAssociations bigint
	declare @hasRights bigint
	select @nodeCapabilities = nodeCapabilities,
			@childCapabilities = childCapabilities
		from @sec_NodeIdaAccessOutput
		where UserIDVal = @userId
	if exists(
		select *
		 from @sec_NodeIdaAccessOutput
		where UserIDVal = @userId
	)
	begin
		set @hasAssociations = 1
	end
	if @hasAssociations=1
	begin
		if (@capability=0)
		begin
			set @hasRights = 1
		end
		else
		begin
			set @hasRights = @nodeCapabilities & power(2,@capability -1)
		end
		if @hasRights=0 and @inheritFromChildren=1
		begin
			set @hasRights = @childCapabilities & power(2,@capability -1)
		end
	end
	-- If there are no associations then we say User doesnt have privilege on this item.
	if @hasRights>0
	begin
		return
	end
	-- Format the response and return to user
	declare @userName nvarchar(max)
	set @userName = IsNull((select CASE WHEN name <> '' THEN name ELSE login END from UMUsers where id = @userId),'')
  	if (len(@userName)=0)
	begin
		set @errorString = 'Invalid Login'
		return
	end
	declare @capabilityName nvarchar(max)
	if @capability!=0
	begin
		set @capabilityName = IsNull((select name from UMCapability where id = @capability),'')
  		if (len(@capabilityName)=0)
		begin
			set @errorString = 'Invalid Capability'
			return
		end
	end
	else
	begin
		set @capabilityName = 'View'
	end
	declare @iType int
	if (@id4 != 0)
	begin
		set @iType = @type4
	end
	else if (@id3 != 0)
	begin
		set @iType = @type3
	end
	else if (@id2 != 0)
	begin
		set @iType = @type2
	end
	else if (@id1 != 0)
	begin
		set @iType = @type1
	end
	if (@type1 = 0)
	begin
set @iType = 2018
	end
	declare @objMessType bigint
if (@iType=2230)
	begin
set @objMessType = (1004 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2231)
	begin
set @objMessType = (1005 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2012)
	begin
set @objMessType = (1006 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2009)
	begin
set @objMessType = (1007 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2018)
	begin
set @objMessType = (1008 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2240)
	begin
set @objMessType = (1009 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2011)
	begin
set @objMessType = (1010 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2049)
	begin
set @objMessType = (1011 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=9615)
	begin
set @objMessType = (1994 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2048)
	begin
set @objMessType = (1012 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2142)
	begin
set @objMessType = (1010 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2572)
	begin
set @objMessType = (1013 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=2013)
	begin
set @objMessType = (1014 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=8107)
	begin
set @objMessType = (1179 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=8180)
	begin
set @objMessType = (1180 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
else if (@iType=8462)
	begin
set @objMessType = (1181 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
        else
	begin
set @objMessType = (1015 | (CAST(POWER(2, 24) AS BIGINT) * 35));
	end
	--event.evPrintf(objMessType, objectName, 4104-10);
	declare @objectName nvarchar(max)
	set @objectName = dbo.fn_EvFormatEventMsgText(0,@i_localeId, @objMessType, 0,@commcellId)
	--event << name;							-- User [^1%s] does not have required capability [^2%s] for this ^3%s and this operation.
	--event << capability;
	--event << objectName;
	--event.evPrintf(GUIMSG_SECURITY_USER_CAPABILITY, uMsgBuf, sizeof (uMsgBuf)-1);
set @errorString = (select message from EvLocaleMsgs Where messageId=(462 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @i_localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', @userName)
	SET @errorString = REPLACE(@errorString, '^2%s',
		dbo.fn_EvFormatEventMsgText(0,@i_localeId,
			IsNull((Select tokenId from UMCapability where id = @capability),
				(Select tokenId from UMCapability where id = 31)),
		0,2))
	SET @errorString = REPLACE(@errorString, '^3%s', @objectName)
	return
GO

IF EXISTS (select * from GxQscripts where name = 'sec_DoesUserHaveRightsOnEntity')
	delete from GxQscripts where name = 'sec_DoesUserHaveRightsOnEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_DoesUserHaveRightsOnEntity')
	delete from GXDBVersions where aliasname = 'sec_DoesUserHaveRightsOnEntity'
GO

insert into GXDBVersions values(2, 'sec_DoesUserHaveRightsOnEntity',  '00010014004200040000', 'sec_DoesUserHaveRightsOnEntity', '00010014004200040000')
GO

