

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_DeleteRole.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Procedure: sec_DeleteRole
--  |
--  | Description:
--  |  Called for deleting one role - generates a Generic Entity Response
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jagadeesh & Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_DeleteRole')
BEGIN
	print '>>> Drop Stored Procedure: sec_DeleteRole <<<'
	drop procedure sec_DeleteRole
END
IF EXISTS (select * from GxQscripts where name='sec_DeleteRole')
	delete from GxQscripts where name = 'sec_DeleteRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_DeleteRole')
	delete from GXDBVersions where aliasname = 'sec_DeleteRole'
GO
print '... Creating Procedure: sec_DeleteRole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_DeleteRole
  @xmlIn XML,
  @userId INT,
  @isCmdLine INT,
  @skipFlagCheck INT = 0,
  @returnCursor INT = 1
AS
  DECLARE @xmlOut XML
DECLARE @errorCode AS BIGINT
DECLARE @errorString AS NVARCHAR(1024)
SET @errorCode = 0
SET @errorString = 'Successful'
DECLARE @roleId AS INT
SET @roleId = 0
DECLARE @roleName AS NVARCHAR(MAX)
SET @roleName = ''
DECLARE @localeid INT
SET @roleId = ISNULL((SELECT ref.value('@roleId', 'int') AS role
						FROM @xmlIn.nodes('Security_Role/role') R (ref)),0)
SET @roleName = ISNULL((SELECT ref.value('@roleName', 'NVARCHAR(MAX)') AS role
						FROM @xmlIn.nodes('Security_Role/role') R (ref)),'')
SET @localeId = ISNULL((SELECT ref.value('@localeId', 'INT') AS role
					  FROM @xmlIn.nodes('Security_Role/processinginstructioninfo/locale') R (ref)), 0)
IF @roleId = 0 AND @roleName <> ''
BEGIN
SET @errorCode = (2421 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2421 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', @roleName)
	GOTO END_PROCESSING
END
DECLARE @flags int
SELECT @flags=flags FROM UMRoles WHERE id = @roleId
IF(@flags IS NULL) -- incorrect role Id
BEGIN
SET @errorCode = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3760 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO END_PROCESSING
END
--security check to delete roles - only users with change security settings on commcell level can operate on role
DECLARE @hasPermission INT = 0
EXEC sec_checkPermissionOnEntity @userId, 243, @hasPermission OUTPUT, 120, @roleId
IF @hasPermission = 0
BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@userId))
SET @errorString = REPLACE(@errorString, '^2%s', dbo.sec_getLocalizedPermission(243, @localeId))
	SET @errorString = REPLACE(@errorString, '^3%s', (SELECT name FROM UMRoles WHERE id = @roleId))
SET @errorString = REPLACE(@errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (3044 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
	GOTO END_PROCESSING
END
IF @skipFlagCheck = 0					--System created non-editable roles like client owner roles can be deleted from the code base but not from GUI
BEGIN									--so when they are coming from code base they will come with the skipFlagCheck set to "true"
IF (@flags & 2 <> 0)
	BEGIN
SET @errorCode = (2422 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2422 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @roleName)
		GOTO END_PROCESSING
	END
END
IF (@flags & 536870912 <> 0)
	BEGIN
		DECLARE @planName nvarchar(255) = ''
DECLARE @propertyNames nvarchar(255) = 'Feature'
		DECLARE @tempPlanNameTbl table(planName nvarchar(255))
		INSERT INTO @tempPlanNameTbl
		EXEC AppPlanGetEntityPlanName @propertyNames, @roleId
		SET @planName = (SELECT TOP 1 planName from @tempPlanNameTbl)
SET @errorCode = (3748 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3748 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @roleName)
		SET @errorString = REPLACE(@errorString, '^2%s', @planName)
		GOTO END_PROCESSING
	END
--Lets see if user has rights on all the entitis, which will end up losing its capability
IF NOT EXISTS(SELECT 1 FROM UMRoles WHERE flags & 32 <>0 and id=@roleId)
AND EXISTS (SELECT 1 FROM UMSEcurityAssociations where roleId=@roleId)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
			  DROP TABLE #permissionIdTable
		CREATE TABLE #permissionIdTable (permissionId INT)
		INSERT INTO #permissionIdTable
		SELECT permissionId
		from UMRolesWithPermissionsExpanded where roleId=@roleId
		IF EXISTS(SELECT 1 from #permissionIdTable)
		BEGIN
IF NOT EXISTS(SELECT 1 FROM #permissionIdTable where permissionId=107)
			BEGIN
				INSERT INTO #permissionIdTable
VALUES(107)
			END
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF EXISTS(SELECT 1 from #permissionIdTable)
BEGIN
IF NOT EXISTS(SELECT 1 FROM #permissionIdTable where permissionId=107)
	BEGIN
		INSERT INTO #permissionIdTable
VALUES(107)
	END
	 DECLARE @entityType1 INT,@entityId1 INT,
			@entityType2 INT,@entityId2 INT,
			@entityType3 INT,@entityId3 INT,
			@entityType4 INT,@entityId4 INT,
			@entityType5 INT,@entityId5 INT
	DECLARE @errorPerimssionString VARCHAR(MAX)
	  IF OBJECT_ID('tempdb.dbo.#sec_checkPermissionList') IS NOT NULL
                DROP TABLE #sec_checkPermissionList
    CREATE TABLE #sec_checkPermissionList (permissionId INT)
	  DECLARE AssociatedEntitiesWithRoleCursor CURSOR STATIC FOR
      SELECT DISTINCT Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5
      FROM UMSecurityAssociations Sec WITH(NOLOCK)   where roleId=@roleId
	  OPEN AssociatedEntitiesWithRoleCursor
      FETCH NEXT FROM AssociatedEntitiesWithRoleCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
	   WHILE @@FETCH_STATUS = 0
       BEGIN
                DELETE FROM #sec_checkPermissionList
                EXEC sec_getPermissionsOnEntity '#sec_checkPermissionList', @userId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5,0,1
IF NOT EXISTS (SELECT * FROM #sec_checkPermissionList WHERE permissionId = 107)
				 BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
						EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @errorPerimssionString OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
						SET @errorString = REPLACE(@errorString, '^2%s', @errorPerimssionString)
						CLOSE AssociatedEntitiesWithRoleCursor
					    DEALLOCATE AssociatedEntitiesWithRoleCursor
						GOTO END_PROCESSING
				END
				IF EXISTS(SELECT 1 FROM #permissionIdTable Input where Input.permissionId not in (SELECT sec.permissionId from #sec_checkPermissionList sec))
				BEGIN
SET @errorCode = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
                    SET @errorPerimssionString = (SELECT ISNULL(SUBSTRING((SELECT ',' +  dbo.sec_getLocalizedPermission(Input.permissionId, @localeId)
                                                                 FROM #permissionIdTable Input where Input.permissionId not in (SELECT sec.permissionId from #sec_checkPermissionList sec)
                                                                FOR XML PATH('')), 2, 2147483647), ''))
                    SET @errorString = REPLACE(@errorString, '^1%s', @errorPerimssionString)
                    EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @errorPerimssionString OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
                    SET @errorString = REPLACE(@errorString, '^2%s', @errorPerimssionString)
					CLOSE AssociatedEntitiesWithRoleCursor
					DEALLOCATE AssociatedEntitiesWithRoleCursor
                    GOTO END_PROCESSING
				END
                FETCH NEXT FROM AssociatedEntitiesWithRoleCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
            END
            CLOSE AssociatedEntitiesWithRoleCursor
            DEALLOCATE AssociatedEntitiesWithRoleCursor
   END
		END
	END
BEGIN TRY
	--Need to delete all UMTables that can have a foreign key constraint on roleId
	DELETE FROM UMSecurityAssociations
	WHERE roleId = @roleId
	DELETE FROM UMRolesWithPermissionsExpanded
	WHERE roleId = @roleId
	DELETE FROM UMRolesPermissions
	WHERE roleId = @roleId
	DELETE FROM UMOwnerRoles
	WHERE roleId = @roleId
	DELETE FROM UMRoles
	WHERE id = @roleId
	--If role was created during v10 to v11 security upgrade delete its value from UMGroupsProp as well
	DELETE FROM UMGroupsProp
WHERE attrName = 'SystemCreatedRole_' AND attrVal = CONVERT(NVARCHAR(128), @roleId)
	--Delete Security Associations that belong to this role
EXEC sec_deleteSecurityAssociationsForEntity 120, @roleId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH
END_PROCESSING:
SET @xmlout = (SELECT @errorCode AS '@errorCode',
					  @errorString AS '@errorString',
					  (SELECT @roleId AS '@roleId',
								@roleName AS '@roleName'
								FOR XML PATH('role'),TYPE)
	FOR XML PATH('App_GenericEntityResponse'))
IF @returnCursor = 1
SELECT @xmlout
ELSE
SET @xmlIn = @xmlOut
GO

IF EXISTS (select * from GxQscripts where name = 'sec_DeleteRole')
	delete from GxQscripts where name = 'sec_DeleteRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_DeleteRole')
	delete from GXDBVersions where aliasname = 'sec_DeleteRole'
GO

insert into GXDBVersions values(2, 'sec_DeleteRole',  '00000000000000000000', 'sec_DeleteRole', '00000000000000000000')
GO

