

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_CreateSystemLocalAdminUserCredentials.sp] ---------- 

--		ALLOW COMMENTS BELOW HERE!
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =============================================
-- Author:		Andrei Loukienko
-- Creation date: 09/30/2011
-- Description:	Creates entry in UMUserCredentials with all capabilities for specified user on specified client
--				This user is used for qcommand operations as local admin of machine
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_CreateSystemLocalAdminUserCredentials')
BEGIN
	print '>>> Drop Stored Procedure: sec_CreateSystemLocalAdminUserCredentials <<<'
	drop procedure sec_CreateSystemLocalAdminUserCredentials
END
IF EXISTS (select * from GxQscripts where name='sec_CreateSystemLocalAdminUserCredentials')
	delete from GxQscripts where name = 'sec_CreateSystemLocalAdminUserCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_CreateSystemLocalAdminUserCredentials')
	delete from GXDBVersions where aliasname = 'sec_CreateSystemLocalAdminUserCredentials'
GO
print '... Creating Procedure: sec_CreateSystemLocalAdminUserCredentials'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_CreateSystemLocalAdminUserCredentials
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INTEGER
AS
  DECLARE @o_errorCode INTEGER
  DECLARE @o_errorMsg NVARCHAR(255)
SET NOCOUNT ON
DECLARE @clientName			NVARCHAR(255)
DECLARE @userName			NVARCHAR(255)
DECLARE @now				INTEGER
SET @o_errorMsg = 'Success'
SET @o_errorCode = 0
SET @now = dbo.GetUnixTime (GetUTCdate()) + 2
-- Check if we need to wait due to multiple logins for the same user
UPDATE  UMUsers SET Pager = Pager WHERE id = @i_userId
BEGIN TRY
	IF NOT EXISTS (SELECT name FROM UMUsers WHERE id=@i_userId)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorMsg = 'sec_CreateSystemLocalAdminUserCredentials: Invalid user ID passed.'
		GOTO ERROR_OUT
	END
	DECLARE @userFlags INTEGER = (SELECT flags FROM UMUsers WHERE id=@i_userId)
IF (@userFlags & 0x020) = 0x020 OR
(@userFlags & 0x10000) = 0x10000
	BEGIN
		SET @userName = (SELECT name FROM UMUsers WHERE id=@i_userId)
	END
	ELSE
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorMsg = 'sec_CreateSystemLocalAdminUserCredentials: User is not a system local admin or local user.'
		GOTO ERROR_OUT
	END
	-- CharIndex returns 0 if not found
	DECLARE @namePos INTEGER = (SELECT CHARINDEX('_localadmin__', @userName))
	IF @namePos = 0
	BEGIN
		SET @namePos  = (SELECT CHARINDEX('_localuser__', @userName))
		IF @namePos = 0
		BEGIN
			SET @o_errorCode = 3
			SET @o_errorMsg = 'sec_CreateSystemLocalAdminUserCredentials: Invalid user name. Expecting either local user or local admin. '
			GOTO ERROR_OUT
		END
	END
	SET @clientName = LEFT( @userName, @namePos-1)
	DECLARE @clientID INTEGER = (SELECT id FROM App_Client WHERE name=@clientName)
	IF @clientID IS NULL
	BEGIN
		SET @o_errorCode = 4
		SET @o_errorMsg = 'sec_CreateSystemLocalAdminUserCredentials: Invalid client name.'
		GOTO ERROR_OUT
	END
	DECLARE @allCaps BIGINT
	DECLARE @permissionBitArray VARBINARY(2000)
	DECLARE @RoleId INT
	SET @RoleId = ISNULL((SELECT roleId FROM UMOwnerRoles WHERE entityType = 1 AND entityID = 2),
												(SELECT id FROM UMRoles WHERE name = 'Master' AND (flags & (1 | 2) <> 0)))
	SET @allcaps = (SELECT SUM(DISTINCT CASE WHEN (ISNULL(RPE.permissionId,0)<=64) THEN POWER(2.0,(ISNULL(RPE.permissionId,0)-1)) ELSE POWER(2.0,31-1) END )
					FROM UMRolesWithPermissionsExpanded RPE
					WHERE roleId = @roleId)
	SET @permissionBitArray = (SELECT dbo.sec_setbitmask(permissionId)
								FROM UMRolesWithPermissionsExpanded
								WHERE roleID = @roleID and permissionId<64)
IF (@userFlags & 0x020) = 0x020
	BEGIN
		-- Add the role for the client
		IF NOT EXISTS(SELECT 1 FROM UMSecurityAssociations  where  userOrGroupId=@i_userId and isUser=1 and entityType1=3 and entityId1=@clientId and entityType2=0 and roleId=@RoleId)
			INSERT UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
			VALUES(@RoleId,0,@i_userId,1,3,@clientId,0,1)
		DELETE FROM UMUserCredentials WHERE userId=@i_userId
		INSERT INTO UMUserCredentials (userId,capabilities,flag,commCellId,clientGroupId,clientId,appTypeId,instanceId,backupsetId,subClientId,mediaAgentId,libraryId,archGroupId,
     		vtContainerId,vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId,cdPolicyId,complianceReportId, taskId,permissionBitArray)
     		VALUES( @i_userId, @allCaps,0,2,0,@clientID,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,@permissionBitArray)
		-- CMR 239783: VM clients handling. Assign rights on the associated VM clients, if this client is a PM client Id.
		IF EXISTS (SELECT TOP 1 1
				  FROM APP_VMToPMMap (NOLOCK)
				  WHERE
					pmClientID = @clientId)
		BEGIN
			INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
SELECT @roleId, 0, @i_userId, 1, 3, vmClientId, 0, 1
				FROM APP_VMToPMMap VMPM (NOLOCK)
					LEFT OUTER JOIN UMSecurityAssociations Sec (NOLOCK)
ON Sec.isUser = 1 AND Sec.userOrGroupID = @i_userID AND entityType1 = 3 AND entityId1 = vmClientId AND isCreator = 0 AND roleID = @roleID
				WHERE
					pmClientId = @clientId
					AND Sec.isUser IS NULL				-- Insert into Security table, only if it is not present there already.
			DELETE Sec									-- Delete any entry that has been added previously, but not valid now.
			FROM UMSecurityAssociations Sec
			WHERE
				isUser = 1
				AND userOrGroupId = @i_userId
AND entityType1 = 3
				AND entityId1 NOT IN (SELECT vmClientId FROM App_VMToPMMap WHERE pmClientId = @clientId)
				AND entityId1 <> @clientID
			-- Insert into Security Cache table as well. Line no. 123 deletes all entries for this user already from this table. So no Delete is required now on this table.
			INSERT INTO UMUserCredentials (userId,capabilities,flag,commCellId,clientGroupId,clientId,appTypeId,instanceId,backupsetId,subClientId,mediaAgentId,libraryId,archGroupId,
     									  vtContainerId,vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId,cdPolicyId,complianceReportId, taskId,permissionBitArray)
				SELECT @i_userId, @allCaps, 0,2,0, vmClientId, 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, @permissionBitArray
				FROM APP_VMToPMMap VMPM (NOLOCK)
				WHERE
					pmClientId = @clientID
		END
		UPDATE UMUsers SET credSetTime = @now WHERE id = @i_userId
	END
	ELSE
	BEGIN
		-- Add the role to only to Unix FS on the client
		--Only one type of Unix FS will be present on client.
		DECLARE @appTypeId INTEGER = ISNULL((
										select distinct apptypeId from App_Application where clientId = @clientId and
										apptypeId in (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = 34) -- APPGRP_UnixFileSystem
									 ),0)
		-- Perform any changes only wrt to FS apptype installed on the client
		IF @appTypeId <> 0
		BEGIN
			-- CLIENT_ENTITY_TYPE 3, APPTYPE_ENTITY_TYPE 4
			IF NOT EXISTS(SELECT 1 FROM UMSecurityAssociations  where  userOrGroupId=@i_userId and isUser=1
							and entityType1=3 and entityId1=@clientId
							and entityType2=4 and entityId2=@appTypeId
							and roleId=@RoleId)
				INSERT UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, entityType2,entityID2, isCreator, authorId)
				VALUES(@RoleId,0,@i_userId,1,3,@clientId,4,@appTypeId,0,1)
				DELETE FROM UMUserCredentials WHERE userId=@i_userId
				INSERT INTO UMUserCredentials (userId,capabilities,flag,commCellId,clientGroupId,clientId,appTypeId,instanceId,backupsetId,subClientId,mediaAgentId,libraryId,archGroupId,
     				vtContainerId,vtPolicyId,vtShelfId,reviewSetId,querySetId,downloadSetId,ermId,legalHoldId,tagId,cdPolicyId,complianceReportId, taskId,permissionBitArray)
     				VALUES( @i_userId, @allCaps,0,2,0,@clientID,@appTypeId,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,@permissionBitArray)
				UPDATE UMUsers SET credSetTime = @now WHERE id = @i_userId
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = 5
	SET @o_errorMsg = 'sec_CreateSystemLocalAdminUserCredentials: Unknown exception occured.'
END CATCH
ERROR_OUT:
	SELECT @o_errorCode, @o_errorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'sec_CreateSystemLocalAdminUserCredentials')
	delete from GxQscripts where name = 'sec_CreateSystemLocalAdminUserCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_CreateSystemLocalAdminUserCredentials')
	delete from GXDBVersions where aliasname = 'sec_CreateSystemLocalAdminUserCredentials'
GO

insert into GXDBVersions values(2, 'sec_CreateSystemLocalAdminUserCredentials',  '00000000000000000000', 'sec_CreateSystemLocalAdminUserCredentials', '00000000000000000000')
GO

