

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_CreateRole.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Procedure: sec_CreateRole
--  |
--  | Description:
--  |  Called for creating one role - generates a Generic Entity Response
--  |
--  |   Revisions  Author   	Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jagadeesh & Seema  Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_CreateRole')
BEGIN
	print '>>> Drop Stored Procedure: sec_CreateRole <<<'
	drop procedure sec_CreateRole
END
IF EXISTS (select * from GxQscripts where name='sec_CreateRole')
	delete from GxQscripts where name = 'sec_CreateRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_CreateRole')
	delete from GXDBVersions where aliasname = 'sec_CreateRole'
GO
print '... Creating Procedure: sec_CreateRole'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_CreateRole
  @xmlIn XML,
  @userId INT,
  @isCmdLine INT,
  @o_xml XML OUTPUT,
  @isReturn INT = 0,
  @flags INT = 0						
AS
  DECLARE @xmlOut XML
--Sample inputs
/*SET @xmlIn = '<Security_Role description="New role entity" visibility="0" >
	<role roleName="role6"/>
	<categoryPermission opDone="OVERWRITE">
		<categoriesPermissionList _type_="CV_CATEGORY_TYPE" categoryId="2">
		</categoriesPermissionList>
		<categoriesPermissionList _type_="CV_PERMISSION_TYPE" categoryId="2" permissionId="7">
			<flags exclude="1"/>
		</categoriesPermissionList>
		<categoriesPermissionList _type_="CV_PERMISSION_TYPE" categoryId="2" permissionId="9">
			<flags exclude="1"/>
		</categoriesPermissionList>
	</categoryPermission>
</Security_Role>'
SET @userId = 1
SET @isCmdLine = 1*/
DECLARE @errorCode AS BIGINT = 0
DECLARE @errorString AS NVARCHAR(MAX) = 'Successful'
DECLARE @description AS NVARCHAR(1024)
DECLARE @visibility AS INT
DECLARE @roleName AS NVARCHAR(1024)
DECLARE @nowTime AS INT
DECLARE @includeAllCategories AS INT
DECLARE @disabled AS INT
DECLARE @roleId AS INT
DECLARE @localeId AS INT
DECLARE @isPrivate AS INT
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
SET @roleName = ISNULL((SELECT ref.value('@roleName', 'NVARCHAR(MAX)') AS role
						FROM @xmlIn.nodes('Security_Role/role') R (ref)),'')
SET @description = ISNULL((SELECT ref.value('@description', 'NVARCHAR(MAX)') AS role
						FROM @xmlIn.nodes('Security_Role')R (ref)),'')
SET @visibility = ISNULL((SELECT ref.value('@visibility', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role')R (ref)),0)
SET @disabled = ISNULL((SELECT ref.value('@disabled', 'INT') AS role
						FROM @xmlIn.nodes('Security_Role/role/flags') R (ref)), 0)
SET @localeId = ISNULL((SELECT ref.value('@localeId', 'INT') AS role
					  FROM @xmlIn.nodes('Security_Role/processinginstructioninfo/locale') R (ref)), 0)
IF @visibility=1
	SET @isPrivate=0
ELSE
	SET @isPrivate=1
--1. Insert into UMRoles
IF @roleName = ''
BEGIN
SET @errorCode = (2412 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2412 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO END_PROCESSING
END
SELECT @roleId = id FROM UMRoles WHERE name = @roleName
IF (ISNULL(@roleId, 0) > 0)
BEGIN
SET @errorCode = (2413 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2413 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', @roleName)
	GOTO END_PROCESSING
END
--2. security check to create roles - only users with create role on commcell level can operate on role
DECLARE @userHasRight INT = 0
EXEC sec_checkPermissionOnEntity @userId, 241, @userHasRight OUTPUT, 1, 2
IF @userHasRight = 0
BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (3708 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
	GOTO END_PROCESSING
  END
--Role is visible to all , so user need to have change security settings on commcell.
IF(@isPrivate=0)
BEGIN
	set @userHasRight = 0
EXEC sec_checkPermissionOnEntity @userId, 107, @userHasRight OUTPUT, 1, 2
	IF @userHasRight = 0
	BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @userId),''))
SET @errorString = REPLACE(@errorString, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId))
		GOTO END_PROCESSING
	END
END
if object_id('tempdb.dbo.#categoryPermissionAssociationConsolidated') is not null
	DROP TABLE #categoryPermissionAssociationConsolidated
--3. Get the list of categories-permission association sent from GUI
CREATE TABLE #categoryPermissionAssociationConsolidated
(
			[hierarchyLevel] INT,
			[categoryId] INT,
			[categoryName] nvarchar(1024),
			[permissionId] INT,
			[permissionName] nvarchar(1024),
			[excludeCategory] INT,
			[excludePermission] INT,
			[shouldInsert] INT
)
DECLARE @categoryPermissionInputXML AS XML
SET @categoryPermissionInputXML = (SELECT @xmlIn.query('Security_Role/categoryPermission'))
--not mandatory that all roles should have category-permission associations
--there can be some roles that are created as part of upgrade or backward compatibility
--for whom the category-permissions cannot be present
IF (@xmlIn.exist('Security_Role/categoryPermission/categoriesPermissionList') <> 0)
BEGIN
	DECLARE @idoc AS INT
	EXEC sp_xml_preparedocument @idoc OUTPUT, @categoryPermissionInputXML
	INSERT INTO #categoryPermissionAssociationConsolidated(hierarchyLevel, categoryId, categoryName, permissionId, permissionName,excludeCategory, excludePermission, shouldInsert)
	SELECT hierarchyLevel,
		   ISNULL(categoryid,0),
		   ISNULL(categoryName,''),
		   ISNULL(permissionid,0),
		   ISNULL(permissionName,''),
		   CASE
WHEN hierarchyLevel = 121 THEN ISNULL(exclude,0)
				ELSE 0
		   END,
		   CASE
WHEN hierarchyLevel = 122 THEN ISNULL(exclude,0)
				ELSE 0
		   END,
		   0
	FROM OPENXML(@idoc, '/categoryPermission/categoriesPermissionList',0)
	WITH (hierarchyLevel int '@_type_',
		  categoryid int '@categoryId',
		  permissionid int '@permissionId',
		  exclude int 'flags/@exclude',
		  permissionName nvarchar(1024) '@permissionName',
		  categoryName nvarchar(1024) '@categoryName')
	DELETE FROM #categoryPermissionAssociationConsolidated
WHERE	((hierarchyLevel = 121 AND categoryId = 0 AND categoryName = '' AND permissionId = 0 AND permissionName = '') OR
(hierarchyLevel = 122 AND categoryId = 0 AND categoryName = '' AND permissionId = 0 AND permissionName = ''))
	EXEC  sp_xml_removedocument @idoc
	--In some cases (like when creating owner roles for VM clients) only permissionId is filled in input xml
	--We need to fill category id before inserting in UMRolesPermissions table, so manually filling them here
	UPDATE Tbl
	SET Tbl.categoryId = Perm.categoryId
	FROM #categoryPermissionAssociationConsolidated Tbl INNER JOIN UMPermissions Perm
	ON Tbl.permissionId = Perm.id
	WHERE Tbl.permissionId <> 0
	--Do some validation on the input table
	--shall we do this for cmdline alone?
	IF @isCmdLine = 1
	BEGIN
		EXEC sec_validatePermissionList @localeId, @errorCode OUTPUT, @errorString OUTPUT
	END
	ELSE
	BEGIN
			UPDATE #categoryPermissionAssociationConsolidated
			SET shouldInsert = 1
	END
END
END_PROCESSING:
IF @errorCode = 0
BEGIN
	BEGIN TRY
		--"flags" is passed as input for this "flags" column - currently the supported values are "protected" and "hidden"
		--we dont accept this "flags" as input, unlike "disabled" and "isPrivate" options, because this is purely internal operation
		--When creating a role, the creator code decides how this role should be and it is not changeable by end user
		--where as end users can control other settings like "disabled" and "isPrivate"
		INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID)
			VALUES(2, @roleName, @description, @disabled, @isPrivate, @flags, @userId, @nowTime, 0, NEWID())
		SET @roleId = (SELECT id FROM UMRoles WHERE name = @roleName)
		INSERT INTO UMRolesPermissions(roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
				SELECT @roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission
				FROM #categoryPermissionAssociationConsolidated
				WHERE shouldInsert = 1
		DECLARE @populateTempTable INTEGER= 0
IF EXISTS(SELECT 1 FROM UMRoles WHERE flags & 32 <>0 and id=@roleId)
			SET @populateTempTable=1
		EXEC sec_expandRoleWithPermissions @roleId, @errorCode OUTPUT, @errorString OUTPUT,@populateTempTable
		IF @errorCode = 0
		BEGIN
			--set creator of Role and assign him 'View' role on the role created
DECLARE @creatorPermissionList VARCHAR(MAX) = '242,243,107'
EXEC sec_setCreatorForEntity @userId, 0, @creatorPermissionList, @errorCode OUTPUT, @errorString OUTPUT, 120, @roleId
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END CATCH
END
SET @xmlout = (SELECT @errorCode AS '@errorCode',
				@errorString AS '@errorString',
				(SELECT @roleId AS '@roleId',
					   @roleName AS '@roleName',
					   @disabled AS 'flags/@disabled'
				FOR XML PATH('entity'),TYPE)
			FOR XML PATH('App_GenericEntityResponse'))
SET @o_xml =@xmlOut
IF(@isReturn<>0)
	SELECT @xmlOut

IF EXISTS (select * from GxQscripts where name = 'sec_CreateRole')
	delete from GxQscripts where name = 'sec_CreateRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_CreateRole')
	delete from GXDBVersions where aliasname = 'sec_CreateRole'
GO

insert into GXDBVersions values(2, 'sec_CreateRole',  '00000000000000000000', 'sec_CreateRole', '00000000000000000000')
GO

